#include "ncgfx.h"
#include "global.h"
#include "ncgfx.cpp"
#include "ncsfx.cpp"
#include "ncfil.cpp"
#include "nckey.cpp"
#include "3dload.h"

void part10(void); 
void part12(void);
void part31(void);
void part2(void);
void part21(void);
void part3(void);
void part4(void);
void part6(void);
void part36(void);
void generic(void);


void main(void)
{
    base=0x220; // base gus or sb !
	baseport();
	if(isvesa())
	    {
	    mode3();	  
	    printf("\nSVGA not supported, please load your loader !\n");
	    return;
	    }

      lock();
      
      buf1=new byte [64000];
      buf2=new byte [64000];
      buf3=new byte [64000];
	  data=fopen("ft.dat","rb");
	 
	  loadxm("nucleus.xm");  // load la toune en format ncs
	  guspresent=1;
      if(guspresent) initgus(base);     // init la gus, download les sample de ram a ram gus
      mode13();
	  make_angle();         // preparation table de cos et de sin !
      startmusic();   // modifie le timer et start la toune
     
      waitpat(0,60); // ok 
	  synchro(.400);
      part10();
    
  
	  synchro(.500); // ok 
	  part12();       
	  
	 /*ville */ 
      synchro(25.00);
      part2();
     
      synchro(15.000);
	  part3();
	  
      synchro(1.000);
      part31();
 
	  synchro(.4);
	  part4();

//      synchro(.500);
//      part6();
	  
	  generic();
	  waitpat(36,1);
      stopmusic();  // remet le timer a sa bonne freqence stop all voice...
	  fclose(data); // close the data file
      mode3();
      unlock();
      

      
      delete buf1;
      delete buf2;
      delete buf3;
      
} 




void generic(void)
{

	  byte *bufscrl=new byte[1843200];
	if(setvesamode(0x0101)) // 640x480x256c
	    {
	  mode3();	  
	    printf("\nSVGA mode 0x0100 not supported\n");
	    return;
	    }
	  byte pal[768];
    if(PCXload("credits.pcx",1,bufscrl,pal))
        { 
        mode3();
        printf("PCX error\n");
        return;
        }
	for(int i=0;i<2400;i++)
        {
        //waitr();
        memcpysvga(ecran,bufscrl+(i*640));
        }

}
/**************************************************************************/
/*                            PART    1.2                                 */
/**************************************************************************/


void part12(void)
{
    memset(ecran,0,64000);           
	frame=0;
//      buf1=new byte [64000];
//      buf2=new byte [64000];
	byte pal[768];
	memset(buf1,0,64000);
	memset(buf2,0,64000);
	dload(pal,768,31618);
	setpal(pal);
//              struct COLORS col;      
//              col.red=col.blue=col.green=0;
  //      fade(&col,0,0,255,pal);
int i;
memset(ecran,0,64000);
      
//fade(&col,64,0,255,pal);

dpcxload(buf2,pal,17268); // load(pal,768,"gray.pal");

while(frame<320)
{
	look();
	memset(buf1,0,64000);
	for(i=0;i<320;i++)
		 {
		 shadeline(frame,98,i,0,buf2,buf1);    
		 shadeline(frame,98,i,199,buf2,buf1);    
		 }
	for(i=0;i<200;i++)
		 {
		 shadeline(frame,98,0,i,buf2,buf1);    
		 shadeline(frame,98,319,i,buf2,buf1);    
		 }
	memcpy(ecran,buf1,64000);
}

dpcxload(buf2,pal,79582);
frame=0;
while(frame<320)
{
	look();
	memset(buf1,0,64000);
	for(i=0;i<320;i++)
     {
	 shadeline(frame,98,i,0,buf2,buf1);    
	 shadeline(frame,98,i,199,buf2,buf1);    
	 }
	for(i=0;i<200;i++)
		 {
		 shadeline(frame,98,0,i,buf2,buf1);    
		 shadeline(frame,98,319,i,buf2,buf1);    
		 }
	memcpy(ecran,buf1,64000);
}



//fade(&col,0,0,255,pal);
  
memset(ecran,0,64000);

//delete buf2;
//delete buf1;
}

/**************************************************************************/
/*                            PART    1.3                                 */
/**************************************************************************/
	

void part31(void)
{

frame=0;
byte pal[768];
//dload(pal,768,0);
//setpal(pal);

init_light(0,310,10,100); // init de la light 0 at pos 160,100 and power 200;
init_light(1,310,190,100); // init de la light 0 at pos 160,100 and power 200;
init_light(2,10,190,100); // init de la light 0 at pos 160,100 and power 200;
init_light(3,10,10,100); // init de la light 0 at pos 160,100 and power 200;

int x=0;

						   // this power will be attracted by all bigger pwr;
init_source(0,x,140,300);  // place all source of power...

//buf1=new byte [64000];
//buf2=new byte [64000];
pcxload(buf2,pal,"ft.pcx");

while(frame<500)
{
look();
memset(buf1,0,64000);
init_source(0,160,100,300);  // place all source of power...
//int frm=frame;
//if(frm%20)
{
lighting(alight[0]);
lighting(alight[1]);
lighting(alight[2]);
lighting(alight[3]);
fadebuf(buf1);
for(int i=0;i<64000;i++)
	   if(buf2[i])buf1[i]=buf2[i];
memcpy(ecran,buf1,64000);
}
}
waitpat(15,0);
}
	



/**************************************************************************/
/*                            PART    1.0                                 */
/**************************************************************************/

void part10(void)
{
	frame=0;
  // buf2=new byte [64000];
   // buf1=new byte [64000];
//      buf3=new byte [64000];
	byte pal2[768];
	byte pal[768];

	dpcxload(buf2,pal2,40895);
	dpcxload(buf3,pal2,57395);
	dload(pal,768,0);
	
float c=0;
byte l2,l3,l4,l1;
l2=l3=l4=l1=1;
byte col1,col2,col3,col4,col11,col22,col33,col44;
col1=col2=col3=col4=1;
col11=col22=col33=col44=63;
/* generate table 1 */
   int table1[320];
	 for(int i=0;i<320;i++)
		   table1[i]=sin((i)/101.7183)*3*256;  // displacement des waves en rel to x;
/* generate table 2  */
   int table2[70];
	  for(i=0;i<70;i++)
		  table2[i]=(i/5.60)*256;// number of wave to generate    
		  
/* remark good number are 2.60 , >> 8, and 3.5 on the y for the shade ...*/
/* from 0 to 16 fade in */   
		struct COLORS col;      
		col.red=col.blue=col.green=0;
	    fade(&col,0,0,255,pal);
	    

	memcpy(buf1,buf2,41600);
	
	for(int y=0;y<70;y++)
		{   
			int t2=-frame*18;
			int t1=table2[y];
			unsigned short int add=y*320+41600;
			for(int x=0;x<320;x++)
				 buf1[add++]=sin((t2+t1-table1[x])/256.0)*((t1+table1[x])>>8)+85;

		}
	 memcpy(ecran,buf1,64000);
  
while(frame<609)
 { 
       look();
       memcpy(buf1,buf2,41600);
       for(int y=0;y<70;y++)
	{
	  int t2=-frame*18;
	  int t1=table2[y];
		  unsigned short int add=y*320+41600;
		       for(int x=0;x<320;x++)
				 buf1[add++]=sin((t2+t1-table1[x])/256.0)*((t1+table1[x])>>8)+85;

		}

if(l1<63)
   {
		col.red=col.blue=col.green=0;
	    fade(&col,l1,1,199,pal);
	    l1++;
   }  
		
if(frame>=32 && frame<160)
   {
   
	   for(i=0;i<64000;i++)
			{
			   byte col=buf3[i];
			   if(col)
				  {
					 if(col>193)
						   buf1[i]=col;
				  }
			}
	   
   }
   

if(frame>=32 && col1<64 && frame<96)
{
		col.red=col.blue=col.green=0;
	    fade(&col,col1,193,255,pal);
	    col1++;
	    col11=col1;


}
   
if(frame>=96 && col11>0 && frame<160)
   {
		col.red=col.blue=col.green=0;
	fade(&col,col11,193,255,pal);
	    col11--;
   }       
   
if(col11==0 && frame<160 && col1)
	{ 
	   memset(buf3,0,64000);
	   col1=0;
	}



if(frame>=160 && l2)
	{
	   dpcxload(buf3,pal2,65432);
	   l2=0;
	}
if(frame>=160 && frame<288)
   {
	   
	   for(i=0;i<64000;i++)
			{
			   byte col=buf3[i];
			   if(col)
				  {
					 if(col>193)
						   buf1[i]=col;
				  }
			}
   }
	
if(frame>=160 && col2<64 && frame<224)
   {
		col.red=col.blue=col.green=0;
	    fade(&col,col2,193,255,pal);
	    col2++;
	    col22=col2;
	   
   }
   
if(frame>=224 && col22>0 && frame<288)
   {
		col.red=col.blue=col.green=0;
	    fade(&col,col22,193,255,pal);
	    col22--;
	   
   }

if(col22==0 && frame<288 && col2)
	{ 
	   memset(buf3,0,64000);
	   col2=0;
	}


if(frame>=288 && l3)
	{
	   dpcxload(buf3,pal2,32386);
	   l3=0;
	}
if(frame>=288 && frame<416)
   {
	   
	   for(i=0;i<64000;i++)
			{
			   byte col=buf3[i];
			   if(col)
				  {
					 if(col>193)
						   buf1[i]=col;
				  }
			}
   }
	
if(frame>=288 && col3<64 && frame<352)
   {
		col.red=col.blue=col.green=0;
	    fade(&col,col3,193,255,pal);
	    col3++;
	    col33=col3;
   }

if(frame>=352 && col33>0 && frame<416)
   {
		col.red=col.blue=col.green=0;
	    fade(&col,col33,193,255,pal);
	    col33--;
   }
if(col33==0 && frame<416 && col3)
	{ 
	   memset(buf3,0,64000);
	   col3=0;
	}


if(frame>=416 && l4)
   {
	dpcxload(buf3,pal2,73663);
	l4=0;
   }
	
if(frame>=416 && frame<544)
   {
	   
	   for(i=0;i<64000;i++)
			{
			   byte col=buf3[i];
			   if(col)
				  {
					 if(col>193)
						   buf1[i]=col;
				  }
			}
   }
	
if(frame>=416 && col4<64 && frame<480)
   {
		col.red=col.blue=col.green=0;
	    fade(&col,col4,193,255,pal);
	    col4++;
	    col44=col4;
	   
   }
if(frame>=480 && col44>0 && frame<544)
   {
		col.red=col.blue=col.green=0;
	    fade(&col,col44,193,255,pal);
	    col44--;
   }
   
if(col44==0 && frame<544 && col4)
	{ 
	   memset(buf3,0,64000);
	   col4=0;
	}

   
 /* final fade */

if(frame>=544 && frame<608)
{
		col.red=col.blue=col.green=0;
	    fade(&col,608-frame,0,199,pal);
}          
	
	
	memcpy(ecran,buf1,64000);

}  
	 /* desalocation */
    //delete buf3;
	//delete buf1;
	//delete buf2;
    col.red=col.blue=col.green=0;
	fade(&col,0,0,255,pal); 
}



void part2(void)
{

byte pal[768];
byte *texture1,*texture2,*texture3,*www;
texture1=new byte [64000];
texture2=new byte [64000];
texture3=new byte [64000];
www=new byte [64000];
dpcxload(texture1,pal,87597);
dpcxload(texture2,pal,106567);
dpcxload(texture3,pal,133130);
PCXload("clouds.pcx",0,www,pal);
load(pal,768,"lit2.pal");
setpal(pal);

byte ville[2048]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
		  0,0,0,0,0,0,0,2,3,3,3,3,3,3,5,3,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
		  0,0,0,2,0,0,0,0,0,0,0,0,0,0,4,0,
		  0,0,0,0,0,0,0,0,0,0,2,0,0,0,4,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,
		  0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,4,0,0,0,0,0,0,0,0,2,0,0,
		  0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,4,0,0,0,2,0,0,0,0,0,0,0,
		  0,0,0,0,4,0,0,0,0,0,1,0,0,0,0,0,
		  0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0,
		  0,3,3,3,5,3,3,3,3,3,3,5,3,3,3,0,
		  0,4,0,0,4,1,0,0,0,0,0,4,0,0,0,0,
		  0,0,0,0,4,0,0,0,0,0,0,4,0,0,0,0,
		  0,0,0,0,4,1,0,0,0,0,0,4,0,0,0,0,
		  0,0,0,1,4,0,0,0,0,1,2,4,0,0,0,0,
		  0,0,0,0,4,1,0,0,0,0,0,4,0,0,0,0,
		  0,3,3,3,5,3,3,3,3,3,3,5,3,3,3,0,
		  0,0,0,0,4,1,1,0,0,0,0,4,2,1,2,0,
		  0,0,0,0,4,0,0,0,0,0,0,4,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
		  0,0,3,3,3,3,5,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,2,1,2,2,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,4,0,4,0,0,0,0,0,2,0,
		  0,0,0,0,0,0,4,0,4,1,0,0,0,0,0,0,
		  0,0,0,0,0,0,4,0,4,0,0,0,0,0,0,0,
		  0,0,0,0,0,2,5,3,5,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,4,2,1,1,0,0,0,0,
		  0,0,3,3,3,3,3,3,5,3,3,3,3,5,0,0,
		  0,0,0,0,0,0,0,0,4,0,0,0,0,4,0,0,
		  0,0,0,0,0,2,0,0,0,0,0,0,0,4,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,
		  0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,0,
		  0,0,0,2,0,0,0,4,0,0,0,0,4,0,0,0,
		  0,0,2,5,3,3,3,5,0,0,0,0,4,0,0,0,
		  0,0,0,4,0,0,0,4,0,0,0,1,4,0,0,0,
		  0,0,0,4,0,1,0,4,0,0,0,1,4,0,0,0,
		  0,0,0,4,0,0,0,4,1,0,0,1,5,3,3,3,
		  0,0,0,4,0,0,0,4,0,0,0,0,2,0,0,0,
		  2,3,3,5,3,3,3,5,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,1,0,0,
		  0,0,0,4,0,0,2,0,0,0,2,0,0,0,4,0,
		  0,0,0,4,0,0,0,1,2,0,0,0,0,0,4,0,
		  3,3,3,5,2,0,0,4,0,0,0,3,3,3,5,3,
		  0,0,0,1,0,0,0,4,0,2,0,1,0,1,0,0,
		  0,0,0,0,2,3,3,5,3,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,2,4,0,0,0,0,0,0,
		  0,0,0,1,0,0,0,4,0,4,0,1,0,0,0,0,
		  0,0,3,3,3,3,3,5,3,5,3,5,3,1,0,0,
		  0,0,0,2,0,0,1,4,2,1,0,4,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,1,3,3,3,5,3,3,3,5,3,3,3,3,
		  0,0,0,0,1,0,0,4,2,0,0,4,1,0,0,0,
		  0,0,0,0,0,1,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,2,0,2,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,0,3,3,3,5,3,3,3,5,0,0,1,0,
		  0,0,0,0,1,0,0,0,0,1,0,4,0,0,0,0,
		  2,3,3,5,3,3,3,5,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,1,0,0,
		  0,0,0,4,0,0,2,0,0,0,2,0,0,0,4,0,
		  0,0,0,4,0,0,0,1,2,0,0,0,0,0,4,0,
		  3,3,3,5,2,0,0,4,0,0,0,3,3,3,5,3,
		  0,0,0,1,0,0,0,4,0,2,0,1,0,1,0,0,
		  0,0,0,0,2,3,3,5,3,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,2,4,0,0,0,0,0,0,
		  0,0,0,1,0,0,0,4,0,4,0,1,0,0,0,0,
		  0,0,3,3,3,3,3,5,3,5,3,5,3,1,0,0,
		  0,0,0,2,0,0,1,4,2,1,0,4,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,1,3,3,3,5,3,3,3,5,3,3,3,3,
		  0,0,0,0,1,0,0,4,2,0,0,4,1,0,0,0,
		  0,0,0,0,0,1,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,2,0,2,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,0,3,3,3,5,3,3,3,5,0,0,1,0,
		  2,3,3,5,3,3,3,5,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,1,0,0,
		  0,0,0,4,0,0,2,0,0,0,2,0,0,0,4,0,
		  0,0,0,4,0,0,0,1,2,0,0,0,0,0,4,0,
		  3,3,3,5,2,0,0,4,0,0,0,3,3,3,5,3,
		  0,0,0,1,0,0,0,4,0,2,0,1,0,1,0,0,
		  0,0,0,0,2,3,3,5,3,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,2,4,0,0,0,0,0,0,
		  0,0,0,1,0,0,0,4,0,4,0,1,0,0,0,0,
		  0,0,3,3,3,3,3,5,3,5,3,5,3,1,0,0,
		  0,0,0,2,0,0,1,4,2,1,0,4,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,1,3,3,3,5,3,3,3,5,3,3,3,3,
		  0,0,0,0,1,0,0,4,2,0,0,4,1,0,0,0,
		  0,0,0,0,0,1,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,2,0,2,0,0,0,4,0,0,0,4,0,0,0,0,
		  0,0,0,0,3,3,3,5,3,3,3,5,0,0,1,0,
		  0,0,0,0,1,0,0,0,0,1,0,4,0,0,0,0,
		  2,3,3,5,3,3,3,5,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,4,0,0,0,0,0,0,0,0,0,1,0,0,
		  0,0,0,4,0,0,2,0,0,0,2,0,0,0,4,0,
		  0,0,0,4,0,0,0,1,2,0,0,0,0,0,4,0,
		  3,3,3,5,2,0,0,4,0,0,0,3,3,3,5,3,
		  0,0,0,1,0,0,0,4,0,2,0,1,0,1,0,0,
		  0,0,0,0,2,3,3,5,3,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,0,4,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,4,2,4,0,0,0,0,0,0};

/* find how many object we have in the world */
word num_objet=0;
VERTEX *place_objet;
int i;
for(i=0;i<2048;i++) 
{    
      if(ville[i]) 
      num_objet++; 
}
 
// allocate memory for objects 

objet3d cam,*vec;
vec= new objet3d [num_objet+2];
place_objet=new VERTEX [num_objet];
if(!vec)exit(0);
if(!place_objet)exit(0);
// find objects positions

int op=0;
for(i=0;i<2048;i++)
{
     if(ville[i])
	 {
	     place_objet[op].x=i%16;
	     place_objet[op].y=i/16;
	     place_objet[op].z=ville[i];  // center.z has the value of object type
	     op++;
	 }
	      
}



// load object form  and set is postion
for(i=0;i<num_objet;i++)
{
	if(place_objet[i].z==1)
	{
//            vec[i].dload(79334,0);
	    vec[i].load("edi1.n3d",0);

	    vec[i].mdraw=4;
	    vec[i].texture[0].x=0;
	    vec[i].texture[0].y=199;
	    vec[i].texture[3].x=0;
	    vec[i].texture[3].y=199;
	    
	    vec[i].texture[1].x=319;
	    vec[i].texture[1].y=199;
	    vec[i].texture[2].x=319;
	    vec[i].texture[2].y=199;
	    
	    vec[i].texture[4].x=0;
	    vec[i].texture[4].y=0;
	    vec[i].texture[7].x=0;
	    vec[i].texture[7].y=0;
	    
	    vec[i].texture[5].x=319;
	    vec[i].texture[5].y=0;
	    vec[i].texture[6].x=319;
	    vec[i].texture[6].y=0;
	    vec[i].TEXPTR=texture1;
	}
	    
	if(place_objet[i].z==2)
       {
       // vec[i].dload(79458,0);
	vec[i].load("edi2.n3d",0);

	    vec[i].mdraw=4;
	    vec[i].texture[0].x=0;
	    vec[i].texture[0].y=199;
	    vec[i].texture[3].x=0;
	    vec[i].texture[3].y=199;
	    
	    vec[i].texture[1].x=319;
	    vec[i].texture[1].y=199;
	    vec[i].texture[2].x=319;
	    vec[i].texture[2].y=199;
	    
	    vec[i].texture[4].x=0;
	    vec[i].texture[4].y=0;
	    vec[i].texture[7].x=0;
	    vec[i].texture[7].y=0;
	    
	    vec[i].texture[5].x=319;
	    vec[i].texture[5].y=0;
	    vec[i].texture[6].x=319;
	    vec[i].texture[6].y=0;
	    vec[i].TEXPTR=texture2;
	

       }
	
	
    if(place_objet[i].z==3)
	{
	    //vec[i].dload(79294,0);
	    vec[i].load("plaque.n3d",0);

	    vec[i].mdraw=4;
	    vec[i].texture[0].x=65;
	    vec[i].texture[0].y=0;
	    vec[i].texture[1].x=160;
	    vec[i].texture[1].y=0;
	    vec[i].texture[2].x=160;
	    vec[i].texture[2].y=95;
	    vec[i].texture[3].x=65;
	    vec[i].texture[3].y=95;
	    vec[i].TEXPTR=texture3;
     //       
	}
	
    if(place_objet[i].z==4)
	{
	    //vec[i].dload(79294,0);
	    vec[i].load("plaque.n3d",0);

	    vec[i].cs=230;
	    vec[i].ct=240;
	    vec[i].mdraw=4;
	    vec[i].texture[0].x=0;
	    vec[i].texture[0].y=104;
	    vec[i].texture[1].x=95;
	    vec[i].texture[1].y=104;
	    vec[i].texture[2].x=95;
	    vec[i].texture[2].y=199;
	    vec[i].texture[3].x=0;
	    vec[i].texture[3].y=199;
	    vec[i].TEXPTR=texture3;
	    
	}
    if(place_objet[i].z==5)
	{
	    //vec[i].dload(79294,0);
	    vec[i].load("plaque.n3d",0);

	    vec[i].mdraw=4;
	    vec[i].texture[0].x=189;
	    vec[i].texture[0].y=31;
	    vec[i].texture[1].x=284;
	    vec[i].texture[1].y=0;
	    vec[i].texture[2].x=284;
	    vec[i].texture[2].y=126;
	    vec[i].texture[3].x=189;
	    vec[i].texture[3].y=126;
	    vec[i].TEXPTR=texture3;
	}
	
   
    vec[i].litset(1.57,0,0,(place_objet[i].x-8)*256,0,place_objet[i].y*256);    
    
    


}

// allocate memory for buffer
//buf1=new byte[64000];
if(!buf1)exit(0);

/* Special camera */
//cam.ax=1.70;
cam.ay=0;
cam.az=0;
cam.parent=0;
cam.tot_vertex=0;
cam.center.x=0;
cam.center.y=0;
cam.center.z=0;
/***********/                            

for(i=0;i<num_objet;i++)
    {
    vec[i].parent=&cam;
  //  vec[i].prenormal();
  //  vec[i].findnorm();
  //  vec[i].rotaten(0,0,0);
    vec[i].ALL=0;
    vec[i].zmax=256;
    }
    


cam.az=3.1415;
//cam.ax=-.14;
cam.center.y=-650;
byte key;
int xstart=0;
frame=0;
waitpat(9,0);
byte palette=1;
	word sx=0,sy=100,ex,ey=99,incl=0;
	struct COLORS c,col;

    c.red=0; c.green=0; c.blue=0;
    col.red=0; col.green=0; col.blue=0;

	word intn=64;
	int b=1;
   word i2=159;
   word j=159;
   word y=99;
memset(buf3,0,64000);


byte cola=0;
while(cam.center.z<32768)
{            
	look();
	if(cola<64)
	{
	fade(&col,cola,0,255,pal);
	cola++;
	}
    memset(buf1,0,64000);
	cam.center.z=frame;
	cam.rotate();
	scroll13h(xstart,0,150,buf1,www);
	xstart=((int)(frame/30))%320;
    long dist;
	for(i=0;i<num_objet;i++)
	{
	dist=vec[i].center.z-cam.center.z;
	if(dist>500  && dist<5000)
	     vec[i].rotate();
	}
	
	for(i=(num_objet-1);i>=0;i--)
	{
	dist=vec[i].center.z-cam.center.z;
    if(dist>500  && dist<5000)
	    vec[i].draw();
	    
    }
     if(cam.center.z>21000)
      {
	    { 
	      if(j<319)
           {  
              buf3[32000+j]=63;
              buf3[32000+j+1]=63;
              buf3[32000+i2]=63;
              buf3[32000+i2-1]=63;
              i2-=2; 
              j+=2; 
            }
          else
            if(y>50)
                 {
                   Yfade(&c,intn,0,255,pal);
	               for(word i3=0;i3<319;i3++)
	                {
	                Yshadeline(i3,100,i3,y,buf3);
	                Yshadeline(i3,100,i3,y+b,buf3);
	                }
	               b+=2;
	               intn--;
	               y--;
                 }
	          else
	             cam.center.z=32768;
	for(word u=y*320;u<(y+b)*320;u++)
	    if(buf3[u])
	        buf1[u]=buf3[u];
		}				   
    }
	memcpy(ecran,buf1,64000);

}


delete texture1;
delete texture2;
delete texture3;
//delete buf1;
delete vec;
delete place_objet;
delete www;
}


void part3(void)
{
    byte pal[768];
    byte *font=new byte [64000];
int num_objet=2;
int i,z;
objet3d *vec;
vec=new objet3d [num_objet];
short int *col_table;
col_table=new short int [2048];
load(pal,768,"multi.pal");
struct COLORS c;
c.red=63; c.green=63; c.blue=63;
fade(&c,0,0,255,pal);
//getch();
//setpal(pal);                                    

FILE *entree;
entree=fopen("color.map","rb");
fread(col_table,2,2048,entree);
fclose(entree);
 

vec[1].load("tunnel.map",0);


for(i=1;i<num_objet;i++)
    {
    vec[i].parent=&vec[0];
    vec[i].center.x=0;
    vec[i].center.y=0;
    vec[i].center.z=0;
    vec[i].prenormal();
    vec[i].findnorm();
    for(z=0;z<vec[i].tot_vertex;z++)    
    {
	(vec[i].normalvi[z].z=col_table[z]-128)/2;
	}
    vec[i].cs=129;
    vec[i].ct=255;
    vec[i].mdraw=2;
    }
    
vec[0].ax=0;
vec[0].ay=0;
vec[0].az=3.1415;
vec[0].parent=0;
vec[0].tot_vertex=0;
vec[0].center.x=0;
vec[0].center.y=0;
vec[0].center.z=-8600;
vec[1].ALL=1;

c.red=63; c.green=63; c.blue=63;
word intn=0;
frame=0;
byte stop=1;

init_light(0,310,10,100); // init de la light 0 at pos 160,100 and power 200;
init_light(1,310,190,100); // init de la light 0 at pos 160,100 and power 200;
init_light(2,10,190,100); // init de la light 0 at pos 160,100 and power 200;
init_light(3,10,10,100); // init de la light 0 at pos 160,100 and power 200;
init_source(0,0,140,300);  // place all source of power...
pcxload(font,pal,"ft.pcx");


while(vec[0].center.z<8000)
{
     if(intn<64)
         { 
           fade(&c,intn,0,255,pal);
           intn++;
         }
look();
memset(buf1,0,64000);
init_source(0,160,100,300);  // place all source of power...

lighting(alight[0]);
lighting(alight[1]);
lighting(alight[2]);
lighting(alight[3]);
fadebuf(buf1);
for(int i=0;i<64000;i++)
	   if(font[i])buf1[i]=font[i];
     vec[0].center.z=frame;
     vec[0].az+=.05;
     vec[0].rotate();
     vec[1].rotate();
     vec[1].draw();
     memcpy(ecran,buf1,64000);
} 
//delete buf1;
delete vec;
delete font;
}


void part4(void)
{
int xstart=10;
byte *www=new byte[64000];
byte pal[768];
if(!www||!buf1)return;
if(PCXload("clouds3.pcx",1,www,pal))return;
//loadpal("gray.pal",pal);
//setpal(pal);

objet3d *vec;
vec=new objet3d [30];

vec[1].load("cata3.n3d",0);
vec[2].load("cata3.n3d",0);
vec[3].load("cata3.n3d",0);
vec[4].load("cata3.n3d",0);
vec[5].load("cata3.n3d",2);
vec[6].load("cata3.n3d",1);
vec[7].load("cata3.n3d",0);
vec[8].load("cata3.n3d",0);
vec[9].load("cata3.n3d",0);
vec[10].load("cata3.n3d",0);
vec[11].load("cata3.n3d",2);
vec[12].load("cata3.n3d",1);
vec[13].load("castle3.n3d",0);//tour
vec[14].load("castle3.n3d",0);
vec[15].load("castle3.n3d",0);
vec[16].load("castle3.n3d",0);
vec[17].load("castle3.n3d",1);//mur
vec[18].load("castle3.n3d",1);
vec[19].load("castle3.n3d",1);
vec[20].load("castle3.n3d",1);
vec[21].load("cataball.n3d",0);
vec[22].load("cataball.n3d",0);
vec[23].load("cata3.n3d",0);
vec[24].load("cata3.n3d",0);
vec[25].load("cata3.n3d",0);
vec[26].load("cata3.n3d",0);
vec[27].load("cata3.n3d",2);
vec[28].load("cata3.n3d",1);
vec[29].load("cataball.n3d",0);

/* Special camera */
vec[0].set(0,0,0,0,0,0,0,0,0.19,0,800,-540,-1600,0,0,0,0,0,0,0,0,0,0,0);
vec[0].tot_vertex=0;
/***********/                            
for(word i=1;i<30;i++)
    {
	vec[i].set(&vec[0],0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,2);
    vec[i].prenormal();
    vec[i].findnorm();
    vec[i].rotaten(0,0,0);
    }
for(i=1;i<6;i++)
    vec[i].parent=&vec[6];
for(i=7;i<12;i++)
    vec[i].parent=&vec[12];
for(i=23;i<28;i++)
    vec[i].parent=&vec[28];
    
vec[1].center.x=261;vec[1].center.y=130;vec[1].center.z=-30;
vec[2].center.x=261;vec[2].center.y=-130;vec[2].center.z=-30;
vec[3].center.x=-57;vec[3].center.y=-130;vec[3].center.z=-30;
vec[4].center.x=-57;vec[4].center.y=130;vec[4].center.z=-30;

vec[7].center.x=261;vec[7].center.y=130;vec[7].center.z=-30;
vec[8].center.x=261;vec[8].center.y=-130;vec[8].center.z=-30;
vec[9].center.x=-57;vec[9].center.y=-130;vec[9].center.z=-30;
vec[10].center.x=-57;vec[10].center.y=130;vec[10].center.z=-30;

vec[23].center.x=261;vec[23].center.y=130;vec[23].center.z=-30;
vec[24].center.x=261;vec[24].center.y=-130;vec[24].center.z=-30;
vec[25].center.x=-57;vec[25].center.y=-130;vec[25].center.z=-30;
vec[26].center.x=-57;vec[26].center.y=130;vec[26].center.z=-30;

vec[12].center.x=800;
vec[12].center.z=800;
vec[28].center.x=1800;
vec[28].center.z=1800;
vec[6].ax=1.57;
vec[12].ax=1.57;
vec[28].ax=1.57;

vec[21].center.x=400;        //+400 x
vec[21].center.y=-120;       //-120 y
							 //same z
vec[22].center.x=1240;
vec[22].center.y=-120;
vec[22].center.z=800;        

vec[29].center.x=2240;
vec[29].center.y=-120;
vec[29].center.z=1800;

vec[13].ax=1.57;
vec[14].ax=1.57;
vec[15].ax=1.57;
vec[16].ax=1.57;
vec[13].center.x=-706;vec[13].center.y=60;vec[13].center.z=718+2000;
vec[14].center.x=703;vec[14].center.y=60;vec[14].center.z=718+2000;
vec[15].center.x=703;vec[15].center.y=60;vec[15].center.z=1300;
vec[16].center.x=-706;vec[16].center.y=60;vec[16].center.z=1300;

vec[17].ax=1.57;
vec[18].ax=1.57; vec[18].ay=1.57;
vec[19].ax=1.57;
vec[20].ax=1.57; vec[20].ay=1.57;

vec[17].center.x=0;vec[17].center.y=55;vec[17].center.z=718+2000;
vec[18].center.x=703;vec[18].center.y=55;vec[18].center.z=1960;
vec[19].center.x=0;vec[19].center.y=55;vec[19].center.z=-740+2000;
vec[20].center.x=-706;vec[20].center.y=55;vec[20].center.z=0+2000;
//valeurs gourad
for(i=1;i<5;i++)
   { vec[i].cs=17; vec[i].ct=31; }
vec[5].cs=64; vec[5].ct=79;
vec[6].cs=64; vec[6].ct=79;
for(i=7;i<11;i++)
   { vec[i].cs=17; vec[i].ct=31; }
vec[11].cs=64; vec[11].ct=79;
vec[12].cs=64; vec[12].ct=79;
for(i=13;i<17;i++)
   { vec[i].cs=128; vec[i].ct=191; }
for(i=17;i<21;i++)
   { vec[i].cs=128; vec[i].ct=191; }
vec[21].cs=96; vec[21].ct=111;
vec[22].cs=96; vec[22].ct=111;
for(i=23;i<27;i++)
   { vec[i].cs=17; vec[i].ct=31; }
vec[27].cs=64; vec[27].ct=79;
vec[28].cs=64; vec[28].ct=79;
vec[29].cs=96; vec[29].ct=111;

    
long ffframe=0;
byte way=1;
int ystart=20,yend=132;

rnd_centroid =new CENTROID [30];
bufArn =new CENTROID [30];
bufBrn =new CENTROID [30];
float olday;
float oldy;
float curpos=0;

int totframes;
byte maxpath;
int cpath=0;
FILE *f;
if((f=fopen("16.pth","rb"))==NULL)
	{
    printf("ERROR: can't open file\n");
    getch();
	exit(0);
    }
fread(&maxpath,sizeof(maxpath),1,f);
loadpath(vec,&totframes,f);

while(cpath<maxpath)
{
   look();
   oldy=vec[0].center.y;
   olday=vec[0].ay;

   memset(buf1,96,64000);
    vec[0].rotate(); //camera
	vec[6].rotate(); //whole
	vec[5].rotate(); //arm
	vec[12].rotate();
	vec[11].rotate();
	vec[28].rotate();
	vec[27].rotate();
	for(i=13;i<21;i++)
	vec[i].rotate();
	vec[21].rotate();//ball
	vec[22].rotate();//ball
	vec[29].rotate();//ball
	vec[23].rotate();//land
	for(word t=1;t<5;t++)
	    vec[t].rotate();
	for(t=7;t<11;t++)
	    vec[t].rotate();
	for(t=23;t<27;t++)
	    vec[t].rotate();

	for(int i=0;i<30;i++)
		    if(vec[i].mstart && vec[i].mend)
			    vec[i].inta(curpos,(float)totframes);
	    if(olday>vec[0].ay)
		   way=1;
	    else
		   if(olday<vec[0].ay)
		      way=2;
		   else
		       way=0;
	scroll13h2(&xstart,ystart,yend,buf1,www,way);


	render(30,vec);
	memcpy(ecran,buf1,64000);
    curpos=frame;
    if(curpos>totframes)
		{ curpos=0;
		  frame=0;
	  cpath++;
	  if(cpath<maxpath)
	      loadpath(vec,&totframes,f);
		}
}
}


void initwind(void)
{

   FILE *entree3;
   entree3=fopen("chev.dat","rb");
   
   for(int i=0;i<totchev;i++)
   {
      
       fread(&cheveux[i].posx,2,1,entree3);
       fread(&cheveux[i].posy,2,1,entree3);

       cheveux[i].initx=cheveux[i].posx;
       cheveux[i].inity=cheveux[i].posy;
  
       cheveux[i].startx=3;
       cheveux[i].starty=1;
       cheveux[i].len=rand()%40+40;
       cheveux[i].sta=rand()%255;
  }
  fclose(entree3);
}


void wind()
{
// cheveux normal sans vent + pos influence



     for(word i=0;i<totchev;i++)
	 {
	     word oldx=cheveux[i].posx;
	     word oldy=cheveux[i].posy;
	     
	    for(word l=0;l<cheveux[i].len;l++)
		{
//                   if(oldx<320)
//                   buf1[oldx+oldy*320]=249;
		   byte str=cheveux[i].sta;

			 if(l<10)
			     {
				if(cheveux[i].initx>=160)
				cheveux[i].posx+=cheveux[i].startx;
				else
				cheveux[i].posx-=cheveux[i].startx;
				
				cheveux[i].posy+=cos((-frame+l+str)/infwind)*windy+cheveux[i].starty;
			     }
			 else
			 {
			     
			  cheveux[i].posx+=windx;
			  cheveux[i].posy+=cos((-frame+l+str)/infwind)*windy+1;
			 }
			 
			if(oldx<320 && cheveux[i].posx<320)
		       line(oldx,oldy,cheveux[i].posx,cheveux[i].posy,230,buf1);
		       oldx=cheveux[i].posx;
		       oldy=cheveux[i].posy;
		       
		       
			 
	       }
	       cheveux[i].posx=cheveux[i].initx;
	       cheveux[i].posy=cheveux[i].inity;

	}
}

void Yshadeline(word x,word y,word x2,word y2,byte *buf1)
{
	  long deg=63<<16;
	  int i, sx, sy, dy, e;
	  dy = abs(y2 - y);
if(dy)
{
long inc=(31<<16)/dy;

   if(y<y2)
	  for(i = (y<<8)+(y<<6);i < (y2<<8)+(y2<<6);i+=320)
	  {
				  
				   buf1[i+x]=(byte)(deg>>16);
				   deg-=inc;
	  }
   if(y2<y)
	  for(i = (y<<8)+(y<<6);i > (y2<<8)+(y2<<6);i-=320)
	  {
				  
				   buf1[i+x]=(byte)(deg>>16);
				   deg-=inc;
	  }
}
}

void Yfade(struct COLORS *cp,word intensity,word start,word end,byte *palbuf)
{
// range parameter values: red,green,blue  0 to 63  (6bit)
//                         intensity       0 to 64
//                         start,end       0 to 255
	byte inc;
//	waitr();
	word i=start*3;
	outp(0x03c8,start);
	for(;i<=(end*3);i+=3)
		{ 
		  outp(0x03c9,( (intensity * *(palbuf+i))/64) + cp->red);
		  outp(0x03c9,( (intensity * *(palbuf+i+1))/64) + cp->green);
		  outp(0x03c9,( (intensity * *(palbuf+i+2))/64) + cp->blue);
		}
	if(cp->red<64) cp->red++; 
	if(cp->green<64) cp->green++; 
	if(cp->blue<64) cp->blue++; 
}



void part6(void)
{
   byte pal[768];
   PCXload("sw.pcx",0,buf2,pal);
   objet3d rose,cam,petal,tige1,tige2,sw;
   load(pal,768,"all.pal");
   setpal(pal);
   rose.load("rose.n3d",0);
   petal.load("rose.n3d",1);
   tige1.load("rose.n3d",2);
   tige2.load("rose.n3d",3);

   cam.center.x=0;
   cam.center.y=0;
   cam.center.z=0;
   cam.parent=0;
   cam.tot_vertex=0;
   cam.tot_face=0;
   
    rose.prenormal();
    rose.findnorm();
    rose.rotaten(512,10,10);
    rose.parent=&cam;
    rose.litset(0,0,0,0,0,0);
    rose.mdraw=2;
    rose.ALL=1;
    rose.cs=32;
    rose.ct=46;
    
    tige1.prenormal();
    tige1.findnorm();
    tige1.rotaten(0,0,0);
    tige1.parent=&rose;
    tige1.litset(0,0,0,0,0,0);
    tige1.mdraw=2;
    tige1.ALL=1;
    tige1.cs=96;
    tige1.ct=111;
    
    tige2.prenormal();
    tige2.findnorm();
    tige2.rotaten(0,0,0);
    tige2.parent=&rose;
    tige2.litset(0,0,0,0,0,0);
    tige2.mdraw=2;
    tige2.ALL=1;
    tige2.cs=96;
    tige2.ct=111;
    
    petal.prenormal();
    petal.findnorm();
    petal.rotaten(0,0,0);
    petal.parent=&rose;
    petal.litset(0,0,0,0,0,0);
    petal.mdraw=2;
    petal.ALL=1;
    petal.cs=96;
    petal.ct=111;


    for(int i=0;i<800;i++)
	{ 
	  pixel[i].pos=rand() % 32000;
	  pixel[i].pos+=rand() % 32000;
	  pixel[i].pos+=rand() % 1535;
	  pixel[i].color=(rand() % 24)+8;
	}


  rose.center.y=-100;
  cam.center.z=-1500;

cheveux= new HAIR [200];

   while(frame<200)
       {
	  look();
     initwind();
	  for(i=0;i<800;i++)
	      { 
	      pixel[i].pos-=pixel[i].color / 7;
	      buf1[ pixel[i].pos ]=260-pixel[i].color; 
	      }
	    
	    cam.rotate();
	    rose.ax=1.90;
	    rose.az+=.04;
	    rose.rotate();
	    tige1.rotate();
	    tige2.rotate();
	    petal.rotate();
	    tige2.draw();
	    tige1.draw();
	    petal.draw();
	    rose.draw();
	    memcpy(ecran,buf1,64000);
       }
 }

void memcpysvga(byte *dest,byte *source)
{
	dword c=0;
	for(dword i=0;i<4;i++)  // first four blocks of 64k
	    {
	    setwindow(0,i);
		memcpy(ecran,source+c,65536);
        c+=65536;
        }
    setwindow(0,i);
	memcpy(ecran,source+c,45056); // 5th block of ~45k
}

byte isvesa(void)
{
    byte buf[256],r;
    #pragma aux test =\
      "mov eax,4f00h          "\
      "mov ebx,dword ptr [buf] "\
      "mov edi,ebx           "\
      "int 10h               "\
      "mov r,al              "\
	modify exact [eax edi ebx] nomemory;
	test();
	if(r!=0x4f)
	    return(1);
    #pragma aux test2 =\
      "mov eax,4f01h          "\
      "mov ebx,dword ptr [buf] "\
      "mov edi,ebx           "\
      "mov cx,0101h         "\
      "int 10h               "\
      "mov r,al              "\
	modify exact [eax edi ebx ecx] nomemory;
	test2();
	if(r!=0x4f)
	    return(1);
	return(0);
}

byte setvesamode(word mode)
{
    byte r;
    #pragma aux setamode =\
      "mov ax,4f02h "\
      "mov bx,0101h  "\
      "int 10h "\
      "mov r,al"\
	modify exact [eax ebx] nomemory;
	setamode();
	if(r!=0x4f)
	    return(1);
	return(0);
}

void setwindow(byte win,word pos)
{
	word pos2=pos;
    #pragma aux setwin =\
      "mov ax,4f05h "\
      "mov bh,00h   "\
      "mov bl,win   "\
      "mov dx,pos2  "\
      "int 10h      "\
    modify exact [eax ebx edx] nomemory;
    setwin();
 }

void baseport(void)
{
    printf("\n\nForgotten Times by Nucleus   (c)1996\n");
    printf("\nGus baseport:\n");
    printf("1. [210]\n");
    printf("2. [220]\n");
    printf("3. [230]\n");
    printf("4. [240]\n");
    printf("5. [250]\n");
    printf("6. [260]\n");
    printf("7. [270]\n");
    printf("8. [280]\n");
	byte key=0,t;
	fflush(stdin);
	if(kbhit())t=getch();
	key=getch();
	while(key<49&&key>56)
		key=getch();
	key-=48;
	switch(key)
	   { 
	   case 1: base=0x210; break;
	   case 2: base=0x220; break;
	   case 3: base=0x230; break;
	   case 4: base=0x240; break;
	   case 5: base=0x250; break;
	   case 6: base=0x260; break;
	   case 7: base=0x270; break;
	   case 8: base=0x280; break;
	   }
}

