//---------------------------------------------------------------------------------------------------------------------
//Overlace importer + displayer
//Code: Cruzer/CML
//Asm: KickAss 4
//Tab: 8 chars
//---------------------------------------------------------------------------------------------------------------------
.import source "cruzersLib.asm"
//---------------------------------------------------------------------------------------------------------------------
//params...
.var borderColor = $0e
.var bgColor = $00
.var filename = "screamingEagle.png"
.var picOffsetX = 0
//---------------------------------------------------------------------------------------------------------------------
//zeropage...		      # bytes
.var pnt0 =		$02 //2
.var pnt1 = 		$04 //2
.var xPos = 		$06 //1
.var yPos = 		$07 //1
.var xPosChr =		$08 //1
.var source =		$09 //2
.var target =		$0b //3
.var srcPos =		$0e //1
.var destPos =		$0f //1
.var destPosBitmap = 	$10 //2
//---------------------------------------------------------------------------------------------------------------------
//memory...		from    to
.var basic =		$0801 //080f
.var main =		$0900 //0fff
.var tune =		$1000 //2fff
.var d800tmp =		$3000 //33ff
.var bitmap =		$4000 //5fff
.var screen0 =		$6000 //63ff
.var screen1 =		$6400 //67ff
.var sprites =		$6800 //7fff
//---------------------------------------------------------------------------------------------------------------------
//misc...
.var rastatime = f
.var unused = $fff6
.var border = rastatime ? $d020 : unused
.var topIrqLine = $2d
.var ProcessorPortDDRDefault = %00101111
.var ProcessorPortAllRAMWithIO = %00100101
.var CIA1InterruptControl =	$dc0d
.var CIA1TimerAControl =	$dc0e
.var CIA1TimerBControl =	$dc0f
.var CIA2InterruptControl =	$dd0d
.var CIA2TimerAControl =	$dd0e
.var CIA2TimerBControl =	$dd0f
.var VIC2InteruptControl =	$d01a
.var VIC2InteruptStatus =	$d019
.var tuneInit = $1000
.var tunePlay = $1003
//---------------------------------------------------------------------------------------------------------------------
//scripting for PNG import...

.var defaultRGBs = List()
.eval defaultRGBs.add($000000,$ffffff,$d74612,$6ff7ff)
.eval defaultRGBs.add($cc35ff,$67f200,$5125ff,$ffff00)
.eval defaultRGBs.add($d67c00,$906f00,$ff8a62,$727272)
.eval defaultRGBs.add($a4a4a4,$b9ff3f,$9b79ff,$d5d5d5)

.var charWidth = 4
.var numBlockColors = 3

.function colorDist(rgb0, rgb1) {
	.var r = [[rgb1 & $ff0000] >> $10] - [[rgb0 & $ff0000] >> $10]
	.var g = [[rgb1 & $00ff00] >> $08] - [[rgb0 & $00ff00] >> $08]
	.var b = [[rgb1 & $0000ff] >> $00] - [[rgb0 & $0000ff] >> $00]
	.var dist = sqrt(r*r + g*g + b*b)
	.return dist
}

.function findNearestColor(rgb) {
	.var minDist = 9999999
	.var c64 = 0
	.for (var i=0; i<16; i++) {
		.var dist = colorDist(rgb, defaultRGBs.get(i))
		.if (dist < minDist) {
			.eval c64 = i
			.eval minDist = dist
		}
	}
	.return c64
}

.function toC64Color(rgb) {
	.var c64 = rgb2c64.get(rgb)
	.if (c64 == null) {
		.eval c64 = findNearestColor(rgb)
		.eval rgb2c64.put(rgb, c64)
	}
	.return c64
}

.function getC64Color(xPos, yPos, pic, rgb2c64) {
	.eval xPos = xPos*2 + picOffsetX
	.var rgb0 = pic.getPixel(xPos+0, yPos)
	.var rgb1 = pic.getPixel(xPos+1, yPos)
	.var c64Color0 = toC64Color(rgb0)
	.var c64Color1 = toC64Color(rgb1)
	.if (c64Color0 == null) {
		.print "wrong color @ " + int(xPos) + "," + int(yPos)
		.eval c64Color0 = 0
	}
	.if (c64Color1 == null) {
		.print "wrong color @ " + int(xPos+1) + "," + int(yPos)
		.eval c64Color1 = 0
	}
	.var c64Color = c64Color0
	.if (c64Color0 == bgColor && c64Color1 != bgColor) .eval c64Color = c64Color1
	.return c64Color
}

.function getBlockColors(chrX, chrY, pic, rgb2c64) {
	.var colorCounts = list(16, 0)
	.for (var pixY=0; pixY<8; pixY++) {
		.for (var pixX=0; pixX<charWidth; pixX++) {
			.var c64Color = getC64Color(chrX*charWidth + pixX, chrY*8 + pixY, pic, rgb2c64)
			.eval colorCounts.set(c64Color, colorCounts.get(c64Color) + 1)
			.eval colorCounts.set(c64Color, colorCounts.get(c64Color) + 1)
		}
	}
	.eval colorCounts.set(bgColor, 0)
	.for (var i=0; i<16; i++) {
		.eval colorCounts.set(i, [colorCounts.get(i) << 4] | i)
	}
	.eval colorCounts.sort()
	.eval colorCounts.reverse()
	.if (colorCounts.get(numBlockColors) >= $10) {
		.print "too many colors @ char " + int(chrX) +"," +int(chrY)
		.return null
	}
	.var blockColors = list(16, 0)
	.for (var i=0; i<numBlockColors; i++) {
		.var c64Color = colorCounts.get(i) & $0f
		.eval blockColors.set(c64Color, i+1)
	}
	.return blockColors
}

.function getBlock(chrX, chrY, pic, rgb2c64) {
	.var blockColors = getBlockColors(chrX, chrY, pic, rgb2c64)
	.var blockData = List()
	.if (null == blockColors) {
		.return list(11, 0)
	}
	.for (var pixY=0; pixY<8; pixY++) {
		.var bitmapByte = 0
		.for (var pixX=0; pixX<charWidth; pixX++) {
			.var c64Color = getC64Color(chrX * charWidth + pixX, chrY*8 + pixY, pic, rgb2c64)
			.var multiColor = blockColors.get(c64Color)
			.eval bitmapByte = bitmapByte | [multiColor << [6 - pixX * 2]]
		}
		.eval blockData.add(bitmapByte)
	}
	.for (var multiColor=1; multiColor<4; multiColor++) {
		.var c64Color = 0
		.for (var i=1; i<16; i++) {
			.if (blockColors.get(i) == multiColor) .eval c64Color = i
		}
		.eval blockData.add(c64Color)
	}
	.return blockData
}

.var bitmapData = List()
.var screenData = List()
.var d800Data = List()

.function parsePic(pic, rgb2c64) {
	.for (var chrY=0; chrY<25; chrY++) {
		.for (var chrX=0; chrX<40; chrX++) {
			.var block = getBlock(chrX, chrY, pic, rgb2c64)
			.for (var i=0; i<8; i++) .eval bitmapData.add(block.get(i))
			.var scrColor = [block.get(8) << 4] | [block.get(9) & $f]
			.eval screenData.add(scrColor)
			.eval d800Data.add(block.get(10))
		}
	}
}

.function initPalette(pngPic) {
	.var rgb2c64 = Map()
	.return rgb2c64
}

.function getC64Pixel(xPos, yPos, pic, rgb2c64) {
	.var ret = 0
	.var xPosD = xPos + picOffsetX
	.if ((xPosD < 0) || (xPosD >= 320) || (yPos >= 200)) {
		.eval ret = 0
	} else {
		.eval ret = rgb2c64.get(pic.getPixel(xPosD, yPos))
	}
	.return ret
}

.function getSpritePixel(xPos, yPos, pic, rgb2c64) {
	.eval xPos = xPos * 2
	.var pix0 = getC64Pixel(xPos - 2, yPos, pic, rgb2c64)
	.var pix1 = getC64Pixel(xPos - 1, yPos, pic, rgb2c64)
	.var pix2 = getC64Pixel(xPos + 0, yPos, pic, rgb2c64)
	.var pix3 = getC64Pixel(xPos + 1, yPos, pic, rgb2c64)
	.var ret = 0
	.if ((pix0 != bgColor) && (pix1 == bgColor)) {
		.eval ret = 1
	}
	.if ((pix2 == bgColor) && (pix3 != bgColor)) {
		.eval ret = 1
	}
	.return ret
}

.function getSpriteByte(byteX, yPos, pic, rgb2c64) {
	.var byte = 0
	.for (var px=0; px<8; px++) {
		.var pxVal = getSpritePixel(byteX * 8 + px, yPos, pic, rgb2c64)
		.eval byte = byte | (pxVal << (7 - px))
	}
	.return byte
}

.var spriteData = List()

.function parseSprite(sprX, sprY, pic, rgb2c64) {
	.var baseX = sprX * 3
	.var baseY = sprY * 21
	.for (var byteY=0; byteY<21; byteY++) {
		.for (var byteX=0; byteX<3; byteX++) {
			.var byteVal = getSpriteByte(baseX + byteX, baseY + byteY, pic, rgb2c64)
			.eval spriteData.add(byteVal)
		}
	}
	.eval spriteData.add(0)
}

.function parseSprites(pic, rgb2c64) {
	.for (var sprY=0; sprY<10; sprY++) {
		.for (var sprX=0; sprX<7; sprX++) {
			.eval parseSprite(sprX, sprY, pic, rgb2c64)
		}
	}
}

.var pngPic = LoadPicture(filename)
.var rgb2c64 = initPalette(pngPic)
.eval parsePic(pngPic, rgb2c64)
.eval parseSprites(pngPic, rgb2c64)

.pc = bitmap "bitmap"
.fill 40*25*8, bitmapData.get(i)
.pc = screen0 "screen0"
.fill 40*25, screenData.get(i)
.pc = screen1 "screen1"
.fill 40*25, screenData.get(i)
.pc = d800tmp "d800tmp"
.fill 40*25, d800Data.get(i)

.pc = sprites "sprites"
.fill 7*10*64, spriteData.get(i)
//---------------------------------------------------------------------------------------------------------------------
.pc = tune "tune"
.var tuneFile = LoadBinary("screamingEagleTune.prg")
.fill tuneFile.getSize() - 2, tuneFile.get(i + 2)
//---------------------------------------------------------------------------------------------------------------------
:basic(init)
//---------------------------------------------------------------------------------------------------------------------
.pc = main "main"
//---------------------------------------------------------------------------------------------------------------------
outLoop:
{
	jmp *
}
//---------------------------------------------------------------------------------------------------------------------
topIrq:
{
	inc border

	:mb #$80: $d018

	lda #$32
	.for (var i=0; i<7; i++) {
		sta $d001 + i * 2
	}
	
	ldx #$a0
	.for (var i=0; i<7; i++) {
		stx screen0 + $03f8 + i
		inx
	}
	.for (var i=0; i<7; i++) {
		stx screen1 + $03f8 + i
		inx
	}
	
	ldx #<irq00
	ldy #>irq00
	lda #$46
}

irqEnd:
{
	stx $fffe
	sty $ffff
	sta $d012
	asl VIC2InteruptStatus
	:mb #0: border
r:	rti	
}
//---------------------------------------------------------------------------------------------------------------------
.macro makeIrq(irqNo, sprY, sprPnt, scr, nextIrq, nextd012) {

	inc border

	lda #sprY
	.for (var i=0; i<7; i++) {
		sta $d001 + i * 2
	}

	.if (irqNo == 2 || irqNo == 5) {
		jsr waitLoop
	}

	.var d18 = $80 + scr * $10
	:mb #d18 : $d018

	.var screen = screen0 + [scr^1]*$400
	ldx #sprPnt
	.for (var i=0; i<7; i++) {
		stx screen + $3f8 + i
		inx
	}

	.if (irqNo == 9) {
		inc border
		jsr tunePlay
	}

	ldx #<nextIrq
	ldy #>nextIrq
	lda #nextd012
	jmp irqEnd
}
//---------------------------------------------------------------------------------------------------------------------
irq00:	makeIrq(1, $47, $ae, 1, irq01, $5a)
irq01:	makeIrq(2, $5c, $b5, 0, irq02, $70)
irq02:	makeIrq(3, $71, $bc, 1, irq03, $85)
irq03:	makeIrq(4, $86, $c3, 0, irq04, $99)
irq04:	makeIrq(5, $9b, $ca, 1, irq05, $af)
irq05:	makeIrq(6, $b0, $d1, 0, irq06, $c4)
irq06:	makeIrq(7, $c5, $d8, 1, irq07, $d9)
irq07:	makeIrq(8, $da, $df, 0, irq08, $ee)
irq08:	makeIrq(9, $ef, $a0, 1, topIrq, topIrqLine)
//---------------------------------------------------------------------------------------------------------------------
waitLoop:
.pc = * "waitLoop"
{
	ldx #5
loop:	dex
	bne loop
	nop
	nop
	nop
	rts
}
//---------------------------------------------------------------------------------------------------------------------
.pc = * "init"
init:
{
	sei

	lda #$00
	jsr tuneInit
	
	ldx #0
!:	.for (var i=0; i<4; i++) {
		lda d800tmp + i * $0100,x
		sta $d800 + i * $0100,x
	}
	inx
	bne !-
	
	.for (var i=0; i<7; i++) {
		:mb #i*48+23 : $d000+i*2
		:mb #$32 : $d001+i*2
		:mb #$a0+i : screen0+$3f8+i
		:mb #$a7+i : screen1+$3f8+i
		:mb #bgColor : $d027+i
	}

	:mb #$7f : $d015
	:mb #$7f : $d01d
	:mb #$60 : $d010
	:mb #$00 : $d017
	:mb #$80 : $d018
	:mb #$02 : $dd00
	:mb #$d8 : $d016
	:mb #borderColor : $d020
	:mb #bgColor : $d021
		
	jsr clearInterrupts
	jsr initInterrupts
	cli
	jmp outLoop
}
//---------------------------------------------------------------------------------------------------------------------
clearInterrupts:
{
	:mb #ProcessorPortDDRDefault : $00
	:mb #ProcessorPortAllRAMWithIO : $01

	// Clear all CIA to known state, interrupts off.
	lda #$7f
	sta CIA1InterruptControl
	sta CIA2InterruptControl
	lda #0
	sta VIC2InteruptControl
	sta CIA1TimerAControl
	sta CIA1TimerBControl
	sta CIA2TimerAControl
	sta CIA2TimerBControl
	
	// Ack any interrupts that might have happened from the CIAs
	lda CIA1InterruptControl
	lda CIA2InterruptControl
	
	// Ack any interrupts that have happened from the VIC2
	:mb #$ff : VIC2InteruptStatus
	
	// Setup kernal and user mode IRQ vectors to point to a blank routine
	:mw #irqEnd.r : $fffe
	:mw #irqEnd.r : $fffa
	
	rts
}
//---------------------------------------------------------------------------------------------------------------------
initInterrupts:
{
	// Setup raster IRQ
	:mw #topIrq : $fffe
	:mb #1 : VIC2InteruptControl
	:mb #topIrqLine : $d012
	:mb #$3b : $d011

	// Ack any interrupts that might have happened from the CIAs
	lda CIA1InterruptControl
	lda CIA2InterruptControl

	// Ack any interrupts that have happened from the VIC2
	:mb #$ff : VIC2InteruptStatus
	
	rts
}
//---------------------------------------------------------------------------------------------------------------------
