#define VIF0_STAT		*((volatile unsigned long*)0x10003800)  // vif0 status register
#define VIF1_STAT		*((volatile unsigned long*)0x10003c00)  // vif1 status register

#define VIF_NOP				0x00
#define VIF_STCYL			0x01 
#define VIF_OFFSET			0x02
#define VIF_BASE			0x03		// 0000011 (set the TOP register for VU data memory double buffering)
#define VIF_FLUSH			0x11		// 0010001 (postpone VIF operation untill memory transfers for VU instruction and data memory have finished and the previous VU program has finished executing)
#define VIF_FLUSHA			0x13		// 0010011 (postpone VIF operation untill memory transfers for VU instruction and data memory have finished)
#define VIF_FLUSHE			0x10		// 0010000 (postpone VIF operation untill the previous VU program has finished executing)
#define VIF_MSCAL			0x14		// 0010100 (execute a VU program residing in address and exchange the double buffering registers)
#define VIF_MSCALF			0x15		// 0010101 (execute a VU program residing in address without swapping the double buffer registers)
#define VIF_MPG				0x4A		// 1001010 (size dwords to the VU program memory)

#define VIF_UNPACK			0x60
#define VIF_UNPACK_MASK		0x10

#define VIF_UNPACK_DBLBUF	0x8000	// applied to immediate

#define VIF_UNPACK_S_32		(VIF_UNPACK|0x00)	// scalar 32 bits
#define VIF_UNPACK_S_16		(VIF_UNPACK|0x01)	// scalar 16 bits
#define VIF_UNPACK_S_8		(VIF_UNPACK|0x02)	// scalar 8 bits
#define VIF_UNPACK_V2_32	(VIF_UNPACK|0x04)	// vector 2x 32 bits
#define VIF_UNPACK_V2_16	(VIF_UNPACK|0x05)	// vector 2x 16 bits
#define VIF_UNPACK_V2_8		(VIF_UNPACK|0x06)	// vector 2x 8 bits
#define VIF_UNPACK_V3_32	(VIF_UNPACK|0x08)	// vector 3x 32 bits
#define VIF_UNPACK_V3_16	(VIF_UNPACK|0x09)	// vector 3x 16 bits
#define VIF_UNPACK_V3_8		(VIF_UNPACK|0x0A)	// vector 3x 8 bits
#define VIF_UNPACK_V4_32	(VIF_UNPACK|0x0C)	// vector 4x 32 bits
#define VIF_UNPACK_V4_16	(VIF_UNPACK|0x0D)	// vector 4x 16 bits
#define VIF_UNPACK_V4_8		(VIF_UNPACK|0x0E)	// vector 4x 8 bits
#define VIF_UNPACK_V4_5		(VIF_UNPACK|0x0F)	// vector 5+5+5+1 bits

#define VIF_CODE(CMD,NUM,IMMEDIATE) ((((u32)(CMD))<<24)|(((u32)(NUM))<<16)|((u32)(IMMEDIATE)))

#define VIF_STAT_PROGRAM_RUNNING 0x04
#define VIF_STAT_UNPACKING		 0x03
#define VIF_STAT_GIF_TRANSFERING 0x08

#define vif_active() ((VIF1_STAT & (VIF_STAT_PROGRAM_RUNNING|VIF_STAT_UNPACKING|VIF_STAT_GIF_TRANSFERING)) != 0)
#define vif_program_running() ((VIF1_STAT & VIF_STAT_PROGRAM_RUNNING) != 0)

void vu_reset();
void vu_dbl_buf(int base, int offset); // call explicitly with -1, -1 to turn off double buffering
void vu_data_v4_32(void* data, u32 qw_count, int addr);
void vu_mpg(void* data, u32 instruction_count, int addr);
void vu_mscal();
void vu_mscalf();
void vu_flush();
void vu_send();

void vu_dump_to_file();
void vu_get_header(void** start, void** end);

// v4_32 at MOST 255 vec4's!
void vu_header_begin(int addr);
void vu_header_add(void* p, int nvec);
void vu_header_add_vecf(float x, float y, float z, float w);
void vu_header_add_veci(u32 x, u32 y, u32 z, u32 w);
void vu_header_add_u64_2(u64 x, u64 y);
int vu_header_end();

void vu_send_vif(void* pck, int qword_cnt);
