#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <stdlib.h>
#include <loadfile.h>
#include <fileio.h>
#include "amigamod.h"
#include "misc.h"

extern void gfx_vsync();


void mod_init()
{
/*	
	void* mod_ptr;
	int mod_size;
	nprintf("mod_init(%s)\n",filename);
	read_file(filename,&mod_ptr,&mod_size);
	nprintf("mod_init(%s): module size = %d\n", filename, mod_size); */
	if(SifLoadModule("rom0:LIBSD", 0, 0) < 0)
	{
		if(SifLoadModule("host:LIBSD", 0, 0) < 0)
		{
			if(SifLoadModule("cdrom0:LIBSD", 0, 0) < 0)
			{
				nprintf("mod_init(): failed to load LIBSD\n");
				SleepThread();
			}
		}
	}
	if(SifLoadModule("host:amigamod.irx", 0, 0) < 0)
	{
		if(SifLoadModule("cdrom0:amigamod.irx", 0, 0) < 0)
		{
			nprintf("mod_init(): failed to load amigamod.irx\n");
			SleepThread();
		}
	}
	amigaModInit(0);
}

void mod_load(char* begin, char* end)
{
	amigaModLoad(begin,(u32)end - (u32)begin);	
}

void mod_pause()
{
	gfx_vsync();
	amigaModPause();
	gfx_vsync();
	gfx_vsync();
}

void mod_play()
{
	amigaModPlay(0);
	gfx_vsync();
	gfx_vsync();
	amigaModSetVolume(0x3fff);
}

void mod_getpos(int* order, int* row)
{
	ModInfoStruct info;

	amigaModGetInfo(&info);
	*order = info.curorder;
	*row = info.currow;
}

void mod_quit()
{
	gfx_vsync();
	gfx_vsync();
	amigaModQuit();
}
