#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <fileio.h>
#include <stdlib.h>
#include <string.h>

#include "gfx.h"
#include "math.h"
#include "vu.h"
#include "pad.h"
#include "mod.h"

extern void e_particles_init();
extern void e_particles_prerun();
extern int e_particles_run();

extern void e_spheremod_init();
extern void e_spheremod_prerun();
extern int e_spheremod_run();

extern void e_rotozoom_init();
extern void e_rotozoom_prerun();
extern int e_rotozoom_run();

//#define TEST_ONE_FRAME

/*
float fmod_halfpi(float x)
{
	Vector3d temp = {x,x,x,x};
	Vector3d temp2 = {0.63661977236758134307607071493546,1.57079632679489661923,0,0};

  __asm__ __volatile__(
	  "lqc2	vf30, 0(%0)\n"
	  "lqc2	vf31, 0(%1)\n"

	  "vmulx.y vf30y,vf30y,vf31x\n"
	  "vftoi0.y vf30y,vf30y\n"
	  "vitof0.y vf30y,vf30y\n"
	  "vmul.y vf30y,vf30y,vf31y\n"
	  "vsuby.x vf30x,vf30x,vf30y\n"

	  "sqc2 vf30, 0(%0)\n"
	  :: "r" (&temp), "r" (&temp2) );

  printvec(temp.x,temp.y,temp.z,temp.w);
  return temp.x;
}*/

void vutest()
{/*
	const int count = 16;
	u32 v[4+count/2];
	int i;

	v[0] = VIF_CODE(VIF_FLUSH,0,0); 
	v[1] = VIF_CODE(VIF_NOP,0,0); 
	v[2] = VIF_CODE(VIF_STCYL,0,0x0101);
	v[3] = VIF_CODE(VIF_UNPACK_V4_5,count,0);
	for(i=0;i<count;++i)
		((u16*)(&v[4]))[i] = 0xffff;

	vu_send_vif(v,(sizeof(v)/sizeof(u32))/4);
	while(gif_active() || vif_active()) 
		;

	dumpmem(vu1_mem,vu1_mem+count*2);

	SleepThread();*/
}

void run_particles()
{
	e_particles_prerun();

	for(;;)
	{
		gfx_vsync();
		gfx_flip_screen();

#ifdef TEST_ONE_FRAME
		GIF_BGCOLOR = 0x00; // if the border flashes red, it's not one-frame!
#endif
		if(!e_particles_run())
			break;
#ifdef TEST_ONE_FRAME
		GIF_BGCOLOR = 0xff;
#endif
	}	
}

void run_rotozoom()
{
	e_rotozoom_prerun();

	for(;;)
	{
		gfx_vsync();
		gfx_flip_screen();

#ifdef TEST_ONE_FRAME
		GIF_BGCOLOR = 0x00; // if the border flashes red, it's not one-frame!
#endif
	if(!e_rotozoom_run())
		break;
#ifdef TEST_ONE_FRAME
		GIF_BGCOLOR = 0xff;
#endif
	}
}

void run_spheremod()
{
	e_spheremod_prerun();

	for(;;)
	{
		gfx_vsync();
		gfx_flip_screen();

#ifdef TEST_ONE_FRAME
		GIF_BGCOLOR = 0x00; // if the border flashes red, it's not one-frame!
#endif
		if(!e_spheremod_run())
			break;
#ifdef TEST_ONE_FRAME
		GIF_BGCOLOR = 0xff;
#endif
	}

}

int main()
{
  	SifInitRpc(0); 

	gfx_init();
	pad_init();

	DEFINE_BINARY_DATA(ss);
	mod_init();
	mod_load(binary_ss_start,binary_ss_end);

	e_particles_init();
	e_spheremod_init();
	e_rotozoom_init();

	mod_play();

	run_particles();
	run_spheremod();
	run_rotozoom();

	
	SleepThread();
	return 0;
}
