#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <fileio.h>
#include <stdlib.h>

#include "gfx.h"
#include "math.h"
#include "vu.h"
#include "misc.h"
#include "pad.h"

extern unsigned int e_rotozoom_vu_begin  __attribute__((section(".vudata")));
extern unsigned int e_rotozoom_vu_end  __attribute__((section(".vudata")));

extern unsigned char binary_e_rotozoom_img_start[]; 

static Vector3d obj[]={
	{  0,  1,  0, 1},
	{  1,  1,  0, 1},
	{  1,  0,  0, 1},
	{  0,  0,  0, 1},

	{  0,  1,  1, 1},
	{  1,  1,  1, 1},
	{  1,  0,  1, 1},
	{  0,  0,  1, 1},

};

// 49152 trekanter/frame = 2457600 trekanter/sec

static Vector3d actualobj[12*3];
#define NUM_ROWS 136

#define BATCH_SIZE 17

//#define PACKAGE_SIZE (4+(BATCH_SIZE+7)/8)
#define PACKAGE_SIZE (4+(BATCH_SIZE+7)/8)
#define PACKET_START 44

#define NBATCHES (NUM_ROWS/BATCH_SIZE)
//static 	Vector2d v[BATCH_SIZE+3];

static Vector2d *packages;

#define ARGB16(a,r,g,b) (((a)>0)<<15)|(((b)>>3)<<10)|(((g)>>3)<<5)|((r)>>3)

DEFINE_BINARY_DATA(font2);
DEFINE_BINARY_DATA(font2_alpha);
static texture font2;
gif_env;

static char scrolltext[]="                                  ZOOM AND ROTATE AT THE SAME TIME      ONLY AMIGA MAKES IT POSSIBLE                                THIS IS JAR AGAIN WITH ANOTHER ENTRY MADE TOO FAST AND USING A LAME FONT TO WRITE A LAME SCROLLTEXT     SORRY FOR THAT AGAIN TIME HAS NOT BEEN WHAT I HAVE HAD MOST OF   AND YES IT DOES LOOK RATHER LAME BUT I HAD FUN MAKING IT               GRAPHICS BY HR NOKO THE MUSIC WAS DONE BY BSTRR AND WAS THE ONLY USABLE MODULE I HAD LYING AROUND THIS TIME       USE YOUR JOYPAD TO CONTROL THE EFFECT IF YOU LIKE         GREETS TO THE ALWAYS HELPFUL PS2DEV REGULARS AND SOOPADOOPA                          OH YEAH AND A QUICK GREET TO SONY COMPUTER ENTERTAINMENT FOR MAKING MY LIFE HELL                                     DAMN BITCH0RING VU                               OH YEAH AND UGLY SOURCE RELEASED I DO NOT ACTUALLY BELIEVE THAT IT IS SOMETHING TO LEARN FROM BUT IF SOMEONE CAN BE HELPED TO AVOID JUST ONE OF THE  MANY MISTAKES I HAVE MADE WHILE TRYING TO LEARN VU PROGRAMMING I AM HAPPY     WELL OVER AND OUT     NOT AS IF ANYBODY BOTHERED TO READ THE SCROLLTEXT AND LET ALONE FOR SO LONG BUT HEY                          ";
static int scroll_pos = 0;
static int scroll_start = 0;

static void makepackage(int x, int y)
{
	Vector2d* v = &packages[PACKAGE_SIZE*((NUM_ROWS*NBATCHES)*y+x)];
	int j, all_transparent=1;

	for(j=0;j<PACKAGE_SIZE;++j)
		v[j].x=v[j].y=v[j].z=v[j].w=0;

	v[0].x = VIF_CODE(VIF_NOP,0,0); 
	v[0].y = VIF_CODE(VIF_NOP,0,0); 
	v[0].z = VIF_CODE(VIF_STCYL,0,0x0101);
	v[0].w = VIF_CODE(VIF_UNPACK_V4_32,1,PACKET_START|VIF_UNPACK_DBLBUF);
	v[2].x = VIF_CODE(VIF_NOP,0,0); 
	v[2].y = VIF_CODE(VIF_NOP,0,0); 
	v[2].z = VIF_CODE(VIF_NOP,0,0);
	v[2].w = VIF_CODE(VIF_UNPACK_V4_5,BATCH_SIZE,(PACKET_START+1)|VIF_UNPACK_DBLBUF);
	v[PACKAGE_SIZE-1].x = VIF_CODE(VIF_NOP,0,0); 
	v[PACKAGE_SIZE-1].y = VIF_CODE(VIF_MSCAL,0,0);  
	v[PACKAGE_SIZE-1].z = VIF_CODE(VIF_NOP,0,0); 
	v[PACKAGE_SIZE-1].w = VIF_CODE(VIF_NOP,0,0); 

	for(j=0;j<BATCH_SIZE;++j)
	{
		int r= binary_e_rotozoom_img_start[(x+j+y*NUM_ROWS)*3+0];
		int g= binary_e_rotozoom_img_start[(x+j+y*NUM_ROWS)*3+1];
		int b= binary_e_rotozoom_img_start[(x+j+y*NUM_ROWS)*3+2];
		u16* dst = (u16*)&v[3];

		if(r<245)
			all_transparent=0;

		dst[j] = ARGB16(1,r,g,b);
	}
	if(all_transparent)v[0].w=0; // mark it as unused
}

void e_rotozoom_init()
{
	int cnt=0,i;

	texture_load(&font2,binary_font2_start);
	texture_loadalpha(&font2,binary_font2_alpha_start);
	texture_allocupload(&font2);


#define ADD_FACE(a,b,c) { actualobj[cnt++]=obj[a]; actualobj[cnt++]=obj[b]; actualobj[cnt++]=obj[c]; }

	ADD_FACE(0,1,2);
	ADD_FACE(0,2,3);
	ADD_FACE(5,4,7);
	ADD_FACE(5,7,6);
	ADD_FACE(1,5,6);
	ADD_FACE(1,6,2);
	ADD_FACE(4,0,3);
	ADD_FACE(4,3,7);
	ADD_FACE(4,5,1);
	ADD_FACE(4,1,0);
	ADD_FACE(3,2,6);
	ADD_FACE(3,6,7);

	nprintf("e_rotozoom: Allocating %d qwords\n", PACKAGE_SIZE*NUM_ROWS*NBATCHES);
	packages = (Vector2d*)malloc(sizeof(Vector2d)*PACKAGE_SIZE*NUM_ROWS*NBATCHES);

	for(i=0;i<NUM_ROWS;++i)
	{
		int j;
		for(j=0;j<NBATCHES;++j)
		{
			makepackage(j*BATCH_SIZE,i);
		}
	}

	nprintf("e_rotozoom: MPG size = %d\n", DWORD_COUNT((ADDRESS_OF(&e_rotozoom_vu_end)-ADDRESS_OF(&e_rotozoom_vu_begin))));
}

void e_rotozoom_prerun()
{
}

static void SendBatch(int x, int y)
{
	Vector2d* v = &packages[PACKAGE_SIZE*((NUM_ROWS*NBATCHES)*y+x)];
	Vector3d* offset = (Vector3d*)&v[1];

	if(v[0].w==0) {
		return;
	}

	offset->x = (BATCH_SIZE*NBATCHES)/2.0 - x;
	offset->y = (NUM_ROWS/2.0f) - y;
	offset->z = 0;
	offset->w = 0;

	vu_send_vif(v,PACKAGE_SIZE);
}

#define FONT_SIZE 32

static void drawchar2(int x, int y, int c)
{
	int u,v;
	x = 32000+x*16;
	y = 32000+y*16;

	if(c==' ') return;

	if(c>='a' && c<='z')
		c+='A'-'a';
	if(c=='0') c='O';

	if(c>='A' && c<='Z')
	{
		c-='A';
		u = c*8*16;
		v = 0;
	}
	else
	{
		c-='1';
		u = c*8*16;
		v = 16*16;
	}

	gRGBAQ(0x3F80000080808080);

	gUV(u,v);
	gXYZ3(x,y,0);

	gUV(u,v+15*16);
	gXYZ3(x,y+FONT_SIZE*16,0);

	gUV(u+8*16,v);
	gXYZ2(x+FONT_SIZE*16,y,0);

	gUV(u+8*16,v+15*16);
	gXYZ2(x+FONT_SIZE*16,y+FONT_SIZE*16,0);
}

void drawline2(int x, int y, int cnt)
{
	while(x<640)
	{
		drawchar2(x,y,scrolltext[cnt % (sizeof(scrolltext)-1)]);
		x += FONT_SIZE;
		cnt++;
	}
}

#define MAXZOOM 36

static float angle = 0;
static float zoom = 0;
static float skewx = 0;
static float skewy = 0;
static float wave_time = 0;
static float wave_x = 0;
static float wave_y = 0;
static float wave_amount = 0;

static float camera_x = 0;
static float camera_y = 0;

static int interactive_mode = 0;
static float e_rotozoom_t=0;

void check_pad()
{
	struct padButtonStatus button_status;
	static u32 old_pad = 0;
	static int start_ljoy_h;
	static int start_rjoy_v;
	static int start_rjoy_h;
	u32 paddata, new_pad;
	pad_get_button_state(&button_status);
	paddata = pad_state_from_status(&button_status);

	new_pad = paddata & ~old_pad;
	old_pad = paddata;

	if(new_pad)
	{
		if(!interactive_mode)
		{
			nprintf("In interactive mode! Enjoy :) [press start to restart the effect]\n");
			zoom = MAXZOOM;
			start_ljoy_h = button_status.ljoy_h;
			start_rjoy_v = button_status.rjoy_v;
			start_rjoy_h = button_status.rjoy_h;
		}
		interactive_mode=1;
	}
	if(!interactive_mode) return;

	camera_x += button_status.rigth_p/128.0f - button_status.left_p/128.0f;
	camera_y += button_status.up_p/128.0f - button_status.down_p/128.0f;
	zoom += button_status.l1_p/128.0f - button_status.r1_p/128.0f;
	angle += ((button_status.ljoy_h-start_ljoy_h)/20)/256.0f;

	wave_amount += (button_status.l2_p-button_status.r2_p)/1024.0f;	
	wave_x += (button_status.square_p-button_status.triangle_p)/5000.0f;	
	wave_y += (button_status.cross_p-button_status.circle_p)/5000.0f;

	skewx += ((button_status.rjoy_v-start_rjoy_v)/20)/256.0f;
	skewy -= ((button_status.rjoy_h-start_rjoy_h)/20)/256.0f;

	if(new_pad & PAD_START)
	{
		interactive_mode=0;
		angle = 0;
		zoom = 0;
		skewx = 0;
		skewy = 0;
		wave_time = 0;
		wave_x = 0;
		wave_y = 0;
		wave_amount = 0;
		camera_x = 0;
		camera_y = 0;
		interactive_mode = 0;
		e_rotozoom_t=0;
	}
}

int e_rotozoom_run()
{
	int i;
	{
		gif_begin(dma_list);
		gif_tag(0xe,1,0,0,0);
		gPRMODECONT(1);				// refer to prim attributes
		gTEX0_1(0);
		gTEX1_1(0);
		gTEST_1(TEST_DEPTHTEST_ALWAYS);
		gPRIM(PRIM_SPRITE);
		gRGBAQ(0x3F80000080000000|0);
		gXYZ2(32000,32000,0);
		gXYZ2(32000+640*16,32000+256*16,0);
		gTEST_1(TEST_DEPTHTEST_GREATER);
		gALPHA_1(0);
		gif_send(dma_list);
	}

	/* send header and program */
	{
		Matrix viewmat,projmat, combined;
		math_matrix_identity(&viewmat);
		math_matrix_move(&viewmat,camera_x,camera_y,(70-zoom));

		{
			Matrix rotmat;
			math_matrix_identity(&rotmat);
			math_matrix_rotatez(&rotmat, angle);
			math_matrix_rotatex(&rotmat, skewx);
			math_matrix_rotatey(&rotmat, skewy);
			math_matrix_multiply(&viewmat,&rotmat,&viewmat);
		} 

		math_matrix_project(&projmat, M_PI*0.30f, 0.1, 100.0);
		math_matrix_multiply(&combined,&viewmat,&projmat);

		{
			Matrix scalemat;
			math_matrix_identity(&scalemat);
			scalemat.xu=16.0f*1.5f;
			scalemat.yv=16.0f;
			scalemat.zw=1.0f;
			scalemat.dummy4=1.0f;
			scalemat.xx=32000.0f/16.0f+320.0f;
			scalemat.yy=32000.0f/16.0f+128.0f;
			scalemat.zz=1.0f;
			math_matrix_multiply(&combined,&combined,&scalemat);
		}
		
		vu_reset();
		vu_dbl_buf(-1,-1);
		for(i=0;i<2;++i)
		{
			vu_header_begin(i*512);
			vu_header_add_veci(BATCH_SIZE,0,0,0);
			vu_header_add_u64_2(/*(12*BATCH_SIZE)|*/(1<<15UL)|(1UL<<46UL)|((u64)(PRIM_TRI|PRIM_ANTIALIAS1|PRIM_ALPHABLEND)<<47UL)|(4UL<<60UL),(u64)GIF_RGBAQ | ((u64)GIF_XYZF2 << 4UL) | ((u64)GIF_XYZF2 << 8UL) | ((u64)GIF_XYZF2 << 12UL));
			vu_header_add(&combined,4);
			vu_header_add_vecf(-1,wave_time,0,0); // INCR
			vu_header_add_vecf(wave_x,wave_y,wave_amount,0); // PLASMA PARAMETERS
			vu_header_add(actualobj, 12*3);
			vu_header_end();		
		}
		vu_dbl_buf(0, 512);
		vu_mpg(&e_rotozoom_vu_begin,DWORD_COUNT((ADDRESS_OF(&e_rotozoom_vu_end)-ADDRESS_OF(&e_rotozoom_vu_begin))),0);
		vu_send();
	}

	/* do actual stuff */
	for(i=0;i<NUM_ROWS;++i)
	{
		int j;
		for(j=0;j<NBATCHES;++j)
			SendBatch(j*BATCH_SIZE,i);
	}

	{
		gif_begin(dma_list);
		gif_tag(0xe,1,0,0,0);
		gPRIM(PRIM_TRI_STRIP | PRIM_TEXTUREMAP | PRIM_NOT_PERSPECTIVE | PRIM_ALPHABLEND);				
		gALPHA_1(ALPHA_BLEND_NORMAL);
		gPABE(0);
		gPRMODECONT(1);
		gTEST_1(TEST_DEPTHTEST_ALWAYS);
		gTEX0_1(texture_TEX0(&font2));
		gTEX1_1(0);
		drawline2(scroll_start,0,scroll_pos);
		gif_send(dma_list);
	}

	scroll_start-=32/4;
	if(scroll_start==-FONT_SIZE)
	{
		scroll_start=0;
		scroll_pos++;
	}

	if(!interactive_mode)
		angle += 1/50.0f;

	if(e_rotozoom_t<10 && !interactive_mode)
	{
		zoom += MAXZOOM/(50.0f*10.0f);
	}
	
	if(e_rotozoom_t>10 && !interactive_mode)
	{
		skewx = 0.8*sin((e_rotozoom_t-10)*2.2);
		skewy = 0.9*sin((e_rotozoom_t-10)*1.3);
	}

	if(e_rotozoom_t>13 && !interactive_mode)
	{
		wave_amount = (e_rotozoom_t-13)*0.4;
		if(wave_amount>6) wave_amount=6;
		wave_time = e_rotozoom_t*1.5;
		wave_x = 0.5+0.3*cos(e_rotozoom_t*0.52f);
		wave_y = 0.9+0.4*sin(e_rotozoom_t*0.3f+1);
	}

	if(interactive_mode) wave_time = e_rotozoom_t*3;

	e_rotozoom_t += 1.0f / 50.0f;

	check_pad();

	return 1;
}
