#include <tamtypes.h>
#include <fileio.h>
#include <stdlib.h>
#include <kernel.h>

#define MM 2147483647
#define AA 48271
#define QQ 44488
#define RR 3399

s32 random(s32 lo, s32 hi)
{
	static s32 X = 0xfedeabe;
	X=AA*(X%QQ)-RR*(X/QQ);
	if(X<0) X+=MM;
	return lo+X%(hi-lo+1);
}

#define MEDIA "host"
void read_file(const char* filename, void** ptr, int* size)
{
	char fname[FIO_PATH_MAX];
	int fd;
	sprintf(fname, "%s:%s",MEDIA,filename);
	fd = fioOpen(fname, O_RDONLY);
	if(fd > 0)
	{
		*size = fioLseek(fd, 0, SEEK_END);		
		fioLseek(fd, 0, SEEK_SET);
		*ptr = malloc(*size);
		if(*ptr == 0)
		{
			fioClose(fd);
			nprintf("read_file(): Out of memory while loading %s\n", fname);
			SleepThread();
		}
		if(fioRead(fd, *ptr, *size) != *size)
		{
			fioClose(fd);
			nprintf("read_file(): Error reading from %s\n", fname);
			SleepThread();
		}
		fioClose(fd);
	}
	else
	{
		nprintf("read_file(): Error loading %s\n", fname);
		SleepThread();
	}
}

