#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <stdlib.h>

#include "gfx.h"
#include "gif.h"
#include "texture.h"
#include "math.h"
#include "mod.h"
#include "pad.h"

static int frames =0;

extern void effect1_load();
extern void effect2_load();

void do_effect1()
{
	extern void effect1_prerun();
	extern int effect1_run(float t);

	gfx_reset_texmem();
	effect1_prerun();
	frames = 0;
	for(;;)
	{
		//mod_getpos(&order,&row);
		gfx_vsync();
		gfx_flip_screen();

		if(!effect1_run(frames / 50.0f))
			break;

		++frames;
	}
}

void do_effect2()
{
	extern void effect2_prerun();
	extern int effect2_run(float t);

	gfx_reset_texmem();
	effect2_prerun();
	frames = 0;
	for(;;)
	{
		//mod_getpos(&order,&row);
		gfx_vsync();
		gfx_flip_screen();

		if(!effect2_run(frames / 50.0f))
			break;

		++frames;
	}
}

extern void vu_init();

int main(int argc, char* argv[])
{   
   	SifInitRpc(0); 
   	gfx_init();   	
	math_init();
	mod_init("fernandos_gym.mod");
	vu_init();
	//pad_init();
	
	/* init effects */
	effect1_load();
	effect2_load();
	
	mod_play();   	  	

	/* do effects */
	do_effect1();
	do_effect2();
  
   	return 0;
}
