#ifndef GIF_H_INCLUDED
#define GIF_H_INCLUDED

/*** GIF ****************************************************************************/

#define GIF 			((volatile unsigned long*)0x12000000)

#define GIF_PMODE		*((volatile unsigned long*)0x12000000)	// Setup CRT Controller
#define GIF_SMIDE2		*((volatile unsigned long*)0x12000020)	// CRTC Video Settings: PAL/NTCS, Interlace, etc.
#define GIF_DISPFB1		*((volatile unsigned long*)0x12000070)	// Setup the CRTC's Read Circuit 1 data source settings
#define GIF_DISPLAY1	*((volatile unsigned long*)0x12000080)	// RC1 display output settings
#define GIF_DISPFB2		*((volatile unsigned long*)0x12000090)	// Setup the CRTC's Read Circuit 2 data source settings
#define GIF_DISPLAY2	*((volatile unsigned long*)0x120000a0)	// RC2 display output settings
#define GIF_EXTBUF		*((volatile unsigned long*)0x120000b0)	// ...
#define GIF_EXTDATA		*((volatile unsigned long*)0x120000c0)	// ...
#define GIF_EXTWRITE	*((volatile unsigned long*)0x120000d0)	// ...
#define GIF_BGCOLOR		*((volatile unsigned long*)0x120000e0)	// Set CRTC background color
#define GIF_CSR			*((volatile unsigned long*)0x12001000)	// System status and reset
#define GIF_IMR			v((volatile unsigned long*)0x12001010)	// Interrupt Mask Register
#define GIF_BUSDIR		*((volatile unsigned long*)0x12001040)	// ...
#define GIF_SIGLBLID	*((volatile unsigned long*)0x12001080)	// ...

#define GIF_FRAME_1 	0x4c
#define GIF_FRAME_2 	0x4d
#define GIF_ZBUF_1 		0x4e
#define GIF_ZBUF_2 		0x4f
#define GIF_XYOFFSET_1 	0x18
#define GIF_XYOFFSET_2 	0x19
#define GIF_SCISSOR_1 	0x40
#define GIF_SCISSOR_2 	0x41
#define GIF_PRMODECONT 	0x1a
#define GIF_COLCLAMP 	0x46
#define GIF_DTHE 		0x45
#define GIF_TEST_1	 	0x47
#define GIF_TEST_2 		0x48
#define GIF_PRIM 		0x00
#define GIF_RGBAQ 		0x01
#define GIF_ST 			0x02
#define GIF_XYZF2 		0x04
#define GIF_XYZ2 		0x05
#define GIF_XYZ3 		0x0d
#define GIF_UV 			0x03
#define GIF_TEX0_1 		0x06
#define GIF_TEX0_2 		0x07
#define GIF_TEX1_1 		0x14
#define GIF_TEX1_2 		0x15
#define GIF_TEX2_1 		0x16
#define GIF_TEX2_2 		0x17
#define GIF_CLAMP_1 	0x08
#define GIF_CLAMP_2 	0x09
#define GIF_ALPHA_1 	0x42
#define GIF_ALPHA_2 	0x43
#define GIF_PABE 		0x49
#define GIF_FINISH		0x61

/*** DMA ****************************************************************************/

#define DMA 			((volatile unsigned int*)0x1000E000)

#define DMA_CTRL		*((volatile unsigned int*)0x1000E000)
#define DMA_STAT		*((volatile unsigned int*)0x1000E010)
#define DMA_PCR			*((volatile unsigned int*)0x1000E020)
#define DMA_SQWC		*((volatile unsigned int*)0x1000E030)
#define DMA_RBSR		*((volatile unsigned int*)0x1000E040)
#define DMA_RBOR		*((volatile unsigned int*)0x1000E050)
#define DMA_STADR		*((volatile unsigned int*)0x1000E060)

#define DMA01 			((volatile unsigned int*)0x10009000)

#define DMA01_CHCR 		*((volatile unsigned int*)0x10009000)		/* CHANNEL CONTROL 	*/
#define DMA01_MADR 		*((volatile unsigned int*)0x10009010)		/* MEMORY ADDRESS  	*/
#define DMA01_QWC 		*((volatile unsigned int*)0x10009020)		/* QUAD WORD COUNT 	*/
#define DMA01_TADR 		*((volatile unsigned int*)0x10009030)		/* TAG ADDRESS 		*/

#define DMA02 			((volatile unsigned int*)0x1000A000)

#define DMA02_CHCR 		*((volatile unsigned int*)0x1000A000)		/* CHANNEL CONTROL 	*/
#define DMA02_MADR 		*((volatile unsigned int*)0x1000A010)		/* MEMORY ADDRESS  	*/
#define DMA02_QWC 		*((volatile unsigned int*)0x1000A020)		/* QUAD WORD COUNT 	*/
#define DMA02_TADR 		*((volatile unsigned int*)0x1000A030)		/* TAG ADDRESS 		*/

#define DMA01_WAIT() 	{while(DMA01_CHCR&0x100); }
#define DMA02_WAIT() 	{while(DMA02_CHCR&0x100); }

#define DMA01_SEND(start, size, chcr) { DMA01_MADR=((s32)(start))&0x0fffffff; DMA01_QWC=(size); DMA01_CHCR=(chcr); }
#define DMA02_SEND(start, size, chcr) { DMA02_MADR=(s32)start; DMA02_QWC=size; DMA02_CHCR=chcr; }


#define TEST_ALPHATEST			0x00001
#define TEST_DEPTHTEST_NEVER	0x10000
#define TEST_DEPTHTEST_ALWAYS	0x30000
#define TEST_DEPTHTEST_GEQUAL	0x50000
#define TEST_DEPTHTEST_GREATER	0x70000

#define PRIM_POINT			0
#define PRIM_LINE			1
#define PRIM_LINE_STRIP		2
#define PRIM_TRI			3
#define PRIM_TRI_STRIP		4
#define PRIM_TRI_FAN		5
#define PRIM_SPRITE			6

#define PRIM_GOURAUD			0x008
#define PRIM_TEXTUREMAP			0x010
#define PRIM_FOG				0x020
#define PRIM_ALPHABLEND			0x040
#define PRIM_ANTIALIAS1			0x080
#define PRIM_NOT_PERSPECTIVE	0x100


#define TEX1_BILINEAR			0x20

#define GS_RGBAQ(R,G,B,A,Q) (((u64)(R)<<0)|((u64)(G)<<8)|((u64)(B)<<16)|((u64)(A)<<24)|((u64)(Q)<<32))
	 
/* TAK TIL CRAFT */
typedef struct int128
{
	s64 lo,hi;
}int128 __attribute__((aligned(16)));

#define wwd(a,b) ((((long)(b))<<32)+((long)(a)))
#define hhw(a,b) ((((long)(b))<<16)+((long)(a)))

#define gif_env int GIF_i; int128 *GIF_p,*GIF_beg;s64 GIF_nreg;s64 GIF_flg,GIF_prim,GIF_pre
#define gif_begin(a){GIF_p=a;GIF_beg=(void*)a;}
#define gif_tag(regs,nreg,flg,prim,pre) {GIF_i=1;GIF_nreg=nreg;GIF_flg=flg;GIF_prim=prim;GIF_pre=pre;GIF_p[0].hi=regs;}
#define gif_end() {GIF_p[0].lo=(GIF_nreg<<60)+(GIF_flg<<58)+(GIF_prim<<47)+(GIF_pre<<46)+(GIF_i-1)/GIF_nreg;GIF_p+=GIF_i;GIF_i=0;}
#define gif_endfinal() {GIF_p[0].lo=(GIF_nreg<<60)+(GIF_flg<<58)+(GIF_prim<<47)+(GIF_pre<<46)+(((int)1)<<15)+(GIF_i-1)/GIF_nreg;GIF_p+=GIF_i;GIF_i=0;}
#define gif_endimagemode(a) {GIF_p[0].lo=(GIF_nreg<<60)+(GIF_flg<<58)+(GIF_prim<<47)+(GIF_pre<<46)+(((int)1)<<15)+a;GIF_p+=GIF_i;GIF_i=0;}

#define gif_send(a)		gif_endfinal(); \
						flush_cache(0); \
						DMA02_WAIT(); \
						DMA02_SEND(a,gif_length,0x101); \
						DMA02_WAIT()


#define gif_length ((GIF_p-GIF_beg)+GIF_i)

#define gPABE(a)    		{GIF_p[GIF_i].hi=GIF_PABE;  		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gALPHA_1(a)    		{GIF_p[GIF_i].hi=GIF_ALPHA_1;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gALPHA_2(a)    		{GIF_p[GIF_i].hi=GIF_ALPHA_2;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gCLAMP_1(a)    		{GIF_p[GIF_i].hi=GIF_CLAMP_1;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gCLAMP_2(a)    		{GIF_p[GIF_i].hi=GIF_CLAMP_2;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gUV(u,v)    		{GIF_p[GIF_i].hi=GIF_UV;   			GIF_p[GIF_i].lo=hhw((u),(v)); GIF_i++;}
#define gST(a)    			{GIF_p[GIF_i].hi=GIF_ST;   			GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEX0_1(a)    		{GIF_p[GIF_i].hi=GIF_TEX0_1;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEX0_2(a)    		{GIF_p[GIF_i].hi=GIF_TEX0_2;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEX1_1(a)    		{GIF_p[GIF_i].hi=GIF_TEX1_1;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEX1_2(a)    		{GIF_p[GIF_i].hi=GIF_TEX1_2;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEX2_1(a)    		{GIF_p[GIF_i].hi=GIF_TEX2_1;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEX2_2(a)    		{GIF_p[GIF_i].hi=GIF_TEX2_2;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gFRAME_1(a)    		{GIF_p[GIF_i].hi=GIF_FRAME_1;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gFRAME_2(a)    		{GIF_p[GIF_i].hi=GIF_FRAME_2;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gZBUF_1(a)    		{GIF_p[GIF_i].hi=GIF_ZBUF_1;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gZBUF_2(a)    		{GIF_p[GIF_i].hi=GIF_ZBUF_2;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gXYOFFSET_1(a)   	{GIF_p[GIF_i].hi=GIF_XYOFFSET_1;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gXYOFFSET_2(a)   	{GIF_p[GIF_i].hi=GIF_XYOFFSET_2;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gSCISSOR_1(a)   	{GIF_p[GIF_i].hi=GIF_SCISSOR_1;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gSCISSOR_2(a)   	{GIF_p[GIF_i].hi=GIF_SCISSOR_2;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gPRMODECONT(a)   	{GIF_p[GIF_i].hi=GIF_PRMODECONT;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gCOLCLAMP(a)   		{GIF_p[GIF_i].hi=GIF_COLCLAMP;   	GIF_p[GIF_i].lo=a; GIF_i++;}
#define gDTHE(a)   			{GIF_p[GIF_i].hi=GIF_DTHE;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEST_1(a)   		{GIF_p[GIF_i].hi=GIF_TEST_1;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gTEST_2(a)   		{GIF_p[GIF_i].hi=GIF_TEST_2;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gPRIM(a)   			{GIF_p[GIF_i].hi=GIF_PRIM;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gRGBAQ(a)   		{GIF_p[GIF_i].hi=GIF_RGBAQ;   		GIF_p[GIF_i].lo=a; GIF_i++;}
#define gXYZ2(x,y,z)		{GIF_p[GIF_i].hi=GIF_XYZ2;   		GIF_p[GIF_i].lo=wwd(hhw((x),(y)),(z)); GIF_i++;}
#define gXYZ3(x,y,z)		{GIF_p[GIF_i].hi=GIF_XYZ3;   		GIF_p[GIF_i].lo=wwd(hhw((x),(y)),(z)); GIF_i++;}
#define gVEC(a,b)   		{GIF_p[GIF_i].hi=a;   				GIF_p[GIF_i].lo=b; GIF_i++;}

#endif 
