#include <tamtypes.h>
#include <kernel.h>
#include "gfx.h"
#include "gif.h"
#include "misc.h"

int gfx_screen[2];
int gfx_zbuffer;
int gfx_pal;
static int gfx_texmem_start;
static int gfx_nextfree;
int128 dma_list[1<<14]; // 256K (16K entries)

void dma_reset()
{
	DMA02[32]=0;
	DMA02_CHCR=0;
	DMA02_TADR=0;
	DMA02_MADR=0;
	DMA02[20]=0;
	DMA02[16]=0;

	DMA01[32]=0;
	DMA01_CHCR=0;
	DMA01_TADR=0;
	DMA01_MADR=0;
	DMA01[20]=0;
	DMA01[16]=0;

	DMA[4]=0xff1f; // D_STAT
	DMA[4]=DMA[4]&0xff1f; // D_STAT

	DMA[0]=0; // D_CTRL
	DMA[8]=0; // D_PCR
	DMA[12]=0; // D_SQWC
	DMA[20]=0; // D_RBSR
	DMA[16]=0; // D_RBOR

	DMA[0]=DMA[0]|1; // D_CTRL
}

void gfx_init()
{
	nprintf("gfx_init()\n");
	gs_init();
	dma_reset();

	texture_cleartexturemem(0);

	gfx_screen[0] = gfx_allocvideomem(640*256*4);
	gfx_screen[1] = gfx_allocvideomem(640*256*4);
	gfx_zbuffer = gfx_allocvideomem(640*256*4);

	gfx_set_texmem_base();

	gfx_pal = *((volatile char*)0x1fc80000-0xae) == 'E';
}

void gfx_flip_screen()
{
	static int interlaceframe = 0;
	gif_env;
	
	
	GIF[0]=0x000000000000FF62;
	GIF[4]=0x0000000000000002;


	if(gfx_pal)
	{
		GIF[18]=0x0000000000001400+gfx_screen[interlaceframe]/2048/4;
		GIF[20]=0x000ff9FF01824290;
	}
	else
	{
		GIF[18]=0x0000000000001400+gfx_screen[interlaceframe]/2048/4+10;
		GIF[20]=0x000c79FF01824290;
	}

	interlaceframe=1-interlaceframe;

	gif_begin(dma_list);
	gif_tag(0xe,1,0,0,0);
	gFRAME_1(0x00A0000+gfx_screen[interlaceframe]/2048/4);	// framebuffer width = 640/64
	gZBUF_1(gfx_zbuffer/2048/4);				// 0-8 Zbuffer base, 24-27 Z format (32bit)
	gXYOFFSET_1(wwd(32000,32000));	// X,Y offset
	gSCISSOR_1(wwd(hhw(0,639),hhw(0,255)));			// x1,y1,x2,y2 - scissor window
	gPRMODECONT(1);						// refer to prim attributes
	gCOLCLAMP(1);
	gDTHE(0);						// Dither off
	gTEST_1(TEST_DEPTHTEST_ALWAYS);
	gif_endfinal();

	flush_cache(0);
	DMA02_WAIT();
	DMA02_SEND(dma_list,gif_length,0x101);
	DMA02_WAIT();
}

void gfx_vsync()
{
	*((volatile unsigned long*)0x12001000)=*((volatile unsigned long*)0x12001000)&8;
	while(!(*((volatile unsigned long*)0x12001000)&8));
}

void gfx_allocinit(int start)
{
	start=(-BLOCKSIZE)&(start+BLOCKSIZE-1);
	
	gfx_nextfree=start;
}

int gfx_allocvideomem(int size)
{
	size=(-BLOCKSIZE)&(size+BLOCKSIZE-1);

	gfx_nextfree+=size;
	return gfx_nextfree-size;
}

void gfx_reset_texmem()
{
	gfx_allocinit(gfx_texmem_start);
}

void gfx_set_texmem_base()
{
	gfx_texmem_start = gfx_nextfree;
}

void gfx_clearscreen(u64 color)
{
	gif_env;
	
	gif_begin(dma_list);
	gif_tag(0xe,1,0,0,0);
		
	gPRMODECONT(1);				// refer to prim attributes
	gTEST_1(TEST_DEPTHTEST_ALWAYS);
	gPRIM(PRIM_SPRITE);
	gRGBAQ(0x3F80000080000000|color);
	gXYZ2(32000,32000,0);
	gXYZ2(32000+640*16,32000+256*16,0);
		
	gif_endfinal();
	flush_cache(0);
	DMA02_WAIT();
	DMA02_SEND(dma_list,gif_length,0x101);
	DMA02_WAIT();
	
}

void gfx_draw_background(texture* tex, int alpha)
{
	gif_env;

	gif_begin(dma_list);
	gif_tag(0xe,1,0,0,0);


	gPRMODECONT(1);				// refer to prim attributes

	gTEX0_1(texture_TEX0(tex));
	gTEX1_1(1<<5);				//bilinear
	gTEST_1(TEST_DEPTHTEST_ALWAYS);
	gPRIM(0x116+0x40);
	alpha &= 255;
	gRGBAQ(0x3F80000080000000 | (alpha<<16) | (alpha<<8) | alpha);
	gUV(0,0);
	gXYZ2(32000,32000,0);
	gUV(tex->width*16,tex->height*16);
	gXYZ2(32000+640*16,32000+256*16,0);

	gif_endfinal();
	flush_cache(0);
	DMA02_WAIT();
	DMA02_SEND(dma_list,gif_length,0x101);
	DMA02_WAIT();
}	

void gfx_set_register(u64 reg, u64 dat)
{
	gif_env;

	gif_begin(dma_list);
	gif_tag(0xe,1,0,0,0);
	GIF_p[GIF_i].hi=reg; 
	GIF_p[GIF_i].lo=dat; 
	GIF_i++;

	gif_endfinal();
	flush_cache(0);
	DMA02_WAIT();
	DMA02_SEND(dma_list,gif_length,0x101);
	DMA02_WAIT();
}
