#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <stdlib.h>
#include <math.h>

#include "gfx.h"
#include "math.h"

#define FADEIN_END 4.460f//2.5f
#define TRIPART_END 13.399f//15.0f
#define SWIRLPART_END (TRIPART_END+8.961f)
#define ALL_END (SWIRLPART_END+1.0f)

#define X_DIV1 15
#define Y_DIV1 5

#define X_DIV 30//15
#define Y_DIV 15//5

static void* bck_data;
static int bck_size;
static texture bck_texture;
static texture bck2_texture;

static inline void rotate(int* dx, int* dy, int cx, int cy, float ang, float g)
{
	int x = *dx - cx;
	int y = *dy - cy;

	float ca = cos(ang);
	float sa = sin(ang);

	*dx = g*(x*ca - y*sa) + cx;
	*dy = g*(x*sa + y*ca) + cy;
}

void effect1_load()
{
	void* bck2_data;
	int bck2_size;

	read_file("effect1_bck.pcx",&bck_data,&bck_size);
	texture_load(&bck_texture,bck_data);

	read_file("bck2.pcx",&bck2_data,&bck2_size);
	texture_load(&bck2_texture,bck2_data);
}

void effect1_prerun()
{
	texture_allocupload(&bck_texture);
	texture_allocupload(&bck2_texture);
}

static float lastt;
static int lastcnt= -1;
static int maxcnt;
static int GIF_i; static int128 *GIF_p,*GIF_beg;s64 GIF_nreg;s64 GIF_flg,GIF_prim,GIF_pre; // gif_env !!!!

static float uv[2*(X_DIV+1)*(Y_DIV+1)];

static void drawsq(int x, int y, float t, int cnt)
{
	int x0 = (x*640*16)/(X_DIV1);
	int y0 = (y*256*16)/(Y_DIV1);
	int x1 = ((x+1)*640*16)/(X_DIV1);
	int y1 = ((y+1)*256*16)/(Y_DIV1);

	int ax = x0, ay = y0;
	int bx = x0, by = y1;
	int cx = x1, cy = y0;
	int dx = x1, dy = y1;

	int u0 = (x*bck2_texture.width*16)/(X_DIV1);
	int v0 = (y*bck2_texture.height*16)/(Y_DIV1);
	int u1 = ((x+1)*bck2_texture.width*16)/(X_DIV1);
	int v1 = ((y+1)*bck2_texture.height*16)/(Y_DIV1);

	if(cnt==maxcnt-1)
	{
		int midx = (x1+x0)>>1;
		int midy = (y1+y0)>>1;

		float g = ((t-lastt) / ((TRIPART_END-FADEIN_END)/(X_DIV1*Y_DIV1)));
		float ang = M_PI* (1-g);
		float sz = g;

		rotate(&ax,&ay,midx,midy,ang,sz);
		rotate(&bx,&by,midx,midy,ang,sz);
		rotate(&cx,&cy,midx,midy,ang,sz);
		rotate(&dx,&dy,midx,midy,ang,sz);				

	}
	gUV(u0,v0);
	gXYZ3(32000+ax,32000+ay,0);

	gUV(u0,v1);
	gXYZ3(32000+bx,32000+by,0);

	gUV(u1,v0);
	gXYZ2(32000+cx,32000+cy,0);

	gUV(u1,v1);
	gXYZ2(32000+dx,32000+dy,0);
}

static void drawsq2(int x, int y, float*uv, int alpha)
{
	int x0 = (x*640*16)/(X_DIV);
	int y0 = (y*256*16)/(Y_DIV);
	int x1 = ((x+1)*640*16)/(X_DIV);
	int y1 = ((y+1)*256*16)/(Y_DIV);

	//gRGBAQ(0x3f00000080808080);
	gRGBAQ(0x3F80000080000000 | (alpha<<16) | (alpha<<8) | alpha);

	gST(*(s64*)&uv[2*(0)+0]);
	gXYZ3(32000+x0,32000+y0,0);

	gST(*(s64*)&uv[2*(X_DIV+1)+0]);
	gXYZ3(32000+x0,32000+y1,0);

	gST(*(s64*)&uv[2*(1)+0]);
	gXYZ2(32000+x1,32000+y0,0);

	gST(*(s64*)&uv[2*(X_DIV+1+1)+0]);
	gXYZ2(32000+x1,32000+y1,0);
}

#define MAXRAD 3.56

int effect1_run(float t)
{	
	static float startt = -1;
	if(startt<0)startt=t;
	// draw background
	if(t<TRIPART_END)
	{
		int bck_alpha=(t-startt) * 8 + (t-startt)*(t-startt) * 9.2;
		gfx_draw_background(&bck_texture, bck_alpha>0x80?0x80:bck_alpha);	

		if(t>FADEIN_END)
		{
			int x, y, cnt;
			maxcnt = ((t-FADEIN_END)/(TRIPART_END-FADEIN_END)) * (X_DIV1*Y_DIV1);

			if(maxcnt!=lastcnt)
			{
				//printfloat(t-lastt);
				//printfloat((TRIPART_END-FADEIN_END)/(X_DIV*Y_DIV));
				lastt=t;
				lastcnt=maxcnt;
			}

			gif_begin(dma_list);
			gif_tag(0xe,1,0,0,0);

			gPRMODECONT(1);				// refer to prim attributes

			gPRIM(PRIM_TRI_STRIP | PRIM_ANTIALIAS1 | PRIM_TEXTUREMAP | PRIM_NOT_PERSPECTIVE);
			gTEST_1(TEST_DEPTHTEST_ALWAYS);
			gTEX0_1(texture_TEX0(&bck2_texture));
			gTEX1_1(TEX1_BILINEAR);				//bilinear
			gRGBAQ(0x3f00000080808080);

			cnt=0;
			for(y=0;y<Y_DIV1/2&&cnt<maxcnt;++y)
			{
				for(x=0;x<X_DIV1/2&&cnt<maxcnt;++x,++cnt)
					drawsq(x,y,t,cnt);
				for(x=X_DIV1-1;x>=X_DIV1/2&&cnt<maxcnt;--x,++cnt)
					drawsq(x,y,t,cnt);
			}
			for(y=Y_DIV1-1;y>=Y_DIV1/2&&cnt<maxcnt;--y)
			{
				for(x=0;x<X_DIV1/2&&cnt<maxcnt;++x,++cnt)
					drawsq(x,y,t,cnt);
				for(x=X_DIV1-1;x>=X_DIV1/2&&cnt<maxcnt;--x,++cnt)
					drawsq(x,y,t,cnt);
			}

			gif_send(dma_list);
		}
	}
	else if(t<SWIRLPART_END){
		int x, y, cnt;
		float cx1, cy1, cx2, cy2;
		float adjt,adjt2;

		gif_begin(dma_list);
		gif_tag(0xe,1,0,0,0);

		gPRMODECONT(1);				// refer to prim attributes

		gPRIM(PRIM_TRI_STRIP | PRIM_ANTIALIAS1 | PRIM_TEXTUREMAP);
		gTEST_1(TEST_DEPTHTEST_ALWAYS);
		gTEX0_1(texture_TEX0(&bck2_texture));
		gTEX1_1(TEX1_BILINEAR);				//bilinear

		cx1=(X_DIV/2) + (X_DIV/4)*cos(t*1.2f+44);
		cy1=(Y_DIV/2) + (Y_DIV/4)*cos(t*0.23f+3141592);
		cx2=(X_DIV/2) + (X_DIV/4)*sin(t*-0.5f+123123);
		cy2=(Y_DIV/2) + (Y_DIV/4)*cos(t*1.7f+21743);
		
		cnt=0;
		adjt = sin((t-TRIPART_END)*0.7-M_PI/2)*0.5+0.5;
		adjt2 = cos((t-TRIPART_END)*1.1+233)*0.5+0.5;
		for(y=0;y<Y_DIV+1;++y)
		{
			for(x=0;x<X_DIV+1;++x)
			{
				float ut  = (float)(x) / (float)(X_DIV) -0.5;
				float vt  = (float)(y) / (float)(Y_DIV) -0.5;
				float u,v;

				float d1 = sqrt((x-cx1)*(x-cx1)+(y-cy1)*(y-cy1))*(0.385652f*(1-adjt));
				float d2 = sqrt((x-cx2)*(x-cx2)+(y-cy2)*(y-cy2))*(0.2854f*adjt2);
				float ang = ((d1>MAXRAD?0:(MAXRAD-d1)) + (d2>MAXRAD?0:(MAXRAD-d2))) * adjt;
				float ca = cos(ang);
				float sa = sin(ang);

				u = ut*ca - vt*sa;
				v = ut*sa + vt*ca;

				uv[cnt+0] = u+0.5;
				uv[cnt+1] = v+0.5;
				cnt+=2;
			}
		}

		cnt=0;
		for(y=0;y<Y_DIV;++y)
		{
			for(x=0;x<X_DIV;++x)
			{
				drawsq2(x,y,&uv[cnt],0x80);
				cnt+=2;
			}
			cnt+=2;
		}

		gif_send(dma_list);
	}
	else if(t<ALL_END)
	{
		int x, y, cnt,alpha;

		gif_begin(dma_list);
		gif_tag(0xe,1,0,0,0);

		gPRMODECONT(1);				// refer to prim attributes

		gPRIM(PRIM_TRI_STRIP | PRIM_ANTIALIAS1 | PRIM_TEXTUREMAP);
		gTEST_1(TEST_DEPTHTEST_ALWAYS);
		gTEX0_1(texture_TEX0(&bck2_texture));
		gTEX1_1(TEX1_BILINEAR);				//bilinear

		cnt=0;
		alpha = 0x80 - 0x80*(t-SWIRLPART_END)/(ALL_END-SWIRLPART_END);
		for(y=0;y<Y_DIV;++y)
		{
			for(x=0;x<X_DIV;++x)
			{
				drawsq2(x,y,&uv[cnt],alpha);
				cnt+=2;
			}
			cnt+=2;
		}

		gif_send(dma_list);

	}

	return t<ALL_END;
}

