#define IsKeyP(x) keymap[x]

#define KBINT	9
#define KBPORT  0x60

#include <dos.h>
#include "kbdefine.h"

unsigned char keymap[255];

unsigned char handler_on=0;

void interrupt (*cpukbhandler)();
void interrupt newkbhandler();

unsigned char isext=0;
unsigned char isrel=0;

unsigned char k_shift=0;
unsigned char k_alt=0;
unsigned char k_ctrl=0;
unsigned char k_winlogos=0;

void init_kbhandler(void) {
	unsigned char a;
	cpukbhandler=getvect(KBINT);
	setvect(KBINT,newkbhandler);
	for(a=0;a<101;a++) keymap[a]=0;
	isext=0;
	isrel=0;
	handler_on=1;
}

void shutdown_kbhandler(void) {
	unsigned char a;

	if(handler_on) {
		setvect(KBINT,cpukbhandler);
		for(a=0;a<101;a++) keymap[a]=0;
		isext=0;
		isrel=0;
	}
}

void interrupt newkbhandler() {
	unsigned char key;

	key=inportb(KBPORT);
	if(key>128 && key!=224) isrel=1; else isrel=0;
	if(!isrel) {
		if(isext) {
			isext=0;
			keymap[key+128]=1;
		} else if(key!=224) keymap[key]=1;
		if(key==224) isext=1;
	} else {
		if(isext) isext=keymap[key]=0;
		else if(key!=224) keymap[key-128]=0;
	}
	if(keymap[K_LSHIFT]||keymap[K_RSHIFT]) k_shift=1; else k_shift=0;
	if(keymap[K_LALT]||keymap[K_RALT])     k_alt=1; else k_alt=0;
	if(keymap[K_LCTRL]||keymap[K_RCTRL])   k_ctrl=1; else k_ctrl=0;
	if(keymap[E_LOGOWINR]||keymap[E_LOGOWINL]) k_winlogos=1; else k_winlogos=0;
	outportb(0x20,0x20);
}
