#!/bin/sh

SDCC=/home/joppy/Code/sdcc-2018-03-17/bin/sdcc
IHX2SMS=/home/joppy/Code/sdcc-2018-03-17/bin/ihx2sms
DKSMS=/home/joppy/Code/devkitSMS/

mkdir -p Build

echo "Compiling..."
for source_file in main vdp_access bitmap2
do
    echo " -> ${source_file}"
    ${SDCC} -c -mz80 --peep-file ${DKSMS}/SMSlib/src/peep-rules.txt -I . \
        -o Build/${source_file}.rel Source/${source_file}.c || exit 1
done

echo "Linking..."
${SDCC} -o Build/wah_munchies.ihx -mz80 --no-std-crt0 --data-loc 0xC000 ${DKSMS}/crt0/crt0_sms.rel Build/*.rel SMSlib.lib || exit 1

echo "Generating SMS ROM..."
${IHX2SMS} Build/wah_munchies.ihx wah_munchers.sms || exit 1
