#include <stdint.h>

/* VDP ports */
__sfr __at 0xbf VDPControlPort;
__sfr __at 0xbe VDPDataPort;

void read_halfline (uint16_t addr, uint8_t *pattern)
{
    /* Avoid VDP state changes from interrupt handlers */
    __asm di __endasm;

    /* Set address in VDP */
    VDPControlPort = (0xbf, addr & 0x00ff);
    VDPControlPort = (0xbf, (addr & 0x3f00) >> 8);

    /* Read the data */
    for (uint8_t i = 0; i < 2; i++)
    {
        pattern[i] = VDPDataPort;
    }

    __asm ei __endasm;
}

void write_halfline (uint16_t addr, uint8_t *pattern)
{
    /* Avoid VDP state changes from interrupt handlers */
    __asm di __endasm;

    /* Set address in VDP */
    VDPControlPort = (0xbf, addr & 0x00ff);
    VDPControlPort = (0xbf, 0x40  | ((addr & 0x3f00) >> 8));

    /* Read the data */
    for (uint8_t i = 0; i < 2; i++)
    {
        VDPDataPort = pattern[i];
    }

    __asm ei __endasm;
}

