.ifndef __GRAPHICS__
.define __GRAPHICS__

.include "bossAttributes.inc"

.bank 15 slot 2

.define megamanSteadTempTilesCount 17
.define megamanSteadTempTilesBank 15
.section "megamanSteadTempTiles" free
megamanSteadTempTiles:
	.incbin "imagens\megamanSteadTemp.psgcompr" skip 2
.ends

.include "imagens\alphabet.indexes.inc"
.define alphabetTilesCount 42
.define alphabetTilesSize alphabetTilesCount*32
.define alphabetTiles.A alphabetTiles.11
.define alphabetTilesBank 15
.section "alphabetTiles" free
alphabetTiles:
	.incbin "imagens\alphabet.psgcompr" skip 2
.ends

.define bossSelectionTilesCount 19
.define bossSelectionTilesSize bossSelectionTilesCount*32
.define bossSelectionTilesBank 15
.section "bossSelectionTiles" free
bossSelectionTiles:
	.incbin "imagens\bossSelection.psgcompr" skip 2
.ends

.define bossFacesTilesCount 144
.define bossFacesTilesSize bossSelectionTilesCount*32
.define bossFacesTilesBank 15
.section "bossFacesTiles" free
bossFacesTiles:
	.incbin "imagens\bossFaces.psgcompr" skip 2
.ends

.define openingTilesCount 268
.define openingTilesSize openingTilesCount*32
.define openingTilesBank 15
.section "openingTiles" free
openingTiles:
	.incbin "imagens\opening.psgcompr" skip 2
.ends

.include "imagens\openingSprites.indexes.inc"
.define openingSpritesTilesCount 24
.define openingSpritesTilesSize openingSpritesTilesCount*32
.define arrowTile openingSpritesTiles.14
.define openingSpriteTilesBank 15
.section "openingSpritesTiles" free
openingSpritesTiles:
	.incbin "imagens\openingSprites.psgcompr" skip 2
.ends

.define menuTilesCount 18
.define menuTilesSize menuTilesCount*32
.define menuTilesBank 15
.section "menuTiles" free
menuTiles:
	.incbin "imagens\menu.psgcompr" skip 2
.ends

.define passwordMenuTilesCount 5
.define passwordMenuTilesSize passwordMenuTilesCount*32
.define passwordMenuTilesBank 15
.section "passwordMenuTiles" free
passwordMenuTiles:
	.incbin "imagens\passwordMenu.psgcompr" skip 2
.ends

.define openingMapBank 15
.section "openingMap" free
openingMap:
	.include "maps\openingMap.inc"
.ends

.define bossSelectionMapBank 15
.include "maps\bossSelectionMap.inc"

.bank 15 slot 2
.define bubbleManTilesCount 94*2
.define bubbleManTilesSize bubbleManTilesCount*32
.define bubbleManTilesBank 15
.section "bubbleMan" free
bubbleManPalette:
	.db $08 $00 $00 $00 $00 $00 $00 $00
bubbleManIntroText:
	.asc "BUBBLEMAN"
	
bubbleManBossTimers:
	.db 32, (bubbleMan.anim + bubbleMan.anim.numFrames), bubbleMan.anim  
bubbleManTiles:	
	.incbin "imagens\bubbleman.m.psgcompr" skip 2
.ends

.define airManTilesCount 71*2
.define airManTilesSize airManTilesCount*32
.define airManTilesBank 15
.section "airMan" free
airManPalette:
	.db $34 $1b $00 $00 $00 $00 $00 $00
airManIntroText:
	.asc "  AIRMAN "
airManBossTimers:
	.db 86, (airMan.anim + airMan.anim.numFrames), airMan.anim  
airManTiles:	
	.incbin "imagens\airman.m.psgcompr" skip 2
.ends

.define quickManTilesCount 90*2
.define quickManTilesSize quickManTilesCount*32
.define quickManTilesBank 15
.section "quickMan" free
quickManPalette:
	.db $1b $2F $13 $00 $00 $00 $00 $00
quickManIntroText:
	.asc " QUICKMAN"
quickManBossTimers:
	.db 52, (quickMan.anim + quickMan.anim.numFrames), quickMan.anim
quickManTiles:
	.incbin "imagens\quickman.m.psgcompr" skip 2 
.ends

.bank 14 slot 2
.define heatManTilesCount 93*2
.define heatManTilesSize heatManTilesCount*32
.define heatManTilesBank 14
.section "heatMan" free
heatManPalette:
	.db $2F $13 $1b $00 $00 $00 $00 $00
heatManIntroText:
	.asc " HEATMAN "
heatManBossTimers:
	.db 128, (heatMan.anim + heatMan.anim.numFrames), heatMan.anim
heatManTiles:
	.incbin "imagens\heatMan.m.psgcompr" skip 2 
.ends

.define woodManTilesCount 93*2
.define woodManTilesSize woodManTilesCount*32
.define woodManTilesBank 14
.section "woodMan" free
woodManPalette:
	.db $1b $0E $06 $00 $00 $00 $00 $00
woodManIntroText:
	.asc " WOODMAN "
woodManBossTimers:
	.db 32, (woodMan.anim + woodMan.anim.numFrames), woodMan.anim
woodManTiles:
	.incbin "imagens\woodMan.m.psgcompr" skip 2 
.ends

.define metalManTilesCount 90*2
.define metalManTilesSize metalManTilesCount*32
.define metalManTilesBank 14
.section "metalMan" free
metalManPalette:
	.db $13 $0B $2F $00 $00 $00 $00 $00
metalManIntroText:
	.asc " METALMAN"
metalManBossTimers:
	.db 32, (metalMan.anim + metalMan.anim.numFrames), metalMan.anim
metalManTiles:
	.incbin "imagens\metalMan.m.psgcompr" skip 2 
.ends

.define flashManTilesCount 97*2
.define flashManTilesSize flashManTilesCount*32
.define flashManTilesBank 14
.section "flashMan" free
flashManPalette:
	.db $34 $2F $1F $00 $00 $00 $00 $00
flashManIntroText:
	.asc " FLASHMAN"
flashManBossTimers:
	.db 42, (flashMan.anim + flashMan.anim.numFrames), flashMan.anim
flashManTiles:
	.incbin "imagens\flashMan.m.psgcompr" skip 2 
.ends

.define crashManTilesCount 83*2
.define crashManTilesSize crashManTilesCount*32
.define crashManTilesBank 14
.section "crashMan" free
crashManPalette:
	.db $03 $2F $00 $00 $00 $00 $00 $00
crashManIntroText:
	.asc " CRASHMAN"
crashManBossTimers:
	.db 32, (crashMan.anim + crashMan.anim.numFrames), crashMan.anim
crashManTiles:
	.incbin "imagens\crashMan.m.psgcompr" skip 2
.ends
.endif