.ifndef __CONSTANTS__
.define __CONSTANTS__

.define VdpControlPort $bf
.define VdpStatusPort $bf
.define VdpDataPort $be
.define VdpLineCounter $7e

.define VdpMisc1 $80
.define VdpMisc2 $81
.define VdpNameTable $82
.define VdpColorTable $83
.define VdpPatternTable $84
.define VdpSpriteAttrTable $85
.define VdpSpritePattTable $86
.define VdpBackgroundColor $87
.define VdpHorizontalScroll $88
.define VdpVerticalScroll $89

.define M1VerticalScrollLock 1<<7
.define M1HorizontalScrollLock 1<<6
.define M1HideLeftColoum 1<<5
.define M1LineInterrupts 1<<4
.define M1ShiftSprites 1<<3
.define M1Mode4 1<<2
.define	M1ExtendedHeightEnable 1<<1
.define M1Synch 1

.define M2DisplayEnabled 1<<6
.define M2FrameInterrupts 1<<5
.define M2Extended224 1<<4
.define M2Extended240 1<<3
.define M2DoubleTiledSprites 1<<1
.define M2DoubleSizedSprites 1

.define CramWrite.hi $c0
.define CramWrite $c000
.define VramWrite.hi $40
.define VramWrite $4000
.define VramSpriteTable $3f00
.define VramSpriteTable.hi $3f
.define VramSpriteTableBottom.lo $80
.define VramRowCount 28
.define VramColumnCount 32

.define Th.hi $F5
.define Th.lo $D5

;SACBRLDU
.define StartKey 1<<7
.define AKey 1<<6
.define CKey 1<<5
.define BKey 1<<4
.define RKey 1<<3
.define LKey 1<<2
.define DKey 1<<1
.define UKey 1

;SZ5H3VNC: flag register, just in case we need those flags on other register than f
.define SF 1 << 7
.define ZF 1 << 6
.define B5F 1 << 5
.define HCF 1 << 4
.define B3F 1 << 3
.define OPF 1 << 2
.define NF 1 << 1
.define CF 1 

;Bosses
.define BubbleMan 1
.define AirMan 1 << 1
.define QuickMan 1 << 2
.define HeatMan 1 << 3
.define WoodMan 1 << 4
.define MetalMan 1 << 5
.define FlashMan 1 << 6
.define CrashMan 1 << 7
 
;ItensToBosses
.define Item1Boss HeatMan
.define Item2Boss AirMan
.define Item3Boss FlashMan

;Name table entry flags
.define SpritePalete 1 << 3
.define SpritesBelow 1 << 4

.define MegamanFrameTileCount 17
.define MegamanMaxFrameSize MegamanFrameTileCount*32

.endif