.ifndef __MEMORY__
.define __MEMORY__


.define tileDecompVramPtr $c243
.define tileDecompBuffer $c245

.define column.hasNewColumn $c265 
.define column.columnAddress $c266
.define column.buffer $c267

.define mapperConfig $fffc
.define mapperSlot0 $fffd
.define mapperSlot1 $fffe
.define mapperSlot2 $ffff

.define waitingForVBlank $c01d
.define frameCounter $c01c
.define random $c04a
.define difficult $c0cd

.define scrolls $c0b7
.define horizontalScroll $c0b7
.define verticalScroll $c0b9

;status
.define numEtanks $c01e
.define bossesBeaten $c01f
.define itens $c020

;controls
.define holdedKeys $c023
.define holdedKeysPrevious (holdedKeys+1)
.define pressedKeys (holdedKeysPrevious+1)
.define readControlsFunction $c240 ; 2 bytes
.define pauseButtonPressed $c242

.define hasNewPalette $c380
;vdpMemoryMirrors
.define palette $c381
.define spriteTable $c200
.define spriteTableBottom $c300

.define tempVars $c100

;vdp misc registers values
.define vdpMisc1Value $c0f7
.define vdpMisc2Value $c0f8

.define vramRaw ($c800 - 5)
.define vramRaw.haveData vramRaw
.define vramRaw.destiny (vramRaw + 1)
.define vramRaw.fastOtirCall (vramRaw + 3)
.define vramRaw.buffer $c800
.define vramRaw.buffer.hi $c8

.struct _resolutionDependencies
  extendedHeight db
  introTextScroll db
  objectToSpriteYOffset db
  openingFirstDepackedLine dw
  openingFirstVramLine dw
  openingScroll db
  nameTableBegining dw
  verticalScrollEnd db
.endst

.struct object
	objType db
	frameTimer db
	x db
	yFraction db
	y dw
	ySpeed dw
.endst

.enum $c400
	objectTable instanceOf object 64
.ende

.enum $d000
  resolutionDependencies instanceOf _resolutionDependencies
.ende

;game stats
.define numLifes $c0a8
.endif