.bank 1 slot 1

.macro selectController
	ld a, Th.hi
	out ($3F), a
	
	push hl
	pop hl
	
	ld a, Th.lo
	out ($3F), a
	
	push hl
	pop hl
	
	in a, ($DC)
	and %00001100
	ld hl, readMasterSystemController
	jr nz, isMasterSystem
isMegaDrive:
		ld a, Th.hi
		out ($3F), a
		ld hl, readMegaDriveController
isMasterSystem:
		ld (readControlsFunction), hl
.endm

.macro selectResolution
	ld bc, (3 << 8) | VdpControlPort
	ld hl, ((M2Extended224 | M2FrameInterrupts) <<8) | (M1Mode4 | M1ExtendedHeightEnable) 
	ld de, (VdpMisc2 << 8) |	VdpMisc1
	call outputRegisters
	
-:			in a, (c)
		jp p, -
	djnz -
	in a, (VdpLineCounter)
	cp $d0
	ld h, M2Extended224
	ld ix, resolutionDependencies224 
	jr nc, +
		ld hl, M1Mode4
		ld ix, resolutionDependencies192 
+:
	ld (vdpMisc1Value), hl
	call outputRegisters
	push ix
	pop hl
	ld de, resolutionDependencies 
	fastLdir _sizeof__resolutionDependencies
.endm	

.section "outputRegisters" free 
outputRegisters:
	out (c), h
	out (c), d
	out (c), l
	out (c), e
	ret
.ends

.macro clearMemory
	ld hl, $c000
	ld de, $c001
	ld bc, $dff0 - $c001
	ld (hl), l
	ldir
	
.endm

.section "height attributes" free
	.dstruct resolutionDependencies192, _resolutionDependencies,   0,	 0, -24, openingMapLinesEnd - (19*2), VramWrite | $3e40, 200, $3800 | VramWrite, 224
	.dstruct resolutionDependencies224, _resolutionDependencies,   1,	16,  -8, openingMapLinesEnd - (21*2), VramWrite | $3e80, $f0, $3700 | VramWrite,   0
.ends

.section "reset" free
reset:
	di
	clearMemory
	selectController
	selectResolution
	
	ld a, $ff
	ld (pauseButtonPressed), a
	ld a, 3
	ld (numLifes), a
	ei
;Prg14_Lbl_805f:
	call callIntroduction
	ld a, (bossesBeaten)
	cp $ff
	jr z, +
		;lda #$03
		;sta $a8
		call callBossSelection
+:		;Prg14_Lbl_8079	
.ends