.ifndef __CODEBANK0_PRG15_ASM__
.define __CODEBANK0_PRG15_ASM__
.memorymap
defaultslot 0
slotsize $4000
slot 0 $0000
slot 1 $4000
slot 2 $8000
slot 3 $c000 ; Ram
.endme

.rombankmap
bankstotal 16
banksize $4000
banks 16
.endro

.sdsctag 0.1,"MegaMan 2", "Conversion", "gvx32"

.include "asciiTable.inc"
.include "memory.inc"
.include "constants.inc"
.include "decompressors.inc"
.include "graphics.inc"
.include "utilLib.inc"

.include "codeBank1_Prg14.asm"
.include "codeBank2_Prg13.asm"

.bank 0 slot 0


;original : mapPage1
.section "mapPage1" free
mapPage1:
	;ld (mappedPageBackup), a
	;ld ($c069), a
	ld (mapperSlot1), a
ret
.ends

.section "reproduceSound?" free
Lbl_c051:

	ret
.ends

.section "prepareForVblank" free
prepareForVblank: ; Lbl_c0ab
	call Lbl_c427
	ld a, $01
	ld hl, waitingForVBlank
	ld (hl), a
-:	and (hl)
	jp nz, -
	
	ld hl, (readControlsFunction)
	jp (hl)
endControlReading:	
	ld hl, holdedKeys
	ld b, a
	ld a, (hl)
	ld (hl), b
	inc l ; ld hl, holdedKeysPrevious
	ld (hl), a
	inc l ; ld hl, pressedKeys
	xor b
	and b
	ld (hl), a
	ld a, 2 ; original $0d
	jp mapPage1 ; call mapPage1
				; ret 
.ends


.section "stuff" free
Lbl_c427:
/*	ld a, ($c0aa)
	or a
	ret nz
	ld a, ($c355)
	or a
	ret z
	ld hl, ($c044)
	inc (hl)
	cp (hl)
	ret c
	xor a
	ld (hl), a
	dec l
	inc (hl)
	ld a, ($c354)
	ld b, a
	ld a, (hl)
	cp b
	ret nc
	xor a
	ld (hl), a
Lbl_c447:
	add a, a
	add a, a
	add a, a
	add a, a	
	ld e, a 
	ld d, 0
	ld hl, $c376
	add hl, de
	ld de, palette
	ld bc, $10
Lbl_c44e:
	ldir
	ld hl, $c03a
	inc (hl)
Lbl_c45c:*/
	ret 
.ends	
	
.section "callIntroduction" free
callIntroduction:
	ld a, 2 ; original : $0d
	call mapPage1
	call introduction
	ld a, 1 ; original: $0e
	call mapPage1
	ret 
.ends

	
.section "callBossSelection" free
callBossSelection:
	ld a, 2 ; original : $0d
	call mapPage1
	call bossSelection.show
	ld a, 1 ; original: $0e
	call mapPage1
	ret 
.ends

.section "testDepack" free
testDepack:
	push hl
	pop hl
	
	ld hl, openingTiles
	ld de, $3700 - depackedAlphabetSize - depackedOpeningTilesSize
	ld (vramTilesPointer), de
	call vram_depack
	
	;ld a, 2
	;ld (mapperSlot1), a
	ret
.ends

.macro updateRandomValue 
	ld a, r
	ld b, a
	rla
	ld c, a
	ld a, (frameCounter)
	xor b
	xor c
	ld c, a
	rlca
	rlca
	rlca
	rlca
	xor c
	ld (random), a
.endm

.macro outputSpriteTable
	ld c, VdpDataPort
	
	xor a
	out (VdpControlPort), a
	ld a, VramWrite.hi | VramSpriteTable.hi
	out (VdpControlPort), a
	
	ld hl, spriteTable
	fastOtir 64
	
	ld a, VramSpriteTableBottom.lo
	out (VdpControlPort), a
	ld a, VramWrite.hi | VramSpriteTable.hi
	out (VdpControlPort), a
	
	ld hl, spriteTableBottom
	fastOtir 128
.endm

.macro outputPalette ;Lbl_d0f5
	xor a
	out (VdpControlPort), a
	ld a, CramWrite.hi
	out (VdpControlPort), a

	fastOtir 32
.endm

;original : Lbl_cff0
.section "vBlankHandler" free
vBlankHandler:
	exx
	ex af, af'
	in a, (VdpStatusPort)
	ld a, (waitingForVBlank)
	or a
	jr z, runSoundEngine
		xor a
		ld (waitingForVBlank), a
		outputSpriteTable
		
		ld hl, hasNewPalette
		ld a, (hl)
		dec a
		jp nz, +
			ld (hl), a
			inc l
			outputPalette
		
+: 		ld hl, vramRaw.haveData
		ld a, (hl)
		dec a
		jp nz, +
			ld (hl), a
			inc l
			inc c ; ld vdpControlPort
			call outputRawData

+:		ld hl, column.hasNewColumn
		ld a, (hl)
		dec a
		jp nz, +
			ld (hl), a
			inc l
			call outputColumn
	
+:		inc c ; ld vdpControlPort
		ld hl, horizontalScroll + 1
		ld de, (VdpVerticalScroll << 8) | VdpHorizontalScroll
		outi
		out (c), e
		inc l
		outi
		out (c), d
		
		ld hl, frameCounter
		inc (hl)	
		
	Lbl_d066:
		ld a, (vdpMisc2Value)
		or M2DisplayEnabled
		ld (vdpMisc2Value), a 
		out (VdpControlPort), a
		ld a, VdpMisc2
		out (VdpControlPort), a
	
;os quatro labels a seguir se referem a engine de som	
runSoundEngine: ;Lbl_d08d:
Lbl_d095:
Lbl_d0ad:
Lbl_d0ba:
Lbl_d0c1:
	;ld a, (mappedPageBackup)
	;call mapPage1
Lbl_d0c6:
	updateRandomValue
	exx
	ex af, af'
	ei
	ret 
.ends

;hl : vramRaw.destiny
; c : VdpControlPort
.section "outputRawData" free
outputRawData:
	outi
	outi
	ld e, (hl)
	inc l
	ld d, (hl)
	inc hl
	dec c ;ld c, VdpDataPort
	jumpDe
.ends

.section "outputColumn" free
outputColumn:
	ld b, VramRowCount*2
	ld de, (64 << 8) | (>VramWrite | $38)
	ld a, (hl)
	rlca
	inc l
-:		.rept 3 
			inc c
			out (VdpControlPort), a
			out (c), e
			add a, d
			dec c
			outi
			outi
		.endr
		inc c
		out (VdpControlPort), a
		out (c), e
		add a, d
		inc e
		dec c
		outi
		outi
	jp nz, -
	ret
.ends

.section "load3bpp" free
load3bpp:
	out (c), d
	out (c), e
	dec c
	ld d, >reverseLookUp
	
-:		.rept 4
			outi
			outi
			outi
			ld a, (VdpDataPort)
		.endr
		.rept 4
			.rept 3
				ld e, (hl)
				ld a, (de)
				inc hl
				out (VdpDataPort), a
			.endr
			ld a, (VdpDataPort)
		.endr
	djnz -	
.ends

;Lbl_d0d7
.section "readMegaDriveController" free 
readMegaDriveController:
	; TH = 1 : ?1CBRLDU		3-button pad return value
	in a, ($DC)
	or $c0
	ld b, a

	; TH = 0 : ?0SA00DU		3-button pad return value
	ld a, Th.lo
	out ($3F), a

	ld hl, pauseButtonPressed
	ld a, (hl)
	and b
	ld b, a
	ld (hl), $ff

	in a, ($DC)
	rlca
	rlca
	or $3f
	and b
	cpl

	;Set TH hi for the next pass
	ld bc, (Th.hi << 8) | $3F
	out (c), b
	jp endControlReading
.ends
	
.section "readMasterSystemController" free
readMasterSystemController:
	in a, ($DC)
	or $c0
	ld hl, pauseButtonPressed
	and (hl)
	ld (hl), $ff
	cpl
	jp endControlReading
.ends

.section "configureVdp" free
vdpConfigData:
	.db $ff, VdpNameTable
	.db $ff, VdpColorTable
	.db $ff, VdpPatternTable
	.db $ff, VdpSpriteAttrTable
	.db $00, VdpBackgroundColor
	.db $03, VdpSpritePattTable
.ends

.org 0
.section "start" force
Lbl_f2d1:
	ld sp, $dff0
	im 1
	ld c, VdpControlPort
	ld hl, vdpConfigData
	fastOtir 12
	ld a, 1 ; original: $0e
	call mapPage1
	jp reset
.ends

.org $0038
.section "vBlankVector" force
	jp vBlankHandler
.ends

.org $0066
.section "pauseButtonHandler" force
	push af
	ld a, $7f 
	ld (pauseButtonPressed), a
	pop af
	retn
.ends
.endif