.ramsection "Tutorial variables" slot 1
  TutoCnt             dw    ; tutorial counter
  AutoDown            db   ;0: not pressing down, 1: pressing down
.ends


.section "level2"


SetupLevel2:
    ;==============================================================
    ; Load palette
    ;==============================================================
    ; 1. Set VRAM write address to CRAM (palette) address 0 (for palette index 0)
    ; by outputting $c000 ORed with $0000
    ld a,$00
    out ($bf),a
    ld a,$c0
    out ($bf),a
    ; 2. Output colour data
    ld hl,Palette2Start
    ld b,(Palette2End-Palette2Start)
    ld c,$be
    otir
    
    
    ld hl,(tiles_vram_used)
    ;==============================================================
    ; Load level tiles
    ;==============================================================
    ; 1. Set VRAM write address to tile index 0
    ; by outputting $4000 ORed with (tiles_vram_used)
    ld a,l
    out ($bf),a
    ld a,h
    add a,$40
    out ($bf),a
    ; 2. Output tile data
    ld bc,Bike_Tiles_Start-ForestTiles_Start  ; Counter for number of bytes to write
    ld hl,ForestTiles_Start              ; Location of tile data
    
    -:
        ld a,(hl)        ; Get data byte
        out ($be),a
        inc hl           ; Add one to hl so it points to the next data byte
        dec bc
        ld a,b
        or c
        jp nz,-
    ld hl,(tiles_vram_used)
    ld bc,Tiles_bg10_End-Tiles_bg10_Start
    add hl,bc
    ld (tiles_vram_used),hl

    ;load tilemap of current level
    ld hl,Tilemap2Start
    ;hl is where the tilemap of the level starts
    ;==============================================================
    ; Write tilemap data
    ;==============================================================
    ; 1. Set VRAM write address to name table index 0
    ; by outputting $4000 ORed with $3800+0
    ld a,$00
    out ($bf),a
    ld a,$38|$40
    out ($bf),a
    ; 2. Output tilemap data
    ;ld hl,Tilemap2Start
    ld bc,32*24*2; Counter for number of bytes to write
    -:
        ld a,(hl)    ; Get data byte
        out ($be),a
        inc hl       ; Point to next tile
        dec bc
        ld a,b
        or c
        jr nz,-
    
    
    ;init music
    ld hl,00;end_music_ch1_start
    call InitMusic1
    ld hl,end_music_ch2_start
    call InitMusic2
    ld hl,00;end_music_ch3_start
    call InitMusic3
    
    ;variables initialization
    ld hl,$0
    ld (speedX),hl
    ld hl,-$01A0
    ld (speedY),hl
    ld hl,$7C00
    ld (posX),hl
    ld hl,$E000
    ld (posY),hl
    xor a
    ld (rocket_status),a
    
    ;initialize scroll variables
    ld hl,Tilemap1Start
    ld (LevelMapStart),hl
    xor a
    ld (XScrollVDP),a
    ld (YScrollVDP),a
    ld hl,0
    ld (XScrollTotal),hl
    ld (YScrollTotal),hl
    
    ;compute max y scroll value
    ld hl,0
    ld (XScrollTotalMax),hl
    ld (YScrollTotalMax),hl
    
    ld hl,0
    ld (TutoCnt),hl
    xor a
    ld (AutoDown),a
    
    ;functers
    ld hl,DoStart
    ld (OnStartFunction),hl
    ld hl,TutorialFunction
    ld (WaitForVBlankFunction),hl
    ld hl,DoWait
    ld (OnLandRightFunction),hl
    ld hl,DoWait
    ld (OnLandLeftFunction),hl
    ld hl,DoGameLogicTutoOutOfScreen
    ld (OnOutFunction),hl
    
    ld hl,32
    ld (LevelMapWidth),hl
    
    ld a,1
    ld (first_frame_on_end_status),a
    
    ;show level message
    ld de,TutoText11;text pointer in de
    ld c,2;col (tiles) in c
    ld l,22;line (tiles) in l
    ld a,1;have to write slowly
    call PrintText
    
    ld a,1;on tutorial, skip 3,2,1
    ld (gameStatus),a
ret

DoGameLogicTutoOutOfScreen:
    push af
    push bc
    push de
    push hl
    
    ;mechanics
    ;increment Y-speed (gravity)
    ld hl,(speedY)
    inc hl
    inc hl
    ld (speedY),hl
    
    ;update x pos
    ld bc,(posX)
    ld hl, (speedX)
    add hl,bc
    ld (posX),hl
    ;update y pos
    ld bc,(posY)
    ld hl, (speedY)
    add hl,bc
    ld (posY),hl
            
    call ReadButtonsPlay

    call DrawGameElements
    
    ;hide other sprites
    call SetLastSprite
    
    pop hl
    pop de
    pop bc
    pop af

    ret


TutorialFunction:;replace WaitForVBlankSimple for tutorial
  ;don't use oil
  ld hl,$ffff
  ld (rocket_fuel),hl
  
  ;test if leaving tutorial
  ld a,(buttons)
  and %00110000 ;if 1+2 pressed
  cp  %00000000
  jr nz,+
    call DoWon
  +:
  
  ;if yspeed too big, auto press down
  ld a,(AutoDown)
  cp 1
  jr z,TutorialFunctionCurrentlyDown
    ;not currently pressing down
    ld hl,(speedY)
    ld a,h
    cp $01
    jr nz,+
      ld a,1
      ld (AutoDown),a
    +:
    jr TutorialFunctionEndDown

     
  TutorialFunctionCurrentlyDown:
    call OnButtonDown
    ;hide other sprites
    call SetLastSprite
    ld hl,(speedY)
    ld a,h
    cp $FE
    jr nz,+
      ld a,0
      ld (AutoDown),a
    +:
  
  TutorialFunctionEndDown:
  
  ;increment counter
  ld hl,(TutoCnt)
  inc hl
  inc hl
  inc hl
  ld (TutoCnt),hl
  

  
  ;show messages
  ld a,h
  cp $00
  jr nz,+
    ld de,TutoText1;text pointer in de
  +:
  cp $02
  jr nz,+
    ld de,TutoText2;text pointer in de
  +:
  cp $04
  jr nz,+
    ld de,TutoText3;text pointer in de
  +:
  cp $06
  jr nz,+
    ld de,TutoText4;text pointer in de
  +:
  cp $08
  jr nz,+
    ld de,TutoText5;text pointer in de
  +:
  cp $0A
  jr nz,+
    ld de,TutoText6;text pointer in de
  +:
  cp $0C
  jr nz,+
    ld de,TutoText7;text pointer in de
  +:
  cp $0E
  jr nz,+
    ld de,TutoText8;text pointer in de
  +:
  cp $10
  jr nz,+
    ld de,TutoText9;text pointer in de
  +:
  cp $12
  jr nz,+
    ld de,TutoText10;text pointer in de
  +:
  cp $14
  jr nz,+
    ld hl,$0100
    ld (TutoCnt),hl
  +:

  ld c,2;col (tiles) in c
  ld l,20;line (tiles) in l
  ld a,1;have to write slowly
  call WaitForVBlankSimple
  call PrintText
  

ret

TutoText1:
.db "WELCOME TO LANDER2 TUTORIAL",0
TutoText2:                      
.db "ROCKET NATURALLY GOES DOWN ",0
TutoText3:                      
.db "USE YOUR 3 REACTORS        ",0
TutoText4:                      
.db "TO CHANGE YOUR SPEED       ",0
TutoText5:                      
.db "HOLD \"DOWN\" TO GO UP         ",0
TutoText6:                      
.db "HOLD \"LEFT\" TO GO RIGHT      ",0
TutoText7:                      
.db "HOLD \"RIGHT\" TO GO LEFT      ",0
TutoText8:                      
.db "WATCH YOUR OIL COUNTER     ",0
TutoText9:                      
.db "AND TRY TO LAND SLOWLY     ",0
TutoText10:                     
.db "ON BLINKING AREAS          ",0
TutoText11:                     
.db "PRESS 1+2 TO QUIT TUTORIAL ",0

;==============================================================
; Data
;==============================================================

Level2Start:

Palette2Start:
.db %00010100*0,$07,$00,$04,$06,$08,$0b,$10,$14,$15,$16,$1a,$29,$3f,$15,$0f
.db $00,$3f,$00,$20,$38,$01,$02,$03,$15,$2a,$1f,$2f,$3a,$36,$01,$0a
Palette2End:

Tilemap2Start:

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010101101 %0000000010101110 %0000000010101111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010110000 %0000000010110001 %0000000010110010 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010110011 %0000000010110100 %0000000010110101 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000011000000 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000011000000 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000011000000 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000011000000
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111
.dw %0000000011000000 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111

.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111
.dw %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010000111 %0000000010111111 %0000000010000111 %0000000010000111


Tilemap2End:
Level2End:



.ends ;--------------- end level2 section

