;--------------------------------------------------------------------------
;  crt0.s - crt0.s for a Z80 based Game Gear
;
;  Copyright (C) 2000, Michael Hope
;  Copyright (C) 2011, Harley Laue
;
;  This library is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2.1, or (at your option) any
;  later version.
;
;  This library is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this library; see the file COPYING. If not, write to the
;  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
;   MA 02110-1301, USA.
;
;  As a special exception, if you link this library with other files,
;  some of which are compiled with SDCC, to produce an executable,
;  this library does not by itself cause the resulting executable to
;  be covered by the GNU General Public License. This exception does
;  not however invalidate any other reasons why the executable file
;   might be covered by the GNU General Public License.
;--------------------------------------------------------------------------

	.module crt0
	.globl _main
	; These two are  defined in mggl
	.globl _vdp_vsync_handler
	.globl _sms_pause_handler

	.area _HEADER (ABS)
	;; Reset vector
	.org 0
	jp init

	.org 0x08
	reti
	.org 0x10
	reti
	.org 0x18
	reti
	.org 0x20
	reti
	.org 0x28
	reti
	.org 0x30
	reti

	;; V-Sync interrupt
	.org 0x38
	di           ; Don't interrupt while in the interrupt...
	; One of the registered handlers should read from 0xbf to reset the VDP
	; status flag
	call _vdp_vsync_handler
	ei           ; Reenable interrupts
	reti

	;; Our NMI that happens on the SMS pause button being pressed
	.org 0x66
	di
	call _sms_pause_handler
	ei
	retn

	.org 0x100
init:
	di    ; disable interrupts during initialization
	im 1  ; set interrupt mode 1 which expects the interrupt to be at
	      ; 0x038

	;; Stack at the top of memory.
	ld sp, #0xDFF0

	;; Make sure the VDP is sane before continueing
	ld b, #0xb0    ; We're wating till V Counter = 0xb0
waitline:
	in a, (0x7e)   ; Read V-Counter
	cp b
	jp nz, waitline

	;; Initialise global variables
	call gsinit
	call _main
	jp   _exit

	;; Ordering of segments for the linker.
	.area _HOME
	.area _CODE
	.area _GSINIT
	.area _GSFINAL

	.area _DATA
	.area _BSEG
	.area _BSS
	.area _HEAP

	.area _CODE

__clock::
	ld  a, #2
	rst 0x08
	ret

_exit::
	;; Exit - special code to the emulator
	ld  a,#0
	rst 0x08
1$:
	halt
	jr 1$

	.area _GSINIT
gsinit::
	.area _GSFINAL
	ret

	;; This is required by the SMS bios
	.area SMS_HEADER (ABS)
	.org 0x7ff0
	.ascii "TMR SEGA" ; must be this, except the proto bios which we don't target
	.byte 0x00, 0x00 ; reserved
	.byte 0x00, 0x00 ; checksum, I use smscheckhead to write the checksum
	.byte 0x00, 0x00, 0x00 ; product code and last four bits is the version
	.byte 0x4c ; Region code (4 SMS export) and ROM size (c: 32k)
