DECLARE SUB println (text$, xofs%, yofs%, vsfont() AS INTEGER, fontinfo() AS ANY, fontmap() AS INTEGER, kerning%, vs() AS INTEGER)
DECLARE SUB loadcharset (f$, fontinfo() AS ANY, fontmap() AS INTEGER)
DECLARE SUB volumetriclights ()
DECLARE SUB rtprecalc (NsLUT() AS ANY, invmag!(), sph() AS ANY, XMIN%, XMAX%, ymax%, screenz%)
DECLARE SUB IsSphereHit (FHStatus() AS ANY, sph() AS ANY, spherenum%, Ns AS ANY, nscreenz!)
DECLARE SUB raytrace (pal() AS ANY)
DECLARE SUB setbrownpal (pal() AS ANY)
DECLARE SUB setgraypal (pal() AS ANY)
DECLARE SUB delay (d!)
DECLARE SUB setwhitepal (pal() AS ANY)
DECLARE SUB fadepal (frompal() AS ANY, topal() AS ANY)
DECLARE SUB setblackpal (pal() AS ANY)
DECLARE SUB SETPAL (pal() AS ANY)
DECLARE SUB readgif (a$, arr%(), pal() AS ANY)
DECLARE SUB tunnel ()
DECLARE FUNCTION atan2! (x!, y!)
DECLARE FUNCTION ceil% (x!)
DECLARE FUNCTION floor% (x!)
DECLARE SUB normalize (x!, y!, z!)
DECLARE SUB cross (V1 AS ANY, V2 AS ANY, v AS ANY)
DECLARE FUNCTION maxidx% (w AS ANY)

'==============================================
' Solar Rays 2001
' QB Demo by Toshi Horie
'............................
' Effects:
'  * free direction tunnel mapper
'  * realtime sphere raytracer
'  * volumetric lights
'  * text scroller
'==============================================
CONST neveragain = -2
CONST offscanline = -1
CONST unknown = 0
CONST interval = 1
CONST onscanline = 2


CONST FPSTUN = 0
CONST FPSRAY = 1
CONST FPSLITE = 2

'screen is 'screendist' pixels in front of the eye
CONST pi = 3.14159265358979#
CONST ang180 = pi
CONST ang360 = pi * 2
CONST deg2rad = pi / 180

TYPE vec
	x AS SINGLE
	y AS SINGLE
	z AS SINGLE
END TYPE

DEFSNG A-Z
'----------constants for tunnel mapper---------------
CONST radius = 150
CONST screendist = 200
CONST tsize = 15
CONST tmask = 15
CONST xres = 320
CONST yres = 150
CONST invxres = 1! / xres
CONST invyres = 1! / yres
CONST tnxmax = xres - 1
CONST tnymax = yres - 1
CONST yh = (yres \ 2) - 1
CONST xh = (xres \ 2) - 1

DEFINT A-Z


TYPE paltype
	r AS INTEGER
	g AS INTEGER
	b AS INTEGER
END TYPE

TYPE spheretype
	x AS INTEGER
	y AS INTEGER   ' center of sphere
	z AS INTEGER
	r AS INTEGER   ' radius
	R2 AS LONG     ' radius^2
	invr AS SINGLE ' 1/radius
   
	L2 AS LONG '(length of ray from ray origin to sphere center)^2
	eyeoutsidesphere AS INTEGER
END TYPE


TYPE FHStatusType
	flag AS INTEGER
	IntervalL AS INTEGER
	IntervalR AS INTEGER
END TYPE


TYPE fonttype
	x0 AS INTEGER
	y0 AS INTEGER
	w AS INTEGER
	h AS INTEGER
END TYPE

DIM SHARED fps!(0 TO 5)

'----------------main program------------------
SCREEN 13
CLS
'$DYNAMIC
DIM arrvs%(32001)
DIM pal(255) AS paltype
DIM SHARED fontpal(255) AS paltype
DIM SHARED blackpal(255) AS paltype
DIM SHARED whitepal(255) AS paltype
DIM SHARED graypal(255) AS paltype
DIM brownpal(255) AS paltype
CALL setblackpal(blackpal())
CALL setwhitepal(whitepal())
CALL setgraypal(graypal())
CALL setbrownpal(brownpal())
CALL SETPAL(whitepal())

'GOTO credits
CALL readgif("title2.gif", arrvs%(), pal())
PUT (0, 0), arrvs%, PSET
ERASE arrvs%
CALL fadepal(whitepal(), pal())
delay 2
CALL fadepal(pal(), graypal())
CALL fadepal(graypal(), blackpal())
delay 1
CLS
CALL fadepal(blackpal(), brownpal())

CALL tunnel
CALL fadepal(pal(), whitepal())
CLS
REDIM arrvs%(32001)
CALL readgif("sunray.gif", arrvs%(), pal())
PUT (0, 0), arrvs%, PSET
ERASE arrvs%
CALL fadepal(whitepal(), pal())

CONST sxmax = 320, symax = 200
CONST sxctr = sxmax / 2, syctr = symax / 2
CONST XMIN = sxctr - sxmax
CONST XMAX = XMIN + sxmax - 1
CONST ymin = syctr - symax
CONST ymax = ymin + symax - 1
CONST szctr = symax
CONST numspheres = 6
CONST screenz = 150
CONST nscreenz = -screenz

CALL raytrace(pal())

CLS
CALL volumetriclights

credits:
CLS
'$DYNAMIC
DIM vsfont(32001)
DIM vs(32001) AS INTEGER
CALL readgif("font320.gif", vsfont(), fontpal())
DIM fontinfo(72)  AS fonttype
'fontmap() maps ASCII values to fontinfo entries.
DIM fontmap(0 TO 255) AS INTEGER

CALL loadcharset("solar.fnt", fontinfo(), fontmap())
CALL println("Solar Rays 2001", 10, 10, vsfont(), fontinfo(), fontmap(), -1, vs())
CALL println("by Toshi Horie", 10, 30, vsfont(), fontinfo(), fontmap(), 6, vs())
vs(0) = 320 * 8
vs(1) = 200
PUT (0, 0), vs, PSET
CALL fadepal(pal(), fontpal())
delay 1
yoff = 0
CALL println("Special Thanks To", 10, (yoff + 80), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("all who entered the contest.", 5, (yoff + 100), vsfont(), fontinfo(), fontmap(), 6, vs())
PUT (0, 0), vs, PSET
delay 1

FOR yoff = 0 TO -465 STEP -1
REDIM vs(32001) AS INTEGER
vs(0) = 320 * 8
vs(1) = 200
CALL println("Solar Rays 2001", 10, (yoff + 10), vsfont(), fontinfo(), fontmap(), -1, vs())
CALL println("by Toshi Horie", 10, (yoff + 30), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("Special Thanks To", 10, (yoff + 80), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("all who entered the contest.", 5, (yoff + 100), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("===Greets===", 85, (yoff + 240), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("Qasir", 125, (yoff + 260), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("Biskbart", 85, (yoff + 280), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("Entropy", 100, (yoff + 300), vsfont(), fontinfo(), fontmap(), 4, vs())
CALL println("Antoni", 115, (yoff + 320), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("Sane", 130, (yoff + 340), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("Eclipzer", 100, (yoff + 360), vsfont(), fontinfo(), fontmap(), 4, vs())
CALL println("Lithium", 110, (yoff + 380), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("EvilGeek", 100, (yoff + 400), vsfont(), fontinfo(), fontmap(), 4, vs())
CALL println("Optimus", 108, (yoff + 420), vsfont(), fontinfo(), fontmap(), 6, vs())
CALL println("Plasma357", 95, (yoff + 440), vsfont(), fontinfo(), fontmap(), 4, vs())
WAIT &H3DA, 8: WAIT &H3DA, 8, 8
WAIT &H3DA, 8: WAIT &H3DA, 8, 8
PUT (0, 0), vs, PSET
IF LEN(INKEY$) THEN EXIT FOR
NEXT yoff
delay 1
FOR yoff = 200 TO 80 STEP -1
REDIM vs(32001) AS INTEGER
vs(0) = 320 * 8
vs(1) = 200
CALL println("See You Next Time!", 30, (yoff), vsfont(), fontinfo(), fontmap(), 3, vs())
CALL println("http;//toshi.tekscode.com", 10, (yoff + 20), vsfont(), fontinfo(), fontmap(), 6, vs())
WAIT &H3DA, 8: WAIT &H3DA, 8, 8
PUT (0, 0), vs, PSET
IF LEN(INKEY$) THEN EXIT FOR
NEXT yoff

delay 3
CALL fadepal(fontpal(), blackpal())

ERASE vsfont
ERASE vs
ERASE fontmap, fontinfo, fontpal

SCREEN 7: SCREEN 0: WIDTH 80: PALETTE: CLS

'FOR i% = 0 TO 2
'PRINT fps!(i%); "fps"
'NEXT
ERASE blackpal, brownpal, whitepal, graypal, pal
END

REM $STATIC
FUNCTION atan2! (x!, y!)

IF x! THEN
	atnval! = ATN(y! / x!)
	   IF x! >= 0 THEN
		   IF y! < 0 THEN
			   atan2! = atnval! + ang360
		   ELSE
			   atan2! = atnval!
		   END IF
	   ELSEIF x! < 0 THEN
		   atan2! = atnval! + ang180
	   END IF
ELSE
   atan2! = 0
END IF
END FUNCTION

DEFSNG A-Z
FUNCTION ceil% (x!)
ceil% = (x! + .499999) AND -1'=INT(x + .999999!)
END FUNCTION

SUB cross (V1 AS vec, V2 AS vec, v AS vec)
'vector V = V1 x V2
v.x = V1.y * V2.z - V2.y * V1.z
v.y = V2.x * V1.z - V1.x * V2.z
v.z = V1.x * V2.y - V2.x * V1.y
END SUB

SUB delay (d!)
t1! = TIMER
DO: LOOP UNTIL LEN(INKEY$) <> 0 OR TIMER - t1! > d!
END SUB

DEFINT A-Z
SUB fadepal (frompal() AS paltype, topal() AS paltype)
FOR t! = 0 TO 1 STEP 1! / 16
invt! = 1 - t!
WAIT &H3DA, 8
OUT &H3C8, 0
FOR i = 0 TO 255
	OUT &H3C9, (frompal(i).r * invt! + topal(i).r * t!)
	OUT &H3C9, (frompal(i).g * invt! + topal(i).g * t!)
	OUT &H3C9, (frompal(i).b * invt! + topal(i).b * t!)
NEXT
NEXT t!
END SUB

DEFSNG A-Z
FUNCTION floor% (x!)
floor% = INT(x!)
END FUNCTION

SUB IsSphereHit (FHStatus() AS FHStatusType, sph() AS spheretype, spherenum%, Ns AS vec, nscreenz)
'based on ideas and C code by Thomas Moller
'Purpose:
'   calculates whether sphere spherenum% will be hit on this scanline
'Params:
'   spherenum% - which sphere to use
'   Ns - normal of the scanline plane = (Right-Eye)x(Left-Eye)
'   Left - leftmost point on scanline
'Result:
'   fills FirstHitStatus() array
'throw away the coordinate
'that corresponds to max(Ns.x,Ns.y,Ns.z)
badidx% = maxidx(Ns)

signeddist = Ns.x * sph(spherenum%).x + Ns.y * sph(spherenum%).y + Ns.z * sph(spherenum%).z
IF signeddist > sph(spherenum%).r THEN
	' sphere is above the plane, so won't hit it anymore
	FHStatus(spherenum%).flag = neveragain
ELSEIF signeddist < -sph(spherenum%).r THEN
	' sphere is below the scanline plane
	FHStatus(spherenum%).flag = offscanline
ELSE
	'we might hit the sphere
	DIM d AS vec
	DIM h AS vec
	DIM Cc AS vec  'note: Cc is cut circle's center point
	DIM Nd AS vec
	'' vector CC = spherecenter - (signeddist * Ns )
	Cc.x = sph(spherenum%).x - signeddist * Ns.x
	Cc.y = sph(spherenum%).y - signeddist * Ns.y
	Cc.z = sph(spherenum%).z - signeddist * Ns.z
	''cr2=(Sr * Sr)- signeddist^2
	cr2 = sph(spherenum%).R2 - signeddist * signeddist
	'' vector D = CC-Eyepos
	d.x = Cc.x
	d.y = Cc.y
	d.z = Cc.z
	'' D2 = D dot D = (magnitude(D))^2
	d2 = d.x * d.x + d.y * d.y + d.z * d.z
	IF d2 <= cr2 THEN
		FHStatus(spherenum%).flag = onscanline
		EXIT SUB
	END IF
	'' H = D cross Ns
	CALL cross(d, Ns, h)
	t1 = cr2 / d2
	sintheta = SQR(t1)
	costheta = SQR(1 - t1)
	
	
		' .x=.y from case 1
			t1 = h.x * sintheta
			t2 = d.x * costheta
			V1u = t1 + t2
			V2u = t2 - t1
			t1 = h.z * sintheta
			t2 = d.z * costheta
			V1v = t1 + t2
			V2v = t2 - t1
			't1 = xmin 'Left.x
			't2 = nscreenz '-Left.z
			t3 = -V1v
			IF t3 <> 0! THEN
				'V1 is not parallel to scanline
				FHStatus(spherenum%).IntervalR = floor%((V1v * XMIN + V1u * nscreenz) / t3)
				t3 = -V2v
				IF t3 = 0 THEN
					FHStatus(spherenum%).IntervalL = 0
				ELSE
					FHStatus(spherenum%).IntervalL = ceil%((V2v * XMIN + V2u * nscreenz) / t3)
				END IF
			ELSE 'rare case when V1 is parallel to scanline
				t3 = -V2v
				FHStatus(spherenum%).IntervalL = ceil%((V2v * XMIN + V2u * nscreenz) / t3)
				FHStatus(spherenum%).IntervalR = 319
			END IF
   
	' check if interval is valid and set status
	IF ((FHStatus(spherenum%).IntervalL >= 320) OR (FHStatus(spherenum%).IntervalR < 0)) THEN
		FHStatus(spherenum%).flag = offscanline 'off screen to left or right
	ELSE
		IF (FHStatus(spherenum%).IntervalR >= 320) THEN FHStatus(spherenum%).IntervalR = 319
		IF (FHStatus(spherenum%).IntervalL < 0) THEN FHStatus(spherenum%).IntervalL = 0
		IF ((FHStatus(spherenum%).IntervalL = 0) AND (FHStatus(spherenum%).IntervalR = 319)) THEN
			FHStatus(spherenum%).flag = onscanline
		ELSE
			FHStatus(spherenum%).flag = interval
		END IF
	END IF
	IF (FHStatus(spherenum%).IntervalL > FHStatus(spherenum%).IntervalR) THEN
		FHStatus(spherenum%).flag = offscanline
	END IF
END IF
'' this implicitly returns FHstatus
END SUB

DEFINT A-Z
SUB loadcharset (f$, fontinfo() AS fonttype, fontmap() AS INTEGER)
OPEN f$ FOR INPUT AS #1

chofs% = 0
DO
	INPUT #1, chstart$
	INPUT #1, chend$
	ascchstart% = ASC(chstart$)
	numCH% = ASC(chend$) - ascchstart% + 1
	INPUT #1, chymin%, chymax%
	chheight% = chymax% - chymin% + 1

	'note that this writes numCH%+1 entries so make the
	'fontinfo() array one bigger than you'd think you'd need.
	FOR i% = 0 TO numCH%
		iofs% = i% + chofs%
		'PRINT CHR$(i% + ascchstart%); ",";
		INPUT #1, fontinfo(iofs%).x0
		'PRINT fontinfo(iofs%).x0
		fontinfo(iofs%).y0 = chymin%
		fontinfo(iofs%).h = chheight%
		fontmap(ascchstart% + i%) = iofs%
	NEXT
	FOR i% = 0 TO numCH% - 1
		iofs% = i% + chofs%
		fontinfo(iofs%).w = fontinfo(iofs% + 1).x0 - fontinfo(iofs%).x0 + 1
	NEXT i%
	chofs% = chofs% + numCH%
LOOP UNTIL chstart$ = "~"
CLOSE #1

'for debugging character bounding rectangles
'FOR i% = ASC("A") TO ASC("Z")
'    j% = fontmap(i%)
'    LINE (fontinfo(j%).x0, fontinfo(j%).y0)-(fontinfo(j%).x0 + fontinfo(j%).w, fontinfo(j%).y0 + fontinfo(j%).h), 255, B
'NEXT
'CLS

END SUB

FUNCTION maxidx (w AS vec)
'Params:
'   W, the vector to find the max coordinate index of
'returns:
'   1 if W.x coordinate is greatest
'   2 if W.y coordinate is greatest
'   3 if W.z coordinate is greatest
				  MAX = ABS(w.x): tmaxidx = 1
IF (ABS(w.y) > MAX) THEN MAX = ABS(w.y): tmaxidx = 2
IF (ABS(w.z) > MAX) THEN MAX = ABS(w.z): tmaxidx = 3
maxidx = tmaxidx
END FUNCTION

DEFSNG A-Z
SUB normalize (x, y, z)
mag = SQR(x * x + y * y + z * z)
'should make this beep in debug mode
IF mag = 0 THEN
	x = 0
	y = 0
	z = 0
	EXIT SUB
END IF
x = x / mag
y = y / mag
z = z / mag
END SUB

DEFINT A-Z
SUB println (text$, xofs, yofs, vsfont() AS INTEGER, fontinfo() AS fonttype, fontmap() AS INTEGER, kerning%, vs() AS INTEGER)
textlen = LEN(text$)
vsfontseg% = VARSEG(vsfont(2))
vsseg% = VARSEG(vs%(2))
FOR r = 1 TO textlen
	i = ASC(MID$(text$, r, 1))
	j = fontmap(i)
	'PRINT j; fontinfo(j).w
	yb = fontinfo(j).h
	psrc& = VARPTR(vsfont(2)) + (fontinfo(j).y0) * 320& + fontinfo(j).x0
	pdst& = 320& * yofs + xofs + VARPTR(vs%(2))
	IF yofs < 0 THEN
		yt = yofs + yb
		'LOCATE 7, 1: PRINT "yofs="; yofs; "new yb="; yt
		psrc& = VARPTR(vsfont(2)) + (fontinfo(j).y0 - yofs) * 320& + fontinfo(j).x0
		yb = yt
		pdst& = xofs + VARPTR(vs%(2))
	ELSEIF (yofs + yb) > 199 THEN
		yb = 199 - yofs
	END IF
	FOR y = 0 TO yb
		FOR x = 0 TO fontinfo(j).w
			DEF SEG = vsfontseg%
			c = PEEK(psrc& + x)
			DEF SEG = vsseg%
			pdofs& = pdst& + x
			IF c THEN POKE pdofs&, c
		NEXT x
		psrc& = psrc& + 320&
		pdst& = pdst& + 320&
	NEXT y
	xofs = xofs + fontinfo(j).w - kerning%
NEXT r

END SUB

SUB raytrace (pal() AS paltype)
' Realtime raytracer based on techniques in "Realtime Rendering"
' by Moller and Haines, and Moller's scanline rejection algorithm
' in "Graphics Gems," combined with subdivision techniques
' developed while creating my first raytracer. --Toshi

'---------constants for raytracer-----------------


CONST yofs = 20
CONST xofs = 19 'must be an odd number

CONST ysize = (ymax - 28 - (ymin + yofs) + 1)
CONST xsize = (XMAX - 84 - (XMIN + xofs) + 2)

'$DYNAMIC
DIM invmag!(0 TO 160, 0 TO 100)
DIM arr(2 + (ysize * xsize \ 2))
'DIM envmap(0 TO 63, 0 TO 63)
'$STATIC
DIM NsLUT(0 TO 199)  AS vec
DIM sph(1 TO numspheres)  AS spheretype
DIM FHStatus(1 TO numspheres)  AS FHStatusType

CALL rtprecalc(NsLUT(), invmag!(), sph(), XMIN, XMAX, ymax, screenz)
CALL delay(2)
CALL fadepal(pal(), blackpal())
CLS

CALL SETPAL(graypal())

arr(0) = (xsize - 1) * 8
arr(1) = (ysize - 1)

frames = 0
t1! = TIMER

dz! = screenz
dz2! = dz! * dz!

DIM r ' reflected vector
DIM dv AS vec: DIM v0 AS vec
DIM n AS vec
DIM v AS vec

'for plane intersections
DIM pv AS vec
DIM pv0 AS vec
DIM pn AS vec
DIM Left AS vec

'added for fastSphereHit calcs
DIM Ns AS vec 'vector BExAE
Left.x = XMIN
DIM scanlinedir AS vec
Left.z = screenz
DIM hit(ymin TO ymax)
LOCATE 2, 7: COLOR 255: PRINT "---[ Realtime Raytracing ]---"

DO
	REDIM arr(2 + (ysize * xsize \ 2))
	arr(0) = xsize * 8
	arr(1) = ysize
	DEF SEG = VARSEG(arr(2))
	P& = VARPTR(arr(3))

	tt = INT(TIMER * 60) AND 32767
	FOR i = 1 TO numspheres
		FHStatus(i).flag = unknown
	NEXT i

	FOR i = 1 TO numspheres
		ctte! = COS((tt * .007 + i) * 2)
		xx = 150 * ctte!
		yy = 100 * SIN((tt * .007 + i) * 2)
		zz = 350 + 100 * ctte!
	   
		sph(i).x = xx
		sph(i).y = yy
		sph(i).z = zz
		sph(i).L2 = xx * xx + yy * yy + CLNG(zz) * zz
		'if eyeoutsidesphere is FALSE, ray guaranteed
		'to hit the sphere, since it's inside.
		'sph(i).eyeoutsidesphere = (sph(i).L2 > sph(i).r2)
	NEXT

	dz2! = dz! * dz!
	FOR y = ymin + yofs TO ymax - 28
		q& = P& + xsize
		yo = y + syctr
		dy! = y
		dyz2! = dy! * dy! + dz2!
		ay = ABS(y)
		lastisect = -1
		lastc = 0
		c = 0

		Ns = NsLUT(yo)
		Left.y = y

		hit(y) = 0
		leftxmin = 319
		rightxmax = 0
		FOR i = 1 TO numspheres
			IF FHStatus(i).flag <> neveragain THEN
				CALL IsSphereHit(FHStatus(), sph(), i, Ns, nscreenz)
				IF FHStatus(i).flag = interval THEN
					leftx = FHStatus(i).IntervalL
					IF leftxmin > leftx THEN leftxmin = leftx
					rightx = FHStatus(i).IntervalR + 2
					IF rightxmax < rightx THEN rightxmax = rightx
					hit(y) = 1
					'LINE (FHStatus(i).IntervalL, yo)-(FHStatus(i).IntervalR, yo), 253
				ELSEIF FHStatus(i).flag = onscanline THEN
					hit(y) = 1
					'LINE (0, yo)-(319, yo), 128
				END IF
			END IF
		NEXT i%
		minx = leftxmin AND (NOT 1)
		'LOCATE 1, 1: COLOR 255: PRINT yo, minx: k$ = INPUT$(1)
		'LINE (0, yo)-(minx, yo), 255
		IF hit(y) THEN
			FOR x = XMIN + xofs TO XMAX - 84 STEP 2
				IF x + 160 >= rightxmax THEN P& = q&: EXIT FOR
				dx! = x
			   
				IF x + 160 > minx THEN
				i! = invmag!(ABS(x), ay)
				dxn! = dx! * i!
				dyn! = dy! * i!
				dzn! = dz! * i!
			   
				'ray sphere intersection
				GOSUB raytest

				IF intersect THEN
					xi = x
					GOSUB getcolor
				END IF

				IF lastisect <> intersect THEN
					GOSUB tracemiddle
					IF intersect THEN
						GOSUB getcolor
					END IF
				ELSE
					xi = x - 1
					IF intersect THEN POKE P& - 1, (lastc + c) \ 2
					'IF intersect THEN PSET (xi + sxctr, yo), (lastc + c) \ 2
					lastc = c
					lastisect = intersect
				END IF
				END IF
				P& = P& + 2
			NEXT x
		ELSE
			'LINE (0, yo)-(xsize, yo), 80
			P& = P& + xsize
		END IF
		IF INKEY$ <> "" THEN exitflag = 1
	NEXT y
	PUT (xofs, yofs + 12), arr, PSET
	frames = frames + 1
	IF exitflag THEN EXIT DO
	tt = tt + 1
	elapsed! = TIMER - t1!
	
LOOP UNTIL elapsed! > 5
elapsed! = TIMER - t1!
IF elapsed! > 0 THEN
fps!(FPSRAY) = frames / elapsed!
ELSE
fps!(FPSRAY) = 999
END IF
ERASE arr, invmag!, NsLUT, sph, FHStatus
'ERASE envmap
EXIT SUB


raytest:
			c = 0
			intersect = 0
			tmin! = 999999!
			dxx! = dx! + sxctr
			FOR i = 1 TO numspheres
				IF (FHStatus(i).flag = interval AND dxx! >= FHStatus(i).IntervalL AND dxx! <= FHStatus(i).IntervalR) THEN
				'OR FHStatus(i).flag = onscanline THEN
					'd = L dot D
					d! = sph(i).x * dxn! + sph(i).y * dyn! + sph(i).z * dzn!
					'IF d! < 0 THEN
					'    IF sph(i).eyeoutsidesphere THEN
					'        'sphere is behind ray origin
					'        ' so reject intersection
					'        GOTO skip
					'    END IF
					'END IF
					L2& = sph(i).L2
					m2! = L2& - d! * d!
					R2& = sph(i).R2
					IF m2! > R2& THEN
						'reject
						GOTO skip
					END IF
					q! = SQR(R2& - m2!)
					IF L2& > R2& THEN
						t! = d! - q!
					ELSE
						t! = d! + q!
					END IF
					IF t! < tmin! THEN
						tmin! = t!
						intersect = i
					END IF
				END IF
skip:
			NEXT i

RETURN



tracemiddle:
	'order matters
	lastc = c
	lastisect = intersect
	'since raytest overwrites intersect
	xi = x - 1
	dx! = xi
	i! = invmag!(ABS(xi), ay)
	dxn! = dx! * i!
	dyn! = dy! * i!
	dzn! = dz! * i!
	GOSUB raytest
RETURN



getcolor:
	 'position of collision in world coordinates
	 v0x! = tmin! * dxn!
	 v0y! = tmin! * dyn!
	 v0z! = tmin! * dzn!
			   
	'N = normal of the sphere at the collision point
	'N is normalized by the 1/r operation.
	 invr! = sph(intersect).invr
	 nx! = (v0x! - sph(intersect).x) * invr!
	 ny! = (v0y! - sph(intersect).y) * invr!
	 nz! = (v0z! - sph(intersect).z) * invr!
			   
	 'V is view vector (from eye to sphere)
	 'vx! = -dxn!: vy! = -dyn!: vz! = -dzn!
	 'ndoti2! = 2 * (nx! * vx! + ny! * vy! + nz! * vz!)

	 'New direction r = reflection of V about N.
	 'r.x = ndoti2! * nx! - vx!
	 'r.y = ndoti2! * ny! - vy!
	 'r.z = ndoti2! * nz! - vz!

	 c = nx! * nx! * 255 'cheap shading for now

	'smarter, good looking shading is possible using envmaps.
	'you can have infinite phong-like static lighting
	'at no extra calculation cost! You can even have
	'dynamic light rotation around a world axis for the cost
	'of a 2D bitmap rotation.
	'c = envmap(ABS(nx! * 62), ABS(nz! * 62))
   
	IF xi = x THEN
		POKE P&, c
	ELSE
		POKE P& - 1, c
	END IF
RETURN


END SUB

SUB readgif (a$, arr%(), pal() AS paltype)
IF (UBOUND(arr%) - LBOUND(arr%)) < 32001 THEN EXIT SUB
arr%(0) = 320 * 8
arr%(1) = 200

'public domain GIF loader by Rich Geldreich
'Specialized for 320x200x256 images for this demo by Toshi
'arr%() is a GET/PUT graphics array big enough to fit 320x200

'Prefix() and Suffix() hold the LZW phrase dictionary.
'OutStack() is used as a decoding stack.
'ShiftOut() as a power of two table used to quickly retrieve the LZW
'multibit codes.
DIM Prefix(4095), Suffix(4095), OutStack(4095), ShiftOut(8)


'The following line is for the QB environment(slow).
DIM YBase AS LONG, Powersof2(11) AS LONG, WorkCode AS LONG
'For a little more speed, unremark the next line and remark the one
'above, before you compile... You'll get an overflow error if the
'following line is used in the QB environment, so change it back.
'DIM YBase AS INTEGER, Powersof2(11) AS INTEGER, WorkCode AS INTEGER

'Precalculate power of two tables for fast shifts.
FOR a = 0 TO 8: ShiftOut(8 - a) = 2 ^ a: NEXT
FOR a = 0 TO 11: Powersof2(a) = 2 ^ a: NEXT

'Open file for input so QB stops with an error if it doesn't exist.
OPEN a$ FOR INPUT AS #1: CLOSE #1
OPEN a$ FOR BINARY AS #1

'Check to see if GIF file. Ignore GIF version number.
a$ = "      ": GET #1, , a$
IF LEFT$(a$, 3) <> "GIF" THEN PRINT "Not a GIF file.": END

'Get logical screen's X and Y resolution.
GET #1, , TotalX: GET #1, , TotalY: GOSUB GetByte
'Calculate number of colors and find out if a global palette exists.
NumColors = 2 ^ ((a AND 7) + 1): NoPalette = (a AND 128) = 0
'Retrieve background color.
GOSUB GetByte: Background = a

'Get aspect ratio and ignore it.
GOSUB GetByte

'Retrieve global palette if it exists.
IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$

DO 'Image decode loop

'Skip by any GIF extensions.
'(With a few modifications this code could also fetch comments.)
DO
	'Skip by any zeros at end of image (why must I do this? the
	'GIF spec never mentioned it)
	DO
		IF EOF(1) THEN GOTO AllDone 'if at end of file, exit
		GOSUB GetByte
	LOOP WHILE a = 0           'loop while byte fetched is zero

	SELECT CASE a
	CASE 44  'We've found an image descriptor!
		EXIT DO
	CASE 59  'GIF trailer, stop decoding.
		GOTO AllDone
	CASE IS <> 33
		PRINT "Unknown GIF extension type.": END
	CASE ELSE
		' do nothing
	END SELECT
	'Skip by blocked extension data.
	GOSUB GetByte
	DO: GOSUB GetByte: a$ = SPACE$(a): GET #1, , a$: LOOP UNTIL a = 0
LOOP
'Get image's start coordinates and size.
GET #1, , XStart: GET #1, , ystart: GET #1, , XLength: GET #1, , YLength
XEnd = XStart + XLength: YEnd = ystart + YLength

'Check for local colormap, and fetch it if it exists.
GOSUB GetByte
IF (a AND 128) THEN
	NoPalette = 0
	NumColors = 2 ^ ((a AND 7) + 1)
	P$ = SPACE$(NumColors * 3): GET #1, , P$
END IF

'Check for interlaced image.
Interlaced = (a AND 64) > 0: PassNumber = 0: PassStep = 8

'Get LZW starting code size.
GOSUB GetByte

'Calculate clear code, end of stream code, and first free LZW code.
ClearCode = 2 ^ a
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = a + 1: CodeSize = StartCodeSize

'Find maximum code for the current code size.
StartMaxCode = 2 ^ (a + 1) - 1: MaxCode = StartMaxCode

BitsIn = 0: BlockSize = 0: BlockPointer = 1

DEF SEG = VARSEG(arr%(0))
x = XStart: y = ystart: YBase = y * 320& + VARPTR(arr%(2))


'Set palette, if there was one.
IF NoPalette = 0 THEN
	'Use OUTs for speed.
	i = 1
	FOR a = 0 TO NumColors - 1
		pal(a).r = ASC(MID$(P$, i, 1)) \ 4: i = i + 1
		pal(a).g = ASC(MID$(P$, i, 1)) \ 4: i = i + 1
		pal(a).b = ASC(MID$(P$, i, 1)) \ 4: i = i + 1
	NEXT
END IF

IF FirstTime = 0 THEN
  'Clear entire screen to background color. This isn't
  'done until the image's palette is set, to avoid flicker
  'on some GIFs.

	'background filling commented out by Toshi
	'LINE (0, 0)-(319, 199), Background, BF
	FirstTime = -1
END IF

'Decode LZW data stream to screen.
DO
	'Retrieve one LZW code.
	GOSUB GetCode
	'Is it an end of stream code?
	IF Code <> EOSCode THEN
		'Is it a clear code? (The clear code resets the sliding
		'dictionary - it *should* be the first LZW code present in
		'the data stream.)
		IF Code = ClearCode THEN
			NextCode = FirstCode
			CodeSize = StartCodeSize
			MaxCode = StartMaxCode
			DO: GOSUB GetCode: LOOP WHILE Code = ClearCode
			IF Code = EOSCode THEN GOTO ImageDone
			LastCode = Code: LastPixel = Code
			  
			'plot pixel into virtual screen
			POKE x + YBase, LastPixel

			x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
		ELSE
			CurCode = Code: StackPointer = 0

			'Have we entered this code into the dictionary yet?
			IF Code >= NextCode THEN
				IF Code > NextCode THEN GOTO AllDone 'Bad GIF if this happens.
			   'mimick last code if we haven't entered the requested
			   'code into the dictionary yet
				CurCode = LastCode
				OutStack(StackPointer) = LastPixel
				StackPointer = StackPointer + 1
			END IF

			'Recursively get each character of the string.
			'Since we get the characters in reverse, "push" them
			'onto a stack so we can "pop" them off later.
			'Hint: There is another, much faster way to accomplish
			'this that doesn't involve a decoding stack at all...
			DO WHILE CurCode >= FirstCode
				OutStack(StackPointer) = Suffix(CurCode)
				StackPointer = StackPointer + 1
				CurCode = Prefix(CurCode)
			LOOP

			LastPixel = CurCode
			  
			' plot pixel into virtual screen
			POKE x + YBase, LastPixel
		   
			x = x + 1: IF x = XEnd THEN GOSUB NextScanLine

			'"Pop" each character onto the display.
			FOR a = StackPointer - 1 TO 0 STEP -1
				  
				'plot pixel into virtual screen
				POKE x + YBase, OutStack(a)

				x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
			NEXT

			'Can we put this new string into our dictionary? (Some GIF
			'encoders will wait a bit when the dictionary is full
			'before sending a clear code- this increases compression
			'because the dictionary's contents are thrown away less
			'often.)
			IF NextCode < 4096 THEN
				'Store new string in the dictionary for later use.
				Prefix(NextCode) = LastCode
				Suffix(NextCode) = LastPixel
				NextCode = NextCode + 1
				'Time to increase the LZW code size?
				IF (NextCode > MaxCode) AND (CodeSize < 12) THEN
					CodeSize = CodeSize + 1
					MaxCode = MaxCode * 2 + 1
				END IF
			END IF
			LastCode = Code
		END IF
	END IF
LOOP UNTIL Code = EOSCode
ImageDone:

LOOP

AllDone:
CLOSE #1
DEF SEG
EXIT SUB



'Slowly reads one byte from the GIF file...
GetByte: a$ = " ": GET #1, , a$: a = ASC(a$): RETURN

'Moves down one scanline. If the GIF is interlaced, then the number
'of scanlines skipped is based on the current pass.
NextScanLine:
	IF Interlaced THEN
		y = y + PassStep
		IF y >= YEnd THEN
			PassNumber = PassNumber + 1
			SELECT CASE PassNumber
			CASE 1: y = 4: PassStep = 8
			CASE 2: y = 2: PassStep = 4
			CASE 3: y = 1: PassStep = 2
			END SELECT
		END IF
	ELSE
		y = y + 1
	END IF
	x = XStart: YBase = y * 320& + VARPTR(arr%(2))
RETURN

'Reads a multibit code from the data stream.
GetCode:
	WorkCode = LastChar \ ShiftOut(BitsIn)
  'Loop while more bits are needed.
	DO WHILE CodeSize > BitsIn
'Reads a byte from the LZW data stream. Since the data stream is
'blocked, a check is performed for the end of the current block
'before each byte is fetched.
		IF BlockPointer > BlockSize THEN
		  'Retrieve block's length
			GOSUB GetByte: BlockSize = a
			a$ = SPACE$(BlockSize): GET #1, , a$
			BlockPointer = 1
		END IF
	  'Yuck, ASC() and MID$() aren't that fast.
		LastChar = ASC(MID$(a$, BlockPointer, 1))
		BlockPointer = BlockPointer + 1
	  'Append 8 more bits to the input buffer
		WorkCode = WorkCode OR LastChar * Powersof2(BitsIn)
		BitsIn = BitsIn + 8
	LOOP
  'Take away x number of bits.
	BitsIn = BitsIn - CodeSize
  'Return code to caller.
	Code = WorkCode AND MaxCode
RETURN

END SUB

SUB rtprecalc (NsLUT() AS vec, invmag!(), sph() AS spheretype, XMIN, XMAX, ymax, screenz)


'precalc eye-scanline plane normal vectors
DIM BE AS vec 'vector Right-Eye
DIM AE AS vec 'vector Left-Eye
DIM Left AS vec  'leftmost pixel of scanline
DIM Right AS vec  'rightmost pixel of scanline
DIM Ns AS vec

Left.x = XMIN: Right.x = XMAX
Left.z = screenz: Right.z = screenz
AE.z = Left.z
BE.z = Right.z
AE.x = Left.x
BE.x = Right.x
FOR y% = 0 TO symax - 1
		Left.y = y% - syctr
		Right.y = y% - syctr
		AE.y = Left.y
		BE.y = Right.y
		CALL cross(BE, AE, Ns)
		CALL normalize(Ns.x, Ns.y, Ns.z)
		NsLUT(y%) = Ns
NEXT y%

dz! = screenz
dz2! = dz! * dz!
'precalc normalized eye vectors
FOR y = 0 TO ymax
   dy! = y
   dyz2! = dy! * dy! + dz2!
   FOR x = 0 TO XMAX
		dx! = x
		invmag!(x, y) = 1! / SQR(dx! * dx! + dyz2!)
	NEXT x
NEXT y

FOR i = 1 TO numspheres
	sph(i).r = ABS(20 * (4 - i)) + 3
	sph(i).R2 = CLNG(sph(i).r) * sph(i).r
	sph(i).invr = 1 / sph(i).r
NEXT

'create envmap texture
'FOR y = 0 TO 63
'yn! = y / 63!
'FOR x = 0 TO 63
'    xn! = x / 63!
'    envmap(x, y) = 255 - ((((xn! * xn!) + (yn! * yn!)) ^ 3) * 255)
'NEXT
'NEXT
''random specks in light source
'FOR i = 0 TO 128
'x = RND * 32: y = RND * 32
'c = envmap(x, y) + RND * 60 - 30
'IF c > 255 THEN c = 255
'IF c < 0 THEN c = 0
'envmap(x, y) = c
'NEXT
END SUB

DEFSNG A-Z
SUB setblackpal (pal() AS paltype)
FOR i = 0 TO 255
pal(i).r = 0
pal(i).g = 0
pal(i).b = 0
NEXT
END SUB

DEFINT A-Z
SUB setbrownpal (pal() AS paltype)
FOR i% = 0 TO 255
pal(i%).r = i% \ 4
pal(i%).g = i% \ 5
pal(i%).b = i% \ 8
NEXT

END SUB

SUB setgraypal (pal() AS paltype)
FOR i = 0 TO 255
gray = i \ 4
pal(i).r = gray
pal(i).g = gray
pal(i).b = gray
NEXT

END SUB

SUB SETPAL (pal() AS paltype)
OUT &H3C8, 0
FOR i = 0 TO 255
OUT &H3C9, pal(i).r
OUT &H3C9, pal(i).g
OUT &H3C9, pal(i).b
NEXT
END SUB

SUB setwhitepal (pal() AS paltype)
FOR i = 0 TO 255
pal(i).r = 63
pal(i).g = 63
pal(i).b = 63
NEXT

END SUB

SUB tunnel
DEFSNG A-Z
'fov = field of view in radians
fov = ATN(xh / screendist)
esc$ = CHR$(27)
DIM p1 AS vec
DIM p2 AS vec
DIM pd AS vec

'DIM e AS INTEGER ' compiled
DIM e AS LONG 'in IDE

DIM tex%(tmask, tmask)
FOR x% = 0 TO tmask
FOR y% = 0 TO tmask
	tex%(x%, y%) = ((x% AND y%) OR 8) * 15
NEXT y%
NEXT x%

DIM rtimesinvsqr(0 TO 9000)
FOR x% = 1 TO 9000
rtimesinvsqr(x%) = radius * .5 / SQR(x%)
NEXT

DIM atnlut%(-50 TO 50, -50 TO 50)
FOR y% = -400 TO 400 STEP 8
FOR x% = -400 TO 400 STEP 8
atnlut%(x% \ 8, y% \ 8) = INT(atan2(CSNG(x%), CSNG(y%)) * 21) AND tmask
NEXT x%
NEXT y%



DEF SEG = &HA000

t1! = TIMER
frames% = 0
p1.x = -xh
p2.x = xh
pdx = (p2.x - p1.x) * invxres
FOR a = 0 TO pi STEP .01
	e = 320 * 25
	forward = frames% * .6
	Sa = SIN(a)
	Ca = COS(a)
	'top left
	p1.y = screendist * Sa + yh * Ca
	p1.z = screendist * Ca - yh * Sa
	'bottom right
	p2.y = screendist * Sa - yh * Ca
	p2.z = screendist * Ca + yh * Sa
   
	'deltas
	'pdx = (p2.x - p1.x) * invxres
	pdy = (p2.y - p1.y) * invyres
	pdz = (p2.z - p1.z) * invyres
   
	pz = p1.z
	py = p1.y
	FOR sy% = 0 TO tnymax
		px = p1.x
		py2 = py * py
		FOR sx% = 0 TO tnxmax
			n% = ((px * px + py2) * .1) AND -1
			t = rtimesinvsqr(n%)
			x = t * px
			y = t * py
			z = t * pz
			u% = ((z * .05 + forward) AND -1)
			v% = atnlut%((x * .125) AND -1, (y * .125) AND -1)
			c% = tex%(u% AND tmask, v%) - u%
			IF c% > 255 THEN
				c% = 255
			ELSEIF c% < 0 THEN c% = 0
			END IF
			POKE e, c%
			e = e + 1
			px = px + pdx
		NEXT sx%
		py = py + pdy
		pz = pz + pdz
		IF INKEY$ <> "" THEN exitflag% = 1
	NEXT sy%
	frames% = frames% + 1
	IF exitflag% THEN EXIT FOR
NEXT a
elapsed! = TIMER - t1!
DEF SEG
IF elapsed! > 0 THEN
fps!(FPSTUN) = frames% / elapsed!
ELSE
fps!(FPSTUN) = 999
END IF
ERASE atnlut%
ERASE rtimesinvsqr
ERASE tex%
END SUB

DEFINT A-Z
SUB volumetriclights

'fake volumetric light
'using radial blur

REDIM vs(32001)
CONST ymin = 20
CONST ymax = 170

CONST m = 4
CONST snum = 50 'if snum<denom then explode, otherwise implode
CONST denom = 54 '52 gives ok results too

DIM clamp255(511)
FOR i = 0 TO 255
	clamp255(i) = i
NEXT i
FOR i = 256 TO 511
	clamp255(i) = 255
NEXT i

'attenuates the light the further it gets from the center
DIM dim2(510)
FOR i = 0 TO 510
	tt = i - 11
	IF tt > 255 THEN tt = 255
	IF tt < 0 THEN tt = 0
	dim2(i) = tt
NEXT i

vs(0) = 320 * 8
vs(1) = 200

DIM ytab&(199)
vsofs = VARPTR(vs(2))
FOR y = 0 TO 199
	ytab&(y) = y * 320& + vsofs
NEXT

CONST pi = 3.14159265359#
OUT &H3C8, 0
FOR i = 0 TO 254
	ii = i \ 3
	IF ii > 63 THEN ii = 63
	OUT &H3C9, ii
	OUT &H3C9, ii
	OUT &H3C9, i * .16
NEXT
FOR i = 0 TO 2
	OUT &H3C9, 63
NEXT

CONST sinescale = 64
CONST qmax = 60
DIM div16(-qmax * sinescale TO qmax * sinescale)
FOR i = -qmax * sinescale TO qmax * sinescale
	div16(i) = i \ 16
NEXT i

DIM div5(1275)
FOR i = 0 TO 1275
	div5(i) = i \ 5
NEXT

DIM pt(-m TO m, -m TO m)
FOR x = -m TO m
	FOR y = -m TO m
		xt = x * 2
		yt = y * 2
		c = 127 - (xt * xt + yt * yt)
		IF c < 0 THEN c = 0
		pt(x, y) = c
	NEXT
NEXT

DIM sine(127)
DIM cosine(127)
FOR t = 0 TO 127
	sine(t) = SIN(t * 63! / pi) * sinescale
	cosine(t) = COS(t * 63! / pi) * sinescale
NEXT t

DIM scalex(320)
FOR x = 0 TO 320
	xr = (x - 160)
	c = ((xr * snum) \ denom) + 160
	IF c < 0 THEN c = 0
	IF c > 319 THEN c = 319
	scalex(x) = c
NEXT x

DIM scaley(200)
FOR y = 0 TO 200
	c = ((y - 100) * snum \ denom) + 100
	IF c < 0 THEN c = 0
	IF c > 199 THEN c = 199
	scaley(y) = c
NEXT y


t1! = TIMER
DEF SEG = VARSEG(vs(0))

'-------------------main loop--------------------------
DO
FOR P = 0 TO 20
w = w + 1

  '--draw 5 pointed spiral-------
	FOR t = 0 TO 67
		r = div5(t)
		phase = (t + P) AND 255
		x = div16(cosine(phase) * r) + 160
		y = div16(sine(phase) * r) + 100
		FOR yofs = -m TO m
			ystart& = ytab&(y + yofs) + x
			FOR xofs = -m TO m
				c = pt(xofs, yofs)
				vsoff& = ystart& + xofs
				'c = clamp255(c + PEEK(vsoff&))
				POKE vsoff&, c
			NEXT xofs
		NEXT yofs
	NEXT t
   
  '---radial blur outwards from center------
	FOR y = 100 TO ymin STEP -1
		ys& = ytab&(scaley(y))
		yo& = ytab&(y)
		FOR x = 160 TO 319
			srcptr& = ys& + scalex(x)
			destptr& = yo& + x
			POKE destptr&, dim2(PEEK(srcptr&) + PEEK(destptr&))
		NEXT
	NEXT
	FOR y = 100 TO ymin STEP -1
		ys& = ytab&(scaley(y))
		yo& = ytab&(y)
		FOR x = 159 TO 0 STEP -1
			srcptr& = ys& + scalex(x)
			destptr& = yo& + x
			POKE destptr&, dim2(PEEK(srcptr&) + PEEK(destptr&))
		NEXT
	NEXT
	FOR y = 101 TO ymax
		ys& = ytab&(scaley(y))
		yo& = ytab&(y)
		FOR x = 160 TO 0 STEP -1
			srcptr& = ys& + scalex(x)
			destptr& = yo& + x
			POKE destptr&, dim2(PEEK(srcptr&) + PEEK(destptr&))
		NEXT
	NEXT
	FOR y = 101 TO ymax
		ys& = ytab&(scaley(y))
		yo& = ytab&(y)
		FOR x = 161 TO 319
			srcptr& = ys& + scalex(x)
			destptr& = yo& + x
			POKE destptr&, dim2(PEEK(srcptr&) + PEEK(destptr&))
		NEXT
	NEXT

	' ------spatial-blur--------
	FOR y = ymin + 1 TO ymax - 1
		yo& = ytab&(y)
		FOR x = 11 TO 310
			yo& = yo& + 1 'yes, preincrement on purpose
			c0 = PEEK(yo& - 1)
			c1 = PEEK(yo&)
			c2 = PEEK(yo& + 1)
			c3 = PEEK(yo& + 320)
			c4 = PEEK(yo& - 320)
			POKE yo&, div5(c0 + c1 + c2 + c3 + c4)
		NEXT
	NEXT

'    WAIT &H3DA, 8
  
	'---blit to screen-------
	PUT (0, 0), vs, PSET

	REDIM vs(32001)
	vs(0) = 2560
	vs(1) = 200
	IF LEN(INKEY$) THEN GOTO done
NEXT
elapsed! = TIMER - t1!
LOOP UNTIL elapsed! > 3
done:
DEF SEG
elapsed! = TIMER - t1!
frames% = w
IF elapsed! > 0 THEN
fps!(FPSLITE) = frames% / elapsed!
ELSE
fps!(FPSLITE) = 999
END IF
ERASE vs, dim2, div5, sine, cosine, scalex, scaley, ytab&

END SUB

