﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

    

namespace SpaceRescueMapper
{
    
    class RoomConnection:Button
    {
        //zmienne
        public int OnOff;           //włączone czy wyłączone

        //konstruktor
        public RoomConnection(string pType)
        {
            this.FlatStyle = FlatStyle.Flat;         //usuwa border
            this.FlatAppearance.BorderSize = 0;
           
            this.MouseClick+=new MouseEventHandler(RoomConnection_MouseClick);

            OnOff = 0;
            switch (pType)
            {
                case "hor":
                    this.Width=30;
                    this.Height = 10;
                    break;

                case "ver":
                    this.Width = 10;
                    this.Height = 25;
                    break;

            }
            SetColor();
        }

        public void SetColor()
        {
            if (OnOff == 0)
            {
                this.BackColor = System.Drawing.Color.LightGray;
            }
            else
            {
                this.BackColor = System.Drawing.Color.Red;
            }
        }

        private void RoomConnection_MouseClick(object sender, MouseEventArgs e)
        {
            if (OnOff == 0)
            { OnOff = 1; }
            else
            { OnOff = 0; }
            SetColor();
        }
    }
}
