; ELAV
; by Stefano Tognon
; (C) 2006 Ice Team
; version 1.00

; Well, this game is also dedicated to my young friend
; This is my 11 game for C64 

       processor 6502

RASTER0   =  $FF 

INIT_MUSIC = $2D09
PLAY_MUSIC = $2D0D

JOY_UP    = 1
JOY_DOWN  = 2
JOY_LEFT  = 4
JOY_RIGHT = 8
JOY_FIRE  = 16

;sprites:
; 0  fire kong
; 1  up of kong
; 2  dn of kong



; structure of a level
; K  A1 .. Ak
;
; K= number of buildings
; Ax= p xxx yyyy
; 
; p= 1 bihind, 0=in front 
; xxx = 
;  000 3x2
;  001 4x2
;  010 5x2
;  011 6x2
;  100 5x3
;  101 6x3
;  110 7x3
;  111 not used
; yyyy = position from 0 or previous position

POS_BEH = $80
POS_FRO = $00
B3x2    = $00 
B4x2    = $10
B5x2    = $20
B6x2    = $30
B5x3    = $40
B6x3    = $50
B7x3    = $60



; sprite usage:
; 0= kick
; 1= body up
; 2= body dn
  

ACT_NONE = 0
ACT_UP1  = 1           ; body up 1
;ACT_UP2  = 2
ACT_DN1  = 2           ; body dn 2
ACT_DN2  = 3           ; body dn 3
ACT_CL1  = 4           ; climb 1
ACT_CL2  = 5           ; climb 2
ACT_FI1  = 6           ; fire 1
ACT_FI2  = 7           ; fire 2
ACT_FIRE = 8           ; enemy fire

; animation state
ANIM_NONE  = 0         ; no animation
ANIM_WDX   = 1         ; walk at dx
ANIM_WSX   = 2         ; walk at sx
ANIM_CUP   = 3         ; animation climb up
ANIM_CDN   = 3         ; animation climb dn
ANIM_FALL  = 4         ; animation of fall down
ANIM_FIDX1 = 5         ; animation of fire ad dx 1
ANIM_FIDX2 = 6         ; animation of fire ad dx 2
ANIM_FISX1 = 7         ; animation of fire ad sx 1
ANIM_FISX2 = 8         ; animation of fire ad sx 2


; step for animation
STEP_WDX  = 8          ; steps for walk at dx
STEP_WSX  = 8          ; steps for walk at sx
STEP_CUP  = 4          ; steps for climbing up 
STEP_CDN  = 4          ; steps for climbing dn
STEP_FIRE = 10         ; steps for fire action

SPR_MIR   = 8          ; offset of mirrored sprites 

; starting y position of kong
POS_STY1  = 168
POS_STY2  = 189

ACCDEL   = 3           ; acceleration delay for fall down

; state of kong
ST_AT_DX  = 0          ; kong is at dx facing 
ST_CL_DX  = 1          ; kong is climb at dx

ST_AT_SX  = $FF        ; kong is at sx facing
ST_CL_SX  = $FE        ; kong is climb at sx

; status
NORMAL = 0            ; normal
KILLED = 1            ; killed 
PASSED = 2            ; screen is pased

STARTLIFES = 9        ; number of starting lifes
MAXLEVEL  =  8

FALL      = 94        ; fall char
NOT_FALL  = 89        ; not fall char

SCREEN     = $E536    ; clean the screen with color
SET_COOR   = $E50C    ; set x/y coord
STRING     = $AB1E    ; put a string
GOTOXY     = $E510    ; goto xy position

GO         = $05      ; 1=go
timeDl     = $06      ; time delay counter
;time       = $07      ; time counter
;lifes      = $08      ; number of lifes (9 max)
addr       = $0a      ; $0b
addr2      = $0c      ; $0d
status     = $10      ; state: 0=live 1=killed 2=level pass
joystick   = $11      ; joystick values
level      = $12      ; actual level
anim       = $13      ; animation flag for fall down
delay      = $14      ; delay for fall animation

tBuild     = $4E      ; total buildings
rBuild     = $4F      ; remain buildings
temp4      = $50
temp5      = $51
temp6      = $52
temp7      = $53

CHR0       = $80      ; 80-81 char priority 0
COL0       = $82      ; 82-83 color priority 0
CHR1       = $84      ; 84-85 char priority 1
COL1       = $86      ; 86-87 color priority 1
CHR2       = $88      ; 88-89 char priority 2
COL2       = $8A      ; 8A-8B color priority 2
CHR_       = $8C      ; 8C-8D char final location
COL_       = $8E      ; 8E-8F color final location 


virtualD   = $90      ; virtual draw register for sprite
virtualX   = $91      ; virtual high bits register for sprite
temp1      = $92
temp2      = $93
temp3      = $94
animation  = $95      ; animation state
step       = $96      ; animation step

 
time       = $f7;b      ; time counter
lifes      = $f8;c      ; number of lifes (9 max)
state      = $f9;d      ; state of kong
accDel     = $fa;e      ; acceleration delay

 org $801

 ;jsr  $2d0e
; install custom chars
                                  ; transfer characters codes to 14336
        sei

        lda  #$33
        sta  $01

        ldy #0
        ldx #8
lp1
        lda $d000,y
        sta $3800,y
        dey
        bne lp1
next
        inc lp1+2
        inc lp1+5
        dex
        beq exit
        cpx #$06 ; do not overwrite the predefined chars $3a00-3aff
        beq next
        bne lp1
exit
        lda  #$37
        sta  $01
        cli

        jsr  INIT_MUSIC

      sei
      lda  #<irqR0
      sta  $0314
      lda  #>irqR0
      sta  $0315

      lda  #RASTER0
      sta  $D012
                                 ; disable cia interrupt
      ldx  #$00
      stx  $DC0E                 ; Control register A of CIA #1
      inx
      stx  $D01A                 ; IRQ mask register

      cli
                                 ; use VIC interrupt
      stx  $D019                 ; Interrupt indicator register

                                 ; switch to new chars
      lda  #31
      sta  $D018

      ldx  #0
      stx  anim                  ; clear anim flag
      stx  53281                 ; set screen color  
      stx  53280
      dex
      stx  $D01C                 ; all multicolor sprites 

      ldx  #15
      stx  $D022                 ; mcm common color 1 

      ldx  #8
      stx  $D023                 ; mcm common color 2

      
      stx  $D027                 ; primary color mob 0
      stx  $D028                 ; primary color mob 1
      stx  $D029                 ; primary color mob 2
      dex
      stx  $D025                 ; mob common color 1

      ldx  #11
      stx  $D026                 ; mob common color 2

      lda  #$1B
      sta  $D011                 ; VIC control register MCM char mode
      jsr  normalScreen
      ;lda  #$18
      ;sta  $D016                 ; VIC control register MCM char mode
                                 ; create the fixed screen
      ;lda  #15
      jsr  SCREEN                ; clearing the screen with color 


      jsr  copyScreen            ; copy screen
      lda  #$28
      sta  lp1_+2
      lda  #$d8
      sta  lp1__+2
      jsr  copyScreen            ; copy color 
  ;    jsr  clearBuffer           ; clean screen buffers
      jsr  emptyScreen          ; clean screen buffers
      jsr  mirrorSprite

mainLoop:
      ;jsr  writeGameTitle


      ;lda  #1                     ; init music number 1
      ;jsr  initMusic

      ldx  #0
      stx  level                 ; level 1

      ;ldx  #ST_AT_DX
      stx  state                 ; state: kong at dx

      stx  score                 ; clear score
      stx  score+1
      stx  score+2
      stx  status

     ;ldx  #6 ;;;;;;;;;;;
     ; stx  level   ;;;;;;;;              ; level 1


      lda  #STARTLIFES
      sta  lifes

extLoop:
      jsr  emptyScreen
      jsr  writeFire             ; write press fire button for going
      jsr  waitFire
      jsr  hideFire

      lda  #$99                  ; reset energy
      sta  time                  ; 99 seconds

      lda  #NORMAL
      sta  status                ; clear status

      lda  #ANIM_NONE
      sta  animation             ; reset animation

      jsr  insertLevel
      jsr  insertKong

intLoop
      jsr  getJoystick           ; get user joystick movements
      jsr  moveKong              ; move King Kong
      ;jsr  moveEnemy             ; move all the enemy
      jsr  makeMove              ; make the movements
      jsr  makeAnimation         ; make the animation

      lda  $d01e                 ; avoid double kill

      jsr  waitIRQ               ; attend syncronization for madding the scroll
      jsr  animScreen            ; animate the screen if the case
      jsr  removeEnemy
      jsr  insertEnemy           ; insert one enemy if it is the case
      jsr  drawSprites           ; draw all the actors
      jsr  makeDestroy           ; make a destroy of building if it is the case
      jsr  mergeScreen

      ;;ldx  temp5
      ;;ldy  temp6
      ;;jsr  SET_COOR;GOTOXY                 ; $D1-2=pointer of char at x/y position
      ;;lda  #4
      ;;sta  ($F3),y

      ;jsr  removeEnemy

      jsr  checkEnemy            ; check collision

      jsr  decTime               ; decrement the time
      jsr  testScore             ; test if this score is the highscore
      jsr  writeScore            ; write the score

      lda  status                ; test if screen is passed
      cmp  #PASSED
      beq  screenPassed
      cmp  #KILLED
      beq  killed
      jmp  intLoop

screenPassed:
      lda  time
      jsr  giveBonus             ; give bonus according with this time

      inc  level                 ; go to next level
      lda  level                 ; check if we have win
      cmp  #MAXLEVEL
      beq  win

      jmp  extLoop

killed:
      dec  lifes
      beq  over

      lda  #NORMAL
      sta  status
      jmp  intLoop


win:
      ;jsr  emptyScreen
      jsr  writeWin             ; write win
      jsr  waitFire
      jmp  mainLoop

over:
      ;jsr  emptyScreen
      jsr  writeOver            ; write over
      jsr  waitFire
      jmp  mainLoop 

;=================================
; Get a random number 
; routine in publication magazine
; modified by iAN
;=================================
random:
     inc  Z
Z = * +1
     ldy  #00
     lda  $DC04
     eor  $FEDC,y
     eor  $D012
     rts

;Z: 
; .byte $00

;=================================
; Insert kikg kong in starting 
; postion
;=================================
insertKong:
      lda  #ACT_NONE
      sta  actType+0

      lda  #ACT_UP1
      sta  actType+1

      lda  #ACT_DN1
      sta  actType+2

      lda  #20                   ; put actor to his x/y position
      sta  xActLo+1
      sta  xActLo+2
      lda  #00
      sta  xActHi+1
      sta  xActHi+2
      sta  yActSpeed+1
      sta  yActSpeed+2

      lda  #POS_STY1
      sta  yAct+1
      lda  #POS_STY2
      sta  yAct+2
      rts

;=================================
; Insert enemy (fire) according to 
; actual kong position, if this is 
; the case
;=================================
insertEnemy:

      lda  xActSpeed+4          ; exit if fire is already on
      bne  exitIE

      lda  yAct+2              ; skip fire if kong is not climbed
      cmp  #POS_STY2
      beq  exitIE2


      jsr  random
      cmp  #$40  ; gimme a f*king break! =)
      bcc  exitIE
      bmi  exitIE

      and  #$01                ; give positive or negative velocity at random
      tay

      lda  xActLo+2            ; don't fire at sx if too near at sx
      cmp  #50
      bcs  dontforcedx
      ldy  #1
dontforcedx
      lda  xActHi+2
      and  #$01
      beq  dontforcesx

      ldy  #0
dontforcesx
      lda  xacttbl,y
      sta  xActSpeed+4
    ;lda  #7                  ; give a "fire" at screen
    ;sta  53280

      lda  #0
      sta  xActLo+4
      sta  xActHi+4

      lda  yAct+2              ; use same y location of kong
      sta  yAct+4

      lda  #ACT_FIRE
      sta  actType+4
      rts
exitIE2:
      lda #$ff
      sta yAct+4
exitIE:
      rts

xacttbl byte $04,$fc

;=================================
; Remove the enemy if this is the 
; case
;=================================
removeEnemy:
      lda  xActHi+4
      and  #$01
      bne  exitIE
      lda  xActLo+4
      cmp  #4
      bcs  exitIE

clearEnemy:
      lda  #0
      sta  xActSpeed+4

      lda  #0
      sta  xActLo+4
      sta  xActHi+4
exitCE: 
      rts

;=================================
; Check fire collision
;=================================
checkEnemy:
      lda  $d01e
      and  #$10
      beq  exitCE

      lda  #KILLED
      sta  status
      jmp  clearEnemy
      ;rts

;=================================
; Dec time of 1 sec. after 50
; frames
;=================================
decTime:
      lda  time
      beq  endTime
      inc  timeDl
      lda  timeDl
      cmp  #50                    ; 50 frames (pal)=1 second
      bcc  noDecTime
      lda  #$00
      sta  timeDl                 ; reset time frame (delay) conter
      sed
      lda  time
      sec
      sbc  #$01                   ; sub 1 second (in decimal mode)
      sta  time
      cld
noDecTime:
      rts

endTime:
      lda  #$99
      sta  time
      lda  #KILLED
      sta  status
      rts

;=================================
; Write fire string
;=================================
writeFire:
      ldx  #15
      ldy  #12
      jsr  SET_COOR
      lda  #<Sfire
      ldy  #>Sfire
      jmp  STRING                 ; put press fire
      ;rts

;=================================
; Write fire string
;=================================
writeWin:
      ldx  #15
      ldy  #12
      jsr  SET_COOR
      lda  #<Swin
      ldy  #>Swin
      jmp  STRING                 ; put win

;=================================
; Write fire string
;=================================
writeOver:
      ldx  #15
      ldy  #12
      jsr  SET_COOR
      lda  #<Sover
      ldy  #>Sover
      jmp  STRING                 ; put game over


;=================================
; Hide the string
;=================================
hideFire:
      ldx  #15
      ldy  #12
      jsr  SET_COOR
      lda  #<Shide
      ldy  #>Shide
      jmp  STRING                 ; put the name of the game
      ;rts
Sfire:
  .byte 159,"   PRESS FIRE  ",0

Swin:
  .byte 159,"   YOU WIN     ",0

Sover:
  .byte 159,"  GAME OVER    ",0

Shide:
  .byte "               ",0


;================================
; Get Joystick movement
;================================
getJoystick:
      lda  #$FF
      sta  $DC00
      lda  $DC00
      eor  #$FF
      sta  joystick
      rts


waitFire:
releasefire
      jsr  getJoystick           ; check for already pressed fire
      and  #JOY_FIRE
      bne  releasefire
waitFire2                        ; wait a joystick fire action
      jsr  getJoystick
      and  #JOY_FIRE
      beq  waitFire2
      rts

;================================
; Start fire at dx animation
;===============================
fireDX:
      lda  #STEP_FIRE
      sta  step

      jsr  getJoystick
      and  #JOY_FIRE             ; test for fire pressed
      bne  isFireDx

      lda  #ANIM_FIDX1
      sta  animation             ; put animation of fire at dx 1
      rts

isFireDx:
      lda  #ANIM_FIDX2
      sta  animation             ; put animation of fire at dx 2
      rts


;================================
; Start fire at sx animation
;===============================
fireSX:
      lda  #STEP_FIRE
      sta  step

      jsr  getJoystick
      and  #JOY_FIRE             ; test for fire pressed
      bne  isFireSx

      lda  #ANIM_FISX1
      sta  animation             ; put animation of fire at sx 1
      rts

isFireSx:
      lda  #ANIM_FISX2
      sta  animation             ; put animation of fire at sx 2
      rts


;================================
; Fall down and assume SX final 
; position
;================================
fallDownSx:
      lda  #(ACT_DN1+SPR_MIR)
      sta  actType+2             ; put down kong at sx
      lda  #ST_AT_SX
      sta  state                 ; state is at sx
      bne  fallDown

;================================
; Fall down and assume SX final 
; position
;================================
fallDownDx:
      lda  #ACT_DN1
      sta  actType+2             ; put down kong at sx
      lda  #ST_AT_DX
      sta  state                 ; state is at sx

;================================
; Start fall down sequence
;================================
fallDown:
      lda  #ANIM_FALL
      sta  animation

      lda  #1
      sta  yActSpeed+1            ; set y speed to 1
      sta  yActSpeed+2            ; set y speed to 1

      lda  #0
      sta  accDel                 ; reset acceleration delay
      rts

;=================================
; Move Kong according to user 
; action
;=================================
moveKong:
      lda  animation
      bne  exitMK                ; skip if there is an animation in progress

      jsr  getJoystick
      ;and  #JOY_FIRE             ; test for fire pressed
      ;bne  isFire

      lda  joystick
      and  #JOY_RIGHT            ; test for right movement
      bne  moveRight

      lda  joystick
      and  #JOY_LEFT             ; test for left movement
      bne  moveLeft

      lda  joystick
      and  #JOY_UP               ; test for up movement
      bne  moveUp

      lda  joystick
      and  #JOY_DOWN             ; test for up movement
      bne  moveDn

exitMK:
      rts

;================================
; move kong at DX, by setting the
; right animation
;================================
moveRight:
      lda  state
      cmp  #ST_CL_DX             ; cannot goes DX if climb at DX
      beq  fireDX
      cmp  #ST_CL_SX             ; if goes at DX, fall down
      beq  fallDownSx

      lda  #STEP_WDX
      sta  step
moveRightIn:
      lda  #ST_AT_DX
      sta  state                 ; put at dx facing status
      lda  #ANIM_WDX
      sta  animation             ; put animation at dx
      lda  #2                    ; go at dx with 2 pixels of movement
      ;sta  xActSpeed
      sta  xActSpeed+1
      sta  xActSpeed+2
exitMR:
      rts

;================================
; move kong at SX, by setting the
; right animation
;================================
moveLeft:
      lda  state
      cmp  #ST_CL_SX             ; cannot goes SX if climb at SX
      beq  fireSX 
      cmp  #ST_CL_DX             ; if goes at SX, fall down
      beq  fallDownDx

      lda  #STEP_WSX
      sta  step
moveLeftIn:
      lda  #ST_AT_SX
      sta  state                 ; put at sx facing status
      lda  #ANIM_WSX
      sta  animation             ; put animation at sx
      lda  #$FE                  ; -2=sx of 2 pixels
      ;sta  xActSpeed
      sta  xActSpeed+1
      sta  xActSpeed+2
exitML:
      rts

;================================
; move kong at UP, by setting the
; right animation
;=================================
moveUp:
      ldx  state                 ; look for dx/sx faced
      bmi  atSx

      jsr  getChar               ; see if the char is for going up ad dx 
      cmp  #76
      beq  goUpDx
      cmp  #85
      beq  goUpDx
                                 ; test a char after
      jsr  getCharP1             ; see if the char is for going up ad dx 
      cmp  #76
      beq  goUpDx1
      cmp  #85
      beq  goUpDx1
      

      rts
atSx:
      jsr  getChar               ; see if the char is for going up ad sx
      cmp  #79
      beq  goUpSx
      cmp  #88
      beq  goUpSx
                                 ; test a char before
      jsr  getCharM1             ; see if the char is for going up ad dx 
      cmp  #79
      beq  goUpSx1
      cmp  #88
      beq  goUpSx1
      rts

;================================
; move kong at DN, by setting the
; right animation
;================================
moveDn:
                                 ; we always go down, but not when at flow
      lda  yAct+2
      cmp  #POS_STY2
      beq  setLowPart

      lda  #ANIM_CDN
      sta  animation              ; put animation at dx
      lda  #STEP_CDN
      sta  step
      lda  #$2                    ; go dn with 2 pixels of movement
      ;sta  xActSpeed
      sta  yActSpeed+1
      sta  yActSpeed+2
      rts

setLowPart:
      ldx  state                 ; look for dx/sx faced
      bmi  setLowSx

      lda  #(ACT_DN1)            ; put wolk low part of kong
      sta  actType+2

      lda  #ST_AT_DX             ; put that kong is now climbing at dx
      sta  state
      rts

setLowSx:
      lda  #(ACT_DN1+SPR_MIR)    ; put wolk low part of kong
      sta  actType+2

      lda  #ST_AT_SX             ; put that kong is now climbing at sx
      sta  state
      rts

;================================
; Go at dx of one char animation
;================================
goUpDx1:
      lda  #(STEP_WDX/2)
      sta  step
      jmp moveRightIn

;================================
; Go at dx of one char animation
;================================
goUpSx1:
      lda  #(STEP_WDX/2)
      sta  step
      jmp moveLeftIn


;================================
; go up with dx facing
;================================
goUpDx:
      ldx  state
      ;cpx  #ST_AT_DX
      beq  insClimbUpDx

      lda  #ANIM_CUP
      sta  animation             ; put animation at dx
      lda  #STEP_CUP
      sta  step
      lda  #$FE                  ; go up with 2 pixels of movement
      ;sta  xActSpeed
      sta  yActSpeed+1
      sta  yActSpeed+2

insClimbUpDx:
      lda  #ACT_CL1              ; put climbing low part of kong
      sta  actType+2

      lda  #ST_CL_DX             ; put that kong is now climbing at dx
      sta  state
      rts

;================================
; go up with sx facing
;================================
goUpSx:
      ldx  state
      cpx  #ST_AT_SX
      beq  insClimbUpSx

      lda  #ANIM_CUP
      sta  animation              ; put animation at dx
      lda  #STEP_CUP
      sta  step
      lda  #$FE                   ; go up with 2 pixels of movement
      ;sta  xActSpeed
      sta  yActSpeed+1
      sta  yActSpeed+2

insClimbUpSx:
      lda  #(ACT_CL1+SPR_MIR)   ; put climbing low part of kong
      sta  actType+2

      lda  #ST_CL_SX            ; put that kong is now climbing at sx
      sta  state
      rts

;=================================
; Make move of sprites in x/y
;=================================
makeMove:
      ldx  #7
loopMM:
      jsr  moveActorX
      jsr  moveActorY
      dex
      bpl  loopMM
      rts

;==================================
; Move an actor to x direction
; according with his speed (>0=DX)
;==================================
moveActorX:
      clc
      lda  xActSpeed,x            ; read speed in x direction
      bmi  negMoveX

posMoveX:
      lda  xActSpeed,x            ; read speed in x direction
      adc  xActLo,x               ; move to dx
      sta  xActLo,x
      lda  xActHi,x
      adc  #$00
      and  #$01
      sta  xActHi,x
      rts
negMoveX:                         ; move to sx
      adc  xActLo,x
      sta  xActLo,x
      lda  xActHi,x
      adc  #$ff
      sta  xActHi,x
exitMovX:
      rts

;==================================
; Move an actor to y direction
; according with his speed
;==================================
moveActorY:
      lda  yActSpeed,x
      clc
      adc  yAct,x
      sta  yAct,x
      rts


;================================
; Externa call
;================================
resetFDX:
      lda  #ACT_CL1              ; ripristinate climb low 1 part
      sta  actType+2
      lda  #ANIM_NONE
      sta  animation             ; ripristinate no animation

      lda  #ACT_NONE             ; de-activate hand sprite
      sta  actType+0
                                 ; test for damage given
      jsr  isDamage
      rts

;================================
; Externa call
;================================
resetFSX:
      lda  #(ACT_CL1+SPR_MIR)    ; ripristinate climb low 1 part
      sta  actType+2
      lda  #ANIM_NONE
      sta  animation             ; ripristinate no animation

      lda  #ACT_NONE             ; de-activate hand sprite
      sta  actType+0
                                 ; test for damage given
      jsr  isDamage
      rts


;================================
; Animation of fire DX 1
;================================
animFiDX1:
      jsr  getChar               ; read char +0 dx
      sta  temp4

      lda  #ACT_FI1              ; activate hand sprite
      sta  actType+0
      jmp  animFiDX

;================================
; Animation of fire DX 2
;================================
animFiDX2: 
      jsr  getCharP2             ; read char +2 dx
      sta  temp4

      lda  #ACT_FI2              ; activate hand sprite
      sta  actType+0
      ;jmp  animFiDX

;==================================
; Animation of fire at dx 1
;==================================
animFiDX:
      dec  step
      beq  resetFDX

      lda  #ACT_CL2              ; set climb fire part 
      sta  actType+2

      ldx  yAct+2                ; copy y location and fix it
      dex
      stx  yAct

      lda  xActLo+2              ; copy x location and shift it
      clc
      adc  #24
      sta  xActLo
      lda  xActHi+2
      adc  #0
      sta  xActHi

      rts


;================================
; Animation of fire SX 1
;================================
animFiSX1:
      jsr  getChar              ; read char +0 sx
      sta  temp4

      lda  #(ACT_FI1+SPR_MIR)   ; activate hand sprite
      sta  actType+0
      jmp  animFiSX

;================================
; Animation of fire SX 2
;================================
animFiSX2: 
      jsr  getCharM2             ; read char -2 sx
      sta  temp4

      lda  #(ACT_FI2+SPR_MIR)   ; activate hand sprite
      sta  actType+0
      ;jmp  animFiSX

;==================================
; Animation of fire at sx 1
;==================================
animFiSX:
      dec  step
      beq  resetFSX

      lda  #(ACT_CL2+SPR_MIR)    ; set climb fire part 
      sta  actType+2

      ldx  yAct+2                ; copy y location and fix it
      dex
      stx  yAct

      lda  xActLo+2              ; copy x location and shift it
      sec
      sbc  #24
      sta  xActLo
      lda  xActHi+2
      sbc  #0
      sta  xActHi

      rts



;===================================
; Make kong animation
;===================================
makeAnimation:

      lda  animation
      beq  exitMA                  ; skip if no animation is to performe

      cmp  #ANIM_FIDX1             ; animation of fire dx 1
      beq  animFiDX1

      cmp  #ANIM_FIDX2             ; animation of fire dx 2
      beq  animFiDX2

      cmp  #ANIM_WDX               ; dx walk animation?
      beq  animWdx

      cmp  #ANIM_WSX               ; sx walk animation?
      beq  animWsx

      cmp  #ANIM_CUP               ; climb up animation
      beq  fixDec

      cmp  #ANIM_FALL              ; fall down animation
      beq  animFall

      cmp  #ANIM_FISX1             ; animation of fire sx 1
      beq  animFiSX1

      cmp  #ANIM_FISX2             ; animation of fire sx 2
      beq  animFiSX2
exitMA:
      rts

;================================
; animation of fall down
;================================
animFall:
      lda  yAct+2
      cmp  #POS_STY2
      bcs  stopAF

      inc  accDel
      lda  accDel
      cmp  #ACCDEL               ; test for delay of acceleration
      bcc  exitAF

      inc  yActSpeed+1           ; increment speed
      inc  yActSpeed+2
      lda  #0
      sta  accDel                ; reset acceleration delay
exitAF:
      rts

stopAF:
      lda  #ANIM_NONE
      sta  animation              ; stop animation
      ;lda  #0 
      sta  yActSpeed+1            ; stop y speed 
      sta  yActSpeed+2

      lda  #POS_STY1              ; make position at flow
      sta  yAct+1
      lda  #POS_STY2
      sta  yAct+2

      rts


;================================
; animation of walk at sx
;================================
animWsx:
      lda  #(ACT_UP1+SPR_MIR)
      sta  actType+1

      lda  step
      cmp  #STEP_WDX/2              ; change low sprite if at middle of animation
      bcc  changeDxM

      lda  #(ACT_DN2+SPR_MIR)
      bne  saveAWDXM

changeDxM:
      lda  #(ACT_DN1+SPR_MIR)
saveAWDXM:
      sta  actType+2
      jmp  fixDec

;================================
; animation of walk at dx
;================================
animWdx:
      lda  #ACT_UP1
      sta  actType+1
      lda  step
      cmp  #STEP_WDX/2              ; change low sprite if at middle of animation
      bcc  changeDx

      lda  #ACT_DN2
      bne  saveAWDX

changeDx:
      lda  #ACT_DN1
saveAWDX:
      sta  actType+2
      
fixDec:
      dec  step
      bne  skipEOA
      lda  #ANIM_NONE
      sta  animation
      ;lda  #0
      ;sta  xActSpeed
      sta  xActSpeed+1
      sta  xActSpeed+2
      sta  yActSpeed+1
      sta  yActSpeed+2
skipEOA:
      rts

;=================================
; give bonus: time*25 points
;=================================
giveBonus:
      pha
      ldx  #15
      ldy  #12
      jsr  SET_COOR
      lda  #<Sbonus
      ldy  #>Sbonus
      jsr  STRING                 ; put the name of the game
      pla

      tax
loopBonus:
      stx  temp3
      lda  #$20
      jsr  addScore               ; add the score
      jsr  testScore              ; test if this is the high score
      jsr  writeScore
      jsr  waitIRQ
      ldx  temp3
      dex
      bne  loopBonus

      rts

Sbonus:
  .byte 5,"BONUS:  TIME*20",0


;=================================
; Write the score
;=================================
writeScore:
      lda  lifes
      ora  #$30
      sta  $400+40+22

      lda  level
      clc
      adc  #49                    ; add '1'
      sta  $400+40+29

      lda  time                   ; write the time
      jsr  atoax
      stx  $400+40+35
      sta  $400+40+36

      ldx  #0
      jsr  writePoints
      ldx  #3
      jmp  writePoints

      ;rts

;=================================
; write score
; x=0/3 0 for score, 3 for highscore
;=================================
writePoints:
      ldy  #0

      lda  #$2A                   ; this is the low address for score ($42A)
      cpx  #3
      bne  skipws

      lda  #$33                   ; this is the high address for hiscore ($433)
skipws:
      sta  wra1+1                 ; change low address as needed
      sta  wra2+1

loopws:
      lda  score,x
      pha
      lsr
      lsr
      lsr
      lsr
      ora  #$30
wra1:
      sta  $400+40+2,y
      iny
      pla
      and  #$0F
      ora  #$30
wra2:
      sta  $400+40+3,y
      inx
      iny
      cpy  #6
      bne  loopws
      rts


;=================================
; add points to score
; A=point to add
;=================================
addScore:
      stx  temp3
      ldx  #2
      ;ldy  #0                     ; clear carry indicator
      sed                         ; decimal mode
      clc
      adc  score,x
      sta  score,x
      bcc  exitscore

      ;iny                         ; carry indicator
      dex
      lda  #0
      adc  score,x
      sta  score,x
      bcc  exitscore

      dex
      lda  #0
      adc  score,x
      sta  score,x
exitscore:
      cld                         ; normal mode

      ;cpy  #0                     ; test carry indicator
      ;beq  skipAS

      ;lda  score+1                ; read middle of score
      ;and  #$3F
      ;cmp  #$40
      ;bne  skipAS                 ; if $40, we have reach another 4000 points

      ;jsr  incLife                ; give another life
skipAS:
      ldx  temp3
      rts


;=================================
; Test if this score must be the
; hiscore
;=================================
testScore:
                                  ; test if we have a new highscore
      lda  score
      cmp  score+3
      bcc  notHS
      bne  setHS

      lda  score+1
      cmp  score+4
      bcc  notHS
      bne  setHS

      lda  score+2
      cmp  score+5
      bcc  notHS
      bne  setHS

notHS:
      rts

setHS:                             ; copy the score to hiscore
      ldx  #3
setHS_:
      lda  score-1,x
      sta  score+2,x
      dex
      bne  setHS_
      beq  notHS

;=================================
; input a=$12 output x= $31 "1" a= $32 "2"
;=================================
atoax:
      pha                      ; save A for lo-nibble fetch
      lsr
      lsr
      lsr
      lsr
      ora  #$30
      tax
      pla                      ;lo-nibble fetch
      and  #$0F
      ora  #$30
      rts


;================================
; Wait for IRQ before going on
;================================
waitIRQ:
      lda  GO
      beq  waitIRQ
      dec  GO
      rts 

;==================================
; play music, set IRQ1, set graphics
; for scroll
;==================================
irqR0: 
      ;ldx  #1
      ;stx  $d019                 ; acknowledge the raster interrupt

      asl  $d019                  ; acknowledge the raster interrupt
      inc  delay

      ldx  #1
      stx  GO     
      ;dex
      ;stx  53280                  ; use black color

      jsr  PLAY_MUSIC              ; playMusic
      jmp  $ea81

;================================
; copy screen  
;================================
copyScreen:
      ldy #0
      ldx #4
lp1_:
      lda $1C00,y
lp1__:
      sta $0400,y
      dey
      bne lp1_
next_:
      inc lp1_+2
      inc lp1_+5
      dex
      ;beq exit_ 
      bne lp1_
exit_: 
      rts

;================================
; Make the screen empty
;===============================
emptyScreen:
      ldy  #0
      ldx  #$F
      lda  #$c0
      sta  lp2_+2

      ;lda #0
      tya
lp2_:
      sta $c000,y
      dey
      bne lp2_

      inc lp2_+2 
      dex
      ;beq exit2_
      bne lp2_

;now clear dynamic map table
      ldy #[bufChar-B_FB]
lp3_  
      sta B_FB,y
      dey
      bne lp3_
      rts


;================================
; Mirror the sprites
;================================
mirrorSprite:
      lda  #<SPRITES
      sta  addr
      lda  #>SPRITES
      sta  addr+1                ; set source sprites address

      lda  #<SP_END
      sta  addr2
      lda  #>SP_END
      sta  addr2+1               ; set destination sprites address

initSpr:
      ldy  #0
      sty  temp3 

loopSpr:
      lda  (addr),y
                                 ; mirror one byte
      ldx  #3
loopMir:
      lsr
      rol  temp3
      lsr
      rol  temp2
      lsr  temp3
      rol  temp2
      dex
      bpl  loopMir

      lda  temp2
      sta  (addr2),y

      ldx  temp3
      cpx  #2
      bne  skipAdj

      ldx  #$ff
      stx  temp3
                                 ; swap the two values
      pha
      dey
      dey  
      lda  (addr2),y
      sta  temp1
      pla
      sta  (addr2),y
      iny
      iny
      lda  temp1
      sta  (addr2),y

skipAdj:
      inc  temp3

      iny
      cpy  #63                   ; all the sprites chars
      bne  loopSpr

      clc                        ; goes to next sprites
      lda  addr
      adc  #64
      sta  addr
      lda  addr+1
      adc  #0
      sta  addr+1

      cmp  #(>SP_END)+1
      beq  exitSI

      clc                        ; goes to next sprites
      lda  addr2
      adc  #64
      sta  addr2
      lda  addr2+1
      adc  #0
      sta  addr2+1

      jmp  initSpr
exitSI:
      rts

;=================================
; Draw sprites according with their
; positions
;=================================
drawSprites:
      lda  #$00
      sta  virtualX               ; virtual register for msx position of sprites
      sta  virtualD               ; virtual register for display of sprites

      ldx  #7

drawNext:
      lda  actType,x
      bne  toShow                 ; show if it is <>0
      jmp  skipFixH

toShow:
      clc                         ; put sprite pointer
      adc  #(SP_START-1)
      sta  2040,x


      lda  virtualD
      ora  bitTable,x
      sta  virtualD               ; this sprite is to show

      lda  xActLo,x               ; fix x position for sprite center
      clc
      adc  #12                    ; 24-12
      sta  temp1

      lda  xActHi,x
      adc  #$00
      and  #$01
      sta  temp2

      lda  yAct,x                 ; fix y position for sprite center
      clc
      adc  #30                    ; 50-20
      sta  temp3

skipFr0:
      txa
      asl                         ; *2
      tay

      lda  temp1
      sta  $d000,y                ; store x sprite position
      lda  temp3
      sta  $d001,y                ; store y sprite position

      lda  temp2
      beq  skipFixH

      lda  virtualX
      ora  bitTable,x
      sta  virtualX               ; store msb of position in virtual register

skipFixH:
      dex
      bmi  finalDraw
      jmp  drawNext

finalDraw:
      lda  virtualX               ; fix msx position of sprite
      sta  $d010
      lda  virtualD               ; show sprites
      sta  $d015

      rts

bitTable:
  .byte  1,2,4,8,16,32,64,128

;================================
; Clear the memory buffers for 
; screen chars and colors
;================================
;clearBuffer:

;      ldx  #$0F
;lup:
;      lda  #0
;      ldy  #0
;lpc:
;      sta  $c000,y
        
;      dey
;      bne lpc

;      inc lpc+2
;      dex
;      bpl lup
;      rts


;================================
; Set pointers to the buffers
; according to X index (rows)
;================================
setPointer:
      lda  lo0Char,x
      sta  CHR0
      lda  hi0Char,x
      sta  CHR0+1

      lda  lo0Color,x
      sta  COL0
      lda  hi0Color,x
      sta  COL0+1

      lda  lo1Char,x
      sta  CHR1
      lda  hi1Char,x
      sta  CHR1+1

      lda  lo1Color,x
      sta  COL1
      lda  hi1Color,x
      sta  COL1+1

      lda  lo2Char,x
      sta  CHR2
      lda  hi2Char,x
      sta  CHR2+1

      lda  lo2Color,x
      sta  COL2
      lda  hi2Color,x
      sta  COL2+1

      lda  loChar,x
      sta  CHR_
      lda  hiChar,x
      sta  CHR_+1

      lda  loColor,x
      sta  COL_
      lda  hiColor,x
      sta  COL_+1
      rts

;=================================
; Merge the 3 screen (chars and
; colors) into the visible one
; priority: 2 1 0
;=================================
mergeScreen:
      ldx  #15
loopMS:
      jsr  setPointer
      ldy  #31
loopMSI:
      lda  (COL2),y
      sta  temp1

      lda  (CHR2),y
      bne  putThis

      lda  (COL1),y
      sta  temp1

      lda  (CHR1),y
      bne  putThis

      lda  (COL0),y
      sta  temp1

      lda  (CHR0),y
putThis:
      sta  (CHR_),y
      lda  temp1
      sta  (COL_),y
 
      dey
      bpl  loopMSI 

      dex
      bpl  loopMS
      rts


;================================
; Insert le buildings of the level
;================================
insertLevel:
      ldx  level                 ; read the level address
      lda  loLevel,x
      sta  temp1
      ;lda  hiLevel,x
      lda  #>level1
      sta  temp2

      ldy  #0
      sty  temp4                 ; position index
      lda  (temp1),y             ; read the numbers of buildings
      sta  tBuild                ; total buildings
      sta  rBuild                ; remain buildings
      sta  temp3
loopBi:
      iny  
      lda  (temp1),y             ; read next building
      sta  temp5

      and  #$0F
      clc
      adc  temp4                 ; position of this building
      sta  temp4
      sta  B_POS-1,y             ; store the position of this building

      lda  temp5
      and  #$70
   ;   sta  B_TYP-1,y             ; store the type of building

      cmp  #$40                  ; test for 2 or 3 windows
      bmi  wi2

      clc 
      adc  #$20
      lsr
      lsr
      sta  B_DEC-1,y               ; number of damage are double of height
      lsr
      sta  B_Y-1,y                 ; store y dimension
      lda  #9
      sta  B_X-1,y                 ; store x dimension
      bne  sFB

wi2:
      clc
      adc  #$40
      lsr
      lsr
      sta  B_DEC-1,y               ; number of damage are double of height
      lsr
      sta  B_Y-1,y                 ; store y dimension

      lda  #8
      sta  B_X-1,y                 ; store x dimension

sFB:
      lda  temp5
      and  #$80
      sta  B_FB-1,y              ; store F/B position

      lda  #$FF                  ; visible indicator
      sta  B_VIS-1,y

      dec  temp3                 ; remain buildings
      bne  loopBi



                                 ; now insert the building into the right map
      ldy  tBuild                ; read number of building
      sty  temp5  
lpW:
      ldy  temp5
      lda  B_FB,y                ; read front/behind
      sta  temp1
      lda  B_POS,y               ; read position
      sta  temp2
      lda  B_X,y                 ; read x dimension
      sta  temp3
      lda  B_Y,y                 ; read y dimension
      tay  
      dey 
      sty  temp4

      ldx  #15                   ; start from low position
lpWR:
      jsr  setPointer            ; set pointer according with x vertical position
      ldy  temp3                 ; read x dimension
      dey 
      sty  temp6
lpCp:
      ldy  temp6                 ; current x dimension
      lda  temp3                 ; read x dimension
      cmp  #$08
      beq  chooseRight           ; choose right row according to current x position
      jmp  choose3Right          ; like a JSR

adjPos:
      tya                        ; adjust position according to start position
      clc
      adc  temp2                 ; start position
      tay

      lda  temp1                 ; read front/behind
      bne  isBehind 

      pla                        ; put in front
      sta  (COL2),y
      pla
      sta  (CHR2),y
      jmp contD

isBehind:
      pla                        ; put behind
      sta  (COL1),y
      pla
      sta  (CHR1),y
contD:
      dec  temp6                 ; current x dimension
      bpl  lpCp
      dex 
      dec  temp4
      bpl  lpWR


      dec  temp5                 ; go to next building
      bpl  lpW
      rts

;=================================
; Choose right peaces to copy
;=================================
chooseRight:
      cpx  #15                   ; is the first low element? (door low)
      beq  doorL
      cpx  #14                   ; is the second low element? (door high)
      beq  doorH
      lda  temp4
      cmp  #1                   ; is the upper low part?
      beq  flowH
      cmp  #0
      beq  flowL                ; is the upper high part?
      lsr                       ; test if odd
      bcc  colHi

      lda  Row2L,y
      pha
      jmp  doorHL

colHi:
      lda  Row2H,y
      pha
      jmp  doorHL

flowH:
      lda  Row2UL,y
      pha
      lda  Col2UL,y
      pha
      jmp  adjPos

flowL:
      lda  Row2UH,y
      pha
      lda  Col2UH,y
      pha
      jmp  adjPos

doorL:
      lda  Row2DL,y
      pha
      jmp  doorHL
 
doorH:
      lda  Row2DH,y
      pha
doorHL:
      lda  Col2,y
      pha
      jmp  adjPos

;=================================
; Choose 3 right peaces to copy
;=================================
choose3Right:
      cpx  #15                   ; is the first low element? (door low)
      beq  doorL3
      cpx  #14                   ; is the second low element? (door high)
      beq  doorH3
      lda  temp4
      cmp  #1                   ; is the upper low part?
      beq  flowH3
      cmp  #0
      beq  flowL3               ; is the upper high part?
      lsr                       ; test if odd
      bcc  colHi3

      lda  Row3L,y
      pha
      jmp  doorHL3

colHi3:
      lda  Row3H,y
      pha
      jmp  doorHL3

flowH3:
      lda  Row3UL,y
      pha
      lda  Col3UL,y
      pha
      jmp  adjPos

flowL3:
      lda  Row3UH,y
      pha
      lda  Col3UH,y
      pha
      jmp  adjPos

doorL3:
      lda  Row3DL,y
      pha
      jmp  doorHL3
 
doorH3:
      lda  Row3DH,y
      pha
doorHL3:
      lda  Col3,y
      pha
      jmp  adjPos

;================================
; Make a building destroy if it 
; is the case
; during the procedure:
; temp1=position of building
; temp2=number of cells (decrement)
; temp3=front/behind
; temp4=number of cells 
; temp6=delay at beginning
;================================
makeDestroy:
      lda delay
      sta temp6

      lda  #0
      sta  anim                  ; suppose no anim
      ldy  tBuild                ; read total buildings
testB:
      lda  B_DEC-1,y
      bne  goNextB
                                 ; the building have to fall down
      lda  B_VIS-1,y
      bmi  activeB

goNextB: 
      dey
      bpl  testB

;;;;;;;;;;;; iAN CooG/HokutoForce
      lda anim
      beq nostate

      jsr exitIE2
      jsr moveDn
nostate
;;;;;;;;;;;; iAN CooG/HokutoForce
      rts

                                 ; activate the fall down
activeB:
      lda  #ANIM_FALL            ; make the kong fall down and stay down until
      sta  animation             ; all the building is down

      inc  anim                  ; animation must start
      ldx  #15
      jsr  setPointer

      lda  B_X-1,y               ; x dimension
      sta  temp2                 ; number of cells (to decrement)
      sta  temp4                 ; number of cells

      lda  B_POS-1,y 
      sta  temp1                 ; position
      ldx  B_FB-1,y              ; read front/behind
      stx  temp3      ;;;;
      tya
      pha                        ; store remaining buildings
      ldy  temp1                 ; position
cyclC:
      lda  #FALL                 ; use fall down character
      cpx  #0                    ; compare front/behind
      bne  prior1

      sta  (CHR2),y
      lda  #1
      sta  (COL2),y
      bne  decLC
prior1:
      sta  (CHR1),y
      lda  #1
      sta  (COL1),y
decLC:
      iny
      dec  temp2                 ; number of cells
      bne  cyclC


; make the fall of the flors
; maybe a delay in call this should be used
      lda  temp6 ;delay
      and  #$0f
      cmp  #$02
      bmi  contSV
      jmp  skipVis

contSV:
      ldx  #13
      
loopAll:
      jsr  setPointer
      ldy  temp1                 ; position
      lda  temp4                 ; number of cell
      sta  temp2                 ; number of cell (to decrement)
loopCy:
      lda  temp3                 ; front/behind
      bne  prior2
                                 ; copy one row to the buffer
      lda  (CHR2),y
      sta  bufChar,y
      lda  (COL2),y
      bpl  contI2
prior2:
      lda  (CHR1),y
      sta  bufChar,y
      lda  (COL1),y
contI2:
      sta  bufCol,y

      iny
      dec  temp2
      bne  loopCy

      inx
      jsr  setPointer
      ldy  temp1                 ; position
      lda  temp4                 ; number of cell
      sta  temp2
loopCy2:
      lda  temp3                 ; front/behind
      bne  prior3

                                 ; copy the buffer to one row
      lda  bufChar,y
      sta  (CHR2),y
      lda  bufCol,y 
      sta  (COL2),y
      bpl  contI3
prior3:
      lda  bufChar,y
      sta  (CHR1),y
      lda  bufCol,y
      sta  (COL1),y
contI3:
      iny
      dec  temp2                 ; number of cells
      bne  loopCy2
      dex
      dex
      bpl  loopAll
      inx

      jsr  setPointer
      ldy  temp1                 ; position
      lda  temp4                 ; number of cell
      sta  temp2                 ; number of cell (to decrement)
loopCy3:
      lda  temp3                 ; front/behind
      bne  prior4
                                 ; fill the high row
      lda  #0
      sta  (CHR2),y
      ;lda  #6
      ;sta  (COL2),y
      bpl  contI4
prior4:
      lda  #0
      sta  (CHR1),y
      ;lda  #6
      ;sta  (COL1),y
contI4:
      iny
      dec  temp2
      bne  loopCy3

contNext:
      pla
      tax                        ; retrieve remaining buildings
      pha

      dec  B_Y-1,x               ; one flor is fall down
      bne  skipVis

      lda  #0
      sta  B_VIS-1,x             ; now it is not visible anymore
                                 ; put green onto last row
      ldx  #15
      jsr  setPointer
      ldy  temp1                 ; position
cyclCG:
      lda  #0                    ; use not fall character
      ldx  temp3                 ; compare front/behind
      bne  prior1G

      sta  (CHR2),y
      ;lda  #5
      ;sta  (COL2),y
      beq  decLCG
prior1G:
      sta  (CHR1),y
      ;lda  #5
      ;sta  (COL1),y
decLCG:
      iny
      dec  temp4                 ; number of cells
      bne  cyclCG

      dec  rBuild                ; decrement remaining buildings
      bne  skipVis               ; test for passed screen 

      lda  #PASSED
      sta  status                 ; screen is passed

skipVis:
      pla 
      tay
      jmp  goNextB

;================================
; Animate the screen
;================================
animScreen:
      lda  timeDl
      and  #$03
      cmp  #$03
      bne  skipASC

      lda  anim
      beq  normalScreen

      jsr  random                ; put a random number as x-scroll
      and  #$01
      ora  #$18
      sta  $d016
skipASC:
      rts

normalScreen:
      lda  #$18
      sta  $d016
      rts

;=================================
; Get the char at kong position
; according with his state
;=================================
getChar:
      jsr  setCoor                ; set coord
      stx  temp5
      sty  temp6

      jsr  SET_COOR;GOTOXY                 ; $D1-2=pointer of char at x/y position

      ;lda  #4
      ;sta  ($F3),y

      lda  ($D1),y                ; get the char and return it
      rts

;=================================
; Get the char at kong position +1
; according with his state
;=================================
getCharP1:
      jsr  setCoor                ; set coord
      iny

      jsr  SET_COOR;GOTOXY                 ; $D1-2=pointer of char at x/y position

      ;lda  #4
      ;sta  ($F3),y

      lda  ($D1),y                ; get the char and return it
      rts

;=================================
; Get the char at kong position +2
; according with his state
;=================================
getCharP2:
      jsr  setCoor                ; set coord
      iny
      iny
      stx  temp5
      sty  temp6

      jsr  SET_COOR;GOTOXY                 ; $D1-2=pointer of char at x/y position

      ;lda  #4
      ;sta  ($F3),y

      lda  ($D1),y                ; get the char and return it
      rts

;=================================
; Get the char at kong position -1
; according with his state
;=================================
getCharM1:
      jsr  setCoor                ; set coord
      dey

      jsr  SET_COOR;GOTOXY                 ; $D1-2=pointer of char at x/y position

      ;lda  #4
      ;sta  ($F3),y

      lda  ($D1),y                ; get the char and return it
      rts

;=================================
; Get the char at kong position -2
; according with his state
;=================================
getCharM2:
      jsr  setCoor                ; set coord
      dey
      dey
      stx  temp5
      sty  temp6

      jsr  SET_COOR;GOTOXY                 ; $D1-2=pointer of char at x/y position

      ;lda  #4
      ;sta  ($F3),y

      lda  ($D1),y                ; get the char and return it
      rts

;=================================
; Set coord according to position
;=================================
setCoor:
      lda  xActHi+1
      lsr
      lda  xActLo+1
      ror
      lsr
      lsr
      tay    

      dey
      dey 
                     ; put in column

      lda  state
      bmi  skipSD

      iny
      iny
      iny
      iny

skipSD:
      

      lda  yAct+1
      lsr
      lsr
      lsr
      tax                         ; put in row
exitIDM:
      rts

;=================================
; Test if damage 
; temp1: position in map
; temp2: actual puliding y index
; temp3: front behind
; temp4: char collided
; temp5: global x position
; temp6: global y position
;=================================
isDamage:
      lda  temp4
      cmp  #76
      bmi  exitIDM
      cmp  #80
      bpl  exitIDM
                                 ; scan all the building
      ;jsr  setCoor               ; y=column x=row
      ;stx  temp5
      ;sty  temp6

      ldy  #0                    ; start from initial builiding
contNextD:
      sty  temp2                 ; position index

      lda  B_VIS,y
      beq  incNextD              ; look only for visible buiding

      lda  B_FB,y                ; read front/behind
      sta  temp3                 ; front/behind

;;
      lda  B_POS,y               ; position in map
      sta  temp1
      clc
      adc  B_X,y                 ; x dimension of map
      sta  temp7
;;

                                 ; translate global x/y to local map x/y
      lda  temp5
      sec
      sbc  #7
      tax

      lda  temp6
      sec
      sbc  #4  
      tay 

      jsr  setPointer            ; set pointers according to x (rows)

                                 ; test if this is the right palace to look for damage
                                 ; by testing POS and POS+X
;; 
      cpy  temp1
      bmi  incNextD
      cpy  temp7
      bpl  incNextD
;;
      lda  temp3                 ; front/behind
      bne  priorA

                                 ; see if the char is the right pulled
      lda  (CHR2),y
      cmp  temp4
      bne  incNextD
      clc
      adc  #9
      sta  (CHR2),y              ; put damaged char  
      bne  pulled
priorA:
      lda  (CHR1),y
      cmp  temp4
      bne  incNextD
      clc
      adc  #9
      sta  (CHR1),y              ; put damaged char  
      bne  pulled

incNextD
      ldy  temp2
      iny
      cpy  tBuild                ; total buildings
      bne  contNextD

      rts 

pulled:
      ldx  temp2                 ; decrement as now it is damaged
      dec  B_DEC,x

      lda  #$40
      jsr  addScore               ; add the score
      rts

; levels definition

loLevel:
  .byte #<level1
  .byte #<level2
  .byte #<level3
  .byte #<level4
  .byte #<level5
  .byte #<level6
  .byte #<level7
  .byte #<level8

;hiLevel:
;  .byte #>level1
;  .byte #>level2
;  .byte #>level3
;  .byte #>level4
;  .byte #>level5
;  .byte #>level6
;  .byte #>level7
;  .byte #>level8

level1:
  .byte 3
  .byte POS_BEH + B5x3 + $01
  .byte POS_FRO + B3x2 + $05
  .byte POS_FRO + B5x2 + $0F

level2:
  .byte 3
  .byte POS_FRO + B6x2 + $02
  .byte POS_BEH + B7x3 + $0F
  .byte POS_FRO + B3x2 + $03

level3:
  .byte 4
  .byte POS_BEH + B5x3 + $03
  .byte POS_FRO + B4x2 + $04
  .byte POS_BEH + B6x3 + $0d
  .byte POS_FRO + B3x2 + $04

level4:
  .byte 4
  .byte POS_FRO + B7x3 + $00
  .byte POS_BEH + B3x2 + $04
  .byte POS_BEH + B3x2 + $0b
  .byte POS_FRO + B5x2 + $04

level5:
  .byte 5
  .byte POS_BEH + B3x2 + $00
  .byte POS_FRO + B4x2 + $04
  .byte POS_FRO + B7x3 + $09
  .byte POS_BEH + B4x2 + $05
  .byte POS_FRO + B3x2 + $06

level6:
  .byte 5
  .byte POS_BEH + B6x2 + $00
  .byte POS_FRO + B3x2 + $05
  .byte POS_BEH + B6x2 + $06
  .byte POS_FRO + B3x2 + $05
  .byte POS_BEH + B6x2 + $06

level7:
  .byte 5
  .byte POS_BEH + B7x3 + $00
  .byte POS_FRO + B6x2 + $06
  .byte POS_BEH + B5x2 + $06
  .byte POS_FRO + B4x2 + $05
  .byte POS_BEH + B3x2 + $06

level8:
  .byte 5
  .byte POS_FRO + B7x3 + $00
  .byte POS_BEH + B6x2 + $01
  .byte POS_FRO + B7x3 + $0a
  .byte POS_FRO + B7x3 + $0b
  .byte POS_BEH + B6x2 + $01

;2 windows chars definitions
; the head of the building
Row2UH: .byte 82, 83, 83, 83, 83, 83, 83, 84
Row2UL: .byte 76, 92, 92, 92, 92, 92, 92, 79

; one float with only windows
Row2H: .byte 76, 79, 77, 92, 79, 77, 92, 79
Row2L: .byte 76, 81, 80, 92, 81, 80, 92, 79

; one row with a door at the left
Row2DH: .byte 76, 79, 78, 92, 79, 77, 92, 79
Row2DL: .byte 76, 79, 93, 92, 81, 80, 92, 79


;3 windows chars definitions
; the head of the building
Row3UH: .byte 82, 83, 83, 83, 83, 83, 83, 83, 84
Row3UL: .byte 76, 92, 92, 92, 92, 92, 92, 92, 79

; one float with only windows
Row3H: .byte 76, 79, 77, 79, 77, 79, 77, 92, 79
Row3L: .byte 76, 81, 80, 81, 80, 81, 80, 92, 79

; one row with a door at the left
Row3DH: .byte 76, 79, 77, 79, 78, 79, 77, 92, 79
Row3DL: .byte 76, 81, 80, 79, 93, 81, 80, 92, 79



; color information
Col2:  .byte  8,  8,  9,  8,  8,  9,  8,  8 

Col2UH: .byte  9,  9,  9,  9,  9,  9,  9,  9
Col2UL: .byte  8,  8,  8,  8,  8,  8,  8,  8


; color information
Col3:  .byte  8,  8,  9,  8,  9,  8,  9,  8,  8 

Col3UH: .byte  9,  9,  9,  9,  9,  9,  9,  9, 9
Col3UL: .byte  8,  8,  8,  8,  8,  8,  8,  8, 8


; coordinate of memory screen steps
loChar:
loColor:
lo0Char:
lo0Color:
lo1Char:
lo1Color:
lo2Char:
lo2Color:
  .byte #<($0400+7*40+4+0),   #<($0400+7*40+4+40),  #<($0400+7*40+4+80)
  .byte #<($0400+7*40+4+120), #<($0400+7*40+4+160), #<($0400+7*40+4+200)
  .byte #<($0400+7*40+4+240), #<($0400+7*40+4+280), #<($0400+7*40+4+320)
  .byte #<($0400+7*40+4+360), #<($0400+7*40+4+400), #<($0400+7*40+4+440)
  .byte #<($0400+7*40+4+480), #<($0400+7*40+4+520), #<($0400+7*40+4+560)
  .byte #<($0400+7*40+4+600)

hiChar:
  .byte #>($0400+7*40+4+0),   #>($0400+7*40+4+40),  #>($0400+7*40+4+80)
  .byte #>($0400+7*40+4+120), #>($0400+7*40+4+160), #>($0400+7*40+4+200)
  .byte #>($0400+7*40+4+240), #>($0400+7*40+4+280), #>($0400+7*40+4+320)
  .byte #>($0400+7*40+4+360), #>($0400+7*40+4+400), #>($0400+7*40+4+440)
  .byte #>($0400+7*40+4+480), #>($0400+7*40+4+520), #>($0400+7*40+4+560)
  .byte #>($0400+7*40+4+600)

hi0Char:
  .byte #>($1C00+7*40+4+0),   #>($1C00+7*40+4+40),  #>($1C00+7*40+4+80)
  .byte #>($1C00+7*40+4+120), #>($1C00+7*40+4+160), #>($1C00+7*40+4+200)
  .byte #>($1C00+7*40+4+240), #>($1C00+7*40+4+280), #>($1C00+7*40+4+320)
  .byte #>($1C00+7*40+4+360), #>($1C00+7*40+4+400), #>($1C00+7*40+4+440)
  .byte #>($1C00+7*40+4+480), #>($1C00+7*40+4+520), #>($1C00+7*40+4+560)
  .byte #>($1C00+7*40+4+600)

hi0Color:
  .byte #>($2800+7*40+4+0),   #>($2800+7*40+4+40),  #>($2800+7*40+4+80)
  .byte #>($2800+7*40+4+120), #>($2800+7*40+4+160), #>($2800+7*40+4+200)
  .byte #>($2800+7*40+4+240), #>($2800+7*40+4+280), #>($2800+7*40+4+320)
  .byte #>($2800+7*40+4+360), #>($2800+7*40+4+400), #>($2800+7*40+4+440)
  .byte #>($2800+7*40+4+480), #>($2800+7*40+4+520), #>($2800+7*40+4+560)
  .byte #>($2800+7*40+4+600)

hi1Char:
  .byte #>($C000+7*40+4+0),   #>($C000+7*40+4+40),  #>($C000+7*40+4+80)
  .byte #>($C000+7*40+4+120), #>($C000+7*40+4+160), #>($C000+7*40+4+200)
  .byte #>($C000+7*40+4+240), #>($C000+7*40+4+280), #>($C000+7*40+4+320)
  .byte #>($C000+7*40+4+360), #>($C000+7*40+4+400), #>($C000+7*40+4+440)
  .byte #>($C000+7*40+4+480), #>($C000+7*40+4+520), #>($C000+7*40+4+560)
  .byte #>($C000+7*40+4+600)

hi2Char:
  .byte #>($C400+7*40+4+0),   #>($C400+7*40+4+40),  #>($C400+7*40+4+80)
  .byte #>($C400+7*40+4+120), #>($C400+7*40+4+160), #>($C400+7*40+4+200)
  .byte #>($C400+7*40+4+240), #>($C400+7*40+4+280), #>($C400+7*40+4+320)
  .byte #>($C400+7*40+4+360), #>($C400+7*40+4+400), #>($C400+7*40+4+440)
  .byte #>($C400+7*40+4+480), #>($C400+7*40+4+520), #>($C400+7*40+4+560)
  .byte #>($C400+7*40+4+600)

hi1Color:
  .byte #>($C800+7*40+4+0),   #>($C800+7*40+4+40),  #>($C800+7*40+4+80)
  .byte #>($C800+7*40+4+120), #>($C800+7*40+4+160), #>($C800+7*40+4+200)
  .byte #>($C800+7*40+4+240), #>($C800+7*40+4+280), #>($C800+7*40+4+320)
  .byte #>($C800+7*40+4+360), #>($C800+7*40+4+400), #>($C800+7*40+4+440)
  .byte #>($C800+7*40+4+480), #>($C800+7*40+4+520), #>($C800+7*40+4+560)
  .byte #>($C800+7*40+4+600)

hi2Color:
  .byte #>($CC00+7*40+4+0),   #>($CC00+7*40+4+40),  #>($CC00+7*40+4+80)
  .byte #>($CC00+7*40+4+120), #>($CC00+7*40+4+160), #>($CC00+7*40+4+200)
  .byte #>($CC00+7*40+4+240), #>($CC00+7*40+4+280), #>($CC00+7*40+4+320)
  .byte #>($CC00+7*40+4+360), #>($CC00+7*40+4+400), #>($CC00+7*40+4+440)
  .byte #>($CC00+7*40+4+480), #>($CC00+7*40+4+520), #>($CC00+7*40+4+560)
  .byte #>($CC00+7*40+4+600)

hiColor:
  .byte #>($D800+7*40+4+0),   #>($D800+7*40+4+40),  #>($D800+7*40+4+80)
  .byte #>($D800+7*40+4+120), #>($D800+7*40+4+160), #>($D800+7*40+4+200)
  .byte #>($D800+7*40+4+240), #>($D800+7*40+4+280), #>($D800+7*40+4+320)
  .byte #>($D800+7*40+4+360), #>($D800+7*40+4+400), #>($D800+7*40+4+440)
  .byte #>($D800+7*40+4+480), #>($D800+7*40+4+520), #>($D800+7*40+4+560)
  .byte #>($D800+7*40+4+600)


; dinamic map level (max 5 buildings) (last byte is for preventing a bug when 5 buildings)
B_FB:  .byte $00, $00, $00, $00, $00,0         ; front/behind
B_POS: .byte $00, $00, $00, $00, $00,0         ; position
B_DEC: .byte $00, $00, $00, $00, $00,0         ; remain to decrement
B_X:   .byte $00, $00, $00, $00, $00,0         ; x dimension
B_Y:   .byte $00, $00, $00, $00, $00,0         ; y dimension
B_VIS: .byte $00, $00, $00, $00, $00,0         ; visible <>0; if DEC=0, <0 is to fall, >0 fall

bufChar:
  .byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
bufCol:
  .byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


  org $1C00
 
  incbin "screen.bin" 


  .org $2000 
 
SPRITES:

SP_START = $80

SP_UP1 = $80
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 5, 128, 0, 54, 224, 0, 59, 112
  .byte 12, 250, 232, 63, 238, 168, 251, 170, 116
  .byte 246, 234, 85, 218, 171, 213, 234, 169, 181
  .byte 230, 186, 109, 218, 185, 86, 234, 186, 88
  .byte 218, 189, 112, 218, 191, 240, 246, 191, 192, 0

SP_DN1 = $81
  .byte 246, 191, 192, 58, 111, 212, 54, 153, 89
  .byte 58, 170, 102, 250, 170, 89, 255, 171, 102
  .byte 235, 255, 89, 234, 154, 212, 234, 166, 192
  .byte 234, 169, 192, 250, 170, 192, 52, 170, 192
  .byte 14, 122, 192, 3, 234, 192, 14, 234, 192
  .byte 58, 235, 0, 250, 235, 0, 218, 219, 0
  .byte 215, 103, 192, 55, 101, 192, 12, 213, 192, 0

SP_DN2 = $82
  .byte 246, 191, 192, 58, 111, 212, 54, 153, 89
  .byte 58, 170, 102, 250, 170, 89, 255, 171, 102
  .byte 235, 255, 89, 234, 111, 212, 234, 155, 192
  .byte 234, 171, 128, 250, 167, 128, 58, 171, 128
  .byte 14, 107, 128, 3, 235, 128, 0, 235, 192
  .byte 3, 235, 0, 10, 175, 0, 55, 189, 64
  .byte 53, 93, 80, 53, 93, 112, 13, 115, 192, 0

SP_CL1 = $83
  .byte 246, 191, 192, 58, 111, 212, 54, 153, 89
  .byte 58, 170, 102, 250, 170, 89, 255, 171, 102
  .byte 235, 255, 89, 234, 154, 212, 234, 166, 192
  .byte 234, 169, 195, 250, 170, 205, 58, 170, 245
  .byte 14, 170, 183, 3, 250, 151, 0, 14, 148
  .byte 0, 3, 92, 0, 0, 240, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

SP_CL2 = $84
  .byte 250, 106, 191, 54, 154, 170, 58, 169, 154
  .byte 63, 170, 127, 250, 255, 240, 250, 170, 192
  .byte 234, 106, 192, 234, 154, 192, 234, 166, 192
  .byte 234, 169, 195, 250, 170, 205, 58, 170, 245
  .byte 14, 170, 183, 3, 250, 151, 0, 14, 148
  .byte 0, 3, 92, 0, 0, 240, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

SP_HN1 = $85
  .byte 5, 0, 0, 214, 64, 0, 153, 128, 0
  .byte 150, 64, 0, 153, 128, 0, 124, 64, 0
  .byte 5, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

SP_HN2 = $86
  .byte 9, 0, 0, 213, 106, 128, 154, 149, 64
  .byte 149, 106, 0, 154, 148, 0, 231, 80, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

SP_FIRE = $87
  .byte 0, 0, 0, 32, 0, 0, 168, 0, 0
  .byte 168, 0, 0, 32, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0
  .byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
SP_END: 



  .org $2800
  .incbin color.bin


xActLo:                           ; lo x position of sprites (actors)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

xActHi:                           ; hi x position of sprites (actors)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

yAct:                             ; y position of sprites (actors)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

actType:                          ; actor type (0=not to show)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

xActSpeed:                        ; speed of the actor (>0=DX)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

yActSpeed:                        ; speed of the actor in y direction
  .byte $00, $00, $00, $00, $00, $00, $00, $00


score:                            ; actual score
  .byte $00, $00, $00

hiScore:                          ; high score
  .byte $00, $00, $00

 org $2d06

 incbin 2.bin

   org $3a00 ; redefined chars are already in place!
char:
CH_SPACE = 32; null char: use the C= one to save some bytes

 incbin chars.bin

 