.MEMORYMAP                              ; vic 20 memory config for wla6510
DEFAULTSLOT 0
SLOTSIZE $ffff
SLOT 0 $0000
.ENDME

.ROMBANKMAP
BANKSTOTAL 1
BANKSIZE $ffff
BANKS 1
.ENDRO

.BANK 0

;****************************************************************************
;*****
;*****  
;*****  1K WHACK (1024 bytes)
;*****  
;*****  Rogue-like Dungeon Exploring Game for Unexpanded VIC 20
;*****
;*****  (c)2003 Aleksi Eeben (http://www.cncd.fi/aeeben)
;*****  
;*****
;*****  Written for the 2003 MiniGame Competition
;*****
;*****
;****************************************************************************


;-----  zeropage variables

.DEFINE addx            $00             ; any xy-movement
.DEFINE addy            $01

.DEFINE caves           $02             ; dungeon level generator
.DEFINE caverun         $03
.DEFINE rooms           $04
.DEFINE roomsize        $05
.DEFINE doors           $06

.DEFINE verd            $07             ; vertical door check
.DEFINE hord            $08             ; horizontal door check

.DEFINE stairupx        $09
.DEFINE stairupy        $0a

.DEFINE stairdownx      $0b
.DEFINE stairdowny      $0c

.DEFINE manx            $0d
.DEFINE many            $0e

.DEFINE underman        $0f

.DEFINE gamevar         $10

.DEFINE HITPOINTS       $10             ; game variables
.DEFINE GOLD            $11
.DEFINE GOLD100         $12
.DEFINE LEVEL           $13
.DEFINE AMULET          $14

.DEFINE viewxy          $15             ; line-of-sight temporary
.DEFINE flip            $16
.DEFINE monx            $17
.DEFINE mony            $18
.DEFINE monster         $19

.DEFINE tmp             $1a

.DEFINE scr             $1b             ; screen line pointer
.DEFINE scrh            $1c
.DEFINE color           $1d             ; color memory pointer
.DEFINE colorh          $1e

.DEFINE seed1           $1f             ; pseudo-random number generator
.DEFINE seed2           $20
.DEFINE prevr           $21


;-----  tables

.DEFINE colortab        $9400           ; colorization table in color ram
.DEFINE levels          $1d00           ; dungeon level pseudo-random seeds


;-----  game constants

.DEFINE LASTLEVEL       $30             ; last dungeon level (BCD)
.DEFINE HEAL            $03             ; healing effect of a potion (BCD)
.DEFINE MAXGOLD         $17             ; max gold in one pile (and-mask)

.DEFINE BATGOBAC        $c0             ; higher value = harder to kill
.DEFINE DRAGONAC        $e0

.DEFINE CAVERUN         $07             ; max. cave run length (and-mask)

.DEFINE DOORS           $20             ; number of doors to try
;.DEFINE CAVES           $40            ; number of caves = 2x doors
.DEFINE ROOMS           $05             ; number of rooms

.DEFINE floorchr        46
.DEFINE wallchr         102
.DEFINE doorchr         43
.DEFINE amuletchr       38
.DEFINE downchr         62
.DEFINE upchr           60
.DEFINE batchr          2
.DEFINE goblinchr       71
.DEFINE dragonchr       68


;-----  cbm binary load address

.ORG $0
.SECTION "BANKHEADER"
        .dw     $1001
.ENDS


.ORG $1001
.SECTION "main" FORCE

;-----  basic line: "1 sys4107"

        .DB     $0b,$10,$01,$00,$9e,$34,$31,$30,$37,$00


;-----  entry, initialization

entry:
        ldy     #$00
        tya
_clrlp
        sta     levels,y                ; set all levels to non-visited
        iny
        bne     _clrlp

        lda     #topline&255            ; "Hp:12 Gold:0000 L:"
        ldy     #topline>>8             ; topline located at 12xx
        sty     HITPOINTS
        jsr     $cb1e

        ldx     #$0b
_inilp
        ldy.w   objchar,x               ; build object colorization table
        lda.w   objcolor,x
        sta     colortab,y
        lda.w   vicinit,x
        sta     $900f,x                 ; init vic
        lda     #$00                    
        sta     gamevar+1,x             ; init game variables
        dex
        bpl     _inilp

        lda     $a2                     ; init random seed from jiffy clock
        sta     seed1

        jsr     stairdown               ; generate first level


;-----  main game loop

MAINLOOP:
        lda     HITPOINTS               ; "Hp:10 Gold:0000 L:01"
        ldx     #$03
        jsr     writebcd
        lda     GOLD
        ldx     #$0d
        jsr     writebcd
        lda     GOLD100
        dex
        jsr     writebcd
        lda     LEVEL
        ldx     #$12
        jsr     writebcd


;-      draw man

        jsr     locateman

        lda     #$0b
        jsr     drawchar


;-      move monsters

        inc     flip                    ; chessboard check
        lda     flip
        and     #$01

        ldx     #$17                    ; screen lines

_monylp
        tay
_monxlp
        jsr     locate

        stx     mony
        sty     monx

        sta     monster

        cmp     #dragonchr
        beq     _mon
        cmp     #goblinchr
        beq     _mon
        cmp     #batchr
        bne     _nomon

        jsr     randomdir               ; bats move in random
        bcc     _movemon                ; always branch

_mon
        lda     seed1
        bmi     _monv
_monh
        cpy     manx
        beq     _monv
        bcc     _monn3
        lda     #$03
        .DB     $0c                     ; nop $0000, skips 2 bytes
        ;
_monn3
        lda     #$01
        bne     _monok
_monv
        cpx     many
        beq     _monh
        bcc     _monn2
        lda     #$02
        .DB     $0c                     ; nop $0000, skips 2 bytes
        ;
_monn2
        lda     #$00
_monok
        jsr     setdir

_movemon
        lda     #floorchr               ; wipe monster character
        jsr     drawshaded

        jsr     movedir
        bne     _noattack               ; check monster attack (man = char 0)

        lda     HITPOINTS
        sed
        sec
        sbc     #$01
        sta     HITPOINTS
        cld
        bne     _monblocked

        lda     #$02                    ; you die
        sta     (color),y
newgame:
        jsr     $ffe4                   ; getin
        cmp     #13
        bne     newgame
        jmp     entry

_noattack
        cmp     #floorchr               ; only walk on floor
        beq     _monmoved

_monblocked                             ; blocked, restore coordinates
        ldx     mony
        ldy     monx
        jsr     locate
_monmoved
        lda     monster
        jsr     drawshaded

        ldx     mony
        ldy     monx
_nomon
        iny
        iny
        cpy     #$14
        bcc     _monxlp

        iny                             ; next line of chessboard
        tya
        and     #$01
        
        dex
        bne     _monylp


;-      draw man view

        jsr     manview


;-      spawn monsters

        jsr     random                  ; try to create a monster
        bmi     _nospawn                ; not every frame

        and     #$01                    ; random monster type
        ora     #$08
        tay

        lda     AMULET                  ; dragons if carrying amulet
        bne     _dragons

        lda     LEVEL                   ; no dragons if above level 20
        cmp     #$20                    ; and not carrying amulet
        bcc     _nodragons
_dragons
        iny
_nodragons
        lda.w   objchar,y
        pha

        jsr     randomxy                ; find floor

        lda     (color),y               ; only spawn in non-visible area
        and     #$07
        bne     _nospawn

        pla
        sta     (scr),y
_nospawn


;-      player actions

waitkey:
        jsr     $ffe4                   ; getin

        ldx     #$04
_findkey
        cmp.w   keylist,x
        beq     _keyfound
        dex
        bpl     _findkey
        bmi     waitkey

_keyfound
        jsr     setdirx
        jsr     locateman

        lda     underman
        sta     (scr),y

        jsr     movedir
        stx     tmp
        
        ldx     #objcolor-objchar
_findobj
        dex
        lda.w   objchar,x
        cmp     (scr),y
        bne     _findobj

_objfound
        lda.w   actionlist,x
        sta.w   doact_+1

        ldx     tmp
        jsr     random                  ; many actions use random value
doact_
        jsr     walk
        jmp     MAINLOOP


;-----  write bcd number

writebcd:
        pha
        jsr     _bcdone

        dex

        pla
        lsr
        lsr
        lsr
        lsr
_bcdone
        and     #$0f
        ora     #$30
        sta     $1e01,x

        rts


;-----  move to level (a = $99 up, $01 down)

movetolevel:
        sed
        clc
        adc     LEVEL
        sta     LEVEL
        cld
        ;
        ;
;-----  generate dungeon level

generatelevel:
        tay

        lda     levels,y                ; check if dungeon level visited
        bne     _oldlevel
_re
        jsr     random                  ; new level, new random seed
        beq     _re
        sta     levels,y
        lda     seed1
        sta     levels+$80,y

_oldlevel
        lda     levels,y                ; init pseudo-random generator
        sta     seed1
        lda     levels+$80,y
        sta     seed2
        sty     prevr                   ; use level number as previous random


;-      fill map area with black wall character

        ldy     #$00
_imaplp
        lda     #$00
        sta     $9614,y
        sta     $9700,y
        lda     #wallchr
        sta     $1e14,y
        sta     $1f00,y
        iny
        bne     _imaplp


;-      draw caves

        ldx     #$0d                    ; start at middle of screen
        ldy     #$09

        lda     #ROOMS                  ; number of rooms
        sta     rooms

        lda     #DOORS
        sta     doors                   ; number of door places to try
        asl
        sta     caves                   ; number of cave turns


_nextcave
        jsr     randomdir               ; random cave direction

        and     #CAVERUN                ; random cave run length
        sta     caverun


_cavestep
        jsr     movedir                 ; draw one step of cave

        lda     #floorchr
        sta     (scr),y

        dec     caverun
        bpl     _cavestep

        dec     caves
        bne     _nextcave


;-      draw rooms

_nextroom
        lda     #$05
        sta     roomsize

        jsr     randomxy

        dex
        dex

        dey

_drawroom
        jsr     locate

        lda     #floorchr
        sta     (scr),y
        iny
        sta     (scr),y
        iny
        sta     (scr),y
        dey
        dey
        inx

        dec     roomsize
        bne     _drawroom

        dec     rooms
        bne     _nextroom


;-      draw some doors

_nextdoor
        lda     #$00
        sta     verd
        sta     hord

        jsr     randomxy

        dey                             ; check surrounding blocks
        lda     (scr),y
        jsr     hordcheck

        iny
        iny
        lda     (scr),y
        jsr     hordcheck

        dey
        dex
        jsr     verdcheck

        inx
        inx
        jsr     verdcheck


        lda     verd                    ; if both same then no door
        cmp     hord
        beq     _nodoor

        clc                             ; if sum not 2 then no door
        adc     hord
        cmp     #$02
        bne     _nodoor

        dex                             ; draw door
        jsr     locate
        lda     #doorchr
        sta     (scr),y

_nodoor
        dec     doors
        bne     _nextdoor


;-      draw staircases and the amulet on last level

        jsr     randomxy                ; staircase down or amulet
        sty     stairdownx
        stx     stairdowny

        lda     #downchr                

        ldx     LEVEL                   ; amulet on last level
        cpx     #LASTLEVEL
        bne     _noamulet

        lda     AMULET                  ; but only once
        bne     _nodown

        lda     #amuletchr
_noamulet
        sta     (scr),y
_nodown

        jsr     randomxy                ; staircase up
        lda     #upchr
        sta     (scr),y
        sty     stairupx
        stx     stairupy


;-      dungeon level done

;        rts                             ; code below does no harm


;-      doorway check

hordcheck:
        lda     (scr),y
        cmp     #doorchr
        beq     _baddoor
        cmp     #floorchr
        bne     _nohd
        inc     hord
_nohd
        rts

verdcheck:
        jsr     locate
        cmp     #doorchr
        beq     _baddoor
        cmp     #floorchr
        bne     _novd
        inc     verd
_novd
        rts

_baddoor:
        sta     verd                    ; no multiple doors
        rts


;-----  top line

topline:
        .DB     5,147,8,"hP:12 gOLD:0000 l:"    ; (,0)


;-----  direction table (0 = down; 1 = right; 2 = up; 3 = left)

dirx:
        .DB     $00                             ; (,$01,$00,$ff)
diry:
        .DB     $01,$00,$ff,$00,$00


;-----  random direction

randomdir:
        jsr     random
        and     #$03
        ;
        ;
;-----  set direction of (any) movement (a = direction 0-3)

setdir:
        stx     tmp
        tax
setdirx:
        lda.w   dirx,x
        sta     addx
        lda.w   diry,x
        sta     addy

        ldx     tmp
        ;
        ;
;-----  generate pseudo-random number, always clear carry (for add)

random:
        inc     seed2
        lda     seed2
        clc
        adc     seed1
        adc     seed2
        sta     seed1
        eor     seed2
        sta     seed2
        sbc     prevr
        sta     prevr

        clc
        rts


;-----  step y,x in current direction within screen boundaries

movedir:
        txa                             ; y-movement
        clc
        adc     addy
        tax

        cpx     #$01                    ; y-boundaries
        bne     _noty01
        inx
_noty01
        cpx     #$18
        bne     _noty18
        dex
_noty18

        tya                             ; x-movement
        clc
        adc     addx
        tay

        bne     _notx00                 ; x-boundaries
        iny
_notx00

        cpy     #$13
        bne     _notx13
        dey
_notx13
        jmp     locate                  ; always branch


;-----  random coordinates, find floor

randomxy:
        jsr     random                  ; y = x-coordinate, $02-$11
        and     #$0f
        adc     #$02
        tay

        jsr     random                  ; x = y-coordinate, $05-$14
        and     #$0f
        adc     #$05
        tax

        jsr     locate
        cmp     #floorchr
        bne     randomxy

        rts


;-----  locate man

locateman:
        ldy     manx
        ldx     many
        ;
        ;
;-----  locate screen line

locate:
        txa                             ; x * 4
        asl
        asl
        pha

        asl                             ; x * 16
        asl
        sta     scr

        lda     #$1e
        adc     #$00
        sta     scrh

        clc
        pla
        adc     scr
        sta     scr
        sta     color

        bcc     _nosc
        inc     scrh                    ; scr = $1e00 + x * 16 + x * 4

_nosc
        lda     scrh
        eor     #$88
        sta     colorh

        lda     (scr),y
        rts


;-----  line-of-sight view

manview:
        lda     #$01                    ; segment 1
        sta     addx
        lda     #$ff
        sta     addy
        jsr     viewsegment

        lda     #$01                    ; segment 2
        sta     addy
        jsr     viewsegment

        lda     #$ff                    ; segment 3
        sta     addx
        jsr     viewsegment

        lda     #$ff                    ; segment 4
        sta     addy
        ;
        ;
viewsegment:
        ldy     manx
        sty     viewxy
_segxlp

        ldx     many
        jsr     seeblock
        bcs     _segxok

        jsr     drawline

        lda     viewxy
        clc
        adc     addx
        sta     viewxy
        tay

        bpl     _segxlp                 ; always branch
_segxok

        lda     many
        sta     viewxy
_segylp
        lda     viewxy
        clc
        adc     addy
        sta     viewxy
        tax

        ldy     manx
        jsr     seeblock
        bcs     _rts

        jsr     drawline
        bcs     _segylp                 ; always branch


;-      draw one line-of-sight

drawline:
        txa
        clc
        adc     addy
        tax

        tya
        clc
        adc     addx
        tay

        jsr     seeblock
        bcc     drawline

;        rts                             ; code below does no harm


;-      see one block

seeblock:
        jsr     locate
        sta.w   col_+1

        sec

        cmp     #wallchr                ; view blocking characters
        beq     col_
        cmp     #doorchr
        beq     col_

        clc

col_
        lda.w   colortab
        sta     (color),y
_rts
        rts


;-----  actions must be located on same memory page (1 byte jumptable)

stairup:
        lda     #$99                    ; climb up a level
        jsr     movetolevel
        lda     LEVEL
        beq     checkamulet             ; player leaving dungeon

        ldy     stairdownx
        ldx     stairdowny
        bne     walk

checkamulet:
        lda     AMULET                  ; throw back to dungeon if no amulet
        beq     stairdown

        inc     $1e0b                   ; award 1000 gold
        jmp     newgame

stairdown:
        lda     #$01                    ; climb down a level
        jsr     movetolevel
;        ldy     stairupx                ; the values already there
;        ldx     stairupy
        ;
        ;
walk:
        sty     manx                    ; new coordinates to man
        stx     many
blocked:
        rts                             ; do nothing if way blocked

getamulet:
        inc     AMULET                  ; picked up the amulet
        ;
pickpotion:
        lda     HITPOINTS               ; drink potion
        bmi     _pickany                ; no more if already 80+
        sed
        adc     #HEAL                   ; carry always clear here
        sta     HITPOINTS
        cld
        bne     _pickany                ; always branch

pickgold:
        and     #MAXGOLD                ; max gold $17, $07 or $03
        ora     #$01                    ; at least 1 gold
        sed
        adc     GOLD
        sta     GOLD
        lda     GOLD100
        adc     #$00
        sta     GOLD100
        cld
_pickany
        jsr     walk
        ;
opendoor:
        lda     #$00                    ; open door
        beq     drawchar                ; rts there


hitdragon:
        cmp     #DRAGONAC
        .DB     $0c                     ; nop $0000, skips 2 bytes
        ;
hitbatgob:
        cmp     #BATGOBAC
        bcc     blocked

        and     #$01                    ; potion or gold
        ora     #$06
        ;
        ;
;-----  draw char a at y,x

drawchar:
        pha

        jsr     locate
        sta     underman

        pla
        tax

        lda.w   objchar,x
        ;
        ;
;-----  draw character and colorize if in visible (visited) area

drawshaded:
        sta     (scr),y
        sta.w   col_+1

        lda     (color),y
        and     #$07
        bne     col_

        rts


;-----  action jump table

actionlist:
        .DB     walk&255                ; floor
        .DB     blocked&255             ; wall
        .DB     getamulet&255           ; get amulet
        .DB     opendoor&255            ; door
        .DB     stairdown&255           ; staircase down
        .DB     stairup&255             ; staircase up
        .DB     pickpotion&255          ; pick potion
        .DB     pickgold&255            ; pick gold
        .DB     hitbatgob&255           ; hit monster (bat)
        .DB     hitbatgob&255           ; hit monster (goblin)
        .DB     hitdragon&255           ; hit monster (dragon)


;-----  vic init table: $900f-$9015

vicinit:
        .DB     $08,$0e,$22,$94,$32,$00,$f2             ; PAL
;        .DB     $08,$06,$10,$94,$32,$00,$f2             ; NTSC


;-----  keyboard

keylist:
        .DB     17,29,145,157           ; (,46 = floorchr)


;-----  objects

objchar:
        .DB     floorchr                ; floor
        .DB     wallchr                 ; wall
        .DB     amuletchr               ; amulet
        .DB     doorchr                 ; door
        .DB     downchr                 ; staircase down
        .DB     upchr                   ; staircase up
        .DB     33                      ; potion
        .DB     36                      ; gold
        .DB     batchr                  ; bat
        .DB     goblinchr               ; goblin
        .DB     dragonchr               ; dragon
        .DB     0                       ; man
        ;
objcolor:
        .DB     1                       ; floor
        .DB     6                       ; wall
        .DB     7                       ; amulet
        .DB     7                       ; door
        .DB     3                       ; staircase down
        .DB     3                       ; staircase up
        .DB     4                       ; potion
        .DB     7                       ; gold
        .DB     2                       ; bat
        .DB     5                       ; goblin
        .DB     4                       ; dragon
        .DB     1                       ; man
.ENDS
