
;*****************************************
;*                                       *
;*                VARIABLES              *
;*                                       *
;*****************************************



RSSET $C100

SpriteRAM RB 160        ;* Reserve 160 bytes for sprites        *

FrameSkip    RB 1       ;* Frame skip countdown                 *
FrameSkipCnt RB 1       ;* Current frame skip selected by user  *
FrameSkipDefault EQU 6  ;* Default frame skip (used on startup) *
UpdateFrame  RB 1       ;* LCDC to VBlank int communication     *

KirbyFrame   RB 1       ;* Current frame used for Kirby         *
KirbyFrameCnt EQU 3     ;* Total amount of frames               *
KirbyX       RB 1       ;* X position of Kirby                  *
KirbyY       RB 1       ;* Y position of Kirby                  *

KirbyYTop    RB 1       ;* Current 'height of jump'             *
KirbyYChg    RB 1       ;* Size of Y step                       *
KirbyYDir    RB 1       ;* 0: Going up, 1: Going down           *
KirbyXDir    RB 1       ;* 0: Going left, 1 : Going right       *

CloudX       RB 1       ;* Current position of cloud            *
CloudXStart  EQU 180    ;* First position of cloud              *
CloudSkip    RB 1       ;* Cloud frame-skip countdown           *
CloudSkipCnt EQU 35     ;* Cloud frame-skip                     *
CloudY       EQU 22     ;* Current position of cloud            *

TextSkip     RB 1       ;* Text frame-skip countdown            *
TextSkipCnt  EQU 3      ;* Text frame-skip                      *
TextPos      RW 1       ;* First char on screen                 * 
TextX        RB 1       ;* Current X scroll                     *



;* LCDC Control lines *

CLKirby EQU 22
CLBase  EQU 125
;CLBase  EQU 124
CLText  EQU 133





Space  EQU 128
Tilte  EQU 127
Minus  EQU 126
Komma  EQU 125
Period EQU 124
Slash  EQU 123




Txt: MACRO

; for all chars do..
TXTCNT SET 1
REPT STRLEN("\1")
    
TXTCHR SET STRSUB("\1", TXTCNT, 1)

; Numbers
IF ( TXTCHR >= "0" ) && ( TXTCHR <= "9" ) 
  db (128-10-26-5) + TXTCHR - "0"
ENDC

;big chars
IF ( TXTCHR >= "A" ) && ( TXTCHR <= "Z" )
  db (128-10-26-5) + TXTCHR - "A" + 10 
ENDC

IF ( TXTCHR == " " )
  db Space
ENDC

IF ( TXTCHR == "~" )
  db Tilte
ENDC
 
IF ( TXTCHR == "-" )
  db Minus
ENDC

IF ( TXTCHR == "." )
  db Period
ENDC

;IF ( TXTCHR == "," )           ; Doesn't work; seems to be a bug in RGBDS
;  db Komma                     
;ENDC

IF ( TXTCHR == "/" )
  db Slash
ENDC


TXTCNT SET TXTCNT + 1

ENDR
ENDM
