;********************************************************
;*                                                      *
;*  HEADER.INC                                          *
;*  Part of HMGBLIB                                     *
;*                                                      *
;* This source contains the required settings to create *
;* a correct header for a Gameboy image.                *
;*                                                      *
;********************************************************




;*****************
;* ROM TYPE INFO *
;*****************

; Title of image (16 chars max, capital advised)

TITLE EQUS "KIRBY XXL" 


; Licencee code (new): two byte, should be ASCII or $0000 for none
NEWLICCODE EQU $0000


; GB/SGB support indicator 
; 0 - GameBoy
; 3 - Super GameBoy functions

SGBSUPPORT EQU 0


;Cartridge type:
; 0 - Rom only      3 - ROM+MBC1+RAM+Battery
; 1 - ROM+MBC1      5 - ROM+MBC2
; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery

CARTTYPE   EQU 1                         ; 1 - ROM+MBC1


;Rom Size:
; 0 - 256kBit =  32kB =  2 banks
; 1 - 512kBit =  64kB =  4 banks
; 2 -   1MBit = 128kB =  8 banks
; 3 -   2MBit = 256kB = 16 banks
; 4 -   4MBit = 512kB = 32 banks

ROMSIZE    EQU 0                         ; 0 - 256kBit =  32kB =  2 banks


;Ram Size:
; 0 - None
; 1 -  16kBit =  2kB = 1 bank
; 2 -  64kBit =  8kB = 1 bank
; 3 - 256kBit = 32kB = 4 banks

RAMSIZE    EQU 0                         ; 0 - None


;Destination code:
; 0 - Japanese
; 1 - Non-Japanese

DESTCODE   EQU 1                         ; 1 - Non-Japanese


;Licencee code (byte):

OLDLICCODE EQU 0


;Version Number (byte):

VERSION    EQU 1




