;******************************************************************
;*** Source to PUNK-DEMO for the Gameboy '98 Demo competition	***
;***								***
;***			(c) Anders Granlund 1998		***
;***								***
;*** Please feel free to do whatever you want with this code,	***
;*** for your own purposed that is...				***
;***								***
;******************************************************************


memvar				.EQU $CC00
temp                            .EQU memvar+1
a1scroll                        .EQU memvar+2
a2scroll                        .EQU memvar+3
VBLcnt                          .EQU memvar+4
lcd_cnt                         .EQU memvar+5
dist_cnt                        .EQU memvar+6

a1col                           .EQU memvar+7
excol                           .EQU memvar+8
fadea1                          .EQU memvar+9
fadeex                          .EQU memvar+10
fadetime                        .EQU memvar+11

seconds                         .EQU memvar+12
vbls                            .EQU memvar+13

intro                           .EQU memvar+14
yline                           .EQU memvar+15
lcdoffs                         .EQU memvar+16

samp_cnt_h                      .EQU memvar+100
samp_cnt_l                      .EQU memvar+101

samp_pos_h                      .EQU memvar+102
samp_pos_l                      .EQU memvar+103

samp_bank                       .EQU memvar+104



.org	0

.org $40        ;vbl
  jp VBL_int
  reti  
.org $48        ;lcdc
  reti
.org $50        ;timer
  jp TIMER_int
  reti
.org $58
  reti
.org $60
  reti

.org $100
  nop
  jp begin

;Nintendo Scrolling Title Graphic
;***********************************************
.byte	0ceh,0edh,66h,66h,0cch,13,0,11,3,73h
.byte	0,83h,0,12,0,13,0,8,17,31,88h,89h,0
.byte	14,0dch,0cch,6eh,0e6h,0ddh,0ddh,0d9h
.byte	99h,0bbh,0bbh,67h,63h,6eh,0eh,0ech,0cch
.byte	0ddh,0dch,99h,09fh,0bbh,0b9h,33h,3eh
;***********************************************

.byte   "Punk Demo       "              ;Title of the game
.byte	0,0,0				;Not used
.byte   $1                              ;Cartridge type: Rom only
					; 0 - Rom only      3 - ROM+MBC1+RAM+Battery
					; 1 - ROM+MBC1      5 - ROM+MBC2
					; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery
.byte   $1                              ;Rom Size:
					; 0 - 256kBit =  32kB =  2 banks
					; 1 - 512kBit =  64kB =  4 banks
					; 2 -   1MBit = 128kB =  8 banks
					; 3 -   2MBit = 256kB = 16 banks
					; 4 -   4MBit = 512kB = 32 banks
.byte   0                               ;Ram Size:
					; 0 - None
					; 1 -  16kBit =  2kB = 1 bank
					; 2 -  64kBit =  8kB = 1 bank
					; 3 - 256kBit = 32kB = 4 banks
.byte   "A","G"                       ;Manufacturer code:
.byte	1				;Version Number
.byte	0ah				;Complement check
.word	0				;Checksum


begin:

;***********
;** SETUP **
;***********
  di
  xor a
  ldh ($40),a			;Turn off screen

; Copy Sprite handler to high ram
  ld      hl,VblankFirst
  ld      de,$FF80
  ld      b,VblankLast-VblankFirst
loadh:
  ld      a,(hli)
  ld      (de),a
  inc     de
  dec     b
  jr      nz,loadh

  ld a,%01000100		;set lcdc int
  ldh ($41),a
  ld a,%00000111
  ldh ($FF),a                   ;We want LCDC int + Vblank + Timer
  xor a
  ldh ($42),a			;Scroll X
  ldh ($43),a			;Scroll Y
  ldh ($26),a			;Turn off sound
  ld a,%11100100			;"normal" colours
  ldh ($47),a			;BG palette
  ld a,%11100100		;"normal" colours
  ldh ($48),a			;OBJ0 palette
  ldh ($49),a			;OBJ1 palette


  call clear_bgdata
  call clear_bgdata2
  call clear_spritedata


;-- Load the anarchy picture into map:$9800, tiles:$8000 --
  ld hl,map_a1
  ld de,$9800
  call load_map
  ld de,$8000
  ld hl,tiles_a1
  call load_tiles

;-- Load the skeleton head into map:$9C00 tiles:$8800 --
  di
  ld hl,map_head
  ld de,$9C00
  call load_mapw
  ld hl,tiles_head
  ld de,$8800
  call load_tiles


  xor a
  ld (VBLcnt),a
  ld (lcd_cnt),a
  ld (dist_cnt),a
  ld (a1scroll),a
  ld (a2scroll),a
  ld (a1col),a
  ld (excol),a
  ld (fadea1),a
  ldh ($45),a
  ld (vbls),a
  ld (seconds),a
  ld (yline),a
  ld (intro),a

  ld a,1
  ld (fadeex),a
  ld a,35
  ld (fadetime),a


  ld a,7
  ldh ($4B),a			;Window X
  ld a,0
  ldh ($4A),a			;Window Y
  ld a,%11010001
  ldh ($40),a			;Turn screen on



  ld hl,21867   ;sample length
  ld a,h
  ld (samp_cnt_h),a
  ld a,l
  ld (samp_cnt_l),a

  ld hl,$4000

  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a

  ld a,2
  ld (samp_bank),a


  ld a,$84
  ldh ($26),a
  xor a
  ldh ($1A),a
  ldh ($25),a

  ld a,$77
  ldh ($24),a
  ld a,$FF
  ldh ($25),a

  ld a,$FF
  ldh ($1B),a

  ld a,$20
  ldh ($1C),a

;---- 8 Khz freq ----
  ld a,%00000000
  ldh ($1D),a

  ld a,256-16
  ld ($FF06),a                   ;divide

  ld a,4
  ld ($FF07),a                   ;set timer freq = 4096
;---------------------



  ei
main:
  ld a,(seconds)
  cp 10
  jr nz,main
  ld a,1
  ld (fadea1),a


main2:
  jr main2







VBL_int:
  push af
  ld a,(vbls)
  inc a
  cp 60
  jr nz,noresvbls
  ld a,(seconds)
  inc a
  ld (seconds),a
  xor a
noresvbls:
  ld (vbls),a


  ld a,(fadetime)
  dec a
  ld (fadetime),a
  cp 0
  jr nz,vbli3
  ld a,35
  ld (fadetime),a

  ld a,(fadeex)
  cp 0
  jr z,vbli2
  ld a,(excol)
  inc a
  ld (excol),a
  cp 3
  jr nz,vbli2
  xor a
  ld (fadeex),a
vbli2:
  ld a,(fadea1)
  cp 0
  jr z,vbli3
  ld a,(a1col)
  inc a
  ld (a1col),a
  cp 3
  jr nz,vbli3
  xor a
  ld (fadea1),a
vbli3:
  call $FF80
  ld a,(VBLcnt)
  inc a
  cp 2
  jr nz,noresvblc
  xor a
noresvblc:
  ld (VBLcnt),a

  cp 0
  jp z,VBLint_1
  cp 1
  jp z,VBLint_2
  xor a
  ld (VBLcnt),a
  pop af
  reti

VBLint_1:       ;map = $9800
  push de
  push hl

  ld a,%11010001
  ldh ($40),a                   ;swap screen

  ld a,(a1col)
  ld hl,fadecols
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  ldh ($47),a

  ld a,(a2scroll)
  inc a
  inc a
  ld (a2scroll),a
  cp 143
  jr c,noresa2
  xor a
noresa2:
  ld (a2scroll),a


  ld a,(a1scroll)
  inc a
  inc a
  inc a
  inc a
  ld (a1scroll),a
  ld hl,costab
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  ldh ($43),a

  ld a,(a2scroll)
  ld hl,sintab2
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  ldh ($42),a
  pop hl
  pop de
  pop af
  reti


VBLint_2:               ;map = $9C00
  ld a,%11001001
  ldh ($40),a			;Turn screen on
  xor a
  ldh ($43),a
  ldh ($42),a

  ld a,(excol)
  ld hl,fadecols
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  ldh ($47),a

  ld a,(dist_cnt)
  inc a
  cp 143
  jr c,noresdcnt
  xor a
noresdcnt:
  ld (dist_cnt),a
  pop af
  reti






TIMER_int:
  push af
  push bc
  push de
  push hl

  ld a,(samp_pos_h)
  ld h,a
  ld a,(samp_pos_l)
  ld l,a                ;hl = sample position

  ld a,(samp_bank)
  ld ($2000),a  ;select bank

  ld de,$FF30
  ld b,16               ;16 bytes / sample-pack
  xor a
  ldh ($1A),a
load_samp:
  ld a,(hli)
  ld (de),a
  inc de
  dec b
  jr nz,load_samp

  ld a,1
  ld ($2000),a  ;bank1

  ld a,h
  cp $80
  jr nz,noressb

  ld a,(samp_bank)
  inc a
  ld (samp_bank),a

  ld hl,$4000

noressb:

  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a


  ld a,(samp_cnt_h)
  ld h,a
  ld a,(samp_cnt_l)
  ld l,a

  dec hl

  ld a,h
  ld (samp_cnt_h),a
  ld a,l
  ld (samp_cnt_l),a

  inc hl

  ld a,h
  cp 0
  jr nz,noressamp
  ld a,l
  cp 0
  jr nz,noressamp



  ld hl,21867
  ld a,l
  ld (samp_cnt_l),a
  ld a,h
  ld (samp_cnt_h),a

  ld hl,$4000
  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a

  ld a,2
  ld (samp_bank),a


noressamp:
  ld a,$84
  ldh ($26),a
  ld a,$80
  ldh ($1A),a
  ld a,%10000111
  ldh ($1E),a

  pop hl
  pop de
  pop bc
  pop af
  reti




;**************************
;** GENERAL SUB-ROUTINES **
;**************************

load_mapw:               ;** LOAD A MAP AT HL **
  ld a,127
  ld (temp),a
  ld c,32			;Height=32
ldmap1w:
  ld b,32			;Width=32
ldmap2w:
  push bc
  ld a,(temp)
  ld b,a
  ld a,(hli)
  sbc a,b
  pop bc
  call wrAtode
  inc de
  dec b
  jr nz,ldmap2w
  dec c
  jr nz,ldmap1w
  ret


load_map:		;** LOAD A MAP AT HL **
  ld c,32			;Height=32
ldmap1:
  ld b,32			;Width=32
ldmap2:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jr nz,ldmap2
  dec c
  jr nz,ldmap1
  ret

load_tiles:             ;** LOAD TILESET FROM HL **
  ld c,255			;Nr. of tiles
loadtiles:
  ld b,16			;16 bytes per tile 
loadonetile:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jr nz,loadonetile
  dec c
  jr nz,loadtiles
  ret



wrAtohl:	;** Writes A to HL at the right time **
  push af		;Save reg A and flags
wral1:
  ldh a,($41)
  and 2
  jr nz,wral1
  pop af		;Restore reg A and flags
  ld (hl),a		;write a to hl
  ret

wrAtode:	;** Writes A to DE at the right time **
  push af		;Save reg A and flags
wral2:
  ldh a,($41)
  and 2
  jr nz,wral2
  pop af		;Restore reg A and flags
  ld (de),a		;write a to de
  ret




VblankFirst
  push af
  ld a,$c0
  ldh ($46),a
  ld a,$28
VblankW
  dec a
  jr nz,VblankW
  pop af
  ret
VblankLast


clear_spritedata:
  xor a
  ld hl,$C000
  ld c,40			;40 sprites
  xor a
clroamdata:
  ld (hli),a
  ld (hli),a
  ld a,255
  ld (hli),a
  xor a
  ld (hli),a
  dec c
  jr nz,clroamdata
  ret

clear_bgdata:
  ld a,255			;tile 255 = blank
  ld hl,$9800
  ld c,32			;Height=32
cleartiles:
  ld b,32			;width=32
cleartile:
  ld (hli),a
  dec b
  jr nz,cleartile
  dec c
  jr nz,cleartiles
  ret

clear_bgdata2:
  ld a,255			;tile 255 = blank
  ld hl,$9C00
  ld c,32			;Height=32
cleartiles2:
  ld b,32			;width=32
cleartile2:
  ld (hli),a
  dec b
  jr nz,cleartile2
  dec c
  jr nz,cleartiles2
  ret






;**********
;** DATA **
;**********


map_head:
#include "ex.map"
map_a1:
#include "a1.map"

tiles_head:
#include "ex.tle"       ;skeletonhead tiles
tiles_a1:
#include "a1.tle"       ;anarchy tiles
#include "a1b.tle"      ;fonts

fadecols:
.db %00000000,%01010100,%10100100,%11100100

sintab:
#include "punk1.dta"
costab:
#include "punk2.dta"
sintab2:
#include "punk3.dta"
#include "punk3.dta"


.org $8000
sample1:

.end
