;**************************************************
;*** Landscape Demo - TASM source code          ***
;*** (c) Anders Granlund 1998                   ***
;***                                            ***
;*** You are free to use whatever routines you  ***
;*** might find useful in this code for your    ***
;*** own purpouses...                           ***
;**************************************************

memvar				.EQU $CC00

yint				.EQU memvar+1
datapos				.EQU memvar+2
sinptr				.EQU memvar+3


line1int			.EQU memvar+11
line2int			.EQU memvar+12
line3int			.EQU memvar+13
line4int			.EQU memvar+14
line5int			.EQU memvar+15
line6int			.EQU memvar+16
line7int			.EQU memvar+17
line8int			.EQU memvar+18

ballx1				.EQU memvar+20
ballx2				.EQU memvar+21
ballx3				.EQU memvar+22
ballx4				.EQU memvar+23
ballx5				.EQU memvar+24
ballx6				.EQU memvar+25
ballx7				.EQU memvar+26
ballx8				.EQU memvar+27
ballx9				.EQU memvar+28
ballx10				.EQU memvar+29

bally1				.EQU memvar+30
bally2                          .EQU memvar+31
bally3                          .EQU memvar+32
bally4                          .EQU memvar+33
bally5                          .EQU memvar+34
bally6                          .EQU memvar+35
bally7                          .EQU memvar+36
bally8                          .EQU memvar+37
bally9                          .EQU memvar+38
bally10                         .EQU memvar+39

ballcnt                         .EQU memvar+40
ballcnt2                        .EQU memvar+41

temp1                           .EQU memvar+50
temp2                           .EQU memvar+51
temp3                           .EQU memvar+52
temp4                           .EQU memvar+53
temp5                           .EQU memvar+54
temp6                           .EQU memvar+55
temp7                           .EQU memvar+56

textcnth                        .EQU memvar+60  ;high byte of textpos.
textcntl                        .EQU memvar+61  ;low byte of textpos.
scrollcnt                       .EQU memvar+62  ;counts scrolled pixels (0-15)
scrollcnt2                      .EQU memvar+63  ;counts scrolled chars

samp_cnt_h                      .EQU memvar+100
samp_cnt_l                      .EQU memvar+101
samp_pos_h                      .EQU memvar+102
samp_pos_l                      .EQU memvar+103
samp_bank                       .EQU memvar+104


.org	0

.org $40
  jp Vblank_interrupt
  reti
.org $48
  jp lcd_interrupt
  reti
.org $50
;  jp TIMER_int * Disabled due to lack of CPU-Power and/or optimization :-( *
  reti
.org $58
  reti
.org $60
  reti

.org $100
  nop
  jp begin

;Nintendo Scrolling Title Graphic
;***********************************************
.byte	0ceh,0edh,66h,66h,0cch,13,0,11,3,73h
.byte	0,83h,0,12,0,13,0,8,17,31,88h,89h,0
.byte	14,0dch,0cch,6eh,0e6h,0ddh,0ddh,0d9h
.byte	99h,0bbh,0bbh,67h,63h,6eh,0eh,0ech,0cch
.byte	0ddh,0dch,99h,09fh,0bbh,0b9h,33h,3eh
;***********************************************

.byte   "Landscape Demo  "              ;Title of the game
.byte	0,0,0				;Not used
.byte	0 				;Cartridge type: Rom only
					; 0 - Rom only      3 - ROM+MBC1+RAM+Battery
					; 1 - ROM+MBC1      5 - ROM+MBC2
					; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery
.byte	0				;Rom Size:
					; 0 - 256kBit =  32kB =  2 banks
					; 1 - 512kBit =  64kB =  4 banks
					; 2 -   1MBit = 128kB =  8 banks
					; 3 -   2MBit = 256kB = 16 banks
					; 4 -   4MBit = 512kB = 32 banks
.byte   0				;Ram Size:
					; 0 - None
					; 1 -  16kBit =  2kB = 1 bank
					; 2 -  64kBit =  8kB = 1 bank
					; 3 - 256kBit = 32kB = 4 banks
.byte   "A","B"                         ;Manufacturer code:
.byte	1				;Version Number
.byte	0ah				;Complement check
.word	0				;Checksum


begin:

;***********
;** SETUP **
;***********
  di
  xor a
  ldh ($40),a			;Turn off screen

; Copy Sprite handler to high ram
  ld      hl,VblankFirst
  ld      de,$FF80
  ld      b,VblankLast-VblankFirst
loadh:
  ld      a,(hli)
  ld      (de),a
  inc     de
  dec     b
  jr      nz,loadh

  ld a,%01000100		;set lcdc int
  ldh ($41),a
  ld a,%00000111
  ldh ($FF),a			;We want LCDC int + Vblank
  xor a
  ldh ($42),a			;Scroll X
  ldh ($43),a			;Scroll Y
  ldh ($26),a			;Turn off sound
  ld a,%11100100			;"normal" colours
  ldh ($47),a			;BG palette
  ld a,%11100100		;"normal" colours
  ldh ($48),a			;OBJ0 palette
  ldh ($49),a			;OBJ1 palette

  call clear_bgdata
  call clear_spritedata


  ld hl,tiles
  call load_tiles
  ld hl,winmap
  call load_windowmap
  ld a,7
  ldh ($4B),a			;Window X
  ld a,72
  ldh ($4A),a			;Window Y
  ld a,%11110111
  ldh ($40),a			;Turn screen on

  xor a
  ld (datapos),a
  ld (ballcnt),a
  ld (ballcnt2),a
  ld (scrollcnt),a
  ld (textcnth),a
  ld (textcntl),a

  ld a,144
  ld (sinptr),a

  ld a,20
  ld (scrollcnt2),a             ;scroller start-write (offscreen)

  ld d,0
  ld e,8
  ld hl,lsdata
  ld (line1int),a
  add hl,de
  ld a,(hl)
  ld (line2int),a
  add hl,de
  ld a,(hl)
  ld (line3int),a
  add hl,de
  ld a,(hl)
  ld (line4int),a
  add hl,de
  ld a,(hl)
  ld (line5int),a
  add hl,de
  ld a,(hl)
  ld (line6int),a
  add hl,de
  ld a,(hl)
  ld (line7int),a
  add hl,de
  ld a,(hl)
  ld (line8int),a

;*** Setup sample stuff ***
  ld hl,21867   ;sample length
  ld a,h
  ld (samp_cnt_h),a
  ld a,l
  ld (samp_cnt_l),a
  ld hl,$4000
  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a
  ld a,2
  ld (samp_bank),a
  ld a,$84
  ldh ($26),a
  xor a
  ldh ($1A),a
  ldh ($25),a
  ld a,$77
  ldh ($24),a
  ld a,$FF
  ldh ($25),a
  ld a,$FF
  ldh ($1B),a
  ld a,$20
  ldh ($1C),a
;---- 8 Khz freq ----
  ld a,%00000000
  ldh ($1D),a
  ld a,256-16
  ld ($FF06),a                   ;divide
  ld a,4
  ld ($FF07),a                   ;set timer freq = 4096
;---------------------



  ei
main:
  halt
  call drawballs
  jr main

drawballs:
  xor a
  ld (temp4),a
  ld d,0
  ld hl,$c000   ;tile1
  push hl

drwb:
  ld a,(temp4)
  sla a
  sla a
  sla a
  sla a
  ld b,a
  ld a,(ballcnt)
  add a,b
  ld hl,ballcos
  ld e,a
  add hl,de
  ld a,(hl)
  ld (temp1),a
  
  ld a,(temp4)
  sla a
  sla a
  sla a
  sla a
  ld b,a
  ld a,(ballcnt2)
  add a,b
  ld hl,ballsin
  ld e,a
  add hl,de
  ld a,(hl)
  ld (temp2),a

;--- get size off ball ---
  ld a,(temp4)
  sla a
  sla a
  sla a
  sla a
  ld b,a
  ld a,(ballcnt)
  add a,b

  ld hl,ballsin2
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  ld (temp6),a

  ld a,(temp6)
  cp 0
  jr nz,testsize2
  ld a,36
  ld (temp5),a
  ld a,%00000000
  ld (temp3),a
  jr dodrawballs
testsize2:
  ld a,(temp6)
  cp 1
  jr nz,testsize3
  ld a,40
  ld (temp5),a
  ld a,%10000000
  ld (temp3),a
  jr dodrawballs
testsize3:
  ld a,(temp6)
  cp 2
  jr nz,testsize4
  ld a,44
  ld (temp5),a
  ld a,%10000000
  ld (temp3),a
  jr dodrawballs
testsize4:
  ld a,(temp6)
  cp 3
  jr nz,testsize5
  ld a,48
  ld (temp5),a
  ld a,%10000000
  ld (temp3),a
  jr dodrawballs
testsize5:
  ld a,(temp6)
  cp 4
  jr nz,testsize6
  ld a,52
  ld (temp5),a
  ld a,%10000000
  ld (temp3),a
  jr dodrawballs
testsize6:
  ld a,56
  ld (temp5),a
  ld a,%10000000
  ld (temp3),a


dodrawballs:
  ld b,8
  pop hl
  ld a,(temp2)
  ld (hli),a
  ld a,(temp1)
  ld (hli),a

  ld a,(temp5)
  ld (hli),a
  ld a,(temp3)
  ld (hli),a

  inc hl
  inc hl
  inc hl
  inc hl

  ld a,(temp2)  ;tile2
  ld (hli),a
  ld a,(temp1)
  add a,b
  ld (hli),a
  ld a,(temp5)
  inc a
  inc a
  ld (hli),a
  ld a,(temp3)
  ld (hli),a

  inc hl
  inc hl
  inc hl
  inc hl

  push hl

  ld a,(temp4)
  inc a
  ld (temp4),a
  cp 10
  jp nz,drwb
  pop hl

  ret



;***********************
;*** TIMER Interrupt ***
;***********************
TIMER_int:
  push af
  push bc
  push de
  push hl
  ld a,(samp_pos_h)
  ld h,a
  ld a,(samp_pos_l)
  ld l,a                ;hl = sample position
  ld a,(samp_bank)
  ld ($2000),a  ;select bank
  ld de,$FF30
  ld b,16               ;16 bytes / sample-pack
  xor a
  ldh ($1A),a
load_samp:
  ld a,(hli)
  ld (de),a
  inc de
  dec b
  jr nz,load_samp
  ld a,1
  ld ($2000),a  ;bank1
  ld a,h
  cp $80
  jr nz,noressb
  ld a,(samp_bank)
  inc a
  ld (samp_bank),a
  ld hl,$4000
noressb:
  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a
  ld a,(samp_cnt_h)
  ld h,a
  ld a,(samp_cnt_l)
  ld l,a
  dec hl
  ld a,h
  ld (samp_cnt_h),a
  ld a,l
  ld (samp_cnt_l),a
  inc hl
  ld a,h
  or l
  jr nz,noressamp
;*** Reset sample ***
  ld hl,1716
  ld a,l
  ld (samp_cnt_l),a
  ld a,h
  ld (samp_cnt_h),a
  ld hl,$4000
  ld a,h
  ld (samp_pos_h),a
  ld a,l
  ld (samp_pos_l),a
  ld a,2
  ld (samp_bank),a
noressamp:
  ld a,$84
  ldh ($26),a
  ld a,$80
  ldh ($1A),a
  ld a,%10000111
  ldh ($1E),a
  pop hl
  pop de
  pop bc
  pop af
  reti




;********************
;** LCDC-INTERRUPT **
;********************

lcd_interrupt:
  push af
  push bc
  ld a,(yint)
  inc a 
  ld (yint),a
  ldh ($45),a

  cp 72
  jr nz,nonewland
  ld a,%11000100
  ldh ($47),a
nonewland:
  ld a,(yint)
  ld b,a

  ld a,(line1int)
  cp b
  jr z,setcol1

  ld a,(line2int)
  cp b
  jr z,setcol2

  ld a,(line3int)
  cp b
  jr z,setcol1

  ld a,(line4int)
  cp b
  jr z,setcol2

  ld a,(line5int)
  cp b
  jr z,setcol1

  ld a,(line6int)
  cp b
  jr z,setcol2

  ld a,(line7int)
  cp b
  jr z,setcol1

  ld a,(line8int)
  cp b
  jr z,setcol2

gridfin:
  pop bc
  pop af
  reti


setcol1:
  ld a,%11000100
  ldh ($47),a
  pop bc
  pop af
  reti
  jr gridfin
setcol2:
  ld a,%00110100
  ldh ($47),a
  pop bc
  pop af
  reti
  jr gridfin



;**********************
;** VBLANK-INTERRUPT **
;**********************

Vblank_interrupt:
  push af
  push bc
  push de
  push hl
  call $FF80
  xor a
  ldh ($45),a
  ld (yint),a

  ld a,%11100100
  ldh ($47),a

  ld hl,lsdata
  ld a,(datapos)
  inc a
  cp 71
  jr nz,setuplines
  xor a
setuplines:
  ld (datapos),a
  xor d
  ld e,a
  add hl,de

  ld a,(hl)
  ld (line1int),a
  ld e,9
  add hl,de
  ld a,(hl)
  ld (line2int),a
  add hl,de
  ld a,(hl)
  ld (line3int),a
  add hl,de
  ld a,(hl)
  ld (line4int),a
  add hl,de
  ld a,(hl)
  ld (line5int),a
  add hl,de
  ld a,(hl)
  ld (line6int),a
  add hl,de
  ld a,(hl)
  ld (line7int),a
  add hl,de
  ld a,(hl)
  ld (line8int),a

  ld a,(ballcnt)
  dec a
  dec a
  ld (ballcnt),a

  ld a,(ballcnt2)
  dec a
  ld (ballcnt2),a


;--- Scrolltext stuff ---

  ldh a,($43)                   ;scroll left 1 pixel
  inc a
  inc a
  ldh ($43),a

  ld a,(scrollcnt)              ;increase scroll_counter
  inc a
  inc a
  cp 16
  jp nz,nores_scrollcnt

;** Setup for next character **
  ld a,(scrollcnt2)
  inc a
  inc a                 ;two tiles scroller
  cp 32
  jr nz,nores_scrollcnt2
  xor a
nores_scrollcnt2:
  ld (scrollcnt2),a

  ld hl,$9800+(32*4)       ;base offset for writing
  ld e,a
  ld d,0
  add hl,de
  push hl
;** Write the charater on screen **
  ld a,(textcnth)
  ld d,a
  ld a,(textcntl)
  ld e,a
  inc de
  ld a,d
  ld (textcnth),a
  ld a,e
  ld (textcntl),a

  ld hl,scrolltext
  add hl,de
  ld a,(hl)             ;A = character to write

  cp 1                  ;reset scroller?
  jr z,reset_scroller
  jp nores_scrolltext

reset_scroller:
  xor a
  ld (textcnth),a
  ld (textcntl),a

  pop hl                ;write blank character
  ld (hli),a
  ld (hl),a
  ld de,31
  add hl,de
  ld (hli),a
  ld (hl),a
  jr scrolltext_end

nores_scrolltext:
  ld b,64
  sbc a,b               ;A = 0, B=1 etc...

  add a,a               ;a=a*2
  add a,a               ;a=a*4

  ld b,59
  add a,b               ;A = 60, B = 64, C = 68 etc...

write_character:
  pop hl
  ld (hli),a
  inc a
  inc a
  ld (hl),a
  ld de,31
  add hl,de
  dec a
  ld (hli),a
  inc a
  inc a
  ld (hl),a
scrolltext_end:



  xor a
nores_scrollcnt:
  ld (scrollcnt),a


;--- Scroll text up/down ---
  ld a,(ballcnt2)
  ld hl,textsin
  ld e,a
  ld d,0
  add hl,de
  ld a,(hl)
  ldh ($42),a

  pop hl
  pop de
  pop bc
  pop af
  reti




;**************************
;** GENERAL SUB-ROUTINES **
;**************************

load_map:		;** LOAD A MAP AT HL **
  ld de,$9800			;Mapmem location
  ld c,32			;Height=32
ldmap1:
  ld b,32			;Width=32
ldmap2:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jr nz,ldmap2
  dec c
  jr nz,ldmap1
  ret

load_tiles:		;** LOAD TILESET FROM HL **
  ld de,$8000			;BG-tiles position
  ld c,255			;Nr. of tiles
loadtiles:
  ld b,16			;16 bytes per tile 
loadonetile:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jr nz,loadonetile
  dec c
  jr nz,loadtiles
  ret


load_windowmap:			;** LOAD WINDOW MAP **
  ld de,$9C00
  ld c,32
loadwintiles:
  ld b,32
loadwintile:
  ld a,(hli)
  call wrAtode
  inc de
  dec b
  jr nz,loadwintile
  dec c
  jr nz,loadwintiles
  ret



wrAtohl:	;** Writes A to HL at the right time **
  push af		;Save reg A and flags
wral1:
  ldh a,($41)
  and 2
  jr nz,wral1
  pop af		;Restore reg A and flags
  ld (hl),a		;write a to hl
  ret

wrAtode:	;** Writes A to DE at the right time **
  push af		;Save reg A and flags
wral2:
  ldh a,($41)
  and 2
  jr nz,wral2
  pop af		;Restore reg A and flags
  ld (de),a		;write a to de
  ret




VblankFirst
  di
  push af
  ld a,$c0
  ldh ($46),a
  ld a,$28
VblankW
  dec a
  jr nz,VblankW
  pop af
  ei
  ret
VblankLast


clear_spritedata:
  xor a
  ld hl,$C000
  ld c,40			;40 sprites
  xor a
clroamdata:
  ld (hli),a
  ld (hli),a
  ld a,255
  ld (hli),a
  xor a
  ld (hli),a
  dec c
  jr nz,clroamdata
  ret

clear_bgdata:
  ld a,255			;tile 255 = blank
  ld hl,$9800
  ld c,32			;Height=32
cleartiles:
  ld b,32			;width=32
cleartile:
  ld (hli),a
  dec b
  jr nz,cleartile
  dec c
  jr nz,cleartiles
  ret







;**********
;** DATA **
;**********

tiles:
#include "lstiles.z80"
#include "lstiles2.z80"

winmap:
#include "lsmap2.z80"

lsdata:
#include "lsdata.z80"

sinus:
#include "lssin.z80"

ballsin:
#include "lssin.dta"
#include "lssin.dta"
ballsin2:
#include "lssin3.dta"
#include "lssin3.dta"
ballcos:
#include "lscos.dta"
#include "lscos.dta"

textsin:
#include "lssin2.dta"
#include "lssin2.dta"

scrolltext:
.DB "               "
.DB " LANDSCAPE DEMO"
.DB " PRESENTED BY"
.DB " ANDERS GRANLUND"
.DB " FOR THE GAMEBOY"
.DB " DEMO COMPETITION"
.DB "       "
.DB " WELL, THE DEADLINE"
.DB " IS GETTING"
.DB " AWFULLY CLOSE NOW"
.DB " SO I BETTER FINISH"
.DB " THE DEMOS OFF SOON"
.DB " SO MEGAMAN DOESNT"
.DB " HAVE TO SPEND ALL"
.DB " NIGHT UPLOADING"
.DB " THE DEMOS THE LAST"
.DB " DAY IN MARCH"
.DB "      "
.DB " THE LANSCAPE ROUTINES"
.DB " WERE WRITTEN SOMETIME"
.DB " IN JANUARY THIS YEAR"
.DB " BUT I GOT TIRED OF"
.DB " THE PROJECT BACK THEN"
.DB "      "
.DB " DUE TO THE LACK OF"
.DB " DEMOS PRODUCED BY ME"
.DB " I DECIDED TO DO"
.DB " SOMETHING ABOUT THOSE"
.DB " OLD STUFF LYING"
.DB " AROUND ON THE HARDDISK"
.DB "      "
.DB " SO I ADDED A"
.DB " SCROLLER AND SOME BALLS"
.DB " TO THIS LANSCAPE DEMO"
.DB " AND I THINK I WILL"
.DB " HAVE TO DO NOW"
.DB "      "
.DB " GREETS TO ALL MEMBERS"
.DB " OF THE MAILING LIST"
.DB " AND DEV RING"
.DB "      "
.DB " I THINK MEGAMAN"
.DB " DESERVES A SPECIAL"
.DB " GREETING FOR MAINTAINING"
.DB " THE HOMEPAGE FOR THE"
.DB " COMPETITION"
.DB "      "
.DB " KEEP IT UP EVERYONE"
.DB "  "
.DB 1

.org $8000
.end
