;// RISC OS SWI list include file (for GNU Assembler and FASMARM)
;// (c) 2021 Jin X (t.me/jinxonik, jin_x@list.ru)

;// Copied from http://www.riscos.com/support/developers/prm_index/numswilist.html
;// and https://www.riscosopen.org/wiki/documentation/show/List%20of%20modules

;///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
;// RISCOS.COM                                                                                                        //
;///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

;// OS SWIs (Kernel and FileSwitch)
OS_WriteC = 0x00
OS_WriteS = 0x01
OS_Write0 = 0x02
OS_NewLine = 0x03
OS_ReadC = 0x04
OS_CLI = 0x05
OS_Byte = 0x06
OS_Word = 0x07
OS_File = 0x08
OS_Args = 0x09
OS_BGet = 0x0A
OS_BPut = 0x0B
OS_GBPB = 0x0C
OS_Find = 0x0D
OS_ReadLine = 0x0E
OS_Control = 0x0F
OS_GetEnv = 0x10
OS_Exit = 0x11
OS_SetEnv = 0x12
OS_IntOn = 0x13
OS_IntOff = 0x14
OS_CallBack = 0x15
OS_EnterOS = 0x16
OS_BreakPt = 0x17
OS_BreakCtrl = 0x18
OS_UnusedSWI = 0x19
OS_UpdateMEMC = 0x1A
OS_SetCallBack = 0x1B
OS_Mouse = 0x1C
OS_Heap = 0x1D
OS_Module = 0x1E
OS_Claim = 0x1F
OS_Release = 0x20
OS_ReadUnsigned = 0x21
OS_GenerateEvent = 0x22
OS_ReadVarVal = 0x23
OS_SetVarVal = 0x24
OS_GSInit = 0x25
OS_GSRead = 0x26
OS_GSTrans = 0x27
OS_BinaryToDecimal = 0x28
OS_FSControl = 0x29
OS_ChangeDynamicArea = 0x2A
OS_GenerateError = 0x2B
OS_ReadEscapeState = 0x2C
OS_EvaluateExpression = 0x2D
OS_SpriteOp = 0x2E
OS_ReadPalette = 0x2F
OS_ServiceCall = 0x30
OS_ReadVduVariables = 0x31
OS_ReadPoint = 0x32
OS_UpCall = 0x33
OS_CallAVector = 0x34
OS_ReadModeVariable = 0x35
OS_RemoveCursors = 0x36
OS_RestoreCursors = 0x37
OS_SWINumberToString = 0x38
OS_SWINumberFromString = 0x39
OS_ValidateAddress = 0x3A
OS_CallAfter = 0x3B
OS_CallEvery = 0x3C
OS_RemoveTickerEvent = 0x3D
OS_InstallKeyHandler = 0x3E
OS_CheckModeValid = 0x3F
OS_ChangeEnvironment = 0x40
OS_ClaimScreenMemory = 0x41
OS_ReadMonotonicTime = 0x42
OS_SubstituteArgs = 0x43
OS_PrettyPrint = 0x44
OS_Plot = 0x45
OS_WriteN = 0x46
OS_AddToVector = 0x47
OS_WriteEnv = 0x48
OS_ReadArgs = 0x49
OS_ReadRAMFsLimits = 0x4A
OS_ClaimDeviceVector = 0x4B
OS_ReleaseDeviceVector = 0x4C
OS_DelinkApplication = 0x4D
OS_RelinkApplication = 0x4E
OS_HeapSort = 0x4F
OS_ExitAndDie = 0x50
OS_ReadMemMapInfo = 0x51
OS_ReadMemMapEntries = 0x52
OS_SetMemMapEntries = 0x53
OS_AddCallBack = 0x54
OS_ReadDefaultHandler = 0x55
OS_SetECFOrigin = 0x56
OS_SerialOp = 0x57
OS_ReadSysInfo = 0x58
OS_Confirm = 0x59
OS_ChangedBox = 0x5A
OS_CRC = 0x5B
OS_ReadDynamicArea = 0x5C
OS_PrintChar = 0x5D
OS_ChangeRedirection = 0x5E
OS_RemoveCallBack = 0x5F
OS_FindMemMapEntries = 0x60
OS_SetColour = 0x61
OS_Pointer = 0x64
OS_ScreenMode = 0x65
OS_DynamicArea = 0x66
OS_Memory = 0x68
OS_ClaimProcessorVector = 0x69
OS_Reset = 0x6A
OS_MMUControl = 0x6B
OS_ConvertStandardDateAndTime = 0xC0
OS_ConvertDateAndTime = 0xC1
OS_ConvertHex1 = 0xD0
OS_ConvertHex2 = 0xD1
OS_ConvertHex3 = 0xD2
OS_ConvertHex4 = 0xD3
OS_ConvertHex8 = 0xD4
OS_ConvertCardinal1 = 0xD5
OS_ConvertCardinal2 = 0xD6
OS_ConvertCardinal3 = 0xD7
OS_ConvertCardinal4 = 0xD8
OS_ConvertInteger1 = 0xD9
OS_ConvertInteger2 = 0xDA
OS_ConvertInteger3 = 0xDB
OS_ConvertInteger4 = 0xDC
OS_ConvertBinary1 = 0xDD
OS_ConvertBinary2 = 0xDE
OS_ConvertBinary3 = 0xDF
OS_ConvertBinary4 = 0xE0
OS_ConvertSpacedCardinal1 = 0xE1
OS_ConvertSpacedCardinal2 = 0xE2
OS_ConvertSpacedCardinal3 = 0xE3
OS_ConvertSpacedCardinal4 = 0xE4
OS_ConvertSpacedInteger1 = 0xE5
OS_ConvertSpacedInteger2 = 0xE6
OS_ConvertSpacedInteger3 = 0xE7
OS_ConvertSpacedInteger4 = 0xE8
OS_ConvertFixedNetStation = 0xE9
OS_ConvertNetStation = 0xEA
OS_ConvertFixedFileSize = 0xEB
OS_ConvertFileSize = 0xEC
OS_WriteI = 0x100

;// IIC SWI
IIC_Control = 0x240

;// Cache SWIs (for ARM3)
Cache_Control = 0x280
Cache_Cacheable = 0x281
Cache_Updateable = 0x282
Cache_Disruptive = 0x283
Cache_Flush = 0x284

;// Econet SWIs
Econet_CreateReceive = 0x40000
Econet_ExamineReceive = 0x40001
Econet_ReadReceive = 0x40002
Econet_AbandonReceive = 0x40003
Econet_WaitForReception = 0x40004
Econet_EnumerateReceive = 0x40005
Econet_StartTransmit = 0x40006
Econet_PollTransmit = 0x40007
Econet_AbandonTransmit = 0x40008
Econet_DoTransmit = 0x40009
Econet_ReadLocalStationAndNet = 0x4000A
Econet_ConvertStatusToString = 0x4000B
Econet_ConvertStatusToError = 0x4000C
Econet_ReadProtection = 0x4000D
Econet_SetProtection = 0x4000E
Econet_ReadStationNumber = 0x4000F
Econet_PrintBanner = 0x40010
Econet_ReadTransportType = 0x40011
Econet_ReleasePort = 0x40012
Econet_AllocatePort = 0x40013
Econet_DeAllocatePort = 0x40014
Econet_ClaimPort = 0x40015
Econet_StartImmediate = 0x40016
Econet_DoImmediate = 0x40017
Econet_AbandonAndReadReceive = 0x40018
Econet_Version = 0x40019
Econet_NetworkState = 0x4001A
Econet_PacketSize = 0x4001B
Econet_ReadTransportName = 0x4001C
Econet_InetRxDirect = 0x4001D
Econet_EnumerateMap = 0x4001E
Econet_EnumerateTransmit = 0x4001F
Econet_HardwareAddresses = 0x40020
Econet_NetworkParameters = 0x40021

;// NetFS SWIs
NetFS_ReadFSNumber = 0x40040
NetFS_SetFSNumber = 0x40041
NetFS_ReadFSName = 0x40042
NetFS_SetFSName = 0x40043
NetFS_ReadCurrentContext = 0x40044
NetFS_SetCurrentContext = 0x40045
NetFS_ReadFSTimeouts = 0x40046
NetFS_SetFSTimeouts = 0x40047
NetFS_DoFSOp = 0x40048
NetFS_EnumerateFSList = 0x40049
NetFS_EnumerateFS = 0x4004A
NetFS_ConvertDate = 0x4004B
NetFS_DoFSOpToGivenFS = 0x4004C
NetFS_UpdateFSList = 0x4004D
NetFS_EnumerateFSContexts = 0x4004E
NetFS_ReadUserId = 0x4004F
NetFS_GetObjectUID = 0x40050
NetFS_EnableCache = 0x40051

;// Font manager SWIs
Font_CacheAddr = 0x40080
Font_FindFont = 0x40081
Font_LoseFont = 0x40082
Font_ReadDefn = 0x40083
Font_ReadInfo = 0x40084
Font_StringWidth = 0x40085
Font_Paint = 0x40086
Font_Caret = 0x40087
Font_ConverttoOS = 0x40088
Font_Converttopoints = 0x40089
Font_SetFont = 0x4008A
Font_CurrentFont = 0x4008B
Font_FutureFont = 0x4008C
Font_FindCaret = 0x4008D
Font_CharBBox = 0x4008E
Font_ReadScaleFactor = 0x4008F
Font_SetScaleFactor = 0x40090
Font_ListFonts = 0x40091
Font_SetFontColours = 0x40092
Font_SetPalette = 0x40093
Font_ReadThresholds = 0x40094
Font_SetThresholds = 0x40095
Font_FindCaretJ = 0x40096
Font_StringBBox = 0x40097
Font_ReadColourTable = 0x40098
Font_MakeBitmap = 0x40099
Font_UnCacheFile = 0x4009A
Font_SetFontMax = 0x4009B
Font_ReadFontMax = 0x4009C
Font_ReadFontPrefix = 0x4009D
Font_SwitchOutputToBuffer = 0x4009E
Font_ReadFontMetrics = 0x4009F
Font_DecodeMenu = 0x400A0
Font_ScanString = 0x400A1
Font_SetColourTable = 0x400A2
Font_CurrentRGB = 0x400A3
Font_FutureRGB = 0x400A4
Font_ReadEncodingFilename = 0x400A5
Font_FindField = 0x400A6
Font_ApplyFields = 0x400A7
Font_LookupFont = 0x400A8

;// Wimp (window manager) SWIs
Wimp_Initialise = 0x400C0
Wimp_CreateWindow = 0x400C1
Wimp_CreateIcon = 0x400C2
Wimp_DeleteWindow = 0x400C3
Wimp_DeleteIcon = 0x400C4
Wimp_OpenWindow = 0x400C5
Wimp_CloseWindow = 0x400C6
Wimp_Poll = 0x400C7
Wimp_RedrawWindow = 0x400C8
Wimp_UpdateWindow = 0x400C9
Wimp_GetRectangle = 0x400CA
Wimp_GetWindowState = 0x400CB
Wimp_GetWindowInfo = 0x400CC
Wimp_SetIconState = 0x400CD
Wimp_GetIconState = 0x400CE
Wimp_GetPointerInfo = 0x400CF
Wimp_DragBox = 0x400D0
Wimp_ForceRedraw = 0x400D1
Wimp_SetCaretPosition = 0x400D2
Wimp_GetCaretPosition = 0x400D3
Wimp_CreateMenu = 0x400D4
Wimp_DecodeMenu = 0x400D5
Wimp_WhichIcon = 0x400D6
Wimp_SetExtent = 0x400D7
Wimp_SetPointerShape = 0x400D8
Wimp_OpenTemplate = 0x400D9
Wimp_CloseTemplate = 0x400DA
Wimp_LoadTemplate = 0x400DB
Wimp_ProcessKey = 0x400DC
Wimp_CloseDown = 0x400DD
Wimp_StartTask = 0x400DE
Wimp_ReportError = 0x400DF
Wimp_GetWindowOutline = 0x400E0
Wimp_PollIdle = 0x400E1
Wimp_PlotIcon = 0x400E2
Wimp_SetMode = 0x400E3
Wimp_SetPalette = 0x400E4
Wimp_ReadPalette = 0x400E5
Wimp_SetColour = 0x400E6
Wimp_SendMessage = 0x400E7
Wimp_CreateSubMenu = 0x400E8
Wimp_SpriteOp = 0x400E9
Wimp_BaseOfSprites = 0x400EA
Wimp_BlockCopy = 0x400EB
Wimp_SlotSize = 0x400EC
Wimp_ReadPixTrans = 0x400ED
Wimp_ClaimFreeMemory = 0x400EE
Wimp_CommandWindow = 0x400EF
Wimp_TextColour = 0x400F0
Wimp_TransferBlock = 0x400F1
Wimp_ReadSysInfo = 0x400F2
Wimp_SetFontColours = 0x400F3
Wimp_GetMenuState = 0x400F4
Wimp_RegisterFilter = 0x400F5
Wimp_AddMessages = 0x400F6
Wimp_RemoveMessages = 0x400F7
Wimp_SetColourMapping = 0x400F8
Wimp_TextOp = 0x400F9
Wimp_SetWatchdogState = 0x400FA
Wimp_Extend = 0x400FB
Wimp_ResizeIcon = 0x400FC

;// Sound SWIs
Sound_Configure = 0x40140
Sound_Enable = 0x40141
Sound_Stereo = 0x40142
Sound_Speaker = 0x40143
Sound_Mode = 0x40144
Sound_LinearHandler = 0x40145
Sound_SampleRate = 0x40146
Sound_Volume = 0x40180
Sound_SoundLog = 0x40181
Sound_LogScale = 0x40182
Sound_InstallVoice = 0x40183
Sound_RemoveVoice = 0x40184
Sound_AttachVoice = 0x40185
Sound_ControlPacked = 0x40186
Sound_Tuning = 0x40187
Sound_Pitch = 0x40188
Sound_Control = 0x40189
Sound_AttachNamedVoice = 0x4018A
Sound_ReadControlBlock = 0x4018B
Sound_WriteControlBlock = 0x4018C
Sound_QInit = 0x401C0
Sound_QSchedule = 0x401C1
Sound_QRemove = 0x401C2
Sound_QFree = 0x401C3
Sound_QSDispatch = 0x401C4
Sound_QTempo = 0x401C5
Sound_QBeat = 0x401C6
Sound_QInterface = 0x401C7

;// NetPrint SWIs
NetPrint_ReadPSNumber = 0x40200
NetPrint_SetPSNumber = 0x40201
NetPrint_ReadPSName = 0x40202
NetPrint_SetPSName = 0x40203
NetPrint_ReadPSTimeouts = 0x40204
NetPrint_SetPSTimeouts = 0x40205
NetPrint_BindPSName = 0x40206
NetPrint_ListServers = 0x40207
NetPrint_ConvertStatusToString = 0x40208

;// ADFS SWIs
ADFS_DiscOp = 0x40240
ADFS_HDC = 0x40241
ADFS_Drives = 0x40242
ADFS_FreeSpace = 0x40243
ADFS_Retries = 0x40244
ADFS_DescribeDisc = 0x40245
ADFS_VetFormat = 0x40246
ADFS_FlpProcessDCB = 0x40247
ADFS_ControllerType = 0x40248
ADFS_PowerControl = 0x40249
ADFS_SetIDEController = 0x4024A
ADFS_IDEUserOp = 0x4024B
ADFS_MiscOp = 0x4024C
ADFS_SectorDiscOp = 0x4024D
ADFS_ECCSAndRetries = 0x40250
ADFS_LockIDE = 0x40251
ADFS_FreeSpace64 = 0x40252

;// Podule (expansion card) SWIs
Podule_ReadID = 0x40280
Podule_ReadHeader = 0x40281
Podule_EnumerateChunks = 0x40282
Podule_ReadChunk = 0x40283
Podule_ReadBytes = 0x40284
Podule_WriteBytes = 0x40285
Podule_CallLoader = 0x40286
Podule_RawRead = 0x40287
Podule_RawWrite = 0x40288
Podule_HardwareAddress = 0x40289
Podule_EnumerateChunksWithInfo = 0x4028A
Podule_HardwareAddresses = 0x4028B
Podule_ReturnNumber = 0x4028C
Podule_ReadInfo = 0x4028D
Podule_SetSpeed = 0x4028E

;// Debugger SWI
Debugger_Disassemble = 0x40380

;// FPEmulator SWI
FPEmulator_Version = 0x40480

;// FileCore SWIs
FileCore_DiscOp = 0x40540
FileCore_Create = 0x40541
FileCore_Drives = 0x40542
FileCore_FreeSpace = 0x40543
FileCore_FloppyStructure = 0x40544
FileCore_DescribeDisc = 0x40545
FileCore_DiscardReadSectorsCache = 0x40546
FileCore_DiscFormat = 0x40547
FileCore_LayoutStructure = 0x40548
FileCore_MiscOp = 0x40549
FileCore_SectorOp = 0x4054A
FileCore_FreeSpace64 = 0x4054B

;// Shell (ShellCLI) SWIs
Shell_Create = 0x405C0
Shell_Destroy = 0x405C1

;// Hourglass SWIs
Hourglass_On = 0x406C0
Hourglass_Off = 0x406C1
Hourglass_Smash = 0x406C2
Hourglass_Start = 0x406C3
Hourglass_Percentage = 0x406C4
Hourglass_LEDs = 0x406C5
Hourglass_Colours = 0x406C6

;// Draw SWIs
Draw_ProcessPath = 0x40700
Draw_ProcessPathFP = 0x40701
Draw_Fill = 0x40702
Draw_FillFP = 0x40703
Draw_Stroke = 0x40704
Draw_StrokeFP = 0x40705
Draw_StrokePath = 0x40706
Draw_StrokePathFP = 0x40707
Draw_FlattenPath = 0x40708
Draw_FlattenPathFP = 0x40709
Draw_TransformPath = 0x4070A
Draw_TransformPathFP = 0x4070B

;// ColourTrans SWIs
ColourTrans_SelectTable = 0x40740
ColourTrans_SelectGCOLTable = 0x40741
ColourTrans_ReturnGCOL = 0x40742
ColourTrans_SetGCOL = 0x40743
ColourTrans_ReturnColourNumber = 0x40744
ColourTrans_ReturnGCOLForMode = 0x40745
ColourTrans_ReturnColourNumberForMode = 0x40746
ColourTrans_ReturnOppGCOL = 0x40747
ColourTrans_SetOppGCOL = 0x40748
ColourTrans_ReturnOppColourNumber = 0x40749
ColourTrans_ReturnOppGCOLForMode = 0x4074A
ColourTrans_ReturnOppColourNumberForMode = 0x4074B
ColourTrans_GCOLToColourNumber = 0x4074C
ColourTrans_ColourNumberToGCOL = 0x4074D
ColourTrans_ReturnFontColours = 0x4074E
ColourTrans_SetFontColours = 0x4074F
ColourTrans_InvalidateCache = 0x40750
ColourTrans_SetCalibration = 0x40751
ColourTrans_ReadCalibration = 0x40752
ColourTrans_ConvertDeviceColour = 0x40753
ColourTrans_ConvertDevicePalette = 0x40754
ColourTrans_ConvertRGBToCIE = 0x40755
ColourTrans_ConvertCIEToRGB = 0x40756
ColourTrans_WriteCalibrationToFile = 0x40757
ColourTrans_ConvertRGBToHSV = 0x40758
ColourTrans_ConvertHSVToRGB = 0x40759
ColourTrans_ConvertRGBToCMYK = 0x4075A
ColourTrans_ConvertCMYKToRGB = 0x4075B
ColourTrans_ReadPalette = 0x4075C
ColourTrans_WritePalette = 0x4075D
ColourTrans_SetColour = 0x4075E
ColourTrans_MiscOp = 0x4075F
ColourTrans_WriteLoadingsToFile = 0x40760
ColourTrans_SetTextColour = 0x40761
ColourTrans_SetOppTextColour = 0x40762
ColourTrans_SelectTable = 0x40763

;// RamFS SWIs
RamFS_DiscOp = 0x40780
RamFS_Drives = 0x40782
RamFS_FreeSpace = 0x40783
RamFS_DescribeDisc = 0x40785

;// SuperSample SWIs
Super_Sample90 = 0x40D80
Super_Sample45 = 0x40D81

;// Filer_Action SWIs
FilerAction_SendSelectedDirectory = 0x40F80
FilerAction_SendSelectedFile = 0x40F81
FilerAction_SendStartOperation = 0x40F82

;// Socket (Internet) SWIs
Socket_Creat = 0x41200
Socket_Bind = 0x41201
Socket_Listen = 0x41202
Socket_Accept = 0x41203
Socket_Connect = 0x41204
Socket_Recv = 0x41205
Socket_Recvfrom = 0x41206
Socket_Recvmsg = 0x41207
Socket_Send = 0x41208
Socket_Sendto = 0x41209
Socket_Sendmsg = 0x4120A
Socket_Shutdown = 0x4120B
Socket_Setsockopt = 0x4120C
Socket_Getsockopt = 0x4120D
Socket_Getpeername = 0x4120E
Socket_Getsockname = 0x4120F
Socket_Close = 0x41210
Socket_Select = 0x41211
Socket_Ioctl = 0x41212
Socket_Read = 0x41213
Socket_Write = 0x41214
Socket_Stat = 0x41215
Socket_Readv = 0x41216
Socket_Writev = 0x41217
Socket_Gettsize = 0x41218
Socket_Sendtosm = 0x41219

;// CD SWIs
CD_Version = 0x41240
CD_ReadData = 0x41241
CD_SeekTo = 0x41242
CD_DriveStatus = 0x41243
CD_DriveReady = 0x41244
CD_GetParameters = 0x41245
CD_SetParameters = 0x41246
CD_OpenDrawer = 0x41247
CD_EjectButton = 0x41248
CD_EnquireAddress = 0x41249
CD_EnquireDataMode = 0x4124A
CD_PlayAudio = 0x4124B
CD_PlayTrack = 0x4124C
CD_AudioPause = 0x4124D
CD_EnquireTrack = 0x4124E
CD_ReadSubChannel = 0x4124F
CD_CheckDrive = 0x41250
CD_DiscChanged = 0x41251
CD_StopDisc = 0x41252
CD_DiscUsed = 0x41253
CD_AudioStatus = 0x41254
CD_Inquiry = 0x41255
CD_DiscHasChanged = 0x41256
CD_Control = 0x41257
CD_Supported = 0x41258
CD_Prefetch = 0x41259
CD_Reset = 0x4125A
CD_CloseDrawer = 0x4125B
CD_IsDrawerLocked = 0x4125C
CD_AudioControl = 0x4125D
CD_LastError = 0x4125E
CD_AudioLevel = 0x4125F
CD_Register = 0x41260
CD_Unregister = 0x41261
CD_ByteCopy = 0x41262
CD_Identify = 0x41263
CD_ConvertToLBA = 0x41264
CD_ConvertToMSF = 0x41265
CD_ReadAudio = 0x41266
CD_ReadUserData = 0x41267
CD_SeekUserData = 0x41268
CD_GetAudioParms = 0x41269
CD_SetAudioParms = 0x4126A

;// MessageTrans SWIs
MessageTrans_FileInfo = 0x41500
MessageTrans_OpenFile = 0x41501
MessageTrans_Lookup = 0x41502
MessageTrans_MakeMenus = 0x41503
MessageTrans_CloseFile = 0x41504
MessageTrans_EnumerateTokens = 0x41505
MessageTrans_ErrorLookup = 0x41506
MessageTrans_GSLookup = 0x41507
MessageTrans_CopyError = 0x41508
MessageTrans_Dictionary = 0x41509

;// PDumper (printer dumper) SWIs
PDumper_Info = 0x41B00
PDumper_Claim = 0x41B01
PDumper_Free = 0x41B02
PDumper_Find = 0x41B03
PDumper_StartJob = 0x41B04
PDumper_TidyJob = 0x41B05
PDumper_SetColour = 0x41B06
PDumper_PrepareStrip = 0x41B07
PDumper_LookupError = 0x41B08
PDumper_CopyFilename = 0x41B09

;// ResourceFS SWIs
ResourceFS_RegisterFiles = 0x41B40
ResourceFS_DeregisterFiles = 0x41B41

;// CDFS SWIs
CDFS_ConvertDriveToDevice = 0x41E80
CDFS_SetBufferSize = 0x41E81
CDFS_GetBufferSize = 0x41E82
CDFS_SetNumberOfDrives = 0x41E83
CDFS_GetNumberOfDrives = 0x41E84
CDFS_GiveFileType = 0x41E85
CDFS_DescribeDisc = 0x41E86
CDFS_WhereIsFile = 0x41E87
CDFS_Truncation = 0x41E88

;// DragASprite SWIs
DragASprite_Start = 0x42400
DragASprite_Stop = 0x42401

;// Filter manager SWIs
Filter_RegisterPreFilter = 0x42640
Filter_RegisterPostFilter = 0x42641
Filter_DeRegisterPreFilter = 0x42642
Filter_DeRegisterPostFilter = 0x42643

;// TaskManager SWIs
TaskManager_TaskNameFromHandle = 0x42680
TaskManager_EnumerateTasks = 0x42681
TaskManager_Shutdown = 0x42682

;// Squash SWIs
Squash_Compress = 0x42700
Squash_Decompress = 0x42701

;// DeviceFS SWIs
DeviceFS_Register = 0x42740
DeviceFS_Deregister = 0x42741
DeviceFS_RegisterObjects = 0x42742
DeviceFS_DeregisterObjects = 0x42743
DeviceFS_CallDevice = 0x42744
DeviceFS_Threshold = 0x42745
DeviceFS_ReceivedCharacter = 0x42746
DeviceFS_TransmitCharacter = 0x42747

;// Buffer Manager SWIs
Buffer_Create = 0x42940
Buffer_Remove = 0x42941
Buffer_Register = 0x42942
Buffer_Deregister = 0x42943
Buffer_ModifyFlags = 0x42944
Buffer_LinkDevice = 0x42945
Buffer_UnlinkDevice = 0x42946
Buffer_GetInfo = 0x42947
Buffer_Threshold = 0x42948
Buffer_InternalInfo = 0x42949

;// BASICTrans SWIs
BASICTrans_HELP = 0x42C80
BASICTrans_Error = 0x42C81
BASICTrans_Message = 0x42C82

;// Parallel port driver SWIs
Parallel_HardwareAddress = 0x42EC0
Parallel_Op = 0x42EC1

;// Portable SWIs
Portable_Speed = 0x42FC0
Portable_Control = 0x42FC1
Portable_ReadBMUVariable = 0x42FC2
Portable_WriteBMUVariable = 0x42FC3
Portable_CommandBMU = 0x42FC4

;// Territory manager SWIs
Territory_Number = 0x43040
Territory_Register = 0x43041
Territory_Deregister = 0x43042
Territory_NumberToName = 0x43043
Territory_Exists = 0x43044
Territory_AlphabetNumberToName = 0x43045
Territory_SelectAlphabet = 0x43046
Territory_SetTime = 0x43047
Territory_ReadCurrentTimeZone = 0x43048
Territory_ConvertTimeToUTCOrdinals = 0x43049
Territory_ReadTimeZones = 0x4304A
Territory_ConvertDateAndTime = 0x4304B
Territory_ConvertStandardDateAndTime = 0x4304C
Territory_ConvertStandardDate = 0x4304D
Territory_ConvertStandardTime = 0x4304E
Territory_ConvertTimeToOrdinals = 0x4304F
Territory_ConvertTimeStringToOrdinals = 0x43050
Territory_ConvertOrdinalsToTime = 0x43051
Territory_Alphabet = 0x43052
Territory_AlphabetIdentifier = 0x43053
Territory_SelectKeyboardHandler = 0x43054
Territory_WriteDirection = 0x43055
Territory_CharacterPropertyTable = 0x43056
Territory_LowerCaseTable = 0x43057
Territory_UpperCaseTable = 0x43058
Territory_ControlTable = 0x43059
Territory_PlainTable = 0x4305A
Territory_ValueTable = 0x4305B
Territory_RepresentationTable = 0x4305C
Territory_Collate = 0x4305D
Territory_ReadSymbols = 0x4305E
Territory_ReadCalendarInformation = 0x4305F
Territory_NameToNumber = 0x43060
;//Territory_NameToNumber = 0x43061  // again? error?
Territory_ConvertTextToString = 0x43075

;// ScreenBlanker SWI
ScreenBlanker_Control = 0x43100

;// TaskWindow SWI
TaskWindow_TaskInfo = 0x43380

;// MakePSFont SWI
MakePSFont_MakeFont = 0x43440

;// Joystick SWI
Joystick_Read = 0x43F40
Joystick_CalibrateTopRight = 0x43F41
Joystick_CalibrateBottomLeft = 0x43F42

;// Free space display SWIs
Free_Register = 0x444C0
Free_DeRegister = 0x444C1

;// FSLock SWIs
FSLock_Version = 0x44780
FSLock_Status = 0x44781
FSLock_ChangeStatus = 0x44782

;// DOSFS SWIs
DOSFS_DiscFormat = 0x44B00
DOSFS_LayoutStructure = 0x44B01

;// Toolbox SWIs
Toolbox_CreateObject = 0x44EC0
Toolbox_DeleteObject = 0x44EC1
Toolbox_CopyObject = 0x44EC2
Toolbox_ShowObject = 0x44EC3
Toolbox_HideObject = 0x44EC4
Toolbox_GetObjectInfo = 0x44EC5
Toolbox_ObjectMiscOp = 0x44EC6
Toolbox_SetClientHandle = 0x44EC7
Toolbox_GetClientHandle = 0x44EC8
Toolbox_GetObjectClass = 0x44EC9
Toolbox_GetParent = 0x44ECA
Toolbox_GetAncestor = 0x44ECB
Toolbox_GetTemplateName = 0x44ECC
Toolbox_RaiseToolboxEvent = 0x44ECD
Toolbox_GetSysInfo = 0x44ECE
Toolbox_Initialise = 0x44ECF
Toolbox_LoadResources = 0x44ED0
Toolbox_TemplateLookUp = 0x44EFB
Toolbox_GetInternalHandle = 0x44EFC
Toolbox_RegisterPostFilter = 0x44EFD
Toolbox_RegisterPreFilter = 0x44EFE
Toolbox_RegisterObjectModule = 0x44EFF

;// DrawFile SWIs
DrawFile_Render = 0x45540
DrawFile_BBox = 0x45541
DrawFile_DeclareFonts = 0x45542

;// DMA SWIs
DMA_RegisterChannel = 0x46140
DMA_DeregisterChannel = 0x46141
DMA_QueueTransfer = 0x46142
DMA_TerminateTransfer = 0x46143
DMA_SuspendTransfer = 0x46144
DMA_ResumeTransfer = 0x46145
DMA_ExamineTransfer = 0x46146

;// ColourPicker SWIs
ColourPicker_RegisterModel = 0x47700
ColourPicker_DeregisterModel = 0x47701
ColourPicker_OpenDialogue = 0x47702
ColourPicker_CloseDialogue = 0x47703
ColourPicker_UpdateDialogue = 0x47704
ColourPicker_ReadDialogue = 0x47705
ColourPicker_SetColour = 0x47706
ColourPicker_HelpReply = 0x47707
ColourPicker_ModelSWI = 0x47708

;// RemotePrinterSupport SWIs
RemotePrinterSupport_ReadPollwordLocation = 0x47980
RemotePrinterSupport_GetNextEvent = 0x47981
RemotePrinterSupport_ReadUniqueAddress = 0x47982
RemotePrinterSupport_Enable = 0x47983
RemotePrinterSupport_Disable = 0x47984
RemotePrinterSupport_EnableUpcalls = 0x47985
RemotePrinterSupport_DisableUpcalls = 0x47986

;// Freeway SWIs
Freeway_Register = 0x47A80
Freeway_Write = 0x47A81
Freeway_Read = 0x47A82
Freeway_Enumerate = 0x47A83
Freeway_Status = 0x47A84

;// ShareFS SWIs
ShareFS_CreateShare = 0x47AC0
ShareFS_EnumerateShares = 0x47AC1
ShareFS_StopShare = 0x47AC2

;// ScreenModes SWI
ScreenModes_ReadInfo = 0x487C0

;// JPEG SWIs
JPEG_Info = 0x49980
JPEG_FileInfo = 0x49981
JPEG_PlotScaled = 0x49982
JPEG_PlotFileScaled = 0x49983
JPEG_PlotTransformed = 0x49984
JPEG_PlotFileTransformed = 0x49985
JPEG_PDriverIntercept = 0x49986

;// DragAnObject SWIs
DragAnObject_Start = 0x49C40
DragAnObject_Stop = 0x49C41

;// CompressJPEG SWIs
CompressJPEG_Start = 0x4A500
CompressJPEG_WriteLine = 0x4A501
CompressJPEG_Finish = 0x4A502

;// Mbuf SWIs
Mbuf_OpenSession = 0x4A580
Mbuf_CloseSession = 0x4A581
Mbuf_Memory = 0x4A582
Mbuf_Statistic = 0x4A583
Mbuf_Control = 0x4A584

;// ATAPI SWI
ATAPI_GetDrives = 0x4A740

;// PDriver (printer driver) SWIs
PDriver_Info = 0x80140
PDriver_SetInfo = 0x80141
PDriver_CheckFeatures = 0x80142
PDriver_PageSize = 0x80143
PDriver_SetPageSize = 0x80144
PDriver_SelectJob = 0x80145
PDriver_CurrentJob = 0x80146
PDriver_FontSWI = 0x80147
PDriver_EndJob = 0x80148
PDriver_AbortJob = 0x80149
PDriver_Reset = 0x8014A
PDriver_GiveRectangle = 0x8014B
PDriver_DrawPage = 0x8014C
PDriver_GetRectangle = 0x8014D
PDriver_CancelJob = 0x8014E
PDriver_ScreenDump = 0x8014F
PDriver_EnumerateJobs = 0x80150
PDriver_SetPrinter = 0x80151
PDriver_CancelJobWithError = 0x80152
PDriver_SelectIllustration = 0x80153
PDriver_InsertIllustration = 0x80154
PDriver_DeclareFont = 0x80155
PDriver_DeclareDriver = 0x80156
PDriver_RemoveDriver = 0x80157
PDriver_SelectDriver = 0x80158
PDriver_EnumerateDrivers = 0x80159
PDriver_MiscOp = 0x8015A
PDriver_MiscOpForDriver = 0x8015B
PDriver_SetDriver = 0x8015C
PDriver_JPEGSWI = 0x8015D

;// SharedCLibrary SWIs
SharedCLibrary_LibInitAPCS_A = 0x80680
SharedCLibrary_LibInitAPCS_R = 0x80681
SharedCLibrary_LibInitModule = 0x80682

;// Window SWIs
Window_ClassSWI = 0x82880
Window_PostFilter = 0x82881
Window_PreFilter = 0x82882
Window_GetPointerInfo = 0x82883
Window_WimpToToolbox = 0x82884
Window_RegisterExternal = 0x82885
Window_DeregisterExternal = 0x82886
Window_SupportExternal = 0x82887

;// Menu SWIs
Menu_ClassSWI = 0x828C0
Menu_PostFilter = 0x828C1
Menu_PreFilter = 0x828C2
Menu_UpdateTree = 0x828C3

;// Iconbar SWIs
Iconbar_ClassSWI = 0x82900
Iconbar_PostFilter = 0x82901
Iconbar_PreFilter = 0x82902

;// ColourMenu SWIs
ColourMenu_ClassSWI = 0x82980
ColourMenu_PostFilter = 0x82981
ColourMenu_PreFilter = 0x82982

;// ColourDbox SWIs
ColourDbox_ClassSWI = 0x829C0
ColourDbox_PostFilter = 0x829C1
ColourDbox_PreFilter = 0x829C2

;// FontDbox SWIs
FontDbox_ClassSWI = 0x82A00
FontDbox_PostFilter = 0x82A01
FontDbox_PreFilter = 0x82A02

;// FontMenu SWIs
FontMenu_ClassSWI = 0x82A40
FontMenu_PostFilter = 0x82A41
FontMenu_PreFilter = 0x82A42

;// DCS (Discard, Cancel, Save) SWIs
DCS_ClassSWI = 0x82A80
DCS_PostFilter = 0x82A81
DCS_PreFilter = 0x82A82

;// FileInfo SWIs
FileInfo_ClassSWI = 0x82AC0
FileInfo_PostFilter = 0x82AC1
FileInfo_PreFilter = 0x82AC2

;// PrintDbox SWIs
PrintDbox_ClassSWI = 0x82B00
PrintDbox_PostFilter = 0x82B01
PrintDbox_PreFilter = 0x82B02

;// ProgInfo SWIs
ProgInfo_ClassSWI = 0x82B40
ProgInfo_PostFilter = 0x82B41
ProgInfo_PreFilter = 0x82B42

;// SaveAs SWIs
SaveAs_ClassSWI = 0x82BC0
SaveAs_PostFilter = 0x82BC1
SaveAs_PreFilter = 0x82BC2

;// Scale SWIs
Scale_ClassSWI = 0x82C00
Scale_PostFilter = 0x82C01
Scale_PreFilter = 0x82C02

;// TinySupport SWIs
TinySupport_Init = 0x82C40
TinySupport_Die = 0x82C41
TinySupport_Init2 = 0x82C42
TinySupport_Share = 0x82C43

;///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
;// RISCOSOPEN.ORG                                                                                                    //
;///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

;// OS SWI Calls (https://www.riscosopen.org/wiki/documentation/show/OS%20SWI%20Calls)
OS_AbortTrap = 0x67
OS_AMBControl = 0x70
OS_CallASWI = 0x6F
OS_CallASWIR12 = 0x71
OS_ConvertHex6 = 0xD3
OS_ConvertVariform = 0xED
OS_EnterUSR26 = 0x74
OS_EnterUSR32 = 0x73
OS_Hardware = 0x7A
OS_HeapSort32 = 0x7F
OS_IICOp = 0x7B
OS_LeaveOS = 0x7C
OS_NVMemory = 0x76
OS_PlatformFeatures = 0x6D
OS_ReadLine32 = 0x7D
OS_ResyncTime = 0x6C
OS_SubstituteArgs32 = 0x7E
OS_SynchroniseCodeAreas = 0x6E
;// ...other SWIs are already defined above

;// AcornSSL SWI Calls (https://www.riscosopen.org/wiki/documentation/show/AcornSSL%20SWI%20Calls)
AcornSSL_Creat = 0x50F80
AcornSSL_Ioctl = 0x50F81
AcornSSL_Connect = 0x50F82
AcornSSL_Shutdown = 0x50F83
AcornSSL_Close = 0x50F84
AcornSSL_Getsockopt = 0x50F85
AcornSSL_Write = 0x50F86
AcornSSL_Recv = 0x50F87
AcornSSL_CreateSession = 0x50F88
AcornSSL_Getpeername = 0x50F89
AcornSSL_Getsockname = 0x50F8A
AcornSSL_Setsockopt = 0x50F8B
AcornSSL_Stat = 0x50F8C
AcornSSL_Version = 0x50F8D
AcornSSL_Read = 0x50F8E
AcornSSL_Send = 0x50F8F

;// ADFS SWI Calls (https://www.riscosopen.org/wiki/documentation/show/ADFS%20SWI%20Calls)
ADFS_DiscOp64 = 0x40254
ADFS_IDEDeviceInfo = 0x40253
;// ...other SWIs are already defined above

;// BCMSupport SWI Calls (https://www.riscosopen.org/wiki/documentation/show/BCMSupport%20SWI%20Calls)
BCMSupport_SendMBMessage = 0x591C0
BCMSupport_MBSync = 0x591C1
BCMSupport_AllocPropertyBuffer = 0x591C2
BCMSupport_FreePropertyBuffer = 0x591C3
BCMSupport_SendPropertyBuffer = 0x591C4
BCMSupport_SendTempPropertyBuffer = 0x591C5

;// BlendTable SWI Calls (https://www.riscosopen.org/wiki/documentation/show/BlendTable%20SWI%20Calls)
BlendTable_GenerateTable = 0x56280
BlendTable_UnlockTable = 0x56281

;// CDFSDriver SWI Calls (https://www.riscosopen.org/wiki/documentation/show/CDFSDriver%20SWI%20Calls)
CD_SCSIUserOp = 0x4126B
;// ...other SWIs are already defined above

;// Debugger SWI Calls (https://www.riscosopen.org/wiki/documentation/show/Debugger%20SWI%20Calls)
Debugger_DisassembleThumb = 0x40381
;// ...other SWIs are already defined above

;// DMAManager SWI Calls (https://www.riscosopen.org/wiki/documentation/show/DMAManager%20SWI%20Calls)
DMA_AllocateLogicalChannels = 0x46147
;// ...other SWIs are already defined above

;// Draw Module SWI Calls (https://www.riscosopen.org/wiki/documentation/show/Draw%20Module%20SWI%20Calls)
Draw_FillClipped = 0x4070C
Draw_FlattenPath = 0x40708
Draw_StrokeClipped = 0x4070E
;// ...other SWIs are already defined above

;// FileCore SWI Calls (https://www.riscosopen.org/wiki/documentation/show/FileCore%20SWI%20Calls)
FileCore_DiscOp64 = 0x4054C
FileCore_Features = 0x4054D
;// ...other SWIs are already defined above

;// FilterManager SWI Calls (https://www.riscosopen.org/wiki/documentation/show/FilterManager%20SWI%20Calls)
Filter_RegisterCopyFilter = 0x42646
Filter_RegisterPostIconFilter = 0x4264A
Filter_RegisterPostRectFilter = 0x42648
Filter_RegisterRectFilter = 0x42644
Filter_DeRegisterCopyFilter = 0x42647
Filter_DeRegisterPostIconFilter = 0x4264B
Filter_DeRegisterPostRectFilter = 0x42649
Filter_DeRegisterRectFilter = 0x42645
;// ...other SWIs are already defined above

;// FontManager SWI Calls (https://www.riscosopen.org/wiki/documentation/show/FontManager%20SWI%20Calls)
Font_EnumerateCharacters = 0x400A9
;// ...other SWIs are already defined above

;// FPEmulator SWI Calls
FPEmulator_Abort = 0x40487
FPEmulator_ActivateContext = 0x40481
FPEmulator_ChangeContext = 0x40483
FPEmulator_ContextLength = 0x40484
FPEmulator_DeactivateContext = 0x40482  ;// 0x40481 in documentation (the same as FPEmulator_ActivateContext, apparently this is an error)
FPEmulator_ExceptionDump = 0x40486
FPEmulator_InitContext = 0x40485
FPEmulator_LoadContext = 0x40488
FPEmulator_SaveContext = 0x40489
;// ...other SWIs are already defined above

;// Freeway SWI Calls (https://www.riscosopen.org/wiki/documentation/show/Freeway%20SWI%20Calls)
Freeway_Serial = 0x47A85
;// ...other SWIs are already defined above

;// GPIO SWI Calls (https://www.riscosopen.org/wiki/documentation/show/GPIO%20SWI%20Calls)
GPIO_ReadData = 0x58F80

;// InverseTable SWI Calls (https://www.riscosopen.org/wiki/documentation/show/InverseTable%20SWI%20Calls)
InverseTable_Calculate = 0x4BF40
InverseTable_SpriteTable = 0x4BF41

;// PCI SWI Calls (https://www.riscosopen.org/wiki/documentation/show/PCI%20SWI%20Calls)
PCI_ConfigurationRead = 0x50388
PCI_ConfigurationWrite = 0x50389
PCI_EnumerateFunctions = 0x50383
PCI_FindByClass = 0x5038F
PCI_FindByID = 0x5038E
PCI_FindByLocation = 0x5038D
PCI_HardwareAddress = 0x5038A
PCI_IORead = 0x50384
PCI_IOWrite = 0x50385
PCI_LogicalAddress = 0x50392
PCI_MemoryRead = 0x50386
PCI_MemoryWrite = 0x50387
PCI_RAMAlloc = 0x50390
PCI_RAMFree = 0x50391
PCI_ReadHeader = 0x50381
PCI_ReadID = 0x50380
PCI_ReadInfo = 0x5038B
PCI_ReturnNumber = 0x50382
PCI_SpecialCycle = 0x5038C

;// Portable SWI Calls (https://www.riscosopen.org/wiki/documentation/show/Portable%20SWI%20Calls)
Portable_EnumerateBMU = 0x42FD0
Portable_Idle = 0x42FC6
Portable_ReadBMUVariables = 0x42FD1
Portable_ReadFeatures = 0x42FC5
Portable_ReadSensor = 0x42FD2
Portable_SleepTime = 0x42FCC
Portable_Speed2 = 0x42FCE
Portable_Status = 0x42FC8
Portable_Stop = 0x42FC7
;// ...other SWIs are already defined above

;// RamFS SWI Calls (https://www.riscosopen.org/wiki/documentation/show/RamFS%20SWI%20Calls)
RamFS_DiscOp64 = 0x40785
;// ...other SWIs are already defined above

;// RTC SWI Calls (https://www.riscosopen.org/wiki/documentation/show/RTC%20SWI%20Calls)
RTC_Adjust = 0x594C3
RTC_Features = 0x594C0
RTC_Read = 0x594C1
RTC_Write = 0x594C2

;// RTSupport SWI Calls (https://www.riscosopen.org/wiki/documentation/show/RTSupport%20SWI%20Calls)
RT_ChangePriority = 0x575C4
RT_Deregister = 0x575C1
RT_ReadInfo = 0x575C5
RT_Register = 0x575C0
RT_TimedYield = 0x575C3
RT_Yield = 0x575C2

;// ScreenModes SWI Calls (https://www.riscosopen.org/wiki/documentation/show/ScreenModes%20SWI%20Calls)
ScreenModes_EnumerateAudioFormats = 0x487C1
ScreenModes_Features = 0x487C2
;// ...other SWIs are already defined above

;// SDIODriver SWI Calls (https://www.riscosopen.org/wiki/documentation/show/SDIODriver%20SWI%20Calls)
SDIO_ClaimDeviceVector = 0x59006
SDIO_Control = 0x59001
SDIO_ControllerFeatures = 0x59003
SDIO_Enumerate = 0x59002
SDIO_Initialise = 0x59000
SDIO_Op = 0x59005
SDIO_ReadRegister = 0x59004
SDIO_ReleaseDeviceVector = 0x59007

;// SharedCLibrary SWI Calls (https://www.riscosopen.org/wiki/documentation/show/SharedCLibrary%20SWI%20Calls)
SharedCLibrary_LibInitAPCS_32 = 0x80683
;// ...other SWIs are already defined above

;// SharedSound SWI Calls (https://www.riscosopen.org/wiki/documentation/show/SharedSound%20SWI%20Calls)
SharedSound_HandlerInfo = 0x4B442
SharedSound_HandlerVolume = 0x4B443
SharedSound_InstallDriver = 0x4B447
SharedSound_InstallHandler = 0x4B440
SharedSound_RemoveHandler = 0x4B441
SharedSound_SampleRate = 0x4B446

;// SoundControl SWI Calls (https://www.riscosopen.org/wiki/documentation/show/SoundControl%20SWI%20Calls)
SoundCtrl_ExamineMixer = 0x50000
SoundCtrl_SetMix = 0x50001
SoundCtrl_GetMix = 0x50002

;// SoundDMA SWI Calls (https://www.riscosopen.org/wiki/documentation/show/SoundDMA%20SWI%20Calls)
Sound_ControllerInfo = 0x4014A
Sound_EnumerateControllers = 0x40149
Sound_ReadSysInfo = 0x40147
Sound_SelectDefaultController = 0x40148
;// ...other SWIs are already defined above

;// TaskManager SWI Calls (https://www.riscosopen.org/wiki/documentation/show/TaskManager%20SWI%20Calls)
TaskManager_StartTask = 0x42683
;// ...other SWIs are already defined above

;// Territory SWI Calls (https://www.riscosopen.org/wiki/documentation/show/Territory%20SWI%20Calls)
Territory_ConvertTimeFormats = 0x43078
Territory_DaylightRules = 0x43063
Territory_DaylightSaving = 0x43077
Territory_IME = 0x43062
Territory_Select = 0x43076
Territory_TransformString = 0x43061
;// ...other SWIs are already defined above

;// URL_Fetcher SWI Calls (https://www.riscosopen.org/wiki/documentation/show/URL_Fetcher%20SWI%20Calls)
URL_Register = 0x83E00
URL_GetURL = 0x83E01
URL_Status = 0x83E02
URL_ReadData = 0x83E03
URL_SetProxy = 0x83E04
URL_Stop = 0x83E05
URL_Deregister = 0x83E06
URL_ParseURL = 0x83E07
URL_EnumerateSchemes = 0x83E08
URL_EnumerateProxies = 0x83E09
URL_ProtocolRegister = 0x83E20
URL_ProtocolDeregister = 0x83E21

;// USBDriver SWI Calls (https://www.riscosopen.org/wiki/documentation/show/USBDriver%20SWI%20Calls)
USBDriver_RegisterBus = 0x54A40
USBDriver_DeregisterBus = 0x54A41
USBDriver_InsertTransfer = 0x54A42
USBDriver_TransferComplete = 0x54A43
USBDriver_ScheduleSoftInterrupt = 0x54A44
USBDriver_Version = 0x54A45

;// UtilityModule SWI Calls (https://www.riscosopen.org/wiki/documentation/show/UtilityModule%20SWI%20Calls)
ARM_IMB = 0xF00000
ARM_IMBRange = 0xF00001

;// VFPSupport SWI Calls (https://www.riscosopen.org/wiki/documentation/show/VFPSupport%20SWI%20Calls)
VFPSupport_CheckContext = 0x58EC0
VFPSupport_CreateContext = 0x58EC1
VFPSupport_DestroyContext = 0x58EC2
VFPSupport_ChangeContext = 0x58EC3
VFPSupport_ExamineContext = 0x58EC4
VFPSupport_FastAPI = 0x58EC5
VFPSupport_ActiveContext = 0x58EC6
VFPSupport_Version = 0x58EC7
VFPSupport_Features = 0x58EC8
VFPSupport_ExceptionDump = 0x58EC9
VFPSupport_ElementaryFunctions = 0x58ECA

;// WindowManager SWI Calls (https://www.riscosopen.org/wiki/documentation/show/WindowManager%20SWI%20Calls)
Wimp_AutoScroll = 0x400FD
;// ...other SWIs are already defined above
