;****************************************************************
;*  maxdemo.asm
;*			Demo mit Grafik und Text fr ZX81 (24KB)
;*			========================================
;*
;*  10.02.99	Bodo Wenzel	V1.0, Erstellung als ZX97DEMO
;*  09.03.99	Bodo Wenzel	bernahme als ladbare MAXDEMO
;****************************************************************

	title	"MAXDEMO V1.0"

;= Test auf Assemblierungsvarianten =============================
;	TXT=1	Textdemo
;	HRG=1	Grafikdemo
;	beide	Kombidemo

	if	(not def TXT) or (not def HRG)
	error	"TXT und HRG definieren!"
	else
	if	(TXT=0) and (HRG=0)
	error	"Mindestens eins von TXT oder HRG auf 1 setzen!"
	endif
	endif

;= Platzierung bestimmen ========================================

p81	segment	4009H,0BFFFH

;= I/O ==========================================================

NMI_OFF		equ	0FDH	;per OUT
NMI_ON		equ	0FEH	;per OUT
VSYNC_ON	equ	0FEH	;per IN
HSYNC_ON	equ	0FFH	;per OUT

;= Konstanten ===================================================

;	ACHTUNG! Da die Bilderzeugung extrem vom durchlaufenen
;	Maschinencode abhngt, knnen diese Konstanten nicht
;	ohne weiteres gendert werden! Sie dienen nur der
;	besseren Lesbarkeit.

LINES		equ	30	;Anzahl Textzeilen
COLUMNS		equ	40	;Anzahl Textspalten
OFFS		equ	64	;nchstgrere 2er-Potenz
LINES_TOP	equ	3	;Leerzeilen oben
MARGIN_TOP	equ	8*LINES_TOP-1-1
MARGIN_BOTTOM	equ	312-(1+1+6+MARGIN_TOP+1+1+8*LINES)
;sorry, keine 60 Hz mglich, damit es auf's LCD pat

		if	TXT
FONT		equ	1E00H	;Adresse des Fonts
		endif

		if	HRG
N_SQUIXX	equ	8	;mu gerade sein
		endif

;= BASIC-Systemvariablen ========================================

	db	0		;VERSN
	dw	0		;E_PPC
	dw	dsp		;D_FILE
	dw	dsp+1		;DF_CC
	dw	var		;VARS
	dw	0		;DEST
	dw	last		;E_LINE
	dw	line10-1	;CH_ADD
	dw	0C000H		;X_PTR
	dw	last		;STKBOT
	dw	last		;STKEND
	db	0		;BERG
	dw	membot		;MEM
	db	0		;unbenutzt
	db	2		;DF_SZ
	dw	0		;S_TOP
	db	0FFH,0FFH,0FFH	;LAST_K
	db	55		;MARGIN
	dw	line10		;NXTLIN
	dw	0		;OLDPPC
	db	0		;FLAGX
	dw	0		;STRLEN
	dw	0C8DH		;T_ADDR
	dw	0		;SEED
	dw	0FFFFH		;FRAMES
	db	0,0		;COORDS
	db	0BCH		;PR_CC
	db	33,24		;S_POSN
	db	01000000B	;CDFLAG
	ds	33		;Ausgabepuffer
membot:	ds	30		;Rechenpuffer
	ds	2		;unbenutzt

;= Erste BASIC-Zeile ============================================

line1:	db	0,1
	dw	line10-$-2
	db	0EAH		;REM

;= Start ========================================================

	out	(NMI_OFF),a	;Bildausgabe stoppen

;- Textausgabe vorbereiten --------------------------------------

	if	TXT

	ld	sp,txt_stack+(8*LINES*2)*2
	ld	a,LINES
	ld	hl,txt_mem+8000H+LINES*(COLUMNS+1)
	ld	de,-(COLUMNS+1)
	ld	bc,show_next
ti_loop1:
	add	hl,de
	ex	af,af'
	ld	a,8
ti_loop2:
	push	bc
	push	hl
	dec	a
	jr	nz,ti_loop2
	ex	af,af'
	dec	a
	jr	nz,ti_loop1	;Stack fr Textausgabe setzen

	ld	hl,show_end	;Ende fr letzte Zeile
	ld	(txt_stack+(8*LINES*2)*2-2),hl

	if	not HRG

	ld	a,0FEH and (high FONT)
	ld	i,a		;MSBits des Fonts setzen

	endif

	endif

;- Grafikausgabe vorbereiten ------------------------------------

	if	HRG

	if	TXT

	ld	sp,hrg_stack+(8*LINES*2)*2
	ld	hl,hrg_mem+8*LINES*OFFS
	ld	de,-OFFS
	ld	a,8*LINES/2
	ld	bc,show_switch
gi_loop1:
	add	hl,de
	push	hl
	push	bc
	dec	a
	jr	nz,gi_loop1
	ld	a,8*LINES/2
	ld	bc,hrg_dummy+8000H
gi_loop2:
	add	hl,de
	push	hl
	push	bc
	dec	a
	jr	nz,gi_loop2	;Stack fr Bildausgabe setzen

	else

	ld	sp,hrg_stack+(1+8*LINES*2)*2
	ld	hl,show_end
	push	hl
	ld	hl,hrg_mem+8*LINES*OFFS
	ld	de,-OFFS
	ld	a,8*LINES
	ld	bc,hrg_dummy+8000H
gi_loop:
	add	hl,de
	push	hl
	push	bc
	dec	a
	jr	nz,gi_loop	;Stack fr Bildausgabe setzen

	endif

	endif

;- Stack setzen -------------------------------------------------

	ld	sp,stack	;dies ist der "echte" Stack

;- Bild entpacken -----------------------------------------------

	if	HRG

	ld	hl,packed
	ld	de,hrg_mem+8*LINES*(OFFS-COLUMNS)
	ld	b,1		;Auspacken vorbereiten
	push	bc
unp_loop:
	pop	bc

	push	hl
	ld	hl,10000H-hrg_memend
	add	hl,de
	pop	hl
	jr	c,expand	;fertig mit Auspacken?

	djnz	unp_goon	;noch Bits im Prefixbyte?

	ld	c,(hl)		;nchstes Prefixbyte
	inc	hl
	ld	b,8		;Bitzhler zurcksetzen

unp_goon:
	rl	c
	push	bc
	jr	c,unp_repl	;Wiederholung?

	ldi			;Byte direkt kopieren
	jr	unp_loop

unp_repl:
	ld	c,(hl)
	inc	hl
	ld	a,(hl)
	and	0fh
	ld	b,a
	rld
	inc	hl		;Anzahl und Offset holen

	push	hl
	ld	hl,-3
	sbc	hl,bc
	add	hl,de
	add	a,3
	ld	c,a
	ld	b,0
	ldir
	pop	hl		;Wiederholung kopieren
	jr	unp_loop

expand:
	ld	hl,hrg_mem+8*LINES*(OFFS-COLUMNS)
	ld	de,hrg_mem
	ld	a,8*LINES	;Umspeicherung vorbereiten
exp_loop:
	ld	bc,COLUMNS
	ldir
	ex	de,hl
	ld	bc,OFFS-COLUMNS
	add	hl,bc
	ex	de,hl
	dec	a
	jr	nz,exp_loop	;noch nicht alle Zeilen?

	endif

;= Bildeffekte vorbereiten ======================================

	if	HRG

	ld	b,3*2*N_SQUIXX
	ld	hl,squixx
	xor	a
hrg_prep:
	ld	(hl),a
	inc	hl
	djnz	hrg_prep	;alle Koordinaten vorbereiten

	ld	hl,speed
	ld	(hl),7
	inc	hl
	ld	(hl),3
	inc	hl
	ld	(hl),11
	inc	hl
	ld	(hl),7		;ein paar empirische Werte

	if	TXT

	ld	hl,txt_stack+(8*LINES/2)*2*2
	ld	(sw_point),hl

	ld	hl,8*LINES/2+1
	ld	(sw_count),hl	;ab der Mitte nach oben

	endif

	endif

;- Bildausgabe freigeben ----------------------------------------

	ld	ix,sync
	out	(NMI_ON),a	;Bildausgabe starten

;= Hauptschleife ================================================

mainloop:
	if	TXT

	ld	b,COLUMNS
	call	xor_none
	ld	hl,txt_mem+COLUMNS-1
	ld	b,LINES
	call	xor_t2b
	ld	b,COLUMNS
	call	xor_none
	ld	hl,txt_mem+(LINES-1)*(COLUMNS+1)
	ld	b,LINES
	call	xor_b2t

	ld	hl,txt_mem+1
	ld	b,COLUMNS-3
	call	xor_l2r
	ld	b,LINES-1
	call	xor_t2b
	ld	b,COLUMNS-3
	call	xor_r2l
	ld	b,LINES-2
	call	xor_b2t

	ld	b,COLUMNS-4
	call	xor_l2r
	ld	b,LINES-3
	call	xor_t2b
	ld	b,COLUMNS-5
	call	xor_r2l
	ld	b,LINES-4
	call	xor_b2t

	ld	b,COLUMNS-6
	call	xor_l2r
	ld	b,LINES-5
	call	xor_t2b
	ld	b,COLUMNS-7
	call	xor_r2l
	ld	b,LINES-5
	call	xor_b2t

	endif

	if	not TXT
	call	hrg_fx
	endif

	jr	mainloop
;----------------------------------------------------------------
	if	TXT

xor_none:
	push	hl
	pop	hl
	call	hrg_fx
	djnz	xor_none	;nur Dummy
	ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
xor_l2r:
	ld	a,(hl)
	xor	80H
	ld	(hl),a
	inc	hl
	call	hrg_fx
	djnz	xor_l2r		;links -> rechts invertieren
	ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
xor_r2l:
	ld	a,(hl)
	xor	80H
	ld	(hl),a
	dec	hl
	call	hrg_fx
	djnz	xor_r2l		;rechts -> links invertieren
	ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
xor_t2b:
	ld	de,COLUMNS+1
xt2b_loop:
	ld	a,(hl)
	xor	80H
	ld	(hl),a
	add	hl,de
	call	hrg_fx
	djnz	xt2b_loop	;oben -> unten invertieren
	ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
xor_b2t:
	ld	de,-(COLUMNS+1)
xb2t_loop:
	ld	a,(hl)
	xor	80H
	ld	(hl),a
	add	hl,de
	call	hrg_fx
	djnz	xb2t_loop	;unten -> oben invertieren
	ret

	endif
;----------------------------------------------------------------
hrg_fx:
	if	not HRG

	push	bc

	ld	bc,2000
fx_delay:
	dec	bc
	ld	a,b
	or	c
	jr	nz,fx_delay

	pop	bc		;ein bichen langsamer...
	ret

	else

	push	bc
	push	de
	push	hl		;Register retten

	ld	bc,(squixx)
	ld	a,(squixx+2)
	ld	e,a
	ld	d,0
	exx
	ld	bc,(squixx+3)
	ld	a,(squixx+3+2)
	ld	e,a
	ld	d,0
	call	xor_line	;letzte Strecke lschen

	ld	hl,squixx+3*2
	ld	de,squixx
	ld	bc,3*2*(N_SQUIXX-1)
	ldir			;Strecken im Puffer schieben

	ld	hl,squixx+3*2*(N_SQUIXX-1)
	ld	de,speed
	ld	b,2		;Vorbereitung fr zwei Punkte
m_step:
	push	bc

	ld	a,(hl)
	inc	hl
	push	hl
	ld	h,(hl)
	ld	l,a
	ld	a,(de)
	ld	c,a
	rlca
	jr	c,msx_minus	;X-Schritt negativ?

	ld	b,0
	add	hl,bc
	push	hl
	ld	bc,-320
	add	hl,bc
	pop	bc		;positiver X-Schritt
	jr	nc,msx_store
	ld	bc,319
	ld	a,(de)
	neg
	ld	(de),a
	jr	msx_store	;begrenzen

msx_minus:
	ld	b,-1
	add	hl,bc
	ld	b,h
	ld	c,l		;negativer Y-Schritt
	jr	c,msx_store
	ld	bc,0
	ld	a,(de)
	neg
	ld	(de),a		;begrenzen

msx_store:
	pop	hl
	ld	(hl),b
	dec	hl
	ld	(hl),c		;neue X-Koordinate merken
	inc	hl
	inc	hl
	inc	de

	ld	a,(de)
	ld	c,a
	rlca
	jr	c,msy_minus	;Y-Schritt negativ?

	ld	a,(hl)
	add	a,c		;positiver Y-Schritt
	jr	c,msy_over
	cp	240
	jr	c,msy_store
msy_over:
	ld	a,(de)
	neg
	ld	(de),a
	ld	a,239
	jr	msy_store	;begrenzen

msy_minus:
	ld	a,(hl)
	add	a,c		;negativer Y-Schritt
	jr	c,msy_store
	ld	a,(de)
	neg
	ld	(de),a
	xor	a		;begrenzen

msy_store:
	ld	(hl),a		;neue Y-Koordinate merken
	inc	hl
	inc	de

ms_next:
	pop	bc
	djnz	m_step		;noch nicht beide Punkte?

	ld	bc,(squixx+3*2*(N_SQUIXX-1))
	ld	a,(squixx+3*2*(N_SQUIXX-1)+2)
	ld	e,a
	ld	d,0
	exx
	ld	bc,(squixx+3*2*(N_SQUIXX-1)+3)
	ld	a,(squixx+3*2*(N_SQUIXX-1)+3+2)
	ld	e,a
	ld	d,0
	call	xor_line	;neue Strecke zeichnen

	pop	hl
	pop	de
	pop	bc		;Register holen
	ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
xor_line:			;bc=x1 de=y1 bc'=x2 de'=y2
	push	bc
	exx
	pop	hl
	and	a
	sbc	hl,bc
	jr	nc,xl_noswap
	exx			;x1<=x2 sicherstellen
xl_noswap:

	ld	a,c
	and	07H
	ld	l,a
	inc	l
	ld	a,0
	scf
xl_pixel:
	rra
	dec	l
	jr	nz,xl_pixel
	push	af		;Pixel im Byte bestimmen

	push	bc
	exx
	ld	h,b
	ld	l,c
	pop	bc
	sbc	hl,bc
	exx			;Anzahl X-Pixel berechnen

				;(s1)=m bc=x1 de=y1 de'=y2 hl'=dx
	push	de
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	ex	de,hl
	ld	h,b
	ld	l,c
	srl	h
	rr	l
	srl	h
	rr	l
	srl	h
	rr	l
	add	hl,de
	ld	de,hrg_mem
	add	hl,de
	pop	de
	push	hl		;Zeiger in Bildspeicher

	exx
	push	de
	exx
	pop	hl
	sbc	hl,de		;Anzahl Y-Pixel berechnen
	ld	de,+OFFS
	jr	nc,xl_down	;abwrts?
	ex	de,hl
	ld	hl,0
	and	a
	sbc	hl,de
	ld	de,-OFFS	;sonst Vorzeichen umdrehen
xl_down:
	push	hl
	exx
	pop	bc

				;(s2)=m (s1)=p de'=dp bc=dy hl=dx
	push	hl
	and	a
	sbc	hl,bc
	pop	hl
	jr	c,xl_steep	;Gerade steil?

xl_flat:
	push	hl
	exx
	pop	bc
	inc	bc		;Schrittzahl aus X-Pixeln
	exx

	sla	c
	rl	b
	ex	de,hl
	ld	hl,0
	sbc	hl,de
	ld	d,h
	ld	e,l
	add	hl,bc
	sla	e
	rl	d
	exx			;Vorbereitungen Bresenham
	pop	hl
				;(s1)=m bc=n de=dp hl=p
				;bc'=dy de'=-dx hl'=e
xlf_loop:
	pop	af
	push	af
	xor	(hl)
	ld	(hl),a		;Pixel umkippen

	exx
	bit	7,h
	jr	nz,xlf_br
	add	hl,de
	exx
	add	hl,de
	exx			;Bresenham lt gren
xlf_br:

	pop	af
	rrc	a
	push	af
	jr	nc,xlf_step
	exx
	inc	hl
	exx			;nchster X-Schritt
xlf_step:

	add	hl,bc
	exx
	dec	bc
	ld	a,b
	or	c
	jr	nz,xlf_loop	;noch nicht alle Schritte?

	pop	af
	ret			;fertig!

xl_steep:
	push	bc
	exx
	pop	bc
	inc	bc		;Schrittzahl aus Y-Pixeln
	exx

	add	hl,hl
	ex	de,hl
	ld	hl,0
	sbc	hl,bc
	ld	b,h
	ld	c,l
	add	hl,de
	sla	c
	rl	b
	exx			;Vorbereitungen Bresenham
	pop	hl
				;(s1)=m bc=n de=dp hl=p
				;bc'=-dy de'=dx hl'=e
xls_loop:
	pop	af
	push	af
	xor	(hl)
	ld	(hl),a		;Pixel umkippen

	exx
	bit	7,h
	jr	nz,xls_br
	pop	af
	rrc	a
	push	af
	jr	nc,xls_step
	exx
	inc	hl
	exx
xls_step:
	add	hl,bc		;Bresenham lt gren
xls_br:

	add	hl,de
	exx
	add	hl,de		;nchster Y-Schritt

	dec	bc
	ld	a,b
	or	c
	jr	nz,xls_loop	;noch nicht alle Schritte?

	pop	af
	ret			;fertig!

	endif

;= Bildschirm ===================================================

sync:
	ld	hl,(sync)
	ld	b,7
sy_delay1:
	djnz	sy_delay1	;Verzgerung fr eine Zeile

	in	a,(VSYNC_ON)	;VSync einschalten

	if	TXT and HRG

	ld	hl,(sw_count)
	ld	a,l
	cp	1
	jr	c,sy_no_sw1
	cp	8*LINES-1
	jr	nc,sy_no_sw2	;nicht im erlaubten Bereich?

	ld	a,8*LINES-1
	bit	0,h
	jr	z,sy_up_sw	;nach oben schwingen?

	ld	de,txt_stack+4
	ld	bc,hrg_dummy+8000H
	jr	sy_new_sw

sy_up_sw:
	sub	l
	ld	l,a		;Wert umkehren => nach unten

	ld	de,txt_stack
	ld	bc,show_switch
sy_new_sw:
	ld	h,0
	add	hl,hl
	add	hl,hl
	ex	de,hl		;Offset in den Stacks

	add	hl,de
	ld	(sw_point),hl	;Startstelle im Textstack

	ld	hl,hrg_stack
	add	hl,de
	ld	(hl),c
	inc	hl
	ld	(hl),b		;Endestelle im Grafikstack
	jr	sy_end_sw

sy_no_sw2:
	ld	b,11
	jr	sy_no_sw
sy_no_sw1:
	ld	b,13
sy_no_sw:
	djnz	sy_no_sw
	inc	hl		;Laufzeitausgleich

sy_end_sw:
	ld	hl,(sw_count)
	inc	hl
	ld	(sw_count),hl	;Laufvariable erhhen

	nop
	ld	b,75
sy_delay2:
	djnz	sy_delay2	;VSync ist sechs Zeilen lang

	else

	ld	a,r
	ld	b,95
sy_delay2:
	djnz	sy_delay2	;VSync ist sechs Zeilen lang

	endif

	out	(HSYNC_ON),a	;wieder Videopegel

	ld	a,-MARGIN_TOP
	call	rstcal		;zum Hauptprogramm

	call	show		;Bild ausgeben

	ld	a,-MARGIN_BOTTOM
	call	rstcal		;zum Hauptprogramm

	jp	sync		;und von vorn...
;----------------------------------------------------------------
	if	HRG

	if	TXT

show:
	ld	b,2
sh_delay:
	djnz	sh_delay	;Abstand von linken Rand

	ld	h,b
	ld	l,b
	add	hl,sp		;"echten" Stack merken
	ld	(txt_stack+(8*LINES*2)*2),hl

	ld	de,(sw_point)	;Anfang Textstack

	ld	sp,hrg_stack
	scf
	ret			;zum Dummycode

show_switch:
	ld	a,0FEH and (high FONT)
	ld	i,a		;MSBits des Fonts setzen

	ex	de,hl
	ld	sp,hl
	ret			;zum Text umschalten

	else

show:
	ld	b,3
	ld	b,3
sh_delay:
	djnz	sh_delay	;Abstand von linken Rand

	ld	h,b
	ld	l,b
	add	hl,sp		;"echten" Stack merken
	ld	(hrg_stack+(1+8*LINES*2)*2),hl

	ld	sp,hrg_stack
	scf
	ret			;zum Dummycode

	endif

	else

show:
	inc	hl
	ld	b,6
sh_delay:
	djnz	sh_delay	;Abstand von linken Rand

	ld	hl,0
	add	hl,sp		;"echten" Stack merken
	ld	(txt_stack+(8*LINES*2)*2),hl

	ld	sp,txt_stack
	ret			;zum Dummycode im Bild

	endif

	if	TXT

show_next:
	pop	hl
	push	hl
	inc	hl		;ein paar Takte Luft
	ret			;nchste Pixelzeile bei Text

	endif

show_end:
	pop	hl
	ld	sp,hl		;wieder "echten" Stack setzen
	ret
;----------------------------------------------------------------
rstcal:
	pop	ix		;Rcksprung merken

	ex	af,af'
	out	(NMI_ON),a	;NMIs zur Zeilenzhlung

	pop	hl
	pop	de
	pop	bc
	pop	af		;Register holen
	ret

;= Dummycode fr eine Bildzeile =================================

	if	HRG

hrg_dummy:
	pop	hl		;nchste Bildadresse holen
	ld	a,h
	ld	i,a
	ld	a,l
	ld	r,a		;"Videozeiger" darauf richten
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop			;COLUMNS-mal "nichts tun"
	ret	c		;nchste Zeile / Bildende

	endif

;= Text =========================================================

	if	TXT
txt_mem:
	include	"maxtxt.inc"
	endif

;= Bild =========================================================

	if	HRG
packed:
	include	"maxpac.inc"
	endif

;= Restliche BASIC-Zeilen =======================================

	db	076H		;N/L (von erster Zeile)

line10:	db	0,10
	dw	dsp-$-2
	db	0F9H		;RAND
	db	0D4H		;USR
	db	01CH		;0
	db	07EH		;Zahl
	db	08FH
	db	001H
	db	004H
	db	000H
	db	000H
	db	076H		;N/L

;- Leerer Bildschirm --------------------------------------------

dsp:	db	076H
	db	076H,076H,076H,076H,076H,076H,076H,076H
	db	076H,076H,076H,076H,076H,076H,076H,076H
	db	076H,076H,076H,076H,076H,076H,076H,076H

;- Keine BASIC-Variablen ----------------------------------------

var:	db	080H

;- Ende des abgespeicherten Bereichs ----------------------------

last:

;= RAM ==========================================================

		ds	60		;sollte reichen
stack:

		if	TXT

txt_stack:	ds	(8*LINES*2)*2+2

		endif

		if	HRG

HRG_OVER	equ	($-1) and (OFFS-1)
		ds	OFFS-1-HRG_OVER	;Anfang mu passen!
hrg_mem:	ds	8*LINES*OFFS
hrg_memend:
		ds	20		;Schutz vor Entpacker

hrg_stack:	ds	(8*LINES*2)*2+2
		if	not TXT
		ds	2
		endif

squixx:		ds	3*2*N_SQUIXX
speed:		ds	4

		endif

		if	TXT and HRG

sw_count:	ds	2
sw_point:	ds	2

		endif

;= Ende =========================================================
	end
