Unit Moon;
Interface
Uses
  CRT,DOS,GRAPHVGA,LIBUSES;
const
  MoonX    = 111;
  MoonY    = 89;
  MaskX    = 151;
  MaskY    = 89;

Procedure InitMoon;
Procedure CloseMoon;

Procedure BouffeLaLune;

Procedure GerbeLaLune;

Implementation
Var
  P        : RGB;
  Moon1    : Pointer; { Array of Byte; {10080 }
  Moon2    : Pointer;
  Mask1    : Pointer; {13680 }
  Mask2    : Pointer;

Procedure PutBob(X1,Y1,X2,Y2 : word; P : Pointer);
Begin
    asm
      { Calcul des pts de depart }
      cli
      Push  DS
      Mov   AX,WriteS
      Mov   ES,AX

      Lds   SI,P
      INC   SI
      INC   SI
      Mov   AX,Y1
      mov   BX,320
      Mul   bx
      add   ax,X1     { DI = Y2*320+X2 }
      Mov   Di,AX     { DI = DI + 289 (320-31) }
      Sub   BX,X2

      mov   DX,Y2
@@Bcl:Mov   CX,X2
      rep   movsb
      Add   DI,BX
      dec   dx
      jnz   @@Bcl

      pop   DS
      sti
    end;
End;

Procedure InitMoon;
var
  X,Y,C : Word;
Begin
   FillChar(Screen^,64000,0);
   PaletteOff;
   opensub(Moon_walk);
	 
   GetMem(Moon1,10080);
   GetMem(Moon2,10080);
   GetMem(Mask1,13680);
   GetMem(Mask2,13680);

   LoadRaw(P,SizeOf(P));
   LoadRaw(Moon1^,10080); {SizeOf(Moon1));}
   LoadRaw(Moon2^,10080); {SizeOf(Moon2));}
   LoadRaw(Mask1^,13680); {SizeOf(Mask1));}
   LoadRaw(Mask2^,13680); {SizeOf(Mask2));}
   SetRgb(P);
end;

Procedure CloseMoon;
Begin
   FreeMem(Moon1,10080);
   FreeMem(Moon2,10080);
   FreeMem(Mask1,13680);
   FreeMem(Mask2,13680);
end;

Procedure AddBob(X1,Y1,X2,Y2 : word; P : Pointer);
Begin
    asm
      { Calcul des pts de depart }
      cli
      Push  DS
      Mov   AX,WriteS
      Mov   ES,AX
      Lds   SI,P
      inc   SI
      inc   SI
      Mov   AX,Y1
      mov   BX,320
      Mul   bx
      add   ax,X1     { DI = Y2*320+X2 }
      Mov   Di,AX     { DI = DI + 289 (320-31) }

      Sub   BX,X2

      mov   DX,Y2
@@Bcl:Mov   CX,X2
@@Bc2:Mov   AH,Byte Ptr ES:[DI]
      xor   AL,AL
      mov   AL,Byte Ptr DS:[SI]
      cmp   AL,0
      je    @@go
      inc   AL
@@go: inc   SI
      cmp   AL,16
      jbe   @@ok
      xor   AL,AL
@@ok: Sub   AH,AL
      Mov   AL,AH
      cmp   AL,0
      jnle  @@sor
      Xor   AL,AL
@@Sor:Stosb
      Loop  @@Bc2
      Add   DI,BX
      dec   dx
      jnz   @@Bcl

      pop   DS
      sti
    end;
End;

Procedure BouffeLaLune;
Var
  C   : Word;
Begin
  For C:=0 to 138 do
    begin
      PutBob(160-55,100-44,MoonX,MoonY,Moon1);
      AddBob(214-C,100-44,MaskX,MaskY,Mask1);
      Move(Ptr(WriteS,0)^,Ptr($A000,0)^,64000);
      WaitVbl;
      WaitVbl;
      WaitVbl;
    end;
End;

Procedure GerbeLaLune;
Var
  C   : Word;
Begin
  For C:=138 to 138*2 do
    begin
      PutBob(160-55,100-44,MoonX,MoonY,Moon2);
      AddBob(210-C,100-44,MaskX,MaskY,Mask2);
      Move(Ptr(WriteS,0)^,Ptr($A000,0)^,64000);
      WaitVbl;
      WaitVbl;
      WaitVbl;
    end;
End;

End.
