#ifndef VDP2_H_
#define VDP2_H_

#include "types.h"

#define VDP2_BASE           0x25e00000
#define VDP2_VRAM           VDP2_BASE
#define VDP2_CRAM           VDP2_BASE+0x100000
#define VDP2_REGISTER_BASE  VDP2_BASE+0x180000

#define TVMD    (*(vu16 *)(VDP2_REGISTER_BASE+0x00))
#define DISP    (1<<15)
#define BDCLMD  (1<<8)
#define LSMD1   (1<<7)
#define LSMD0   (1<<6)
#define VRESO1  (1<<5)
#define VRESO0  (1<<4)
#define HRESO2  (1<<2)
#define HRESO1  (1<<1)
#define HRESO0  (1<<0)
/* Display modes. Only TV modes. */
#define NOINTERLACE     (0)
#define SINGLEINTERLACE (LSMD1)
#define DOUBLEINTERLACE (LSMD1|LSMD0)
#define VRES224         (0)
#define VRES240         (VRESO0)
/* 256 lines in PAL, 240 lines in NTSC */
#define VRES256         (VRESO1|VRESO0)
#define HRES320         (0)
#define HRES352         (HRESO0)
#define HRES640         (HRESO1)
#define HRES704         (HRESO1|HRESO0)

#define EXTEN   (*(vu16 *)(VDP2_REGISTER_BASE+0x02))
#define EXLTEN  (1<<9)
#define EXSYEN  (1<<8)
#define DASEL   (1<<1)
#define EXBGEN  (1<<0)

#define TVSTAT  (*(vu16 *)(VDP2_REGISTER_BASE+0x04))
#define EXLTFG  (1<<9)
#define EXSYFG  (1<<8)
#define VBLANK  (1<<3)
#define HBLANK  (1<<2)
#define ODD     (1<<1)
#define PAL     (1<<0)
/* Sync macros */
#define WaitForVBLANK() while(!(TVSTAT&VBLANK));
#define WaitForHBLANK() while(!(TVSTAT&HBLANK));
#define WaitForVBLANKExit() while(TVSTAT&VBLANK);

#define VRSIZE  (*(vu16 *)(VDP2_REGISTER_BASE+0x06))
#define VRAMSZ  (1<<15)

#define HCNT    (*(vu16 *)(VDP2_REGISTER_BASE+0x08))
#define VCNT    (*(vu16 *)(VDP2_REGISTER_BASE+0x0a))
#define RAMCTL  (*(vu16 *)(VDP2_REGISTER_BASE+0x0e))
#define CYCA0L  (*(vu16 *)(VDP2_REGISTER_BASE+0x10))
#define CYCA0U  (*(vu16 *)(VDP2_REGISTER_BASE+0x12))
#define CYCA1L  (*(vu16 *)(VDP2_REGISTER_BASE+0x14))
#define CYCA1U  (*(vu16 *)(VDP2_REGISTER_BASE+0x16))
#define CYCB0L  (*(vu16 *)(VDP2_REGISTER_BASE+0x18))
#define CYCB0U  (*(vu16 *)(VDP2_REGISTER_BASE+0x1a))
#define CYCB1L  (*(vu16 *)(VDP2_REGISTER_BASE+0x1c))
#define CYCB1U  (*(vu16 *)(VDP2_REGISTER_BASE+0x1e))
#define BGON    (*(vu16 *)(VDP2_REGISTER_BASE+0x20))
#define R0TPON  (1<<12)
#define N3TPON  (1<<11)
#define N2TPON  (1<<10)
#define N1TPON  (1<<9)
#define N0TPON  (1<<8)
#define R1ON    (1<<5)
#define R0ON    (1<<4)
#define N3ON    (1<<3)
#define N2ON    (1<<2)
#define N1ON    (1<<1)
#define N0ON    (1<<0)

#define MZCTL   (*(vu16 *)(VDP2_REGISTER_BASE+0x22))
#define SFSEL   (*(vu16 *)(VDP2_REGISTER_BASE+0x24))
#define SFCODE  (*(vu16 *)(VDP2_REGISTER_BASE+0x26))
#define CHCTLA  (*(vu16 *)(VDP2_REGISTER_BASE+0x28))
#define CHCTLB  (*(vu16 *)(VDP2_REGISTER_BASE+0x2a))
#define BMPNA   (*(vu16 *)(VDP2_REGISTER_BASE+0x2c))
#define BMPNB   (*(vu16 *)(VDP2_REGISTER_BASE+0x2e))
#define PNCN0   (*(vu16 *)(VDP2_REGISTER_BASE+0x30))
#define PNCN1   (*(vu16 *)(VDP2_REGISTER_BASE+0x32))
#define PNCN2   (*(vu16 *)(VDP2_REGISTER_BASE+0x34))
#define PNCN3   (*(vu16 *)(VDP2_REGISTER_BASE+0x36))
#define PNCR    (*(vu16 *)(VDP2_REGISTER_BASE+0x38))
#define PLSZ    (*(vu16 *)(VDP2_REGISTER_BASE+0x3a))
#define MPOFN   (*(vu16 *)(VDP2_REGISTER_BASE+0x3c))
#define MPOFR   (*(vu16 *)(VDP2_REGISTER_BASE+0x3e))
#define MPABN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x40))
#define MPCDN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x42))
#define MPABN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x44))
#define MPCDN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x46))
#define MPABN2  (*(vu16 *)(VDP2_REGISTER_BASE+0x48))
#define MPCDN2  (*(vu16 *)(VDP2_REGISTER_BASE+0x4a))
#define MPABN3  (*(vu16 *)(VDP2_REGISTER_BASE+0x4c))
#define MPCDN3  (*(vu16 *)(VDP2_REGISTER_BASE+0x4e))
#define MPABRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x50))
#define MPCDRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x52))
#define MPEFRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x54))
#define MPGHRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x56))
#define MPIJRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x58))
#define MPKLRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x5a))
#define MPMNRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x5c))
#define MPOPRA  (*(vu16 *)(VDP2_REGISTER_BASE+0x5e))
#define MPABRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x60))
#define MPCDRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x62))
#define MPEFRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x64))
#define MPGHRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x66))
#define MPIJRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x68))
#define MPLKRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x6a))
#define MPMNRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x6c))
#define MPOPRB  (*(vu16 *)(VDP2_REGISTER_BASE+0x6e))
#define SCXIN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x70))
#define SCXDN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x72))
#define SCYIN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x74))
#define SCYDN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x76))
#define ZMXIN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x78))
#define ZMXDN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x7a))
#define ZMYIN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x7c))
#define ZMYDN0  (*(vu16 *)(VDP2_REGISTER_BASE+0x7e))
#define SCXIN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x80))
#define SCXDN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x82))
#define SCYIN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x84))
#define SCYDN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x86))
#define ZMXIN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x88))
#define ZMXDN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x8a))
#define ZMYIN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x8c))
#define ZMYDN1  (*(vu16 *)(VDP2_REGISTER_BASE+0x8e))
#define SCXN2   (*(vu16 *)(VDP2_REGISTER_BASE+0x90))
#define SCYN2   (*(vu16 *)(VDP2_REGISTER_BASE+0x92))
#define SCXN3   (*(vu16 *)(VDP2_REGISTER_BASE+0x94))
#define SCYN3   (*(vu16 *)(VDP2_REGISTER_BASE+0x96))
#define ZMCTL   (*(vu16 *)(VDP2_REGISTER_BASE+0x98))
#define SCRCTL  (*(vu16 *)(VDP2_REGISTER_BASE+0x9a))
#define VCSTAU  (*(vu16 *)(VDP2_REGISTER_BASE+0x9c))
#define VCSTAL  (*(vu16 *)(VDP2_REGISTER_BASE+0x9e))
#define LSTA0U  (*(vu16 *)(VDP2_REGISTER_BASE+0xa0))
#define LSTA0L  (*(vu16 *)(VDP2_REGISTER_BASE+0xa2))
#define LSTA1U  (*(vu16 *)(VDP2_REGISTER_BASE+0xa4))
#define LSTA1L  (*(vu16 *)(VDP2_REGISTER_BASE+0xa6))
#define LCTAU   (*(vu16 *)(VDP2_REGISTER_BASE+0xa8))
#define LCTAL   (*(vu16 *)(VDP2_REGISTER_BASE+0xaa))
#define BKTAU   (*(vu16 *)(VDP2_REGISTER_BASE+0xac))
#define BKTAL   (*(vu16 *)(VDP2_REGISTER_BASE+0xae))
#define RPMD    (*(vu16 *)(VDP2_REGISTER_BASE+0xb0))
#define RPRCTL  (*(vu16 *)(VDP2_REGISTER_BASE+0xb2))
#define KTCTL   (*(vu16 *)(VDP2_REGISTER_BASE+0xb4))
#define KTAOF   (*(vu16 *)(VDP2_REGISTER_BASE+0xb6))
#define OVPNRA  (*(vu16 *)(VDP2_REGISTER_BASE+0xb8))
#define OVPNRB  (*(vu16 *)(VDP2_REGISTER_BASE+0xba))
#define RPTAU   (*(vu16 *)(VDP2_REGISTER_BASE+0xbc))
#define RPTAL   (*(vu16 *)(VDP2_REGISTER_BASE+0xbe))
#define WPSX0   (*(vu16 *)(VDP2_REGISTER_BASE+0xc0))
#define WPSY0   (*(vu16 *)(VDP2_REGISTER_BASE+0xc2))
#define WPEX0   (*(vu16 *)(VDP2_REGISTER_BASE+0xc4))
#define WPEY0   (*(vu16 *)(VDP2_REGISTER_BASE+0xc6))
#define WPSX1   (*(vu16 *)(VDP2_REGISTER_BASE+0xc8))
#define WPSY1   (*(vu16 *)(VDP2_REGISTER_BASE+0xca))
#define WPEX1   (*(vu16 *)(VDP2_REGISTER_BASE+0xcc))
#define WPEY1   (*(vu16 *)(VDP2_REGISTER_BASE+0xce))
#define WCTLA   (*(vu16 *)(VDP2_REGISTER_BASE+0xd0))
#define WCTLB   (*(vu16 *)(VDP2_REGISTER_BASE+0xd2))
#define WCTLC   (*(vu16 *)(VDP2_REGISTER_BASE+0xd4))
#define WCTLD   (*(vu16 *)(VDP2_REGISTER_BASE+0xd6))
#define LWTA0U  (*(vu16 *)(VDP2_REGISTER_BASE+0xd8))
#define LWTA0L  (*(vu16 *)(VDP2_REGISTER_BASE+0xda))
#define LWTA1U  (*(vu16 *)(VDP2_REGISTER_BASE+0xdc))
#define LWTA1L  (*(vu16 *)(VDP2_REGISTER_BASE+0xde))
#define SPCTL   (*(vu16 *)(VDP2_REGISTER_BASE+0xe0))
#define SPCCCS1 (1<<13)
#define SPCCCS0 (1<<12)
#define SPCCN2  (1<<10)
#define SPCCN1  (1<<9)
#define SPCCN0  (1<<8)
#define SPCLMD  (1<<5)
#define SPWINEN (1<<4)
#define SPTYPE3 (1<<3)
#define SPTYPE2 (1<<2)
#define SPTYPE1 (1<<1)
#define SPTYPE0 (1<<0)
#define SPRITETYPE0 (0)
#define SPRITETYPE1 (SPTYPE0)
#define SPRITETYPE2 (SPTYPE1)
#define SPRITETYPE3 (SPTYPE1|SPTYPE0)
#define SPRITETYPE4 (SPTYPE2)
#define SPRITETYPE5 (SPTYPE2|SPTYPE0)
#define SPRITETYPE6 (SPTYPE2|SPTYPE1)
#define SPRITETYPE7 (SPTYPE2|SPTYPE1|SPTYPE0)
#define SPRITETYPE8 (SPTYPE3)
#define SPRITETYPE9 (SPTYPE3|SPTYPE0)
#define SPRITETYPEA (SPTYPE3|SPTYPE1)
#define SPRITETYPEB (SPTYPE3|SPTYPE1|SPTYPE0)
#define SPRITETYPEC (SPTYPE3|SPTYPE2)
#define SPRITETYPED (SPTYPE3|SPTYPE2|SPTYPE0)
#define SPRITETYPEE (SPTYPE3|SPTYPE2|SPTYPE1)
#define SPRITETYPEF (SPTYPE3|SPTYPE2|SPTYPE1|SPTYPE0)

#define SDCTL   (*(vu16 *)(VDP2_REGISTER_BASE+0xe2))
#define CRAOFA  (*(vu16 *)(VDP2_REGISTER_BASE+0xe4))
#define CRAOFB  (*(vu16 *)(VDP2_REGISTER_BASE+0xe6))
#define LNCLEN  (*(vu16 *)(VDP2_REGISTER_BASE+0xe8))
#define SFPRMD  (*(vu16 *)(VDP2_REGISTER_BASE+0xea))
#define CCCTL   (*(vu16 *)(VDP2_REGISTER_BASE+0xec))
#define SFCCMD  (*(vu16 *)(VDP2_REGISTER_BASE+0xee))
#define PRISA   (*(vu16 *)(VDP2_REGISTER_BASE+0xf0))
#define PRISB   (*(vu16 *)(VDP2_REGISTER_BASE+0xf2))
#define PRISC   (*(vu16 *)(VDP2_REGISTER_BASE+0xf4))
#define PRISD   (*(vu16 *)(VDP2_REGISTER_BASE+0xf6))
#define PRINA   (*(vu16 *)(VDP2_REGISTER_BASE+0xf8))
#define PRINB   (*(vu16 *)(VDP2_REGISTER_BASE+0xfa))
#define PRIR    (*(vu16 *)(VDP2_REGISTER_BASE+0xfc))
#define CCRSA   (*(vu16 *)(VDP2_REGISTER_BASE+0x100))
#define CCRSB   (*(vu16 *)(VDP2_REGISTER_BASE+0x102))
#define CCRSC   (*(vu16 *)(VDP2_REGISTER_BASE+0x104))
#define CCRSD   (*(vu16 *)(VDP2_REGISTER_BASE+0x106))
#define CCRNA   (*(vu16 *)(VDP2_REGISTER_BASE+0x108))
#define CCRNB   (*(vu16 *)(VDP2_REGISTER_BASE+0x10a))
#define CCRR    (*(vu16 *)(VDP2_REGISTER_BASE+0x10c))
#define CCRLB   (*(vu16 *)(VDP2_REGISTER_BASE+0x10e))
#define CLOFEN  (*(vu16 *)(VDP2_REGISTER_BASE+0x110))
#define CLOFSL  (*(vu16 *)(VDP2_REGISTER_BASE+0x112))
#define COAR    (*(vu16 *)(VDP2_REGISTER_BASE+0x114))
#define COAG    (*(vu16 *)(VDP2_REGISTER_BASE+0x116))
#define COAB    (*(vu16 *)(VDP2_REGISTER_BASE+0x118))
#define COBR    (*(vu16 *)(VDP2_REGISTER_BASE+0x11a))
#define COBG    (*(vu16 *)(VDP2_REGISTER_BASE+0x11c))
#define COBB    (*(vu16 *)(VDP2_REGISTER_BASE+0x11e))

#endif /* VDP2_H_ */
