; NeoGeo Pocket TLCS-900/H data bus tests
; Mic, 2012


; Tell the AS assembler we want to code for NGPC
;
        cpu 96C141
        maxmode on
        include "stddef96.inc"


        include "hardware.inc"  ; Include hardware defines
        include "system.inc"    ; Include System Call defines
        
;
; Define variables
;


PUTSTR: MACRO str,pal,colm,row
  jr call_puts
  sstr:    db   str,0
  call_puts:
  ld xhl,sstr
  ld d,pal
  ld c,colm
  ld b,row
  call Puts
 ENDM


START_TIMER: MACRO timeout
    ldb (TRUN),	0
    ldb (T01MOD),TIMER0_SRC_T4|TIMER01_8BIT
    ldb (TREG0),timeout
    ldb (INTET01),5
    ldb (TFFCR),0
    ldb (TRDC),	0
    ldb (TRUN),TIMER0_ON|PRESCALER_ON
    wait_for_int: jr wait_for_int
 ENDM


UPLOAD_TEST: MACRO testCode,addr
    ld  xde,	addr
    ld  xhl,	testCode
    ld  bc,	testCode_end-testCode
    ldir (xde+),(xhl+)
 ENDM
 
 
INT_HANDLER: MACRO tstMaj,tstMin,testCode,testRunAddr,memAccAddr
    ldb (TRUN),0
    ld xwa,timer_int_cont
    ld (rTI0),xwa
    pop de
    pop xwa
    ld xwa,test_tstMaj_tstMin_start
    push xwa
    push de
;    ldb (TREG0),50
    ld xhl,memAccAddr
    ldb (TRUN),TIMER0_ON|PRESCALER_ON
    reti
    
    timer_int_cont:
    ldb (TRUN),0
    pop de
    pop xwa
    ld xwa,testRunAddr+testCode_loop_end-testCode
    push xwa
    push de
    reti
 ENDM
 
 
SHOW_RESULT: MACRO addr,correctVal,colm,row
    ld  h,	colm
    ld  l,	row
    ld  wa,	(addr)
    push wa
    ld  d,	1*2
    sub wa,	correctVal
    jr  pl,	diff_sign_ok
    neg wa
    diff_sign_ok:
    cp  wa,	1
    jr  ule,	result_is_acceptable
    ld  d,	0*2
    result_is_acceptable:
    pop wa
    call	DisplayWord
 ENDM

 
 
WAITF: MACRO frames
    ld w,	frames
    call	vbWait
 ENDM
 
        
START_OF_RAM    EVAL    _MAINRAM
   RAMDB YFRT
   RAMDB XFRT
   RAMDB HIH
   RAMDB SCOREL
   RAMDB SCOREL1
   RAMDB SCOREL2
   RAMDB SCOREL3
   RAMDB VBCOUNTER


HEADER_OFS      EQU     0200000H

REG_Z80SND      equ     0b8h    ; 16bit w - switch the z80 and/or snd chip on or off
ZS_Z0S0         equ     0aaaah  ; Z80 off Snd off
ZS_Z0S1         equ     0aa55h  ; Z80 off Snd on - Snd with direct access from TLCS
ZS_Z1S0         equ     055aah  ; Z80 on Snd off
ZS_Z1S1         equ     05555h  ; Z80 on Snd on - Snd only available via Z80

REG_Z80_NMI     equ     0bah    ; 8bit w - triggers Z80 NMI
REG_Z80_COMM    equ     0bch    ; 8bit r/w - comms with z80 address 0x8000

_Z80RAM         equ     7000h   ; start of Z80 RAM

REG_DACL EQU 00A2h
REG_DACR EQU 00A3h

Z80_COUNTER	equ	7500h


;TRUN            equ 0020h
;TREG0		equ 0022h
;TREG1		equ 0023h
T01MOD		equ 0024h
TFFCR           equ 0025h
;TREG3           equ 0027h
T23MOD          equ 0028h
TRDC		equ 0029h

INTEVZ		equ 0071h
INTET01		equ 0073h
INTETC01	equ 0079h
INTETC23	equ 007Ah

TIMER0_ON	equ 01h
TIMER1_ON	equ 02h
TIMER2_ON	equ 04h
TIMER3_ON	equ 08h
PRESCALER_ON	equ 80h

TIMER0_SRC_HINT equ 00h
TIMER0_SRC_T1 	equ 01h
TIMER0_SRC_T4	equ 02h
TIMER0_SRC_T16	equ 03h
TIMER1_SRC_TIMER0 equ 00h
TIMER1_SRC_T1	 equ 04h
TIMER1_SRC_T16	 equ 08h
TIMER1_SRC_T256	 equ 0Ch
TIMER01_8BIT	 equ 00h
TIMER01_16BIT	 equ 40h


;
; Standard cartridge header
;
    org    HEADER_OFS
    db     " LICENSED BY SNK CORPORATION"    ; 28 bytes license string
    dd     Start                             ; Program Counter
    dw     0                                 ; Catalog number
    db     0                                 ; Sub catalog number
    db     10h                               ; colour or b+w (10h = colour)
    db     "NGP BUS TEST"                    ; Game name (12 bytes)
    dd     0,0,0,0                           ; padding - reserve for future use

; User Interrupt Vectors

UserIntVect:
        dd      nada            ; Software Interrupt (SWI 3)
        dd      nada            ; Software Interrupt (SWI 4)
        dd      nada            ; Software Interrupt (SWI 5)
        dd      nada            ; Software Interrupt (SWI 6)
        dd      nada            ; RTC Alarm Interrupt
        dd      VBlankInt       ; Vertical Blanking Interrupt
        dd      nada            ; Interrupt from Z80
        dd      nada            ; Timer Interrupt (8 bit timer 0)
        dd      nada            ; Timer Interrupt (8 bit timer 1)
        dd      nada            ; Timer Interrupt (8 bit timer 2)
        dd      nada            ; Timer Interrupt (8 bit timer 3)
        dd      nada            ; Serial Transmission Interrupt
        dd      nada            ; Serial Reception Interrupt
        dd      nada            ; (Reserved)
        dd      nada            ; End Micro DMA Int (MicroDMA 0)
        dd      nada            ; End Micro DMA Int (MicroDMA 1)
        dd      nada            ; End Micro DMA Int (MicroDMA 2)
        dd      nada            ; End Micro DMA Int (MicroDMA 3)

nada:   reti

; *** Start of User Code ***

Start:

        calr    OS_VERSION      ; Initialize NGP or NGPC mode

        set     6,(rUSERA)      ; User Answer

; Install User Interrupt Vectors

        lda     xix,(UserIntVect)
        lda     xiy,(rSWI3)
        ld      b,18
UIVloop:
        ld      xwa,(xix+)
        ld      (xiy+),xwa
        djnz    b,UIVloop


    ; set up screen size 160x152
    ld   (08002h),0
    ld   (08003h),0
    ld   (08004h),0a0h
    ld   (08005h),98h

    ld   wa,	0
    ld   xhl,	_TILERAM
    ld   bc,	200h
    clear_pattern_ram:
    ld  (xhl+),	wa
    djnz bc,	clear_pattern_ram
    
    ; copy charset to character RAM
    ld   bc,1536/2
    ld   xde, _TILERAM+400h
    ld   xhl, font_tiles
    ldirw (xde+),(xhl+)
    
    call ClearScreen
; Enable Interrupts

        ei      0

Restart:
    ; copy palette to character palette RAM
    ld bc, (ENDPALETTE-PALETTE)/2
    ld xde, _SCR2PAL
    ld xhl, PALETTE
    ldirw (xde+),(xhl+)

    ; background colour 
    ; _BGCPAL = GRxB
    ld (_BGCPAL), 0fdh
    ld (_BGCPAL+1), 0dh
    ldb (8118h),80h
 
    ldw 	(REG_Z80SND), ZS_Z0S0  ; turn off z80 and snd chip
    ld 	xde, _Z80RAM
    ld 	xhl, z80_code
    ld 	bc, 0200h
    ldir 	(xde+), (xhl+) 		; copy z80 code

        
    PUTSTR "NGPC Data Bus Test",3,1,1

    ;--------------------
    PUTSTR "ROM",2,0,4

    ld  xwa,	test_1_1_int
    ld  (rTI0),	xwa
    WAITF 1
    START_TIMER 50
test_1_1_start:
    call	test1
    SHOW_RESULT SCOREL,0EAh,12,4

    ld  xwa,	test_1_4_int
    ld  (rTI0),	xwa
    WAITF 1
    START_TIMER 50
test_1_4_start:
    call	test3
    SHOW_RESULT SCOREL,0EAh,16,4
    ;--------------------

    ;--------------------
    PUTSTR "RAM",2,0,5

    ld  xwa,	test_1_2_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test1,7800h
    WAITF 1
    START_TIMER 50
test_1_2_start:    
    ld		xwa,7800h
    call	(xwa)
    SHOW_RESULT SCOREL,0FCh,12,5

    ld  xwa,	test_1_5_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test3,7800h
    WAITF 1
    START_TIMER 50
test_1_5_start:    
    ld		xwa,7800h
    call	(xwa)
    SHOW_RESULT SCOREL,0F7h,16,5
    ;--------------------

    ;--------------------
    PUTSTR "ROM+ROM",2,0,6

    ld  xwa,	test_2_1_int
    ld  (rTI0),	xwa
    WAITF 1
    START_TIMER 50
test_2_1_start:
    call	test2
    SHOW_RESULT SCOREL,083h,12,6

    ld  xwa,	test_2_3_int
    ld  (rTI0),	xwa
    WAITF 1
    START_TIMER 50
test_2_3_start:
    call	test4
    SHOW_RESULT SCOREL,083h,16,6
    ;--------------------

    ;--------------------
    PUTSTR "RAM+ROM",2,0,7

    ld  xwa,	test_2_2_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test2,7800h
    WAITF 1
    START_TIMER 50
test_2_2_start:    
    ld		xwa,7800h
    call	(xwa)
    SHOW_RESULT SCOREL,0AAh,12,7

    ld  xwa,	test_2_4_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test4,7800h
    WAITF 1
    START_TIMER 50
test_2_4_start:    
    ld		xwa,7800h
    call	(xwa)
    SHOW_RESULT SCOREL,0A8h,16,7
    ;--------------------

    ;--------------------
    PUTSTR "RAM+RAM",2,0,8

    ld  xwa,	test_3_1_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test2,7800h
    WAITF 1
    START_TIMER 50
test_3_1_start:    
    ld		xwa,7800h
    call	(xwa)
    SHOW_RESULT SCOREL,0FDh,12,8

    ld  xwa,	test_3_6_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test4,7800h
    WAITF 1
    START_TIMER 50
test_3_6_start:    
    ld		xwa,7800h
    call	(xwa)
    SHOW_RESULT SCOREL,0F7h,16,8
    ;--------------------
    
    ;--------------------
    PUTSTR "T+Z TTS Z80",2,0,9
    PUTSTR "T+Z TTS TLCS",2,0,10

    ld  xwa,	test_3_2_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test2,6800h
    WAITF 1
    START_TIMER 50
test_3_2_start:    
    ldw (Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,6800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,0FEh,12,9
    SHOW_RESULT SCOREL,0FCh,12,10

    ld  xwa,	test_3_7_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test4,6800h
    WAITF 1
    START_TIMER 50
test_3_7_start:    
    ldw (Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,6800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,0FEh,16,9
    SHOW_RESULT SCOREL,0F7h,16,10
    ;--------------------
    
    ;--------------------
    PUTSTR "T+Z SSS Z80",2,0,11
    PUTSTR "T+Z SSS TLCS",2,0,12

    ld  xwa,	test_3_3_int
    ld  (rTI0),	xwa 
    UPLOAD_TEST test2,7800h
    WAITF 1
    START_TIMER 50
test_3_3_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,7800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,02h,12,11
    SHOW_RESULT SCOREL,0FCh,12,12

    ld  xwa,	test_3_8_int
    ld  (rTI0),	xwa 
    UPLOAD_TEST test4,7800h
    WAITF 1
    START_TIMER 50
test_3_8_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,7800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,12h,16,11
    SHOW_RESULT SCOREL,0E3h,16,12
    ;--------------------

    ;--------------------
    PUTSTR "T+Z TSS Z80",2,0,13
    PUTSTR "T+Z TSS TLCS",2,0,14

    ld  xwa,	test_3_4_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test2,6800h
    WAITF 1
    START_TIMER 50
test_3_4_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,6800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,07Eh,12,13
    SHOW_RESULT SCOREL,0B2h,12,14

    ld  xwa,	test_3_9_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test4,6800h
    WAITF 1
    START_TIMER 50
test_3_9_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,6800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,082h,16,13
    SHOW_RESULT SCOREL,0ABh,16,14
    ;--------------------

    ;--------------------
    PUTSTR "T+Z STS Z80",2,0,15
    PUTSTR "T+Z STS TLCS",2,0,16

    ld  xwa,	test_3_5_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test2,7800h
    WAITF 1
    START_TIMER 50
test_3_5_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,7800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,071h,12,15
    SHOW_RESULT SCOREL,0B9h,12,16

    ld  xwa,	test_3_10_int
    ld  (rTI0),	xwa
    UPLOAD_TEST test4,7800h
    WAITF 1
    START_TIMER 50
test_3_10_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    ld		xwa,7800h
    call	(xwa)
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,078h,16,15
    SHOW_RESULT SCOREL,0A8h,16,16
    ;--------------------
    
    ;--------------------
    ; Test Z80 execution speed when the TLCS is executing from ROM
    ;
    PUTSTR "T+Z R S Z80",2,0,17

    ld  xwa,	test_1_3_int
    ld  (rTI0),	xwa
    WAITF 1
    START_TIMER 50
test_1_3_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    call	test1
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,0FEh,12,17

    ld  xwa,	test_1_6_int
    ld  (rTI0),	xwa
    WAITF 1
    START_TIMER 50
test_1_6_start:    
    ldw 	(Z80_COUNTER),0
    ldw 	(REG_Z80SND), ZS_Z1S0   ; restart z80
    call	test3
    ldw 	(REG_Z80SND), ZS_Z0S0   ; stop z80
    SHOW_RESULT Z80_COUNTER,0FEh,16,17
    ;--------------------
    
    
    
forever
	jr	forever
	

 ALIGN 2

test1:
    ld  xbc,	0
    ld  xde,	1
test1_loop:
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    mirr wa		; 3
    add xbc,	xde	; 2
    jr  test1_loop	; 5 = 50
test1_loop_end:
    ld (SCOREL),xbc
    ret
test1_end:


 ALIGN 2

test3:
    nop
    ld  xbc,	0
    ld  xde,	1
test3_loop:
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    daa a		; 4
    mirr wa		; 3
    add xbc,	xde	; 2
    jr  test3_loop	; 5 = 50
test3_loop_end:
    ld (SCOREL),xbc
    ret
test3_end:

test_1_1_int:
 INT_HANDLER 1,1,test1,test1,test1

test_1_2_int:
 INT_HANDLER 1,2,test1,7800h,test1

test_1_3_int:
 INT_HANDLER 1,3,test1,test1,test1

test_1_4_int:
 INT_HANDLER 1,4,test3,test3,test3

test_1_5_int:
 INT_HANDLER 1,5,test3,7800h,test3

test_1_6_int:
 INT_HANDLER 1,6,test3,test3,test3
   
;-----------------------


 ALIGN 2
 
test2:
    ld  xbc,	0
test2_loop:
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    add a,23		; 3
    add xbc,	1	; 6
    jr  test2_loop	; 5 = 50
test2_loop_end:
    ld (SCOREL),xbc
    ret
test2_end:


 ALIGN 2
 
test4:
    nop
    ld  xbc,	0
test4_loop:
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    ld  xwa,	(xhl)	; 6
    add a,23		; 3
    add xbc,	1	; 6
    jr  test4_loop	; 5 = 50
test4_loop_end:
    ld (SCOREL),xbc
    ret
test4_end:


test_2_1_int:
 INT_HANDLER 2,1,test2,test2,test2

test_2_2_int:
 INT_HANDLER 2,2,test2,7800h,test2

test_2_3_int:
 INT_HANDLER 2,3,test4,test4,test4

test_2_4_int:
 INT_HANDLER 2,4,test4,7800h,test4
 
 
test_3_1_int:
 INT_HANDLER 3,1,test2,7800h,7900h
 
test_3_6_int:
 INT_HANDLER 3,6,test4,7800h,7900h

;------------------


test_3_2_int:
 INT_HANDLER 3,2,test2,6800h,6900h
 
test_3_3_int:
 INT_HANDLER 3,3,test2,7800h,7900h

test_3_4_int:
 INT_HANDLER 3,4,test2,6800h,7900h

test_3_5_int:
 INT_HANDLER 3,5,test2,7800h,6900h
   
test_3_7_int:
 INT_HANDLER 3,7,test4,6800h,6900h

test_3_8_int:
 INT_HANDLER 3,8,test4,7800h,7900h
 
test_3_9_int:
 INT_HANDLER 3,9,test4,6800h,7900h

test_3_10_int:
 INT_HANDLER 3,10,test4,7800h,6900h
 
;------------------


; User shutdown? (Power off pressed?)

        cp      (rUSERS),0
        jp      z,Restart      ; no

; Power off NGP

        ld      rw3,VECT_SHUTDOWN
        calr    SYSTEM_CALL

done:   jr      done


; vbWait
; Waits for n vertical blank interrupts
; inputs: w = number of VBIs to wait for

vbWait:
   push xwa
   ld (VBCOUNTER), 0
vbw1:
   ld a,(7600h)		; 4
   ld a,(7600h)		; 4	
   ld a, (VBCOUNTER)	; 4
   cp a, w		; 2
   jr nz, vbw1		; 5 (19)
   pop xwa
   ret

   
; 
; DrawChar
;
; Draws a character on the background plane
; inputs: wa = char, hl = xy
;
DrawChar
    push xhl
    push xde
    push xbc
    ld xde, 9800h
    ld c, h
    ld b, 0
    mul xbc, 2
    add de, bc
    ld h, 0
    mul xhl, 40h
    add de, hl
    ld (xde), a
    add xde, 1
    ld (xde), w
    pop xbc
    pop xde
    pop xhl
    ret

;
; DisplayHex
;
; Displays a hex value (e.g. FF) on the background plane
;
; inputs: w = palette, a = value; hl = xy
;
DisplayHex
    push xhl
    push xbc
    push xwa
    ld c, a
    and a, 0f0h
    srl 4, a
    add a, 50h
    cp a,5Ah
    jr ult,char1ok
    add a,7
    char1ok:
    call DrawChar
    ld a, c
    and a, 0fh
    add a, 50h
    cp a,5Ah
    jr ult,char2ok
    add a,7
    char2ok:
    add h, 1
    call DrawChar
    pop xwa
    pop xbc
    pop xhl
    ret

; xhl=string, d=palette, c=column, b=row  (c=0..31, r=0..23)
Puts
	push 	xhl
	push 	xde

	sll	d
	ld	(HIH),d
	
	ld	xde,9800h
	ld	xwa,0
	ld	a,c
	add	a,c
	add	xde,xwa
	ld	c,b
	ld	b,0
	mul	xbc,40h
	add	xde,xbc
	ld	b,19
puts_loop
	ld 	a,(xhl)
	cp 	a,0
	jr	z,puts_done
	inc	xhl
	cp	a,91
	jr	ult,is_upper
;	add	a,0E0h
is_upper
	ld	w,0
	add	wa,32	; first tile in charset
	add 	w,(HIH)		; palette
	ld	(xde),a
	inc	xde
	ld	(xde),w
	inc	xde
	djnz	b,puts_loop
puts_done
	pop	xde
	pop	xhl
	ret
	

; inputs: w = palette, a = value; hl = xy
;
DisplayNibble
    push xhl
    push xbc
    push xwa
    and a, 0fh
    add a, 50h
    cp a,5Ah
    jr ult,ncharok
    add a,7
    ncharok:
    add h, 1
    call DrawChar
    pop xwa
    pop xbc
    pop xhl
    ret
    
; d = palette, wa = value, hl = xy
DisplayWord
    push xwa
    push xhl
    push xde
    ld a,w
    ld w,d
    call DisplayNibble
    pop xde
    pop xhl
    pop xwa
    ld w,d
    add h,2
    jp DisplayHex

;
; Clear the background planes
;
;
ClearScreen
   ld xbc, _SCR1RAM
   ld hl, 4C0h
cs1
   ld (xbc), 0
   add xbc, 1
   sub hl, 1
   jr nz, cs1
   ld xbc, _SCR2RAM
   ld hl, 4C0h
cs2
   ld (xbc), 0
   add xbc, 1
   sub hl, 1
   jr nz, cs2
   ret




VBlankInt:
    push xwa
    push xbc
    push xde
    
    ; Update Watch Dog Timer to prevent CPU reset
    ld      (rWDCR),WD_CLR

    ; increment a counter
    inc (VBCOUNTER)
    pop xde
    pop xbc
    pop xwa
    reti

SYSTEM_CALL:
        SystemCallCode
OS_VERSION:
        OsVersionCode

; in the order 0BGR
PALETTE
   dw 0,044ah,0112h,066bh
   dw 0,04a4h,0121h,06b6h
   dw 0,0b81h,0220h,0cb3h
   dw 0, 0221h, 0222h, 0aaah
ENDPALETTE 


  z80_code: binclude "timtest.bin"

  font_tiles: 	binclude "adore.chr" 


    ; make the cartridge size correct
    org HEADER_OFS + 007FFFh
    db 0FFh

