;Moments by Abaddon
;best of 256b intros in 4kB

;TIMINGS
HIHAT_    EQU 5
ARPEGGIO_ EQU 3
FADEOUT_  EQU 16

INCLUDE "COUNTER.INC"

Divider   EQU 63

ORG 256
 MOV GS,DX
 MOV AL,13H
 INT 10H
 MOV AX,3508H
 INT 21H
 MOV [SI],BX
 MOV [SI+2],ES

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 SUB AL,90H-Divider
 CALL init

main:
 FNINIT
 MOV BX,LES1
 MOV SI,list
.part:
 LODSW
 MOV [BX-LES1+main.part-2],SI
 MOV CX,[SI]
 XCHG SI,AX
 SUB CX,SI
 JBE exit
 LES DI,[BX]
 REP MOVSB
 SUB DI,DI
 MOV BP,320;2334
 MOV DX,0A000H;ES
 MOV SI,INT20H
 MOV CL,IRQ.COUNTER-INT20H
 REP MOVSB
 XCHG AX,CX
 MOV DI,SP
 LSS SI,[BX]
 LDS CX,[BX]
 SUB BX,BX
 DEC CX
 MOV [DI],AX
 DB 0EAH                ; FAR JUMP OPCODE
LES1:
 DW 256,7000H

back:
 MOV AX,CS
 MOV SS,AX
 SUB SP,SP
 PUSH SP
 PUSH CS
 POP DS

 IN AL,60H
 DAS
 JC main

exit:
 LDS DX,[256]
 SALC
CALL init
MOV AX,3
INT 10H
RETN

init:
 OUT 61H,AL
 OUT 40H,AL
 SALC
 OUT 40H,AL
 MOV AX,2508H
 INT 21H
RETN

INT20H:
 PUSH GS
 PUSH back
RETF

 DW 128
 MOV BH,127
@@:
 FLDPI          ; PI
 FIDIV WORD [6] ; PI/128
 FIMUL WORD [DI]; counter*PI/128
 FSIN           ; SIN(counter*PI/128)
 FIMUL WORD [SI]; 127*SIN(counter*PI/128)
 FISTP WORD [BX+SI]; -
 INC BX
 DEC BYTE [DI]  ; loop 256x
 JNZ @B         ; BX = sinus table (FC00H)
 ADD SI,SI

 CALL @F
 JE INT20H
 RETN
@@:
 MOV AH,1
 INT 16H
 JNZ INT20H
 MOV AX,[COUNTER+1]
 SUB AX,[CS:COUNTER0]
 CMP AH,1
RETN

 LODSB
 AAM    21
 MOV    CH,AH           ; CH=color
 AAM    7
 MOV    CL,AH           ; CL=shape
 INC    AX              ; AL=radius+1
 CMP    CH,12           ; highlight?
 JZ     .4
 IMUL   AX,AX,2*6       ; *Z*6
 MUL    AL
.4:
 XCHG   BP,AX
 LODSB                  ; xcoord
 SUB    AL,BL
 IMUL   AL
 SHR    AX,CL
 RCL    AX,1
 SUB    BP,AX
 LODSB                  ; ycoord
 SUB    AL,BH
 IMUL   AL
 CMP    AX,BP           ; inside?
 JNL    .5
 MOV    DL,CH           ; DL=new color
.5:
RETN

;--------------------------------------------------------------------------
IRQ:
 PUSHAD
 PUSH DS
 PUSH CS
 POP DS
 MOV DI,IRQ.COUNTER-4
 MOV ESI,1
.COUNTER:
 MOV AL,2
.SAMPLE:
 SHR AL,1
;TEST AL,AL
 JZ @F
 OUT 42H,AL
@@:
 MOV BX,[DI+2]
 INC DWORD [DI]

KICKDRUM:
 MOV BP,8191
 AND BP,SI

 INCLUDE "MUSIC1.INC"

IRQEND:
 MOV [IRQ.SAMPLE-1],DL
 POP DS
 MOV AL,20H
 OUT 20H,AL
 POPAD
IRET

NOTESB:
 DB 24,16,21,16
NOTESA1:
 DB 128,144,192,0
NOTESA2:
 DB 128,152,192,0
NOTES2:
 DB 64,64,85,96
;--------------------------------------------------------------------------

list:
 DW PART01
 DW PART02
 DW PART03
 DW PART04
 DW PART05
 DW PART06
 DW PART07
 DW PART08
 DW PART09
 DW PART10
 DW PART11
 DW PART12
 DW PART13
 DW PART14
 DW PART15
 DW PART16
 DW PART17
 DW PART18
;DW PART19
 DW PART20
 DW PART21
 DW PART22
 DW PART23

PART01: file 'TC.COM'
PART02: file 'TORUS.COM'
PART03: file 'METAL.COM'
PART04: file 'DRUM.COM'
PART05: file 'SMILE.COM'
PART06: file 'STAR.COM'
PART07: file 'KILL.COM'
PART08: file 'QB.COM'
PART09: file 'MANDEL.COM'
PART10: file 'SLEEP.COM'
PART11: file 'SW.COM'
PART12: file 'SHE.COM'
PART13: file 'HOLE.COM'
PART14: file 'BOOT.COM'
PART15: file 'RTX.COM'
PART16: file 'LIFE.COM'
PART17: file 'HYPERM.COM'
PART18: file 'PENROSE.COM'
;PART19: file 'NOLIMIT.COM'
PART20: file 'TEA.COM'
PART21: file 'GRID.COM'
PART22: file 'BRAINS.COM'
PART23:
