/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.infonode.util.Enum;

public final class Direction
extends Enum {
    private static final long serialVersionUID = 1L;
    public static final Direction UP = new Direction(0, "Up", false);
    public static final Direction RIGHT = new Direction(1, "Right", true);
    public static final Direction DOWN = new Direction(2, "Down", false);
    public static final Direction LEFT = new Direction(3, "Left", true);
    public static final Direction[] DIRECTIONS = new Direction[]{UP, RIGHT, DOWN, LEFT};
    private transient Direction rotateCW;
    private transient boolean isHorizontal;

    private Direction(int value, String name, boolean isHorizontal) {
        super(value, name);
        this.isHorizontal = isHorizontal;
    }

    public Direction getNextCW() {
        return this.rotateCW;
    }

    public Direction getNextCCW() {
        return this.rotateCW.rotateCW.rotateCW;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public Direction getOpposite() {
        return this.getNextCW().getNextCW();
    }

    public static Direction[] getDirections() {
        return (Direction[])DIRECTIONS.clone();
    }

    public static Direction decode(ObjectInputStream in) throws IOException {
        return (Direction)Direction.decode(Direction.class, in);
    }

    static {
        Direction.UP.rotateCW = RIGHT;
        Direction.RIGHT.rotateCW = DOWN;
        Direction.DOWN.rotateCW = LEFT;
        Direction.LEFT.rotateCW = UP;
    }
}

