#!/usr/bin/env python
"""
Convert an OCP art studio window into a sjamsplus code
for the AMstrad Expo Compo.

@author Krusty/Benediciton
@data 13 may 2010
"""

import sys
import binascii

AMSDOS_HEADER_SIZE = 128
#OCP_WINDOW_HEADER_SIZE = 4
OCP_WINDOW_HEADER_SIZE = 0

def generate_code(fname):
  """Launch the code generation for the required file.
  """
  input = open(fname, 'rb')
  output = open("%s.z80" %fname, 'w')

  asm_code = ''
  #pass the first bytes
  input.seek(AMSDOS_HEADER_SIZE + OCP_WINDOW_HEADER_SIZE)

  bytes = [ord(input.read(1)) for i in range(8*4)]
  asm_code += "\tCONWAY_DISPLAY_ARBITRARY_BLOCK %s\n" % ",".join([str(byte) for byte in bytes])
  asm_code += "\tadd hl, de\n"
  bytes = [ord(input.read(1)) for i in range(8*4)]
  asm_code += "\tCONWAY_DISPLAY_ARBITRARY_BLOCK %s\n" % ",".join([str(byte) for byte in bytes])
  asm_code += "\tsbc hl, de\n"


  output.write(asm_code)
  input.close()
  output.close()

def main(argv=None):
  if argv is None:
    argv = sys.argv

  if len(argv) != 2:
    print "Usage: %s file" % argv[0]
    return -1

  print 'Convert %s' % argv[1]
  generate_code(argv[1])
  return 0

if __name__  == "__main__":
  sys.exit(main())
