/*
 * Decompiled with CFR 0.152.
 */
package classes;

import java.awt.Color;

public class GraphicsDecoder {
    public static int[] palette = new int[]{13, 13, 19, 25, 1, 7, 10, 16, 7, 25, 24, 26, 6, 8, 15, 17, 1, 19, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
    public static int[] Inks = new int[]{20, 4, 21, 28, 24, 29, 12, 5, 13, 22, 6, 23, 30, 0, 31, 14, 7, 15, 18, 2, 19, 26, 25, 27, 10, 3, 11, 1, 8, 9, 16, 17};
    static int[] GAInks = new int[]{13, 27, 19, 25, 1, 7, 10, 16, 28, 29, 24, 26, 6, 8, 15, 17, 30, 31, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
    protected static final int[] green = new int[]{1333263, 1465361, 1728789, 1860631, 1992729, 2256157, 2585633, 2717475, 2980903, 3376428, 3574063, 3837747, 3969845, 4233016, 4430907, 4760640, 4958018, 5155909, 0x54B44B, 5749070, 6012497, 6144339, 6342230, 6605657, 6869341, 6935134, 7001183, 4167223, 2717475, 7133025, 1465362, 5814862};
    static int[] GREENS = new int[32];
    public static final int[] INKS = new int[]{0x6D6D55, 0x6D6D55, 65365, 0xFFFF55, 85, 0xFF0055, 27989, 16739669, 0xFF0055, 0xFFFF55, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16739584, 0xFF6DFF, 85, 65365, 65280, 65535, 0, 255, 27904, 28159, 7143509, 7208789, 7208704, 0x6DFFFF, 0x6D0000, 7143679, 0x6D6D00, 0x6D6DFF};

    public static void initGreens() {
        for (int i = 0; i < 32; ++i) {
            GraphicsDecoder.GREENS[i] = green[GAInks[i]];
        }
    }

    public Color getCPCColor(int value) {
        return new Color(INKS[GAInks[value]]);
    }

    public static void decodeLinear(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                map[offs + 3] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 2] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 1] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs] = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 7] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                map[offs + 6] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                map[offs + 5] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                map[offs + 4] = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                break;
            }
            case 1: {
                map[offs + 1] = (byte)((b & 0x80) >> 6 | (b & 0x40) >> 6);
                map[offs + 0] = (byte)((b & 0x80) >> 6 | (b & 0x40) >> 6);
                map[offs + 3] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 2] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 5] = (byte)((b & 8) >> 2 | (b & 4) >> 2);
                map[offs + 4] = (byte)((b & 8) >> 2 | (b & 4) >> 2);
                map[offs + 7] = (byte)(b & 2 | b & 1);
                map[offs + 6] = (byte)(b & 2 | b & 1);
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs++] = (byte)((b & 0x40) >> 6);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 0x10) >> 4);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs++] = (byte)((b & 4) >> 2);
                map[offs++] = (byte)((b & 2) >> 1);
                map[offs] = (byte)(b & 1);
                break;
            }
            case 3: {
                map[offs + 3] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 2] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 1] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 7] = (byte)(b & 2 | b & 1);
                map[offs + 6] = (byte)(b & 2 | b & 1);
                map[offs + 5] = (byte)(b & 2 | b & 1);
                map[offs + 4] = (byte)(b & 2 | b & 1);
            }
        }
    }

    public static final void decodeLinearHalf(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                byte by = (byte)((b & 0x80) >> 4 | (b & 0x40) >> 4 | (b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 1] = by;
                map[offs] = by;
                byte by2 = (byte)(b & 8 | b & 4 | b & 1 | b & 2);
                map[offs + 3] = by2;
                map[offs + 2] = by2;
                break;
            }
            case 1: {
                map[offs++] = (byte)((b & 0x80) >> 6 | (b & 0x40) >> 6);
                map[offs++] = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs++] = (byte)((b & 8) >> 2 | (b & 4) >> 2);
                map[offs] = (byte)(b & 2 | b & 1);
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs++] = (byte)((b & 2) >> 1);
                break;
            }
            case 3: {
                byte by = (byte)((b & 0x20) >> 4 | (b & 0x10) >> 4);
                map[offs + 1] = by;
                map[offs] = by;
                byte by3 = (byte)(b & 2 | b & 1);
                map[offs + 3] = by3;
                map[offs + 2] = by3;
            }
        }
    }

    public static final void decodeFull(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                byte by = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 3] = by;
                map[offs + 2] = by;
                map[offs + 1] = by;
                map[offs] = by;
                byte by2 = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 7] = by2;
                map[offs + 6] = by2;
                map[offs + 5] = by2;
                map[offs + 4] = by2;
                break;
            }
            case 1: {
                byte by = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 1] = by;
                map[offs] = by;
                byte by3 = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 3] = by3;
                map[offs + 2] = by3;
                byte by4 = (byte)((b & 0x20) >> 5 | b & 2);
                map[offs + 5] = by4;
                map[offs + 4] = by4;
                byte by5 = (byte)((b & 0x10) >> 4 | (b & 1) << 1);
                map[offs + 7] = by5;
                map[offs + 6] = by5;
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs++] = (byte)((b & 0x40) >> 6);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 0x10) >> 4);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs++] = (byte)((b & 4) >> 2);
                map[offs++] = (byte)((b & 2) >> 1);
                map[offs] = (byte)(b & 1);
                break;
            }
            case 3: {
                byte by = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 3] = by;
                map[offs + 2] = by;
                map[offs + 1] = by;
                map[offs] = by;
                byte by6 = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 7] = by6;
                map[offs + 6] = by6;
                map[offs + 5] = by6;
                map[offs + 4] = by6;
            }
        }
    }

    public static final void decodeHalf(byte[] map, int offs, int mode, int b) {
        switch (mode) {
            case 0: {
                byte by = (byte)((b & 0x80) >> 7 | (b & 8) >> 2 | (b & 0x20) >> 3 | (b & 2) << 2);
                map[offs + 1] = by;
                map[offs] = by;
                byte by2 = (byte)((b & 0x40) >> 6 | (b & 4) >> 1 | (b & 0x10) >> 2 | (b & 1) << 3);
                map[offs + 3] = by2;
                map[offs + 2] = by2;
                break;
            }
            case 1: {
                map[offs++] = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs++] = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs++] = (byte)((b & 0x20) >> 5 | b & 2);
                map[offs] = (byte)((b & 0x10) >> 4 | (b & 1) << 1);
                break;
            }
            case 2: {
                map[offs++] = (byte)((b & 0x80) >> 7);
                map[offs++] = (byte)((b & 0x20) >> 5);
                map[offs++] = (byte)((b & 8) >> 3);
                map[offs] = (byte)((b & 2) >> 1);
                break;
            }
            case 3: {
                byte by = (byte)((b & 0x80) >> 7 | (b & 8) >> 2);
                map[offs + 1] = by;
                map[offs] = by;
                byte by3 = (byte)((b & 0x40) >> 6 | (b & 4) >> 1);
                map[offs + 3] = by3;
                map[offs + 2] = by3;
            }
        }
    }
}

