/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.core.device.Register;
import JCPC.ui.Debugger;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ERegisters
extends JPanel {
    protected Font fixed;
    protected Device device;

    public void setDevice(Device value) {
        this.device = value;
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.setFont(this.getFont());
        if (this.device != null) {
            int i;
            Register[] regs = this.device.getRegisters();
            int y = -1;
            int cols = 1;
            for (i = 0; i < regs.length; ++i) {
                cols = Math.max(cols, regs[i].getColumn() + 1);
            }
            for (i = 0; i < regs.length; ++i) {
                GridBagConstraints gbc;
                JLabel label;
                Register reg = regs[i];
                String fmt = reg.getFormat();
                int col = reg.getColumn() * 2;
                if (col == 0) {
                    ++y;
                }
                int w = 1;
                if (fmt != null) {
                    label = new JLabel(fmt);
                    label.setFont(this.fixed);
                    label.setForeground(Debugger.navy);
                    w = cols * 2 - 1;
                    gbc = new GridBagConstraints(1, y++, w, 1, 0.0, 0.0, 17, 0, new Insets(1, 4, 1, 1), 0, 0);
                    this.add((Component)label, gbc);
                }
                label = new JLabel(reg.getName());
                label.setForeground(Debugger.navy);
                gbc = new GridBagConstraints(col, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 2, 1), 0, 0);
                this.add((Component)label, gbc);
                JTextField tf = new JTextField();
                tf.setFont(this.fixed);
                gbc = new GridBagConstraints(col + 1, y, w, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
                this.add((Component)tf, gbc);
            }
            GridBagConstraints gbc = new GridBagConstraints(0, y + 1, 2, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)new JLabel(), gbc);
        }
        this.setValues();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fixed = new Font("Courier", 0, font.getSize());
    }

    public void setValues() {
        Component[] comp = this.getComponents();
        Register[] regs = this.device.getRegisters();
        int index = 0;
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof JTextField)) continue;
            Register reg = regs[index];
            String fmt = reg.getFormat();
            String str = "";
            int w = 0;
            if (fmt != null) {
                str = "0000000000000000" + Integer.toBinaryString(this.device.getRegisterValue(index));
                w = reg.getBits();
            } else {
                str = "000000000000000" + Util.hex(this.device.getRegisterValue(index));
                w = (reg.getBits() + 3) / 4;
            }
            ((JTextField)comp[i]).setText(str.substring(str.length() - w));
            ++index;
        }
    }
}

