/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.device.Computer;
import JCPC.ui.Counter;
import JCPC.ui.TimerListener;
import JCPC.util.diss.Disassembler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.border.BevelBorder;

public class EDisassembler
extends JComponent
implements AdjustmentListener,
TimerListener {
    protected static final Color selBackground = new Color(0xE0E0E0);
    protected static final Color selForeground = null;
    protected static final Color pcBackground = new Color(127);
    protected static final Color pcForeground = Color.white;
    protected JScrollBar scrollBar = new JScrollBar(1);
    protected int address = 0;
    protected int maxAddress = 65535;
    protected int pc = 0;
    protected Computer computer;
    protected int lineHeight = 0;
    protected int[] addresses = new int[0];
    protected int selAnchor = 0;
    protected int selStart = 0;
    protected int selEnd = 0;
    protected int timerY = 0;
    protected Counter counter = null;
    protected boolean inSet = false;

    public EDisassembler() {
        this.enableEvents(48L);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setBorder(new BevelBorder(1));
        this.setFont(new Font("Courier", 0, 12));
        this.setLayout(new BorderLayout());
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setBlockIncrement(16);
        this.add((Component)this.scrollBar, "East");
        this.setFocusable(true);
    }

    public void setComputer(Computer value) {
        this.computer = value;
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(65552);
        this.scrollBar.setVisibleAmount(16);
        this.maxAddress = this.computer.getMemory().getAddressSize() - 1;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Disassembler diss;
        Insets insets = this.getInsets();
        Rectangle rect = new Rectangle(insets.left + 1, insets.top + 1, this.getWidth() - this.scrollBar.getWidth() - insets.left - insets.right - 2, this.getHeight() - insets.top - insets.bottom - 2);
        g.setColor(Color.black);
        g.drawRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1);
        g.setColor(this.getBackground());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setFont(this.getFont());
        FontMetrics fm = g.getFontMetrics();
        if (this.computer != null && (diss = this.computer.getDisassembler()) != null) {
            int a = fm.getAscent();
            int[] addr = new int[]{this.address};
            int h = this.lineHeight = fm.getHeight();
            this.addresses = new int[(rect.height + h - 1) / h];
            int n = 0;
            for (int y = rect.y; y < rect.y + rect.height; y += fm.getHeight()) {
                this.addresses[n++] = addr[0];
                if (addr[0] == this.pc) {
                    g.setColor(pcBackground);
                    g.fillRect(0, y, rect.width, fm.getHeight());
                    g.setColor(pcForeground == null ? this.getForeground() : pcForeground);
                } else if (addr[0] >= this.selStart && addr[0] <= this.selEnd) {
                    g.setColor(selBackground);
                    g.fillRect(0, y, rect.width, fm.getHeight());
                    g.setColor(selForeground == null ? this.getForeground() : selForeground);
                } else {
                    g.setColor(this.getForeground());
                }
                String line = diss.disassemble(this.computer.getMemory(), addr, true, 30);
                g.drawString(line, rect.x, y + a);
            }
            this.scrollBar.setVisibleAmount(rect.height / h);
        }
    }

    public void setPC(int value) {
        this.pc = value;
        this.setAddress(this.pc, true);
    }

    public void setAddress(int value, boolean scroll) {
        this.address = Math.min(65535, value);
        this.repaint();
        if (scroll) {
            this.inSet = true;
            this.scrollBar.setValue(this.address);
            this.inSet = false;
        }
    }

    public void setAddress(int value) {
        this.setAddress(value, true);
    }

    public int getAddress(int y) {
        Insets insets = this.getInsets();
        return (y = (y - insets.top + 1) / this.lineHeight) < 0 || y >= this.addresses.length ? -1 : this.addresses[y];
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.inSet) {
            switch (e.getValue() - this.address) {
                case 1: {
                    this.nextAddress();
                    break;
                }
                case -1: {
                    this.prevAddress();
                    break;
                }
                case 16: {
                    for (int i = Math.max(1, this.addresses.length - 1); i > 0; --i) {
                        this.nextAddress();
                    }
                    break;
                }
                case -16: {
                    for (int i = Math.max(1, this.addresses.length - 1); i > 0; --i) {
                        this.prevAddress();
                    }
                    break;
                }
                default: {
                    this.setAddress(this.scrollBar.getValue());
                }
            }
            this.scrollBar.setValue(this.address);
        }
    }

    protected void nextAddress() {
        Disassembler diss = this.computer.getDisassembler();
        diss.disassemble(this.computer.getMemory(), this.addresses, false, 0);
        this.setAddress(this.addresses[0], false);
    }

    protected void prevAddress() {
        int result;
        int end = this.addresses[0];
        int addr = end - 6 & 0xFFFF;
        Disassembler diss = this.computer.getDisassembler();
        do {
            result = addr;
            this.addresses[0] = addr;
            diss.disassemble(this.computer.getMemory(), this.addresses, false, 0);
            addr = this.addresses[0];
            if (addr == end) continue;
            addr = result + 1 & 0xFFFF;
        } while (addr != end);
        this.addresses[0] = result;
        this.setAddress(this.addresses[0], false);
    }

    protected void setSelection(int addr, boolean range) {
        if (!range) {
            this.selStart = this.selEnd = addr;
            this.selAnchor = this.selEnd;
        } else if (addr < this.selAnchor) {
            this.selStart = addr;
            this.selEnd = this.selAnchor;
        } else {
            this.selStart = this.selAnchor;
            this.selEnd = addr;
        }
    }

    protected void startTimer(int y) {
        if (this.counter == null) {
            this.counter = new Counter(this, 50L, null);
        }
        this.timerY = y;
    }

    protected void stopTimer() {
        if (this.counter != null) {
            this.counter.stop();
            this.counter = null;
        }
    }

    @Override
    public void timerTick(Counter counter) {
        if (this.counter == counter) {
            if (this.timerY < 0) {
                this.prevAddress();
                this.setSelection(this.address, true);
            } else {
                this.nextAddress();
                this.setSelection(this.addresses[this.addresses.length - 1], true);
            }
            this.scrollBar.setValue(this.address);
            this.repaint();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.getID() == 501) {
                this.setSelection(this.getAddress(e.getY()), (e.getModifiers() & 1) != 0);
                this.repaint();
            } else if (e.getID() == 502) {
                this.stopTimer();
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && (e.getModifiers() & 0x10) != 0) {
            Dimension size = this.getSize();
            int y = e.getY();
            if (y >= size.height) {
                this.setSelection(this.addresses[this.addresses.length - 1], true);
                this.startTimer(y);
            } else if (y < 0) {
                this.setSelection(this.addresses[0], true);
                this.startTimer(y);
            } else {
                this.setSelection(this.getAddress(e.getY()), true);
                this.stopTimer();
            }
            this.repaint();
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            boolean shift = (e.getModifiers() & 1) != 0;
            switch (e.getKeyCode()) {
                case 36: {
                    this.setSelection(0, shift);
                    break;
                }
                case 35: {
                    this.setSelection(this.maxAddress - 1, shift);
                    break;
                }
                case 38: {
                    this.setSelection(this.address - 1, shift);
                    break;
                }
                case 40: {
                    this.setSelection(this.address + 1, shift);
                    break;
                }
                case 34: {
                    this.setSelection(this.address + 10, shift);
                    break;
                }
                case 33: {
                    this.setSelection(this.address - 10, shift);
                }
            }
        }
        super.processKeyEvent(e);
    }
}

