/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.Util;
import JCPC.core.device.Computer;
import JCPC.core.device.memory.Memory;
import JCPC.ui.EButton;
import JCPC.ui.EDisassembler;
import JCPC.ui.EMemory;
import JCPC.ui.ERegisters;
import JCPC.util.diss.Disassembler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class Debugger
extends JFrame
implements MouseListener,
ActionListener {
    public static final Color navy = new Color(0, 0, 127);
    protected Computer computer;
    protected long startCycles = 0L;
    protected JFileChooser fileDlg;
    public JTextField RA;
    protected JButton bRun;
    protected EButton bStep;
    protected EButton bStepOver;
    protected JButton bStop;
    protected EDisassembler eDisassembler;
    protected EMemory eMemory;
    protected ERegisters eRegisters;
    protected JButton jButton1;
    protected JLabel jLabel1;
    protected JLabel jLabel10;
    protected JLabel jLabel11;
    protected JLabel jLabel12;
    protected JLabel jLabel13;
    protected JLabel jLabel14;
    protected JLabel jLabel15;
    protected JLabel jLabel16;
    protected JLabel jLabel17;
    protected JLabel jLabel18;
    protected JLabel jLabel19;
    protected JLabel jLabel2;
    protected JLabel jLabel20;
    protected JLabel jLabel3;
    protected JLabel jLabel4;
    protected JLabel jLabel5;
    protected JLabel jLabel6;
    protected JLabel jLabel7;
    protected JLabel jLabel8;
    protected JLabel jLabel9;
    protected JPanel jPanel1;
    protected JPanel jPanel2;
    protected JPanel jPanel3;
    protected JPanel jPanel4;
    protected JPanel jPanel5;
    protected JScrollPane jScrollPane1;
    protected JSplitPane jSplitPane1;
    protected static JTextField jTextField1;
    protected static JTextField jTextField10;
    protected static JTextField jTextField11;
    protected static JTextField jTextField12;
    protected static JTextField jTextField13;
    protected static JTextField jTextField14;
    protected static JTextField jTextField15;
    protected static JTextField jTextField16;
    protected static JTextField jTextField17;
    protected static JTextField jTextField18;
    protected static JTextField jTextField2;
    protected static JTextField jTextField3;
    protected static JTextField jTextField4;
    protected static JTextField jTextField5;
    protected static JTextField jTextField6;
    protected static JTextField jTextField7;
    protected static JTextField jTextField8;
    protected static JTextField jTextField9;
    protected JLabel lCycleCount;
    protected JLabel lCycles;
    protected JMenuItem mGoto;
    protected JMenuItem mSave;
    protected static JPanel panel1;
    protected static JPanel panel10;
    protected static JPanel panel11;
    protected static JPanel panel12;
    protected static JPanel panel13;
    protected static JPanel panel14;
    protected static JPanel panel15;
    protected static JPanel panel16;
    protected static JPanel panel17;
    protected static JPanel panel2;
    protected static JPanel panel3;
    protected static JPanel panel4;
    protected static JPanel panel5;
    protected static JPanel panel6;
    protected static JPanel panel7;
    protected static JPanel panel8;
    protected static JPanel panel9;
    protected JPopupMenu popupMenu;
    public JTextField vCC;

    public void INK(int pen, int col) {
        if (col == 0xFFFFFF) {
            col = 0xFFFFFE;
        }
        Color color = new Color(col);
        switch (pen) {
            case 0: {
                panel1.setBackground(color);
                break;
            }
            case 1: {
                panel2.setBackground(color);
                break;
            }
            case 2: {
                panel3.setBackground(color);
                break;
            }
            case 3: {
                panel4.setBackground(color);
                break;
            }
            case 4: {
                panel5.setBackground(color);
                break;
            }
            case 5: {
                panel6.setBackground(color);
                break;
            }
            case 6: {
                panel7.setBackground(color);
                break;
            }
            case 7: {
                panel8.setBackground(color);
                break;
            }
            case 8: {
                panel9.setBackground(color);
                break;
            }
            case 9: {
                panel10.setBackground(color);
                break;
            }
            case 10: {
                panel11.setBackground(color);
                break;
            }
            case 11: {
                panel12.setBackground(color);
                break;
            }
            case 12: {
                panel13.setBackground(color);
                break;
            }
            case 13: {
                panel14.setBackground(color);
                break;
            }
            case 14: {
                panel15.setBackground(color);
                break;
            }
            case 15: {
                panel16.setBackground(color);
                break;
            }
            case 16: {
                panel17.setBackground(color);
            }
        }
    }

    public void setReg(int reg, byte value) {
        switch (reg) {
            case 0: {
                jTextField1.setText(Util.hex(value));
                break;
            }
            case 1: {
                jTextField2.setText(Util.hex(value));
                break;
            }
            case 2: {
                jTextField3.setText(Util.hex(value));
                break;
            }
            case 3: {
                jTextField4.setText(Util.hex(value));
                break;
            }
            case 4: {
                jTextField5.setText(Util.hex(value));
                break;
            }
            case 5: {
                jTextField6.setText(Util.hex(value));
                break;
            }
            case 6: {
                jTextField7.setText(Util.hex(value));
                break;
            }
            case 7: {
                jTextField8.setText(Util.hex(value));
                break;
            }
            case 8: {
                jTextField9.setText(Util.hex(value));
                break;
            }
            case 9: {
                jTextField10.setText(Util.hex(value));
                break;
            }
            case 10: {
                jTextField11.setText(Util.hex(value));
                break;
            }
            case 11: {
                jTextField12.setText(Util.hex(value));
                break;
            }
            case 12: {
                jTextField13.setText(Util.hex(value));
                break;
            }
            case 13: {
                jTextField14.setText(Util.hex(value));
                break;
            }
            case 14: {
                jTextField15.setText(Util.hex(value));
                break;
            }
            case 15: {
                jTextField16.setText(Util.hex(value));
                break;
            }
            case 16: {
                jTextField17.setText(Util.hex(value));
                break;
            }
            case 17: {
                jTextField18.setText(Util.hex(value));
            }
        }
    }

    public Debugger() {
        this.initComponents();
        this.eDisassembler.setFont(new Font("Monospaced", 0, 11));
        this.eMemory.setFont(new Font("Monospaced", 0, 11));
        this.jButton1.addActionListener(this);
        this.bRun.addActionListener(this);
        this.bStop.addActionListener(this);
        this.bStep.addActionListener(this);
        this.bStepOver.addActionListener(this);
        this.mSave.addActionListener(this);
        this.mGoto.addActionListener(this);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(this.getFontMetrics(this.eMemory.getFont()).getHeight());
    }

    public void setComputer(Computer value) {
        if (this.computer != null) {
            this.computer.removeActionListener(this);
        }
        this.computer = value;
        this.eDisassembler.setComputer(this.computer);
        this.eMemory.setComputer(this.computer);
        if (this.computer != null) {
            this.computer.addActionListener(this);
            this.eRegisters.setDevice(this.computer.getProcessor());
            this.updateDisplay();
        } else {
            this.eRegisters.setDevice(null);
        }
    }

    protected void updateDisplay() {
        this.eDisassembler.setPC(this.computer.getProcessor().getProgramCounter());
        this.lCycleCount.setText(Long.toString(this.computer.getProcessor().getCycles() - this.startCycles));
        this.eRegisters.setValues();
        this.repaint();
    }

    protected long getGotoAddress() {
        String address = JOptionPane.showInputDialog("Address: ", (Object)"#");
        if (address == null) {
            return -1L;
        }
        if ((address = address.trim()).length() == 0) {
            return -1L;
        }
        switch (address.charAt(0)) {
            case '#': 
            case '$': 
            case '&': {
                return Long.parseLong(address.substring(1), 16);
            }
        }
        return Long.parseLong(address);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.computer.clearRunToAddress();
        if (e.getSource() == this.bRun) {
            this.computer.start();
        } else if (e.getSource() == this.bStop) {
            this.computer.stop();
        } else if (e.getSource() == this.bStep) {
            this.computer.step();
        } else if (e.getSource() == this.bStepOver) {
            this.computer.stepOver();
        } else if (e.getSource() == this.computer) {
            this.updateDisplay();
        } else if (e.getSource() == this.jButton1) {
            this.computer.getDisplay().DEBUG_SPRITES = true;
            this.jButton1.setEnabled(false);
        } else if (e.getSource() == this.mGoto) {
            long address = this.getGotoAddress();
            if (address != -1L) {
                if (this.popupMenu.getInvoker() == this.eDisassembler) {
                    this.eDisassembler.setAddress((int)address);
                } else {
                    this.eMemory.setAddress((int)address);
                }
            }
        } else if (e.getSource() == this.mSave) {
            if (this.popupMenu.getInvoker() == this.eDisassembler) {
                this.saveDisassembly();
            } else {
                this.saveMemory();
            }
        }
        this.computer.setFrameSkip(0);
        this.computer.updateDisplay(false);
    }

    protected File showSaveDialog(String title) {
        if (this.fileDlg == null) {
            this.fileDlg = new JFileChooser();
        }
        this.fileDlg.setDialogTitle(title);
        return this.fileDlg.showSaveDialog(this.bRun) == 0 ? this.fileDlg.getSelectedFile() : null;
    }

    public void saveMemory() {
        this.saveMemory(this.eMemory.selStart, this.eMemory.selEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMemory(int start, int end) {
        File file = this.showSaveDialog("Save Memory");
        if (file != null) {
            try (FileOutputStream io = new FileOutputStream(file);){
                Memory mem = this.computer.getMemory();
                for (int addr = start; addr <= end; ++addr) {
                    io.write(mem.readByte(addr));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveDisassembly() {
        this.saveDisassembly(this.eDisassembler.selStart, this.eDisassembler.selEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDisassembly(int start, int end) {
        File file = this.showSaveDialog("Save Disassembly");
        if (file != null) {
            int[] addr = new int[]{start};
            try (FileOutputStream io = new FileOutputStream(file);){
                Disassembler diss = this.computer.getDisassembler();
                Memory mem = this.computer.getMemory();
                while (addr[0] <= end) {
                    String s = Util.hex((short)addr[0]) + ": ";
                    io.write((s + diss.disassemble(mem, addr) + "\r\n").getBytes());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.mGoto = new JMenuItem();
        this.mSave = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        panel1 = new JPanel();
        panel2 = new JPanel();
        panel3 = new JPanel();
        panel4 = new JPanel();
        panel5 = new JPanel();
        panel6 = new JPanel();
        panel7 = new JPanel();
        panel8 = new JPanel();
        panel9 = new JPanel();
        panel10 = new JPanel();
        panel11 = new JPanel();
        panel12 = new JPanel();
        panel13 = new JPanel();
        panel14 = new JPanel();
        panel15 = new JPanel();
        panel16 = new JPanel();
        panel17 = new JPanel();
        this.jLabel19 = new JLabel();
        this.vCC = new JTextField();
        this.jLabel20 = new JLabel();
        this.RA = new JTextField();
        this.jPanel3 = new JPanel();
        this.lCycles = new JLabel();
        this.lCycleCount = new JLabel();
        this.eRegisters = new ERegisters();
        this.jSplitPane1 = new JSplitPane();
        this.eDisassembler = new EDisassembler();
        this.jScrollPane1 = new JScrollPane();
        this.eMemory = new EMemory();
        this.jPanel4 = new JPanel();
        this.bRun = new JButton();
        this.bStop = new JButton();
        this.bStep = new EButton();
        this.bStepOver = new EButton();
        this.jButton1 = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        jTextField2 = new JTextField();
        this.jLabel3 = new JLabel();
        jTextField3 = new JTextField();
        this.jLabel4 = new JLabel();
        jTextField4 = new JTextField();
        this.jLabel5 = new JLabel();
        jTextField5 = new JTextField();
        this.jLabel6 = new JLabel();
        jTextField6 = new JTextField();
        this.jLabel7 = new JLabel();
        jTextField7 = new JTextField();
        this.jLabel8 = new JLabel();
        jTextField8 = new JTextField();
        this.jLabel9 = new JLabel();
        jTextField9 = new JTextField();
        this.jLabel10 = new JLabel();
        jTextField10 = new JTextField();
        this.jLabel11 = new JLabel();
        jTextField11 = new JTextField();
        this.jLabel12 = new JLabel();
        jTextField12 = new JTextField();
        this.jLabel13 = new JLabel();
        jTextField13 = new JTextField();
        this.jLabel14 = new JLabel();
        jTextField14 = new JTextField();
        this.jLabel15 = new JLabel();
        jTextField15 = new JTextField();
        this.jLabel16 = new JLabel();
        jTextField16 = new JTextField();
        this.jLabel17 = new JLabel();
        jTextField17 = new JTextField();
        this.jLabel18 = new JLabel();
        jTextField18 = new JTextField();
        this.mGoto.setText("Goto...");
        this.popupMenu.add(this.mGoto);
        this.mSave.setText("Save...");
        this.popupMenu.add(this.mSave);
        this.setTitle("JavaGX4000 Debugger");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0));
        panel1.setBorder(BorderFactory.createEtchedBorder());
        panel1.setMinimumSize(new Dimension(18, 18));
        panel1.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel1);
        panel2.setBorder(BorderFactory.createEtchedBorder());
        panel2.setMinimumSize(new Dimension(18, 18));
        panel2.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel2);
        panel3.setBorder(BorderFactory.createEtchedBorder());
        panel3.setMinimumSize(new Dimension(18, 18));
        panel3.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel3);
        panel4.setBorder(BorderFactory.createEtchedBorder());
        panel4.setMinimumSize(new Dimension(18, 18));
        panel4.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel4);
        panel5.setBorder(BorderFactory.createEtchedBorder());
        panel5.setMinimumSize(new Dimension(18, 18));
        panel5.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel5);
        panel6.setBorder(BorderFactory.createEtchedBorder());
        panel6.setMinimumSize(new Dimension(18, 18));
        panel6.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel6);
        panel7.setBorder(BorderFactory.createEtchedBorder());
        panel7.setMinimumSize(new Dimension(18, 18));
        panel7.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel7);
        panel8.setBorder(BorderFactory.createEtchedBorder());
        panel8.setMinimumSize(new Dimension(18, 18));
        panel8.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel8);
        panel9.setBorder(BorderFactory.createEtchedBorder());
        panel9.setMinimumSize(new Dimension(18, 18));
        panel9.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel9);
        panel10.setBorder(BorderFactory.createEtchedBorder());
        panel10.setMinimumSize(new Dimension(18, 18));
        panel10.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel10);
        panel11.setBorder(BorderFactory.createEtchedBorder());
        panel11.setMinimumSize(new Dimension(18, 18));
        panel11.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel11);
        panel12.setBorder(BorderFactory.createEtchedBorder());
        panel12.setMinimumSize(new Dimension(18, 18));
        panel12.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel12);
        panel13.setBorder(BorderFactory.createEtchedBorder());
        panel13.setMinimumSize(new Dimension(18, 18));
        panel13.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel13);
        panel14.setBorder(BorderFactory.createEtchedBorder());
        panel14.setMinimumSize(new Dimension(18, 18));
        panel14.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel14);
        panel15.setBorder(BorderFactory.createEtchedBorder());
        panel15.setMinimumSize(new Dimension(18, 18));
        panel15.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel15);
        panel16.setBorder(BorderFactory.createEtchedBorder());
        panel16.setMinimumSize(new Dimension(18, 18));
        panel16.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel16);
        panel17.setBorder(BorderFactory.createEtchedBorder());
        panel17.setMinimumSize(new Dimension(18, 18));
        panel17.setPreferredSize(new Dimension(18, 18));
        this.jPanel2.add(panel17);
        this.jLabel19.setText("LineCounter:");
        this.jPanel2.add(this.jLabel19);
        this.vCC.setColumns(2);
        this.vCC.setText("00");
        this.jPanel2.add(this.vCC);
        this.jLabel20.setText("RasterCounter:");
        this.jPanel2.add(this.jLabel20);
        this.RA.setColumns(2);
        this.RA.setText("00");
        this.jPanel2.add(this.RA);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.lCycles.setForeground(new Color(0, 0, 127));
        this.lCycles.setText("Cycles:");
        this.jPanel3.add(this.lCycles);
        this.lCycleCount.setText("0");
        this.lCycleCount.addMouseListener(this);
        this.jPanel3.add(this.lCycleCount);
        this.jPanel1.add((Component)this.jPanel3, "East");
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.eRegisters.setFocusable(false);
        this.eRegisters.setLayout(null);
        this.getContentPane().add((Component)this.eRegisters, "After");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setContinuousLayout(true);
        this.eDisassembler.setComponentPopupMenu(this.popupMenu);
        this.eDisassembler.addMouseListener(this);
        this.jSplitPane1.setTopComponent(this.eDisassembler);
        this.eMemory.setComponentPopupMenu(this.popupMenu);
        this.jScrollPane1.setViewportView(this.eMemory);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jPanel4.setPreferredSize(new Dimension(100, 10));
        this.bRun.setText("Run");
        this.jPanel4.add(this.bRun);
        this.bStop.setText("Stop");
        this.jPanel4.add(this.bStop);
        this.bStep.setText("Step");
        this.jPanel4.add(this.bStep);
        this.bStepOver.setText("S.Over");
        this.jPanel4.add(this.bStepOver);
        this.jButton1.setText("Debug Sprites");
        this.jPanel4.add(this.jButton1);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "CRTC", 0, 0, new Font("Dialog", 0, 10)));
        this.jPanel5.setMinimumSize(new Dimension(10, 10));
        this.jPanel5.setPreferredSize(new Dimension(90, 328));
        this.jPanel5.setLayout(new FlowLayout(1, 5, 0));
        this.jLabel1.setFont(new Font("Monospaced", 0, 10));
        this.jLabel1.setText("Reg. 00");
        this.jPanel5.add(this.jLabel1);
        jTextField1.setColumns(2);
        jTextField1.setFont(new Font("Monospaced", 0, 10));
        jTextField1.setText("0");
        jTextField1.setMinimumSize(new Dimension(18, 16));
        jTextField1.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField1);
        this.jLabel2.setFont(new Font("Monospaced", 0, 10));
        this.jLabel2.setText("Reg. 01");
        this.jPanel5.add(this.jLabel2);
        jTextField2.setColumns(2);
        jTextField2.setFont(new Font("Monospaced", 0, 10));
        jTextField2.setText("0");
        jTextField2.setMinimumSize(new Dimension(18, 16));
        jTextField2.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField2);
        this.jLabel3.setFont(new Font("Monospaced", 0, 10));
        this.jLabel3.setText("Reg. 02");
        this.jPanel5.add(this.jLabel3);
        jTextField3.setColumns(2);
        jTextField3.setFont(new Font("Monospaced", 0, 10));
        jTextField3.setText("0");
        jTextField3.setMinimumSize(new Dimension(18, 16));
        jTextField3.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField3);
        this.jLabel4.setFont(new Font("Monospaced", 0, 10));
        this.jLabel4.setText("Reg. 03");
        this.jPanel5.add(this.jLabel4);
        jTextField4.setColumns(2);
        jTextField4.setFont(new Font("Monospaced", 0, 10));
        jTextField4.setText("0");
        jTextField4.setMinimumSize(new Dimension(18, 16));
        jTextField4.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField4);
        this.jLabel5.setFont(new Font("Monospaced", 0, 10));
        this.jLabel5.setText("Reg. 04");
        this.jPanel5.add(this.jLabel5);
        jTextField5.setColumns(2);
        jTextField5.setFont(new Font("Monospaced", 0, 10));
        jTextField5.setText("0");
        jTextField5.setMinimumSize(new Dimension(18, 16));
        jTextField5.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField5);
        this.jLabel6.setFont(new Font("Monospaced", 0, 10));
        this.jLabel6.setText("Reg. 05");
        this.jPanel5.add(this.jLabel6);
        jTextField6.setColumns(2);
        jTextField6.setFont(new Font("Monospaced", 0, 10));
        jTextField6.setText("0");
        jTextField6.setMinimumSize(new Dimension(18, 16));
        jTextField6.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField6);
        this.jLabel7.setFont(new Font("Monospaced", 0, 10));
        this.jLabel7.setText("Reg. 06");
        this.jPanel5.add(this.jLabel7);
        jTextField7.setColumns(2);
        jTextField7.setFont(new Font("Monospaced", 0, 10));
        jTextField7.setText("0");
        jTextField7.setMinimumSize(new Dimension(18, 16));
        jTextField7.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField7);
        this.jLabel8.setFont(new Font("Monospaced", 0, 10));
        this.jLabel8.setText("Reg. 07");
        this.jPanel5.add(this.jLabel8);
        jTextField8.setColumns(2);
        jTextField8.setFont(new Font("Monospaced", 0, 10));
        jTextField8.setText("0");
        jTextField8.setMinimumSize(new Dimension(18, 16));
        jTextField8.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField8);
        this.jLabel9.setFont(new Font("Monospaced", 0, 10));
        this.jLabel9.setText("Reg. 08");
        this.jPanel5.add(this.jLabel9);
        jTextField9.setColumns(2);
        jTextField9.setFont(new Font("Monospaced", 0, 10));
        jTextField9.setText("0");
        jTextField9.setMinimumSize(new Dimension(18, 16));
        jTextField9.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField9);
        this.jLabel10.setFont(new Font("Monospaced", 0, 10));
        this.jLabel10.setText("Reg. 09");
        this.jPanel5.add(this.jLabel10);
        jTextField10.setColumns(2);
        jTextField10.setFont(new Font("Monospaced", 0, 10));
        jTextField10.setText("0");
        jTextField10.setMinimumSize(new Dimension(18, 16));
        jTextField10.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField10);
        this.jLabel11.setFont(new Font("Monospaced", 0, 10));
        this.jLabel11.setText("Reg. 10");
        this.jPanel5.add(this.jLabel11);
        jTextField11.setColumns(2);
        jTextField11.setFont(new Font("Monospaced", 0, 10));
        jTextField11.setText("0");
        jTextField11.setMinimumSize(new Dimension(18, 16));
        jTextField11.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField11);
        this.jLabel12.setFont(new Font("Monospaced", 0, 10));
        this.jLabel12.setText("Reg. 11");
        this.jPanel5.add(this.jLabel12);
        jTextField12.setColumns(2);
        jTextField12.setFont(new Font("Monospaced", 0, 10));
        jTextField12.setText("0");
        jTextField12.setMinimumSize(new Dimension(18, 16));
        jTextField12.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField12);
        this.jLabel13.setFont(new Font("Monospaced", 0, 10));
        this.jLabel13.setText("Reg. 12");
        this.jPanel5.add(this.jLabel13);
        jTextField13.setColumns(2);
        jTextField13.setFont(new Font("Monospaced", 0, 10));
        jTextField13.setText("0");
        jTextField13.setMinimumSize(new Dimension(18, 16));
        jTextField13.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField13);
        this.jLabel14.setFont(new Font("Monospaced", 0, 10));
        this.jLabel14.setText("Reg. 13");
        this.jPanel5.add(this.jLabel14);
        jTextField14.setColumns(2);
        jTextField14.setFont(new Font("Monospaced", 0, 10));
        jTextField14.setText("0");
        jTextField14.setMinimumSize(new Dimension(18, 16));
        jTextField14.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField14);
        this.jLabel15.setFont(new Font("Monospaced", 0, 10));
        this.jLabel15.setText("Reg. 14");
        this.jPanel5.add(this.jLabel15);
        jTextField15.setColumns(2);
        jTextField15.setFont(new Font("Monospaced", 0, 10));
        jTextField15.setText("0");
        jTextField15.setMinimumSize(new Dimension(18, 16));
        jTextField15.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField15);
        this.jLabel16.setFont(new Font("Monospaced", 0, 10));
        this.jLabel16.setText("Reg. 15");
        this.jPanel5.add(this.jLabel16);
        jTextField16.setColumns(2);
        jTextField16.setFont(new Font("Monospaced", 0, 10));
        jTextField16.setText("0");
        jTextField16.setMinimumSize(new Dimension(18, 16));
        jTextField16.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField16);
        this.jLabel17.setFont(new Font("Monospaced", 0, 10));
        this.jLabel17.setText("Reg. 16");
        this.jPanel5.add(this.jLabel17);
        jTextField17.setColumns(2);
        jTextField17.setFont(new Font("Monospaced", 0, 10));
        jTextField17.setText("0");
        jTextField17.setMinimumSize(new Dimension(18, 16));
        jTextField17.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField17);
        this.jLabel18.setFont(new Font("Monospaced", 0, 10));
        this.jLabel18.setText("Reg. 17");
        this.jLabel18.setRequestFocusEnabled(false);
        this.jPanel5.add(this.jLabel18);
        jTextField18.setColumns(2);
        jTextField18.setFont(new Font("Monospaced", 0, 10));
        jTextField18.setText("0");
        jTextField18.setMinimumSize(new Dimension(18, 16));
        jTextField18.setPreferredSize(new Dimension(18, 16));
        this.jPanel5.add(jTextField18);
        this.jPanel4.add(this.jPanel5);
        this.getContentPane().add((Component)this.jPanel4, "West");
        this.pack();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource() == this.lCycleCount) {
            this.lCycleCountMouseClicked(evt);
        } else if (evt.getSource() == this.eDisassembler) {
            this.eDisassemblerMouseClicked(evt);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    private void eDisassemblerMouseClicked(MouseEvent e) {
        int addr;
        if (e.getClickCount() == 2 && (addr = this.eDisassembler.getAddress(e.getY())) != -1) {
            this.computer.setRunToAddress(addr);
            this.computer.start();
        }
    }

    private void lCycleCountMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.startCycles = this.computer.getProcessor().getCycles();
            this.lCycleCount.setText("0");
        }
    }
}

