; Kod napisany przez Piotra Tars

; Linie zaczynajce si od rednika s komentarzem i nie s brane pod uwag
; przy kopilacji

; Program: Bum (wersja dwuwymiarowa - 2W).
; Opis: Program przedstawiajcy dziecinnie prosty do wykonania efekt graficz
; ny typu wybuch. Zrobiona przeze mnie wersja tego efektu jest do znacznie
; uproszczona (dla wikszej czytelnoci kodu). Program dziaa w rozdzielczo
; ci 320x200x256 kolorw. Korzysta z kernela przeczajcego w tryb 32-bitow
; y autorstwa Mikoaja Feliksa (nie zawarem tutaj jego kodu, gdy objanien
; ie jego dziaania od strony technicznej i zasad pracy procesora (przede ws
; zystkim obliczania adresw bezwzgldnych) w rnych trybach; uyty tutaj p
; rzeze mnie 32-bitowy tryb chroniony jest do trudny do opanowania, wic d
; oczyem tylko skompilowany kernel (plik kernel.obj). Pobieny opis dwch
; najwaniejszych trybw procesora zajby kilkanacie kilobajtw i nie jest
; potrzebny do zrozumienia dziaania poniszego programu.
; Algorytm: Program dziaa w ptli. Na pocztku inicjujemy wszystkie punkty:
; ich wsprzdne ustawiamy na (0,0) - aby wybuch zacz si od rodka ekran
; u, a prdkoci pionowe (vy) i poziome (vx) ustawiamy na losow warto z m
; aego przedziau. Potem zmniejszamy warto koloru. Warto ta jest zmniej
; szana z kad klatk animacji, a wic punkty z czasem staj si coraz bard
; ziej ciemne. Po dojciu do zera kolor si przekrca i ma warto 255 (jest
; zmienn typu bajt, a wic bdzie przekrca si co 256 klatek animacji). W
; kadym powtrzeniu ptli sprawdzane jest czy przypadkiem kolor nie przyj
; wartoci zero. W takim przypadku punkty s reinicjowane (dlatego pocztkow
;  warto zmiennej kolor ustawiem na 1 - aby na pocztku zainicjowa wszys
; tkie punkty). Teraz rysujemy punkty: do wsprzdnych x i y dodajemy korek
; ty odpowiednio x i y, aby wybuch byo wida na rodku ekranu i obliczamy p
; ozycj piksela w buforze ze wzoru: p = 320*y + x, poniewa szeroko ekran
; u wynosi 320. W tym programie rysowane s kwadraty 2x2 zamiast pikseli, by
; byy bardziej widoczne. Wane jest te, by punkty nie wychodziy poza ekra
; n i nie byy na jego brzegu - w takim przypadku nie rysujemy ich. Po narys
; owaniu punktw rozmazujemy obraz (rozmazywanie tutaj polega na zsumowaniu
; pikseli nad, pod, z lewej i z prawej aktualnego piksela i podzielenia wyni
; ku przez 4) i ciemniamy obraz o 1. Rysowanie odbywa si cay czas na tym
; samym ekranie, dziki czemu wida tak jakby lad po ruchu pikseli. Po nary
; sowaniu wszystkich punktw przetwarzamy je: do wsprzdnych x i y dodajem
; y odpowiednio prdkoci vx i vy (punkty poruszaj si we wszystkie strony)
; , prdkoci spowalniamy mnoc je przez np: 0.95 (aby punkty poruszay si
; coraz wolniej) i dodajemy grawitacj do prdkoci pionowej (vy) - aby punk
; ty te powoli spaday w d. Cay proces jest powtarzany dopty, dopki u
; ytkownik nie nacinie klawisza 'Esc' co koczy cay program.

MAX_P			equ 600 ; ilo punktw

; Program wykorzystuje interfejs DPMI, a wic musi by zainstalowany w pami
; ci jaki DOS extender typu CWSDPMI, EMM386 lub inny. Moe te by wINDOW$
; 32-bitowy.
.486p
locals

code32 segment para public use32	; uywamy segmentw 32-bitowych, a wic
	 assume cs:code32, ds:code32	; mamy wszystko w jednym segmencie, tak
						; jak pod wINDOZE

global _main:proc				; potrzebne kernelowi
global code32_base:dword		; zwrcone przez kernel


dpmi_regs struc				; struktura potrzebna do wywoa przerwa
	_edi		dd ?			;  16-bitowych w trybie 32-bitowym, par
	_esi		dd ?			; ametry przekazywane s do tej struktur
	_ebp		dd ?			; y, reszt zajmuje si DOS extender
	_none1	dd ?
	_ebx		dd ?
	_edx		dd ?
	_ecx		dd ?
	_eax		dd ?
	_flags	dw ?
	_es		dw ?
	_ds		dw ?
	_fs		dw ?
	_gs		dw ?
	_none2	dw ?
	_none3	dw ?
	_sp		dw ?
	_ss		dw ?
ends
losuj proc

	mov	bx,los_pom
	add	bx,9248h
	ror	bx,3
	mov	los_pom,bx
	mov	ax,los_max
	sub	ax,los_min
	mul	bx
	mov	ax,dx
	add	ax,los_min				; ax - liczba losowa
	ret
endp
_main proc
	finit					; inicjujemy koprocesor matematyczny

poczatek:
	; alokujemy 64000 bajtw pamici (na nasz bufor ekranu)
	mov	cx,64000			; rozmiar pamici do zaalokowania podaje
	xor	bx,bx				; my w BX:CX
	mov	ax,0501h			; wybieramy funkcj alokowania pamici
	int	31h				; wywoujemy host DPMI
	jc	koniec			; jak bd to kaplica
	shl	ebx,16
	mov	bx,cx
	sub	ebx,code32_base
	mov	ax,si
	shl	eax,16
	mov	ax,di
	mov	uchwyt_bufora,eax		; uchwyt zwracany w SI:DI
	mov	ekran,ebx			; adres bezwzgldny BX:CX (ale przerobil
						; imy go na wzgldny, aby mona go byo
						; uywa)

	; czycimy nasz bufor ekranu
	mov	edi,ebx
	xor	eax,eax
	mov	ecx,64000/4
	cld
	rep	stosd

	; obliczamy wzgldny adres VRAM - pami ekranu
	mov	eax,0a0000h
	sub	eax,code32_base
	mov	_a0000h,eax

	; ustaw tryb 13h (graficzny)
	mov	ax,0300h
	mov	bx,10h
	mov	edi,offset _regs
	mov	[edi._eax],13h
	int	31h

	; podajemy numer koloru od ktrego zaczynamy (w tym przypadku 0)
	mov	dx,03c8h
	xor	ax,ax
	out	dx,al
	; zwikszamy numer portu (podawanie kolorw), i wysyamy kolory (skala
	; odcieni szaroci). Podajemy skadowe R, G, B. Maksymalna warto kt
	; rejkolwiek skadowej wynosi 63 (bo wczesne karty graficzne VGA miay
	; 6-bitowy przetwornik analogowo-cyfrowy (DAC) i tak pozostao, aby pr
	; ogramy byy kompatybilne z kad kart graficzn. Mona wczy 8-bi
	; towy DAC, ale to jest rzadko uywane (w tym programie te jest uywa
	; ny 6-bitowy DAC).
	inc	dx
	; za kadym razem ustawiamy 4 jednakowe kolory, zwikszamy jasno o j
	; eden i tak w kko 64 razy
	mov	bx,64
paleta:
	mov	cx,12
paleta_pentla:
	out	dx,al
	loop	paleta_pentla		; loopnicie, czyli inaczej dec cx \ jnz
	inc	al
	dec	bx
	jnz	paleta

main_loop:					; siedzimy ostro w ptli dopki uyszkod
						; nik nie nacinie eskejta
	dec	kolor	
	jnz	jedziemy_dalej

	; inicjujemy punkty
	mov	ecx,MAX_P
	mov	esi,offset punkt_tab
inicjujemy_punkty:
	fldz					; adujemy zero i ustawiamy nim wsprz
	fst	dword ptr [esi]		; dne punktw (wybuch zaczyna si na ro
	fstp	dword ptr [esi+4]		; dku ekranu)

	mov	los_max, 12000		; losujemy liczb z przedziau 0...12000
	call	losuj				; , odejmujemy 6000 otrzymujc warto z
	sub	ax,6000			; przedziau -6000...6000, dzielimy prze
	mov	fpom16,ax			; z skal (700) i ustawiamy ni prdko
	fild	fpom16			; vx
	fdiv	skala
	fstp	dword ptr [esi+8]

	call	losuj				; to samo co wyej dla prdkoci vy
	call	losuj				; dwa razy losuj, bo funkcja losuj jest
	sub	ax,6000			; niedoskonaa
	mov	fpom16,ax
	fild	fpom16
	fdiv	skala
	fstp	dword ptr [esi+12]

	add	esi,16			; przechodzimy do nastpnego punktu
	dec	ecx				; jeeli jeszcze co zostao to powtarza
	jnz	inicjujemy_punkty		; my ptl

jedziemy_dalej:
; zaczynamy wykonywanie punktw

	mov	ecx,MAX_P
	mov	esi,offset punkt_tab
	mov	edi,ekran
wykonuj_punkty:
	fld	dword ptr [esi]		; adujemy wsprzdne punktu, dodajemy
	fadd	korekta_x			; korekty x i y (aby wybuch by na rodk
	fistp	word ptr [xe]		; ku ekranu) i zapisujemy je w zmiennych
	fld	dword ptr [esi+4]		; przechowujcych wsprzdne ekranowe
	fadd	korekta_y
	fistp	word ptr [ye]

	fld	dword ptr [esi+8]		; adujemy prdko vx
	fadd	dword ptr [esi]		; dodajemy do wsprzdnej x
	fstp	dword ptr [esi]		; zapisujemy wynik we wsprzdnej x
	fld	dword ptr [esi+12]	; adujemy prdko vy
	fadd	dword ptr [esi+4]		; dodajemy do wsprzdnej y
	fstp	dword ptr [esi+4]		; zapisujemy wynik we wsprzdnej y
	fld	dword ptr [esi+8]		; adujemy prdko vx
	fmul	delta_v			; spowalniamy deczko
	fstp	dword ptr [esi+8]		; zapisujemy wynik w prdkoci vx
	fld	dword ptr [esi+12]	; adujemy prdko vy
	fmul	delta_v			; spowalniamy deczko
	fadd	grav				; dodajemy grawitacj (aby sobie spaday
	fstp	dword ptr [esi+12]	; zapisujemy wynik w prdkoci vy

	cmp	word ptr [xe],0		; sprawdzamy wsprzdne ekranowe
	je	punkt_nastempny		; nie powinny one by na brzegu ekranu
	cmp	word ptr [ye],0		; (obojtne, czy grnym, czy lewym, czy
	je	punkt_nastempny		; jakim), ani nie powinny wychodzi poza
	cmp	word ptr [xe],318		; ekran (logiczne)
	ja	punkt_nastempny
	cmp	word ptr [ye],198
	ja	punkt_nastempny

	xor	eax,eax			; obliczamy pozycj naszego pikselka w b
	mov	ax,ye				; uforze ekranu ze wzoru: p = 320*y + x,
	shl	ax,6				; stosuj metod przesuni logicznych,
	mov	bx,ax				; bo jest o wiele szybsza od mnoenia (o
	shl	ax,2				; ptymalizacja)
	add	ax,bx
	add	ax,xe				; mamy nasz pozycj p pikselka
	add	eax,edi			; dodajemy adres bufora ekranu
	mov	bl,kolor			; rysujemy kwadracik 2x2 o kolorze podan
	mov	bh,bl				; ym w zmiennej kolor
	mov	[eax],bx
	mov	[eax+320],bx
punkt_nastempny:
	add	esi,16			; przechodzimy do nastpnego punktu
	dec	ecx				; sprawdzamy czy zostay jeszcze punkty
	jnz	wykonuj_punkty		; jeeli tak to powtarzamy ptl


; koczymy wykonywa punkty

	; blur start
	mov edi,ekran			; zerujemy (czycimy) pierwsz lini ekr
	xor eax,eax				; anu
	mov ecx,320/4
	cld
	rep stosd

	mov edx,64000-640			; rozmazujemy cay ekran oprcz pierwsze
	xor ebx,ebx				; j i ostatniej linii
blur_skok:
	mov al,[edi-1]			; bierzemy piksele po lewej, prawej, u g
	mov bl,[edi-320]			; ry i u dou, sumujemy je, dzielimy to
	add ax,bx				; przez 4, odejmujemy 1 (ciemniamy) i z
	mov bl,[edi+1]			; apisujemy
	add ax,bx
	mov bl,[edi+320]
	add ax,bx
	shr ax,2
	jz blur_dalej
	dec al
	mov [edi],al
blur_dalej:
	inc edi
	dec edx
	jnz blur_skok

	xor eax,eax				; zerujemy (czycimy) ostatni lini ekr
	mov ecx,320/4			; anu
	rep stosd
	; blur end

	; czekamy na odwieenie ekranu
	mov	dx,03dah
c1:
	in	al,dx
	test	al,8
	jz	c1
c2:
	in	al,dx
	test	al,8
	jnz	c2

	; wywalamy nasz bufor na ekran
	mov	esi,ekran
	mov	edi,_a0000h
	mov	ecx,64000/4
	cld
	rep	movsd

	; jeeli nie nacinito eskejta to powtarzamy ptelk
	in	al,60h
	dec	al
	jnz	main_loop

	; zwalniamy pami
	mov	eax,uchwyt_bufora
	mov	di,ax
	shr	eax,16
	mov	si,ax
	mov	ax,0502h
	int	31h

	; z powrotem tryb tekstowy (03h)
	mov	ax,0300h
	mov	bx,10h
	mov	edi,offset _regs
	mov	[edi._eax],03h
	int	31h
koniec:
	; koniec programu i powrt do DOS'a
	mov	ah,4Ch
	int	21h

kolor			db 1				; kolor do rysowania pikseli
even
los_min		dw 0				; do losowania: liczba minimalna,
los_max		dw 0				; maksymalna i liczba pomocnicza (
los_pom		dw 1234h			; tak jak zmienna randomseed w pas
fpom16		dw 0				; zczalu)
xe			dw 0				; wsprzdne ekranowe x i y (po k
ye			dw 0				; orekcie)
align 4
_a0000h		dd 0				; adres pamici ekranu (dostp bez
							; poredni)
ekran			dd 0				; przechowuje adres bufora ekranu
uchwyt_bufora	dd 0				; a ten jego uchwyt (potrzebny do
fpom32		dd 0.0			; pniejszego zwolnienia pamici)
korekta_x		dd 160.0			; korekty wsprzdnych (rysujemy
korekta_y		dd 100.0			; od rodka ekranu)
delta_v		dd 0.95			; spowolnienie
grav			dd 0.056636246626546456 ; sia grawitacji
skala			dd 700.0			; do obliczania prdkoci punktw
hor_resolution	dd 320.0			; rozdzielczo pozioma
_regs			dpmi_regs ?
punkt_tab		dd MAX_P dup(?,?,?,?)	; x,y,vx,vy	(16 bajtw)
endp
code32 ends
end