DosSeg
.model small
.386

; =------------------------------------> Nombre de points grs ...
NbPoints equ 1000
w equ word ptr
zoff equ 1800

.stack 100h
.code

; =------------------------------------> We Need Memory For Video Effect
   mov ax,cs
   mov ds,ax

   mov ah,4Ah
   mov bx,64*3*1024/16     ; nb de blocs, un bloc=16octets
   int 21h

   mov ax,4800h
   mov bx,64000/16
   int 21h
   mov cs:[Buffer1],ax     ; on sauvegarde les adresses des buffers

   mov ax,4800h
   int 21h                 ; bx toujours egale a 64000/16
   mov cs:[Buffer2],ax     ; on sauvegarde les adresses des buffers

   mov ax,4800h
   int 21h                 ; idem
   mov cs:[BVideo],ax      ; on sauvegarde les adresses des buffers

; =------------------------------------> Init du mode et des couleurs

     Mov AX,13h                         ; Mode 13h (320x200x256)
     Int 10h                            ; Hop, on l'enclenche

     Mov DX,3C8h                        ; on va enclencher not' palette
     xor al,al                          ; a partir de 0
     out dx,al
     Inc Dl
     mov si,offset pal                  ; pal.. c'est not' pallette! ;)
     mov cl,21*3                        ; juska 21 (3 composantes par couleur)
     rep outsb                          ; KbLaM! Dans le DAC!

; =------------------------------------> On efface les buffers
     mov bx,cs:[Buffer1]                
     mov es,bx
     mov cx,64000/4
     xor di,di
     rep stosd
     mov bx,cs:[Buffer2]
     mov es,bx
     mov cx,64000/4
     xor di,di
     rep stosd

; =------------------------------------> On gnre notre "forme" 3D
     call GenPos

align 4
Boucle:

; =------------------------------------> fs=vieux, gs=nouveau et on inverse
     mov ax,w cs:[Buffer1]
     mov fs,ax
     mov bx,w cs:[Buffer2]
     mov gs,bx

     mov w cs:[Buffer1],bx           ; on inverse les deux pages
     mov w cs:[Buffer2],ax           ; de travail
     call smooth                     ; smooth segment fs -> gs

     call Boules3D                   ; rot et projete les coord
     call AffBoules                  ; affiche dans segment gs

     add cs:[Rotx],1
     add cs:[Roty],2
     add cs:[Rotz],1

; Copie du buffer vers BVideo
     mov ax,cs:[Buffer1]             ; on affiche smooth(vieux)+nouveau
     mov ds,ax
     mov ax,cs:[BVideo]
     mov es,ax
     mov cx,64000/4
     xor eax,eax
     xor si,si
     xor di,di
     rep movsd


     mov ax,cs
     mov ds,ax
     mov ax,cs:[BVideo]
     mov es,ax
     call CopyMask

     Mov DX,3DAh
VSync1:
     In AL,DX
     Test AL,8
     Jnz VSync1
VSync2:
     In AL,DX
     Test AL,8
     Jz Vsync2

; Copie du BVideo vers l'ecran
     mov ax,cs:[BVideo]             ; on affiche smooth(vieux)+nouveau
     mov ds,ax
     mov ax,0A000h
     mov es,ax
     mov cx,(64000-640)/4          ; premiere et derniere ligne vides!
     xor eax,eax
     mov si,320  ; premiere ligne vide
     mov di,si
     rep movsd

     In AL,60h
     Cmp AL,1
     Jne Boucle


; =------------------------------------> Release Memory & DeInit everything
   mov ax,cs:[Buffer2]
   mov es,ax
   mov ah,49h
   int 21h
               
   mov ax,cs:[Buffer1]
   mov es,ax
   mov ah,49h
   int 21h

   mov ax,cs:[BVideo]
   mov es,ax
   mov ax,4900h
   int 21h

     Mov AX,3h                          ; Mode 3 (80x25x16 TXT)
     Int 10h                            ; Hop, on l'enclenche
     Mov ax,cs                          
     mov ds,ax
     mov si,offset ansi                 ; ds:si pointe sur l'ansi de fin
     mov ax,0B800h
     mov es,ax
     xor di,di                          ; es:di sur l'ecran mode texte
     mov cx,4096/4
     rep movsd                          ; KbLaM! On balance l'ansi en video!

 Mov Ah,2
 xor bh,bh
 mov dx,21*256+0
 int 10h


     Mov AX,4C00h                       ; Terminate program
     Int 21h                            ; and return to DOS


; =------------------------------------> PutBoule(ax=x; bx=y; fs=segment)

PutBoule proc   ; putit sprite prgnr

   imul bx,320         ; Y*320     (9)
   mov  di,ax          ; +X        (2)
   add  di,bx          ;           (2)

; premiere ligne: [0,1,1,0]
   mov al,gs:[di+1]              ; (4)
   inc al                        ; (2)
   cmp al,15                     ; (2)
   jl @p1_2                      ; (3 / 7+m)
   mov al,15                     ; (2)
@p1_2:
   mov gs:[di+1],al              ; (2)      => 15 / 19+m

   mov al,gs:[di+2]
   inc al               ; add al,1
   cmp al,15
   jl @p1_3
   mov al,15
@p1_3:
   mov gs:[di+2],al


; deuxieme ligne: [1,2,3,1]
   mov al,gs:[di+320+0]
   inc al               ; add al,1
   cmp al,15
   jl @p2_1
   mov al,15
@p2_1:
   mov gs:[di+320+0],al

   mov al,gs:[di+320+1]
   add al,2
   cmp al,15
   jl @p2_2
   mov al,15
@p2_2:
   mov gs:[di+320+1],al

   mov al,gs:[di+320+2]
   add al,3
   cmp al,15
   jl @p2_3
   mov al,15
@p2_3:
   mov gs:[di+320+2],al

   mov al,gs:[di+320+3]
   inc al               ; add al,1
   cmp al,15
   jl @p2_4
   mov al,15
@p2_4:
   mov gs:[di+320+3],al

; troisieme ligne: [1,3,4,1]
   mov al,gs:[di+320+320]
   inc al               ; add al,1
   cmp al,15
   jl @p3_1
   mov al,15
@p3_1:
   mov gs:[di+320+320],al

   mov al,gs:[di+320+320+1]
   add al,3
   cmp al,15
   jl @p3_2
   mov al,15
@p3_2:
   mov gs:[di+320+320+1],al

   mov al,gs:[di+320+320+2]
   add al,4
   cmp al,15
   jl @p3_3
   mov al,15
@p3_3:
   mov gs:[di+320+320+2],al

   mov al,gs:[di+320+320+3]
   inc al               ; add al,1
   cmp al,15
   jl @p3_4
   mov al,15
@p3_4:
   mov gs:[di+320+320+3],al

; quatrieme ligne: [0,1,1,0]
   mov al,gs:[di+320+320+320+1]
   inc al               ; add al,1
   cmp al,15
   jl @p4_2
   mov al,15
@p4_2:
   mov gs:[di+320+320+320+1],al

   mov al,gs:[di+320+320+320+2]
   inc al               ; add al,1
   cmp al,15
   jl @p4_3
   mov al,15
@p4_3:
   mov gs:[di+320+320+320+2],al

   ret
PutBoule endp

; =------------------------------------> Macros de rotation suivant UN axe
RotateAxis MACRO

        ; X'=CosA(X+Y)-Y(SinA+CosA)
        ; Y'=X(SinA-CosA)+CosA(X+Y)

        push  esi
        push  edi
        push  ebp

        and   bx,01FFh
        shl   bx,1
          
        movsx esi,w cs:[sinus+bx]             ;=> ESI=Sin A
        movsx edi,w cs:[cosinus+bx]           ;=> EDI=Cos A
        mov   ebp,edi
        add   ebp,esi                      ;=> EBP=SinA+CosA
        sub   esi,edi                      ;=> ESI=SinA-CosA
                                           ;=> EDI=COS A
        mov   ebx,eax
        add   eax,ecx                      ;=> X+Y
        imul  edi                          ;=> CosA(X+Y)
        mov   edi,eax                      ;=> EDI=CosA(x+y)

        mov   eax,ebx
        imul  esi                          ;=> X*(SinA-CosA)
        mov   ebx,eax
        add   ebx,edi                      ;=> EDI=y'

        mov   eax,ecx
        imul  ebp
        sub   edi,eax

        mov   eax,edi                      ;=> EAX=X'
        mov   ecx,ebx                      ;=> ECX=y'
        sar   eax,12
        sar   ecx,12
              
        pop   ebp
        pop   edi
        pop   esi
ENDM


; =------------------------------------> Rotations et les translations
Boules3D proc

        mov   si,offset SPts
        mov   di,offset DPts
        xor   edx,edx        
        mov   ax,NbPoints
        mov   cs:[ptemp],ax
             
align 4
@NextPoint:
        movsx eax,w cs:[si+2]          ; EAX = Y Coord
        movsx ecx,w cs:[si+4]          ; ECX = Z Coord
        movsx ebx,cs:[Rotx]
        RotateAxis                     ; Rotation X
        mov   w cs:[di+2],ax             ; on sauve Y
        movsx eax,w cs:[si]            ; EAX = X Coord
        movsx ebx,cs:[Roty]            ; ECX = Z Coord
        RotateAxis                     ; Rotation Y
;        add   ecx,cs:[Trz]
        mov   w cs:[di+4],cx           ; sauve Z
        movsx ecx,w cs:[di+2]          ; ECX = YCoord
        movsx ebx,cs:[Rotz]
        RotateAxis                     ; Rotation Z
;        add   eax,cs:[Trx]
        mov   w cs:[di],ax             ; sauve X
;        add   ecx,cs:[Try]
        mov   w cs:[di+2],cx           ; sauve Y
        add   si,6
        add   di,6
        dec   cs:[ptemp]
        jnz   @NextPoint
        

        mov   si,offset DPts
        mov   di,offset PPts
        xor   edx,edx        
        mov   ax,NbPoints
        mov   cs:[ptemp],ax

align 4
@NextPointToProject:
        movsx eax,w cs:[si+0]          ; EAX = X Coord
        movsx edx,w cs:[si+2]          ; EDX = Y Coord
        movsx ecx,w cs:[si+4]          ; ECX = Z Coord

        add   ecx,zoff                 ; Z = Z + ZOff
        mov   ebx,edx
        cdq                            ; etend le signe
        shl   eax,8                    ; X = X * 256   
        idiv  ecx                      ; X = X/(Z+Zoff)
        xchg  eax,ebx                  ; Permutte X et Y pour la division
        cdq                            ; etend le signe
        shl   eax,8                    ; Y = Y * 256
        idiv  ecx                      ; Y = Y/(Z+Zoff)
        add   eax,100                  ; Y = Y+100
        add   ebx,160                  ; X = X+160
        xchg  eax,ecx


        mov   w cs:[di+0],bx           ; on sauve X
        mov   w cs:[di+2],cx           ; on sauve Y

        add   si,6
        add   di,4
        dec   cs:[ptemp]
        jnz   @NextPointToProject

        ret
Boules3D endp


; =------------------------------------> Genere positions des boules
GenPos proc
        mov di,offset SPts
        mov w cs:[ptemp],0

        xor ax,ax
@Iloop:
        xor bx,bx
@Jloop:
        xor cx,cx
@Kloop:
        mov dx,ax
        sub dx,900
        mov cs:[di+0],dx

        mov dx,bx
        sub dx,900
        mov cs:[di+2],dx

        mov dx,cx
        sub dx,900
        mov cs:[di+4],dx

        add di,6
        inc w cs:[ptemp]
        cmp w cs:[ptemp],NbPoints
        jge @OutOut


        add cx,200
        cmp cx,2000
        jl @Kloop

        add bx,200
        cmp bx,2000
        jl @Jloop

        add ax,200
        cmp ax,2000
        jl @Iloop
@OutOut:

        ret
GenPos endp

; =------------------------------------> Affiche les boules
AffBoules proc
        mov   si,offset PPts
        mov   cx,NbPoints
align 4
@AffBouloop:

        mov   ax,cs:[si+0]
        cmp ax,0
        jle @OutLimit
        cmp ax,319-4
        jg @OutLimit

        mov   bx,cs:[si+2]
        cmp bx,0
        jle @OutLimit
        cmp bx,199-4
        jg @OutLimit

        call  PutBoule

@OutLimit:
        add si,4
        dec cx
        jnz @AffBouloop

        ret
AffBoules endp


Smooth proc
   mov si,320
   mov di,si

   xor ax,ax
   xor dx,dx

   mov bx,198             ; une colonne -1 du debut -1 de la fin
align 4
@LoopSmoothY:
   inc si
   inc di
   mov cx,318             ; une ligne -1 du debut -1 de la fin
align 4
@LoopSmoothX:
   mov al,fs:[si-321]
   mov dx,ax
   mov al,fs:[si-319]
   add dx,ax
   mov al,fs:[si+321]
   add dx,ax
   mov al,fs:[si+319]
   add dx,ax
   shr dx,2
   mov gs:[di],dl
   inc si
   inc di
   dec cx
   jnz @LoopSmoothX
   inc si
   inc di
   dec bx
   jnz @LoopSmoothY

   ret
Smooth endp

CopyMask proc
; es:di dest
; ds:si source

        xor di,di             ; dest
        xor cx,cx
        mov si,offset Pict      ; SOurce
align 4
@CopyMaskLoop:
        lodsb                   ; on charge une valeur
        cmp al,253
        jb @NormalPix           ; plus petit ke 253 => no compression
        je @MaskedPix           ; =253 => pixel nul, ne pas afficher
        cmp al,255
        jb @ByteRepPix          ; plus petit ke 255 => compression <256

        lodsw                   ; Nb de repet
        mov cx,ax             ; dans ecx
        lodsb                   ; kel couleur a repeter ?
        rep stosb               ; on pose tout ca
        cmp si,offset Pictfin
        jb @CopyMaskLoop        ; fini ?
        ret

@NormalPix:
        cmp al,0
        je @NoPiiix
        stosb                   ; On pose le pix
        cmp si,offset Pictfin
        jb @CopyMaskLoop        ; fini ?
        ret

@NoPiiix:
        inc di
        cmp si,offset Pictfin
        jb @CopyMaskLoop        ; fini ?


@MaskedPix:
        lodsw                   ; Nb de repet du '0'
        add di,ax               ; on 'saute' autant de pix a l'ecran (mask)
        cmp si,offset Pictfin
        jb @CopyMaskLoop        ; fini ?
        ret

@ByteRepPix:
        lodsb                   ; Nb de repet
;        xor ch,ch
        mov cl,al               ; dans ecx
        lodsb                   ; kel couleur a repeter ?
        rep stosb               ; on pose tout ca
        cmp si,offset Pictfin
        jb @CopyMaskLoop       ; fini ?
        ret
CopyMask endp

; =------------------------------------> Datas in Code Segment: Sinus Table
align 4
include sinus.inc

; =------------------------------------> Datas: Blabla de la fin!
include ansi.inc

; =------------------------------------> Datas: Palette et Image
include pal.inc
align 4
include image.inc

; =------------------------------------> Datas: Buffers Segment Backup
Buffer1 dw 0
Buffer2 dw 0
BVideo  dw 0

; =------------------------------------> Datas: Source Points
align 4
SPts   dw 3*NbPoints dup(0)

; =------------------------------------> Datas: Destination Points
align 4
DPts   dw 3*NbPoints dup(0)

; =------------------------------------> Datas: Projected Points
align 4
PPts   dw 2*NbPoints dup(0)

; =------------------------------------> Datas: Variable Pour les rotations
ptemp   dw 0

;Trx     dd 0
;Try     dd 0
;Trz     dd 0

Rotx    dw 0
Roty    dw 0
Rotz    dw 0

end
