! Fire effect for the SEGA 32X 
! Mic, 2008

	.text
	.global	_start

_start:
	bra 	_start
	nop
	
	mov.l	stack_top,r15

	mov.w	vscreen_numwords,r2
	mov.l	vscreen,r8
	add	r2,r2
	mov	#0,r0
_clear_vscreen:
	mov.w	r0,@r8
	dt	r2	
	bf/s	_clear_vscreen
	add	#2,r8
	
! Wait for the SH2 to gain access to the VDP

	mov.l	SYS_REG,r1
	mov.w	bit15,r10
_wait_for_VDP_access:
	mov.w	@r1,r0
	tst	r10,r0
	bt	_wait_for_VDP_access
	
	
! Setup palette

	mov 	#0,r8
	mov 	#0x1F,r5
	mov.l 	color_mask,r6
	mov 	#64,r0
	mov.l 	CRAM,r4
	mov.w	bit15,r9
_setup_palette:
	mov	r8,r2
	or	r9,r2
	mov.w 	r2,@r4			! @r4 = r8
	mov 	r8,r2
	shll2 	r2
	shll2 	r2
	add 	r2,r2
	or 	r5,r2
	or	r9,r2
	mov.w 	r2,@(r0,r4)		! @(64,r4) = 0x1F | r8<<5
	shll 	r0
	mov 	r8,r2
	shll8 	r2
	shll2 	r2
	or 	r6,r2
	or	r9,r2
	mov.w 	r2,@(r0,r4)		! @(128,r4) = 0x07FF | r8<<10
	shlr 	r0
	add 	#2,r4
	add 	#1,r8
	cmp/gt	r5,r8
	bf 	_setup_palette
		
! Set the remaining colors to white

	add	#-33,r8
	add	#127,r4
	add	#1,r4
	mov	#160,r0
	extu.b	r0,r0
_set_colors_to_white:
	mov.w	r8,@r4
	dt	r0
	bf/s	_set_colors_to_white
	add 	#2,r4


! Set VDP mode 1  

	mov.l	VDP_REG,r1
	mov	#1,r0
	mov.w	r0,@r1
	add	#2,r1
	mov	#0,r0
	mov.w	r0,@r1


mov #0,r14

_forever:
	mov #0,r8			! X
_xloop:
	mov.l	vscreen,r4
	add	r8,r4
	mov 	#80,r9 
	mov	#80,r1
	shll2	r1
	mov	r1,r15
	add	r15,r15
	
	mov.w	readoffs,r5
	mov.w	writeoffs,r6
	add	r4,r5
	add	r4,r6
	
_yloop:
	mov	r5,r7
	add	r15,r7
	add	#4,r7
				
! Read 4 pixels

	mov.b	@r5,r10
	mov.b	@(2,r5),r0
	extu.b	r0,r11
	mov.b	@(4,r5),r0
	extu.b	r0,r12
	mov.b	@r7,r13
	extu.b 	r10,r0
	extu.b 	r13,r13
				
! Calculate average

	add	r11,r0
	add	r12,r0
	add	r13,r0
	shlr2	r0
				
! Decrement color value if >0

	cmp/eq 	#0,r0
	bt 	_no_dec
	dt 	r0
_no_dec:

! Duplicate bits 0..7 into bits 8..15

	swap.b	r0,r10
	or 	r0,r10

	mov 	r6,r0
	mov.w 	r10,@r6			! Draw 2 pixels	
	mov.w 	r10,@(r0,r1)		! Draw 2 more pixels one scanline below
	
	add	r15,r5			! Move 2 lines down
	dt 	r9
	bf/s 	_yloop
	add	r15,r6			! Move 2 lines down

! Generate a pseudo-random number

	mov.l	rng_data,r10		! Point to seed1 in RAM
	mov	r10,r0
	add	#2,r0			! Point to the random number table in RAM
	mov.b 	@r10+,r11 		! seed1
	shll 	r11
	mov.w 	@(r0,r11),r12		
	shlr 	r11
	mov.b 	@r10+,r4		! seed2
	shll 	r4
	mov.w 	@(r0,r4),r13
	add	r13,r12			! Add the two numbers
	mov.w 	r12,@(r0,r4)
	shlr 	r4
	add	#1,r11			! Increase seed1
	add	#1,r4			! Increase seed2
	mov	#0x7,r13		
	and	r13,r11
	and	r13,r4
	mov	r12,r2			! Put the random number in r2
	mov.b	r4,@-r10		! Store seed2
	mov.b	r11,@-r10		! Store seed1

	add	#28,r2
	mov 	#191,r10
	extu.b	r10,r10
	and	r10,r2
			
	mov.l	spark,r0

	add	#2,r8
	cmp/eq	r1,r8
	bf/s	_xloop
	mov.b	r2,@(r0,r8)		! Store random pixel

! Flip the framebuffer selection bit, then wait for the flip to take effect
	mov.l	VDP_REG,r1
	add	#0x0a,r1
	mov.w 	@r1,r2
	mov	r14,r0
	xor	#1,r0
	mov.w	r0,@r1
	mov	r0,r14
_wait_FS:
	mov.w	@r1,r0
	xor	r2,r0
	tst	#1,r0
	bt	_wait_FS

! Initialize the line table in the first 512 bytes of the current framebuffer

	mov.w	bit8,r0
	mov	#160,r4
	extu.b	r4,r4
	mov.w	bit8,r2
	mov.l	video_memory,r5	
_init_lt:
	mov.w	r0,@r5
	add	r4,r0
	dt	r2
	bf/s	_init_lt
	add	#2,r5
	
_copy_vscreen:
	mov.w	vscreen_numwords,r2
	mov.l	VRAM_pixels,r8
	mov.l	vscreen,r3
	add	r2,r2
_copy_to_vram:
	mov.w	@r3+,r1
	mov.w	r1,@r8
	dt	r2	
	bf/s	_copy_to_vram
	add	#2,r8
	
	bra 	_forever			
	nop

		
.align 1

bit8:
	.short	256
bit15:
	.short	-32768
vscreen_numwords:
	.short 	17920	
readoffs:
	.short	21118
writeoffs:
	.short 	20480

.align 2

video_memory:
	.long	0x24000000
VRAM_pixels:
	.long	0x24000200
color_mask:
	.long 	0x07FF
spark:
	.long 	_vscreen+0x11800 !0x24011a00
rng_data:
	.long _rng_data

CRAM:
	.long	0x20004200
vscreen:
	.long	_vscreen
SYS_REG:
	.long	0x20004000
VDP_REG:
	.long	0x20004100
stack_top:
	.long __stack_top
	
_rng_data:	
	! Seeds
	.byte 1 
	.byte 4 
_random:
	.word 25662,56977,36314,46707
	
	
	
	.comm	_vscreen,72000,4

