// GBA demo "Flower"
//using the ARM SDK
//
//10 April 2001
// Richard "Ries" van der Brugge / rvdbrugge@yahoo.com
//
// Code borrowed from many sources, mainly from PAN's ATX demo
//
// the flower background is a picture I took of a ballon and then manipulated it in Photoshop.



//include standard routines
#include "rieslib.h"

// include the sinus data from pan/atx
//hey pan, I love rollercoaster how about a update soon???
#include "sinus.c"
// need this for RAND() function for the scroller routine
#include <stdlib.h>
#include <math.h>

#define OAM     ((Sprite*)0x07000000)   // Setup pointer to OAM ram
#define OBJCHARDATA ((u8*)0x06010000)   // Setup pointer to OBJ graphics data
#define OBJ_PLTT    ((u16*)0x05000200)  // Setup pointer to OBJ palette
//define a sprite as a structure
typedef struct _Sprite { u16 Attrib0, Attrib1, Attrib2, RotateScale; } Sprite;


//scroller related vars
u8 scroll_text[] = "                               Richard -Ries- van der Brugge presents his first GBA demo. Credits for the scroller code go to -PAN-/atx , BKG display picture  by Warder1. I promise that the next one will be a bit more original. Visit my GBA homebrew dev site at www.geocities.com/rvdbrugge for more GBC and GBA stuff.           \x0                              ";
u16 scroll_offset;
u16 scroll_offset2;
u16 scroll_x;
u16 scroll_sinus_offset;

s16 bg_y;
u8 bg_ydir;

s16 bg_x;
u8 bg_xdir;

//some stuff needed to setup the picture display
//such as mem. adrr. of the palette, tile data and tile map
//man, this reminds me of GBC coding ...
u16 *pal=(u16*)0x5000000;
u16 *tmp_pal;
u8 *tiles=(u8*)0x6004000;
u8 *bg_data;
u16 *m0=(u16*)0x6000000;

// external ref. to tell the compiler that the picture and sprite data is coming from an external source
//in this case data.asm
extern u8 background;
extern u8 background_pal;
extern u16 sprite_pal;                  // 16 color sprite palette
extern u8 sprite_gfx;                   // 16 color sprite graphics

//fast DMA transfer of data
void DMA3Call(u32 Src,u32 Dst,u32 Cnt)              //used to load our sprite info into vram
{
	REG_DM3SAD = Src;									//where the data is
	REG_DM3DAD = Dst;									//where the data goes
	REG_DM3CNT = Cnt;									//how much data should be loaded
}


//whole scroll routine stolen from PAN's atx demo
//Ries: I barely understand whats going on here :)
void DoScroll()
{
        u16 i,j,k;
        k=scroll_offset2;
        for ( i=0;i<32;i++) {
            j = scroll_sinus[(scroll_sinus_offset+k) & 255] | 0x2300;
            k = (k+4) & 255;
            OAM[81+i].Attrib0= j;
            OAM[81+i].Attrib1= i<<9 |((i<<3)-(scroll_x+8)+scroll_offset*8) & 511 ;
            OAM[81+i].Attrib2= 0x1000  | ((scroll_text[i+scroll_offset]-32)<<1)+4;
            //+64 = COS
            OAM[(i*4)].RotateScale = scroll_sin[(scroll_sinus_angle[(scroll_sinus_offset+k)+64 & 255])+64  & 255];
            // SIN
            OAM[(i*4)+1].RotateScale =scroll_sin[(scroll_sinus_angle[(scroll_sinus_offset+k)+64 & 255]) & 255];
            // negative SIN
            OAM[(i*4)+2].RotateScale =~scroll_sin[(scroll_sinus_angle[(scroll_sinus_offset+k)+64 & 255])  & 255];
            // +64 = COS
            OAM[(i*4)+3].RotateScale =scroll_sin[(scroll_sinus_angle[(scroll_sinus_offset+k)+64 & 255])+64  & 255];
        }
        scroll_sinus_offset = (scroll_sinus_offset+1) & 255;
        scroll_x++;
        if ( (scroll_x&7) == 0) {
            scroll_offset++;
            scroll_offset2-=4;
            scroll_sinus_offset += 8;
        }
        if ( scroll_text[scroll_offset]==0) {
             scroll_offset=0;
             scroll_offset2=0;
             scroll_x = 0;
             scroll_sinus_offset = rand() & 255;
        }
}

//thanx to warder1 for this routine
//what you do is save a 240x160 256color BMP run it thru spritestripper and then tru hackit to get the pal and raw data for inclusion in the data.asm
//spritestripper creates the 8colums you need for mode0 and hackit converts it into raw data
void ShowBKG()
{
   u16 x,y,i;

   //load tiles from data to vram
   bg_data = (u8*)(&background);
   for(i=0;i<64*600;i++) tiles[i]=bg_data[i];

   //load palette to vram
   tmp_pal = (u16*)(&background_pal);
   for (i=0;i<256;i++) pal[i]=tmp_pal[i];

   //draw tiles on screen
   for (y=0;y<20;y++)
       for (x=0;x<30;x++) {
           m0[y*32+x]=y*30+x;
       }
}

//Ries: my own routine to bounce the background around
//chicken quality (tm)
void BGfx(){
//mess with the CY Vertical scroll co-ordinate for BG0
		    *(u16*)0x4000012=bg_y;

		    if (bg_ydir==0){
					bg_y++;
					if (bg_y>=20){
						bg_ydir=1;
					}
			}

		    if (bg_ydir==1){
								bg_y--;
								if (bg_y<=-20){
									bg_ydir=0;
								}
			}
//now do the x scroll reg
			*(u16*)0x4000010=bg_x;

					    if (bg_xdir==0){
								bg_x++;
								if (bg_x>=30){
									bg_xdir=1;
								}
						}

					    if (bg_xdir==1){
											bg_x--;
											if (bg_x<=-30){
												bg_xdir=0;
											}
			}

}


//********************************************************************************
//entry from startup asm code, probably the only original bit in this source all others use c_entry :)))
//this is the replacement for the main() stuff you find in other C programs
//********************************************************************************
void StartHere()
{
        u16 i;


REG_DISPCNT = 0x1110;      //mode 0
REG_BG0CNT = 0x0084;	//setup bkg0 for background pic

//clear the VRAM screendisplay as defined in rieslib.h
DMAClearScreen();
ClearScreen();

//show background picture
ShowBKG();


//Init sprites stuff from PAN starts here
//first use DMA to transfer the sprite palette and data
 DMA3Call((u32)&sprite_pal, (u32)OBJ_PLTT, 0x84000020); //DMA Sprite Colors
 DMA3Call((u32)&sprite_gfx, (u32)OBJCHARDATA, 0x84000000+((6144+128)/2)); //DMA Sprite Graphics
// push all sprites under the screen so they aren't visible
for  (i=0;i<128;i++) OAM[i].Attrib0=168;



// Init scroll offsets
    scroll_x = 0;
    scroll_offset = 0;
    scroll_offset2=0;
    scroll_sinus_offset = 0;



//bg fx stuff
bg_y = 0;
bg_ydir = 0;
bg_x = 0;
bg_xdir = 0;

//loop forever
	while(1){
		//wait for vblank to hit line 160 as defined in rieslib.h
		VSync();
		    DoScroll(); //scroll the text
			BGfx();

		}
}

