@echo off

echo -=[Assembling the startup code]=-
zarmasm -CPU ARM7TDMI -Littleend start.asm
echo -=[Assembling data includes]=-
zarmasm -CPU ARM7TDMI -Littleend data.asm

echo -=[Compiling C code]=-
zarmcc -c -Wall -Otime -ansic -fpu none -Littleend -cpu ARM7TDMI -apcs /narrow/noswst project.c -o project.o

echo -=[Ignore the warning .bin not supported in future releases]=-
zarmlink -bin -first start.o start.o data.o project.o -ro-base 0x08000000 -rw-base 0x03000000 -o flower.gba


echo -=[Fixing GBA headers]=-
rem GBAFIX is util from darkfader - it can be found on http://www.agbdev.net/gbadev/

gbafix flower.gba -p -g1 -m666


@del *.o