; 一个256字节的16位MS-DOS时钟显示器 A 256-byte MS-DOS Clock Display in 16-bit Assembly
; pixel10m28@outlook.com制作 Created by pixel10m28@outlook.com
; 使用NASM(Netwide Assembler) 2.16.03编译 Compiled by NASM 2.16.03
; 2025年2月23日 Feb 23, 2025

section .text
global main
    org 100h
main:
    mov ax, cs
    mov ds, ax
    ; 清屏（25个空行） Clean the screen (25 empty lines)
    mov cx, 25
    cls:
        mov ah, 9
        mov dx, empty_line
        int 21h
    loop cls
    ; 输出时间 Output time
    get_time:
        ; 输出位置保持在第一行 Keep the output place in first line
        mov ah, 2
        mov dh, 0
        mov dl, 0
        mov bh, 0
        int 10h
        ; 获取年、月、日 Get year, month and day
        mov ah, 2Ah
        int 21h
        ; 转换月份（DH） Convert month
        mov al, dh          ; 月份放入AL Put month on AL
        mov ah, 0           ; 清零AH，AX=月份 Clear AH, AX = month
        mov di, date +5     ; 目标地址指向月份的十位位置 The target address points to the tens of month
        call digit2

        ; 转换日期（DL） Convert day
        mov al, dl          ; 日期放入AL Put day on AL
        mov ah, 0           ; 清零AH，AX=日期 Clear AH, AX = day
        mov di, date +8     ; 目标地址指向日期的十位位置 The target address points to the tens of day
        call digit2

        ; 将年份（CX）转换为ASCII字符串 Convert year to ASCII string
        mov ax, cx          ; 年份放入AX Put year on AX
        mov di, date        ; 目标地址指向date字符串开头（年份的千位位置） The target address points to the thousands of year

        ; 转换千位 Convert thousands
        mov dx, 0
        mov bx, 1000
        div bx              ; AX = 千位(thousands)，DX = 余数(remainder)
        add al, '0'         ; 转为ASCII Convert ASCII
        mov [di], al        ; 存储到date[0] Store to date[0]

        ; 转换百位 Convert hundreds
        mov ax, dx          ; 余数放入AX Put remainder on AX
        mov dx, 0
        mov bx, 100
        div bx              ; AX = 百位(hundreds)，DX = 余数(remainder)
        add al, '0'
        mov [di+1], al      ; 存储到date[1] Store to date[1]

        ; 转换十位 Convert tens
        mov ax, dx
        mov dx, 0
        mov bx, 10
        div bx              ; AX = 十位(tens)，DX = 个位(singles)
        add al, '0'
        mov [di+2], al      ; 存储到date[2] Store to date[2]

        ; 转换个位 Convert singles
        add dl, '0'
        mov [di+3], dl      ; 存储到date[3] Store to date[3]

        ; 获取时、分、秒 Get hour, minute, second
        mov ah, 2Ch
        int 21h

        ; 转换秒（DH） Convert second
        mov al, dh          ; 秒放入AL Put second on AL
        mov ah, 0           ; 清零AH，AX=秒 Clear AH, AX = second
        mov di, time +6     ; 目标地址指向秒的十位位置 The target address points to the tens of second
        call digit2

        ; 转换小数点后部分（DL） Convert the part after the point
        mov al, dl          ; 小数点后部分放入AL Put the part after the point on AL
        mov ah, 0           ; 清零AH，AX=小数点后部分 Clear AH, AX = the part after the point
        mov di, time +9     ; 目标地址指向小数点后第一位的位置 The target address points to the first digit after the point
        call digit2

        ; 转换小时（CH） Convert hour
        mov al, ch          ; 小时放入AL Put the hour on AL
        mov ah, 0           ; 清零AH，AX=小时 Clear AH, AX = hour
        mov di, time        ; 目标地址指向小时的十位位置 The target address points to the tens of hour
        call digit2

        ; 转换分钟（CL） Convert minute
        mov al, cl          ; 分钟放入AL Put the minute on AL
        mov ah, 0           ; 清零AH，AX=分钟 Clear AH, AX = minute
        mov di, time +3     ; 目标地址指向分钟的十位位置 The target address points to the tens of minute
        call digit2

        ; 输出日期字符串 Output date string
        mov ah, 9
        mov dx, date
        int 21h

        ; 输出时间字符串 Output time string
        mov ah, 9
        mov dx, time
        int 21h

        ; 输出一个空行 Output an empty line
        mov ah, 9
        mov dx, empty_line
        int 21h

        ; 输出提示 Output an hint
        mov ah, 9
        mov dx, hint
        int 21h

        ; 检测是否有键被按下 Detects if a key is pressed
        mov ah, 0Bh
        int 21h
        cmp al, 0 ; 如果被按下，AL就会大于0，然后就退出了 If it is pressed, AL will be greater than 0 and then exit
        jne exit
    jmp get_time
digit2:
    mov bl, 10
    div bl              ; AL = 十位(tens)，AH = 个位(singles)
    add al, '0'
    mov [di], al        ; 存储到di Store to di
    add ah, '0'
    mov [di+1], ah      ; 存储到di+1 Store to di+1
    ret
exit:
    mov ah, 4ch
    int 21h
hint:
    db "PRESS A KEY TO EXIT", 0dh, 0ah, '$'
empty_line:
    db 0dh, 0ah, '$'
date:
    db "0000-00-00", 20h, '$'
time:
    db "00:00:00.00", 0dh, 0ah, '$'