Type Vector
	Field x#,y#,z#
End Type

Function Vector.vector(x#=0,y#=0,z#=0)
	v.vector=New vector
	v\x#=x# : v\y#=y# : v\z#=z#
	Return v
End Function

Function SetVector(v.vector,x#,y#,z#)
	v\x#=x# : v\y#=y# : v\z#=z#
End Function

Function Normalize(v.vector)
	MAG#=Sqr(v\x#*v\x#+v\y#*v\y#+v\z#*v\z#)
	v\x#=v\x#/MAG# : v\y#=v\y#/MAG# : v\z#=v\z#/MAG#
End Function

Function DotProduct#(a.vector,b.vector)
	Return (a\x#*b\x#+a\y#*b\y#+a\z#*b\z#)
End Function

Function CrossProduct(a.vector,b.vector,c.vector)
	c\x#=a\y#*b\z#-a\z#*b\y#
	c\y#=a\z#*b\x#-a\x#*b\z#
	c\z#=a\x#*b\y#-a\y#*b\x#
End Function

Function Negate(v.vector)
	v\x#=-v\x# : v\y#=-v\y# : v\z#=-v\z#
End Function

Function Scale(v.vector,S#)
	v\x#=v\x#*S# : v\y#=v\y#*S# : v\z#=v\z#*S#
End Function

Function VectorAdd(a.vector,b.vector,c.vector)
	c\x#=a\x#+b\x#
	c\y#=a\y#+b\y#
	c\z#=a\z#+b\z#
End Function

Function VectorSub(a.vector,b.vector,c.vector)
	c\x#=a\x#-b\x#
	c\y#=a\y#-b\y#
	c\z#=a\z#-b\z#
End Function

Function VectorDivScalar(v.vector,S#)
	v\x#=v\x#/S#
	v\y#=v\y#/S#
	v\z#=v\z#/S#
End Function

Function ScaleVector(v.vector,S#)
	v\x#=v\x#*S#
	v\y#=v\y#*S#
	v\z#=v\z#*S#
End Function

Function VectorLength#(v.vector)
	Return Sqr(v\x#*v\x#+v\y#*v\y#+v\z#*v\z#)
End Function

Function TransformVector(v.vector,m.matrix,r.vector)
	r\x#=v\x#*m\aa#+v\y#*m\ba#+v\z#*m\ca#+m\da#
	r\y#=v\x#*m\ab#+v\y#*m\bb#+v\z#*m\cb#+m\db#
	r\z#=v\x#*m\ac#+v\y#*m\bc#+v\z#*m\cc#+m\dc#
End Function
	


Type Matrix
	Field aa#,ab#,ac#,ad#
	Field ba#,bb#,bc#,bd#
	Field ca#,cb#,cc#,cd#
	Field da#,db#,dc#,dd#
End Type

Function MultiplyMatrix(a.matrix,b.matrix,c.matrix)
	c\aa#=a\aa#*b\aa#+a\ab#*b\ba#+a\ac#*b\ca#+a\ad#*b\da#
	c\ab#=a\aa#*b\ab#+a\ab#*b\bb#+a\ac#*b\cb#+a\ad#*b\db#
	c\ac#=a\aa#*b\ac#+a\ab#*b\bc#+a\ac#*b\cc#+a\ad#*b\dc#
	c\ad#=a\aa#*b\ad#+a\ab#*b\bd#+a\ac#*b\cd#+a\ad#*b\dd#
	c\ba#=a\ba#*b\aa#+a\bb#*b\ba#+a\bc#*b\ca#+a\bd#*b\da#
	c\bb#=a\ba#*b\ab#+a\bb#*b\bb#+a\bc#*b\cb#+a\bd#*b\db#
	c\bc#=a\ba#*b\ac#+a\bb#*b\bc#+a\bc#*b\cc#+a\bd#*b\dc#
	c\bd#=a\ba#*b\ad#+a\bb#*b\bd#+a\bc#*b\cd#+a\bd#*b\dd#
	c\ca#=a\ca#*b\aa#+a\cb#*b\ba#+a\cc#*b\ca#+a\cd#*b\da#
	c\cb#=a\ca#*b\ab#+a\cb#*b\bb#+a\cc#*b\cb#+a\cd#*b\db#
	c\cc#=a\ca#*b\ac#+a\cb#*b\bc#+a\cc#*b\cc#+a\cd#*b\dc#
	c\cd#=a\ca#*b\ad#+a\cb#*b\bd#+a\cc#*b\cd#+a\cd#*b\dd#
	c\da#=a\da#*b\aa#+a\db#*b\ba#+a\dc#*b\ca#+a\dd#*b\da#
	c\db#=a\da#*b\ab#+a\db#*b\bb#+a\dc#*b\cb#+a\dd#*b\db#
	c\dc#=a\da#*b\ac#+a\db#*b\bc#+a\dc#*b\cc#+a\dd#*b\dc#
	c\dd#=a\da#*b\ad#+a\db#*b\bd#+a\dc#*b\cd#+a\dd#*b\dd#
End Function

Function Matrix.matrix()
	m.matrix=New matrix
	m\aa#=1.00 : m\bb#=1.00 : m\cc#=1.00 : m\dd#=1.00
	Return m
End Function

Function RotateMatrix(m.matrix,xa#,ya#,za#)
	sx#=Sin(xa#) : sy#=Sin(ya#) : sz#=Sin(za#)
	cx#=Cos(xa#) : cy#=Cos(ya#) : cz#=Cos(za#)
	m\aa#=cy#*cz#             : m\ab#=cy#*sz#             : m\ac#=-sy#
	m\ba#=sx#*sy#*cz#-cx#*sz# : m\bb#=sx#*sy#*sz#+cx#*cz# : m\bc#=sx#*cy#
	m\ca#=cx#*sy#*cz#+sx#*sz# : m\cb#=cx#*sy#*sz#-sx#*cz# : m\cc#=cx#*cy#
End Function	

Function TranslateMatrix(m.matrix,x#,y#,z#)
	m\da#=x# : m\db#=y# : m\dc#=z#
End Function