Include "engineinclude.bb"
Include "vector&matrixlib.bb"

Dim CP.vector(5,2)
Dim FramePreCalc(359,127)

Function RenderRotoZoomer(ang#)
	scale#=4+3*Sin(ang#)
	xoffset=1600+1200*Sin(ang#)
	yoffset=1200+1000*Cos(ang#)
	s#=Sin(ang#) : c#=Cos(ang#)	
	x1#=-159*scale# : x2#=160*scale#
	yy=0
	For y=-119 To 119
			y1#=(Float y)*scale#	 : y2#=y1#
			u0#=x1#*c#+y1#*-s#
			v0#=x1#*s#+y1#*c#
			
			u1#=x2#*c#+y2#*-s#
			v1#=x2#*s#+y2#*c#
			
			u0#=u0#+1600+xoffset : u1#=u1#+1600+xoffset
			v0#=v0#+1200+yoffset : v1#=v1#+1200+yoffset
			
			um#=(u1#-u0#)/320.0
			vm#=(v1#-v0#)/320.0
			u#=u0#	: v#=v0#

			For x=0 To 319
				WritePixelFast x,yy,(u# Xor v#)
				u#=u#+um# : v#=v#+vm#
			Next
		yy=yy+1
	Next
End Function


Function RenderRubberCube(cubebank,ang,x=0,y=0)
	yf=0
	For sy=x To (x+127)
		f=FramePreCalc(ang,yf)
		i=(f+((yf) Shl 7))Shl 2
		For sx=y To (y+127)
			RGB=PeekFloat(CubeBank,i)
			WritePixelFast sx,sy,RGB
			i=i+4
		Next
		yf=yf+1
	Next
End Function


Function RubberCubePrecalcs()
	Restore cube_coords
	For i=0 To 5
		Read x#,y#,z#
		CP(i,0)=Vector(x#,y#,z#)
		CP(i,1)=Vector()
		CP(i,2)=Vector()
	Next
	
	For an#=0 To 359
		inc#=1+Sin(an#*2)
		inca#=1+Cos(an#)
		For y=0 To 127
			f=(Int(frame+(y)*inc#)+Int((128-y)*inca#)) Mod 90
			If f<0
				Repeat
					f=f+90
				Until f>0
			EndIf
			FramePreCalc(an#,y)=f*16384
		Next
	Next

	IMG=LoadImage("madoka0.png")
	image=CreateBank(256*256*4)
	SetBuffer ImageBuffer(IMG)
	LockBuffer 
		i=0
		For y=0 To 255
			For x=0 To 255		
				RGB=ReadPixelFast(x,y) And $FFFFFF
				PokeFloat(image,i,RGB)
				i=i+4
			Next
		Next
	UnlockBuffer
	SetBuffer BackBuffer()
	FreeImage IMG

	CubeBank=CreateBank(128*128*4*90)
	
	Cls
	m.matrix=Matrix()
		For ang=89 To 0 Step -1
			RotateMatrix(m,0,ang,0)
			For i=0 To 5
				TransformVector(CP(i,0),m,CP(i,1))
				vx=(CP(i,1)\x#*256/(6-CP(i,1)\z#))+63
				vy=(CP(i,1)\y#*256/(6-CP(i,1)\z#))+64
				SetVector(CP(i,2),vx,vy,(6-CP(i,1)\z#))
			Next		

			S=(255/90)*(90-ang)
			S2=(255/90)*(ang)
			ClsColor 0,255,0
			Cls
			LockBuffer
			If ang>45
				GouraudPerspectiveTextureMap(CP(0,2)\x#,CP(0,2)\y#,CP(0,2)\z#,0,0,S,CP(1,2)\x#,CP(1,2)\y#,CP(1,2)\z#,255,0,S,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,0,255,S,image)
				GouraudPerspectiveTextureMap(CP(1,2)\x#,CP(1,2)\y#,CP(1,2)\z#,255,0,S,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,0,255,S,CP(3,2)\x#,CP(3,2)\y#,CP(3,2)\z#,255,255,S,image)
				GouraudPerspectiveTextureMap(CP(4,2)\x#,CP(4,2)\y#,CP(4,2)\z#,0,0,S2,CP(5,2)\x#,CP(5,2)\y#,CP(5,2)\z#,0,255,S2,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,255,255,S2,image)
				GouraudPerspectiveTextureMap(CP(4,2)\x#,CP(4,2)\y#,CP(4,2)\z#,0,0,S2,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,255,255,S2,CP(0,2)\x#,CP(0,2)\y#,CP(0,2)\z#,255,0,S2,image)
			Else
				GouraudPerspectiveTextureMap(CP(4,2)\x#,CP(4,2)\y#,CP(4,2)\z#,0,0,S2,CP(5,2)\x#,CP(5,2)\y#,CP(5,2)\z#,0,255,S2,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,255,255,S2,image)
				GouraudPerspectiveTextureMap(CP(4,2)\x#,CP(4,2)\y#,CP(4,2)\z#,0,0,S2,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,255,255,S2,CP(0,2)\x#,CP(0,2)\y#,CP(0,2)\z#,255,0,S2,image)
				GouraudPerspectiveTextureMap(CP(0,2)\x#,CP(0,2)\y#,CP(0,2)\z#,0,0,S,CP(1,2)\x#,CP(1,2)\y#,CP(1,2)\z#,255,0,S,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,0,255,S,image)
				GouraudPerspectiveTextureMap(CP(1,2)\x#,CP(1,2)\y#,CP(1,2)\z#,255,0,S,CP(2,2)\x#,CP(2,2)\y#,CP(2,2)\z#,0,255,S,CP(3,2)\x#,CP(3,2)\y#,CP(3,2)\z#,255,255,S,image)
			EndIf	
				For y=0 To 127
					For x=0 To 127
						RGB=ReadPixelFast(x,y)
						PokeFloat(CubeBank,Offs,RGB)
						offs=offs+4
					Next
				Next
			UnlockBuffer
			;draw progress bar
			ClsColor 0,0,0 : Cls
			Color 0,0,255 : Rect 70,100,(90-ang)*2,40
			Color 255,255,255 : Rect 70,100,180,40,0
			Flip
		Next
	Delete m
	FreeBank image
	SetBuffer BackBuffer()
	Return Cubebank
End Function

.cube_coords
Data -1,-1, 1
Data  1,-1, 1
Data -1, 1, 1
Data  1, 1, 1
Data -1,-1,-1
Data -1, 1,-1
		