varying vec3 vcoord;

void main()
{
	float d = vcoord.z / 128.0;
	if (d < 0.0) d = 0.0;
	if (d > 1.0) d = 1.0;

	float dy = vcoord.y / 128.0;

	float r = (0.55 + dy) * d + (1.0 - d) * 0.0;
	float g = (0.25 + dy) * d + (1.0 - d) * 0.15;
	float b = (0.15 + dy) * d + (1.0 - d) * 0.35;
	float a = 1.0;

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
